// Copyright (c) 2002 Rob Kaper <cap@capsi.com>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License version 2.1 as published by the Free Software Foundation.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this library; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

#ifndef LIBCAPSI_NETWORK_LISTENPORT_H
#define LIBCAPSI_NETWORK_LISTENPORT_H

#include <string>

#define	LISTENQ	1024

class ListenPort
{
public:
	ListenPort(const std::string host, const unsigned int port);
	const std::string ipAddr() { return m_ipAddr; }
	const std::string fqdn() { return m_fqdn; }
	const unsigned int port() { return m_port; }
	const unsigned int fd() { return m_fd; }
	bool isBound() const;

private:
	std::string m_ipAddr, m_fqdn;
	unsigned int m_fd, m_port;
	bool m_isBound;
};

#endif
