#if   !defined(__CORELINUXGUARDGROUP_HPP)
#define __CORELINUXGUARDGROUP_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__SEMAPHOREGROUP_HPP)
#include <SemaphoreGroup.hpp>
#endif

namespace corelinux
{
   DECLARE_CLASS( CoreLinuxGuardGroup );

   /**
   A CoreLinuxGuardGroup is an extension to the SemaphoreGroup for creating
   semaphores for the CoreLinuxGuardPool. 
   */

   class CoreLinuxGuardGroup : public SemaphoreGroup
   {
   public:

                        /**
                        Default constructor creates a private group 
                        semaphores with access for OWNER_ALL
                        @param Short Number of semaphores in group
                        @exception Assertion if aCount < 1 
                        @exception SemaphoreException if kernel group 
                        create call fails.
                        @see AccessRights
                        */
                        
                        CoreLinuxGuardGroup( Short ) 
                           throw(Assertion,SemaphoreException);

                        /// Virtual destructor

      virtual           ~CoreLinuxGuardGroup( void );

      //
      // Accessors
      //

      //
      // Factory methods
      //

               /**
               Create a default GuardSemaphore
               @return AbstractSemaphore aSem - pointer to created semaphore
               @exception SemaphoreException if no sems left in group
               */

      virtual  AbstractSemaphorePtr createSemaphore( void )
                                       throw( SemaphoreException ) ;

               /**
               Create or open (use) a specific GuardSemaphore 
               @param SemaphoreIdentifier identifies which semphore id to
               create or attempt to use
               @param CreateDisposition indicates how to treat the conditions
               that the group may meet in the request:
               CREATE_OR_REUSE indicates that the caller doesn't care
               FAIL_IF_EXISTS indicates the attempt was for a create
               FAIL_IF_NOTEXISTS indicates the attempt was for a open
               @param Recursive to allow same thread multiple locks 
               @param Balking to allow the semaphore to balk
               @return AbstractSemaphore aSem - pointer to created or 
               opened semaphore
               @exception SemaphoreException if the disposition disagrees
               with the semaphore state, or if it is a erroneous identifier
               */

      virtual  AbstractSemaphorePtr createSemaphore
                                 ( 
                                    SemaphoreIdentifierRef aIdentifier,
                                    CreateDisposition disp = CREATE_OR_REUSE,
                                    bool Recursive = false, 
                                    bool Balking = false 
                                 ) throw( SemaphoreException ) ;

               /**
               Create or open (use) a specific GuardSemaphore 
               @param string identifies which semphore id to create or 
               attempt to use
               @param CreateDisposition indicates how to treat the conditions
               that the group may meet in the request:
               CREATE_OR_REUSE indicates that the caller doesn't care
               FAIL_IF_EXISTS indicates the attempt was for a create
               FAIL_IF_NOTEXISTS indicates the attempt was for a open
               @param Recursive to allow same thread multiple locks 
               @param Balking to allow the semaphore to balk
               @return AbstractSemaphore aSem - pointer to created or 
               opened semaphore
               @exception SemaphoreException if the disposition disagrees
               with the semaphore state, or if it is a erroneous identifier
               */

      virtual  AbstractSemaphorePtr createSemaphore
                              ( 
                                 std::string aName,
                                 CreateDisposition disp = CREATE_OR_REUSE,
                                 bool Recursive=false, 
                                 bool Balking = false 
                              ) throw( SemaphoreException ) ;


               /**
               Destroys a created GuardSemaphore
               @note Reference counting is not enabled so applications
               should ensure that only one (1) destroy is called per
               semaphore.
               @param AbstractSemaphore pointer of semaphore to destroy
               @exception SemaphoreException if semaphore does not belong
               to this group or if already destroyed.
               */

      virtual  void  destroySemaphore( AbstractSemaphorePtr )
                        throw( SemaphoreException ) ;
   protected:

      //
      // Constructors
      //
                        /// Default constructor not allowed

                        CoreLinuxGuardGroup( void ) throw( Assertion );

                        /// Copy constructor not allowed

                        CoreLinuxGuardGroup( CoreLinuxGuardGroupCref )
                           throw( Assertion );

      //
      // Operator overloads
      //

               /// Assignment operator not allowed

               CoreLinuxGuardGroupRef operator=( CoreLinuxGuardGroupCref )
                                    throw( Assertion );

      //
      // Directed Factory methods
      //


   private:

               /// Temporary registration collection
         
               AbstractSemaphorePtr  *theUsedMap;
   };
}

#endif // if !defined(__CORELINUXGUARDGROUP_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/06/02 11:51:52 $
   $Locker:  $
*/



