/* 
 * $Id: ctkcombo.h,v 1.10 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#ifndef __CTKCOMBO_H__
# define __CTKCOMBO_H__ 


typedef struct CtkCombo_S
{
      CtkHBox hbox;
      
      CtkWidget* entry;
      CtkWidget* list;
      
      /* This is the window we create and set as modal when open */
      CtkWidget* window;
      CtkWidget* scrolledwindow;
      
      gboolean open;
      gboolean wasDragged;
      gboolean doClose;
      
      gboolean value_in_list;
      gboolean ok_if_empty;
} CtkCombo;

#define CTK_COMBO(obj)	CTK_CHECK_CAST((obj),CtkCombo,CtkTypeCombo)

void ctk_combo_init(CtkCombo* combo);
CtkWidget* ctk_combo_new(void);
void ctk_combo_set_popdown_strings(CtkCombo* combo, GList* strings);
void ctk_combo_set_value_in_list(CtkCombo* combo, 
				 gboolean val,
				 gboolean ok_if_empty);
void ctk_combo_min_size(CtkWidget* widget);
void ctk_combo_real_size(CtkWidget* widget);

#endif
