/* 
 * $Id: ctktype.h,v 1.28 2000/07/10 21:16:48 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTKTYPE_H__
#define __CTKTYPE_H__

typedef enum 
{
      CtkTypeObject = 0,
      CtkTypeWidget,
      CtkTypeMisc,
      CtkTypeLabel,
      CtkTypeContainer,	    
      CtkTypeBin,
      CtkTypeFrame,
      CtkTypeButton,
      CtkTypeToggleButton,
      CtkTypeCheckButton,
      CtkTypeRadioButton,
      CtkTypeOptionMenu,
      CtkTypeWindow,
      CtkTypeScrolledWindow,
      CtkTypeViewport,
      CtkTypeItem,
      CtkTypeMenuItem,
      CtkTypeListItem,
      CtkTypeBox,
      CtkTypeHBox,
      CtkTypeCombo,
      CtkTypeVBox,
      CtkTypeCList,
      CtkTypeList,
      CtkTypeNotebook,
      CtkTypeMenuShell,
      CtkTypeMenu,
      CtkTypeTable,
      CtkTypeTableChild,
      CtkTypeEditable,
      CtkTypeEntry,
      CtkTypeSpinButton,
      CtkTypeRange,
      CtkTypeScale,
      CtkTypeHScale,
      CtkTypeVScale,
      CtkTypeSeparator,
      CtkTypeHSeparator,
      CtkTypeVSeparator,
      CtkTypeProgress,
      CtkTypeProgressBar,
      CtkTypeData,
      CtkTypeAdjustment,

// TypeEND is the largest number.
      CtkTypeEND
} CtkType;

typedef enum {
	CTK_JUSTIFY_LEFT,
	    CTK_JUSTIFY_RIGHT,
	    CTK_JUSTIFY_CENTER,
	    CTK_JUSTIFY_FILL
} CtkJustification;

typedef enum {
	CTK_REDRAW_ALL,
	    CTK_REDRAW_CHANGED
} CtkRedraw;

typedef enum {
	CTK_SCROLL_LEFT,
	    CTK_SCROLL_RIGHT,
	    CTK_SCROLL_UP,
	    CTK_SCROLL_DOWN,
	    CTK_PAGE_LEFT,
	    CTK_PAGE_RIGHT,
	    CTK_PAGE_UP,
	    CTK_PAGE_DOWN,
	    CTK_NONE
} CtkTypeScroll;

typedef enum {
	CTK_WINDOW_TOPLEVEL,
	    CTK_WINDOW_DIALOG,
	    CTK_WINDOW_POPUP
} CtkWindowType;

typedef enum {
	CTK_EXPAND = 1 << 0,
	    CTK_SHRINK = 1 << 1,
	    CTK_FILL = 1 << 2
} CtkAttachOptions;

typedef enum {
	CTK_POS_LEFT,
	    CTK_POS_RIGHT,
	    CTK_POS_TOP,
	    CTK_POS_BOTTOM
} CtkPositionType;

typedef enum {
	CTK_POLICY_ALWAYS,
	    CTK_POLICY_AUTOMATIC,
	    CTK_POLICY_NEVER
} CtkPolicyType;

typedef enum {
	CTK_WIN_POS_NONE,
	CTK_WIN_POS_CENTER,
	CTK_WIN_POS_MOUSE
} CtkWindowPosition;

extern CtkType typeLink[CtkTypeEND];
#define CTK_PARENT_TYPE(type) (typeLink[type])

struct CtkObject_S;

gboolean ctk_type_check_type(struct CtkObject_S* object, CtkType type);
void     ctk_type_init();

#if defined(NDEBUG) || defined(NODEBUG)
#define CTK_CHECK_CAST(tobj, cast, obj_type) ((cast*)tobj)
#else
#define CTK_CHECK_CAST(tobj, cast, obj_type) \
	( \
		ctk_assert(ctk_type_check_type((struct CtkObject_S*)tobj, obj_type), \
			"Attempt to cast " __STRING(tobj) " to a " \
			__STRING(cast) " is invalid."), \
		(cast*)tobj \
	)
#endif

#define CTK_CHECK_TYPE(tobj, type)  (ctk_type_check_type((struct CtkObject_S*)tobj, type))

#endif
