/*****************************************************************************
 * msg.c: print messages.
 *****************************************************************************
 * Copyright (C) 2002 VideoLAN
 * $Id: msg.c,v 1.7 2003/01/29 22:09:46 sam Exp $
 *
 * Authors: Stphane Borel <stef@via.ecp.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

/*****************************************************************************
 * Preamble
 *****************************************************************************/

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#   include <unistd.h>
#endif

#include "common.h"

#include <dvdread/ifo_types.h>
#include <dvdread/ifo_read.h>
#include <dvdread/nav_read.h>

#include "dvdplay/dvdplay.h"

#include "command.h"
#include "vmg.h"

#ifdef HAVE_VASPRINTF
#   define PRINT_MSG(prefix, suffix) \
        va_list args; \
        char *  psz_msg; \
        va_start( args, psz_format ); \
        vasprintf( &psz_msg, psz_format, args ); \
        fprintf( stderr, prefix "%s" suffix, psz_msg ); \
        free( psz_msg ); \
        va_end( args );
#else
#   define PRINT_MSG(prefix, suffix) \
        va_list args; \
        char psz_msg[200]; \
        va_start( args, psz_format ); \
        vsnprintf( psz_msg, 200, psz_format, args ); \
        psz_msg[199] = '\0'; \
        fprintf( stderr, prefix "%s" suffix, psz_msg ); \
        va_end( args );
#endif

void _dvdplay_err( const dvdplay_ptr dvdplay, const char * psz_format, ... )
{
    if( dvdplay->i_verbosity >= 1 )
    {
        PRINT_MSG( "libdvdplay error: ", "\n" );
    }
}

void _dvdplay_warn( const dvdplay_ptr dvdplay, const char * psz_format, ... )
{
    if( dvdplay->i_verbosity >= 2 )
    {
        PRINT_MSG( "libdvdplay warning: ", "\n" );
    }
}

void _dvdplay_dbg( const dvdplay_ptr dvdplay, const char * psz_format, ... )
{
    if( dvdplay->i_verbosity >= 3 )
    {
        PRINT_MSG( "libdvdplay debug: ", "\n" );
    }
}

void _dvdplay_trace( const dvdplay_ptr dvdplay, const char * psz_format, ... )
{
#ifdef TRACE
    if( dvdplay->i_verbosity >= 3 )
    {
        PRINT_MSG( "", "" );
    }
#endif
}
