/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
//! @file inti/atk/streamablecontent.h
//! @brief An AtkStreamableContent C++ wrapper interface.
//!
//! Provides StreamableContent, an interface which provides access to streamable content.

#ifndef INTI_ATK_STREAMABLE_CONTENT_H
#define INTI_ATK_STREAMABLE_CONTENT_H

#ifndef INTI_G_TYPE_H
#include <inti/glib/type.h>
#endif

#ifndef __ATK_STREAMABLE_CONTENT_H__
#include <atk/atkstreamablecontent.h>
#endif

namespace Inti {

namespace Atk {

class StreamableContentIface;

//! @class StreamableContent streamablecontent.h inti/atk/streamablecontent.h
//! @brief An AtkStreamableContent C++ wrapper class.
//!
//! StreamableContent is an interface which provides access to streamable content.

class StreamableContent : public virtual G::TypeInterface
{
	friend class StreamableContentIface;

protected:
//! @name Constructors
//! @{

	virtual ~StreamableContent() = 0;
	//!< Destructors.

//! @}
//  Override these do_ methods when you want to change the default behaviour of the AtkStreamableContent.

	virtual int do_get_n_mime_types();

	virtual const char* do_get_mime_type(int i);

	virtual GIOChannel* do_get_stream(const char *mime_type);

public:
//! @name Accessors
//! @{

	AtkStreamableContent* atk_streamable_content() const { return (AtkStreamableContent*)instance; }
	//!< Get a pointer to the AtkStreamableContent structure.

	AtkStreamableContentIface* atk_streamable_content_iface() const;
	//!< Get a pointer to the AtkStreamableContentIface structure.

	operator AtkStreamableContent* () const;
	//!< Conversion operator; safely converts a StreamableContent to an AtkStreamableContent pointer.

	int get_n_mime_types() const;
	//!< Gets the number of mime types supported by this object.
	//!< @return an integer which is the number of mime types supported by the object.

	String get_mime_type(int i) const;
	//!< Gets the character string of the specified mime type. 
	//!< @param i An integer representing the position of the mime type starting from 0.
	//!< @return A string representing the specified mime type.
	//!<
	//!< <BR>The first mime type is at position 0, the second at position 1, and so on.

	GIOChannel* get_stream(const String& mime_type) const;
	//!< Gets the content in the specified mime type.
	//!< @param mime_type A string representing the mime type.
	//!< @return A GIOChannel which contains the content in the specified mime type.

//! @}
};

} // namespace Atk

} // namespace Inti

#endif // INTI_ATK_STREAMABLE_CONTENT_H

