/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  pixbuf-animation.cc - GdkPixbufAnimation and GdkPixbufAnimationIter C++ wrapper interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "pixbuf-animation.h"
#include "pixbuf.h"
#include "../glib/error.h"


using namespace Inti;

/*  Gdk::PixbufAnimationIter
 */

Gdk::PixbufAnimationIter::PixbufAnimationIter(GdkPixbufAnimationIter *iter, bool reference)
: G::Object((GObject*)iter, reference)
{
}

Gdk::PixbufAnimationIter::~PixbufAnimationIter()
{
}

Gdk::PixbufAnimationIter::operator GdkPixbufAnimationIter* () const
{
	return this ? gdk_pixbuf_animation_iter() : 0;
}

int
Gdk::PixbufAnimationIter::get_delay_time() const
{
	return gdk_pixbuf_animation_iter_get_delay_time(gdk_pixbuf_animation_iter());
}

Gdk::Pixbuf*
Gdk::PixbufAnimationIter::get_pixbuf() const
{
	return G::Object::wrap<Pixbuf>(gdk_pixbuf_animation_iter_get_pixbuf(gdk_pixbuf_animation_iter()));
}

bool
Gdk::PixbufAnimationIter::on_currently_loading_frame() const
{
	return gdk_pixbuf_animation_iter_on_currently_loading_frame(gdk_pixbuf_animation_iter());
}

bool
Gdk::PixbufAnimationIter::advance(const GTimeVal *current_time)
{
	return gdk_pixbuf_animation_iter_advance(gdk_pixbuf_animation_iter(), current_time);
}

/* Gdk::PixbufAnimation
 */

Gdk::PixbufAnimation::PixbufAnimation(GdkPixbufAnimation *pixbuf_animation, bool reference)
: G::Object((GObject*)pixbuf_animation, reference)
{
}

Gdk::PixbufAnimation::PixbufAnimation(const String& filename, G::Error *error)
: G::Object((GObject*)gdk_pixbuf_animation_new_from_file(filename.c_str(), *error))
{
}

Gdk::PixbufAnimation::~PixbufAnimation()
{
}

Gdk::PixbufAnimation::operator GdkPixbufAnimation* () const
{
	return this ? gdk_pixbuf_animation() : 0;
}

int
Gdk::PixbufAnimation::get_width() const
{
	return gdk_pixbuf_animation_get_width(gdk_pixbuf_animation());
}

int
Gdk::PixbufAnimation::get_height() const
{
	return gdk_pixbuf_animation_get_height(gdk_pixbuf_animation());
}

bool 
Gdk::PixbufAnimation::is_static_image() const
{
	return gdk_pixbuf_animation_is_static_image(gdk_pixbuf_animation());
}

Gdk::Pixbuf*
Gdk::PixbufAnimation::get_static_image() const
{
	return G::Object::wrap<Pixbuf>(gdk_pixbuf_animation_get_static_image(gdk_pixbuf_animation()));
}

Pointer<Gdk::PixbufAnimationIter>
Gdk::PixbufAnimation::get_iter(const GTimeVal *start_time) const
{
	return G::Object::wrap<PixbufAnimationIter>(gdk_pixbuf_animation_get_iter(gdk_pixbuf_animation(), start_time));
}

