/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  aspectframe.cc - GtkAspectFrame C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "aspectframe.h"
#include "private/aspectframe_p.h"

using namespace Inti;

/*  Gtk::AspectFrame
 */

Gtk::AspectFrame::AspectFrame(GtkAspectFrame *aspect_frame, bool reference)
: Frame((GtkFrame*)aspect_frame, reference)
{
}

Gtk::AspectFrame::AspectFrame()
: Frame((GtkFrame*)AspectFrameClass::create())
{
}

Gtk::AspectFrame::AspectFrame(float xalign, float yalign)
: Frame((GtkFrame*)AspectFrameClass::create())
{
	set(xalign, yalign, 1.0, true);
}

Gtk::AspectFrame::AspectFrame(float xalign, float yalign, float ratio)
: Frame((GtkFrame*)AspectFrameClass::create())
{
	set(xalign, yalign, ratio, false);
}

Gtk::AspectFrame::AspectFrame(const String& label, float xalign, float yalign, float ratio)
: Frame((GtkFrame*)AspectFrameClass::create())
{
	set_label(label);
	set(xalign, yalign, ratio, false);
}

Gtk::AspectFrame::~AspectFrame()
{
}

GtkAspectFrameClass*
Gtk::AspectFrame::gtk_aspect_frame_class() const
{
	return get_class<GtkAspectFrameClass>();
}

Gtk::AspectFrame::operator GtkAspectFrame* () const
{
	return this ? gtk_aspect_frame() : 0;
}

void
Gtk::AspectFrame::set(float xalign, float yalign, float ratio, bool obey_child)
{
	gtk_aspect_frame_set(gtk_aspect_frame(), xalign, yalign, ratio, obey_child);
}

/*  Gtk::AspectFrameClass
 */

void
Gtk::AspectFrameClass::init(GtkAspectFrameClass *g_class)
{
	FrameClass::init((GtkFrameClass*)g_class);
}

GType
Gtk::AspectFrameClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ASPECT_FRAME, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::AspectFrameClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Properties
 */

const Gtk::AspectFrame::XAlignPropertyType Gtk::AspectFrame::xalign_property("xalign");

const Gtk::AspectFrame::YAlignPropertyType Gtk::AspectFrame::yalign_property("yalign");

const Gtk::AspectFrame::RatioPropertyType Gtk::AspectFrame::ratio_property("ratio");

const Gtk::AspectFrame::ObeyChildPropertyType Gtk::AspectFrame::obey_child_property("obey_child");

