/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  menushell_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_GTK_MENU_SHELL_CLASS_H
#define INTI_GTK_MENU_SHELL_CLASS_H

#include <inti/gtk/private/container_p.h>

namespace Inti {

namespace Gtk {

class MenuShellClass
{
public:
	static void init(GtkMenuShellClass *g_class);

	static GType get_type();

	static void* create();

// Methods
	static void select_item_proxy(GtkMenuShell *menu_shell, GtkWidget *menu_item);

	static void insert_proxy(GtkMenuShell *menu_shell, GtkWidget *child, gint position);

	static int get_popup_delay_proxy(GtkMenuShell *menu_shell);

// Signals
	static void deactivate_proxy(GtkMenuShell *menu_shell);

	static void selection_done_proxy(GtkMenuShell *menu_shell);
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_MENU_SHELL_CLASS_H

