/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  scrolledwindow.cc - GtkScrolledWindow C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "scrolledwindow.h"
#include "private/scrolledwindow_p.h"
#include "scrollbar.h"

using namespace Inti;

Gtk::ScrolledWindow::ScrolledWindow(GtkScrolledWindow *scrolled_window, bool reference) 
: Bin((GtkBin*)scrolled_window, reference)
{
}

Gtk::ScrolledWindow::ScrolledWindow() 
: Bin((GtkBin*)ScrolledWindowClass::create())
{
}

Gtk::ScrolledWindow::ScrolledWindow(Adjustment *hadjustment, Adjustment *vadjustment)
: Bin((GtkBin*)ScrolledWindowClass::create())
{
	set_hadjustment(hadjustment);
	set_vadjustment(vadjustment);
}

Gtk::ScrolledWindow::~ScrolledWindow()
{
}

GtkScrolledWindowClass* 
Gtk::ScrolledWindow::gtk_scrolled_window_class() const 
{ 
	return get_class<GtkScrolledWindowClass>();
}
	
Gtk::ScrolledWindow::operator GtkScrolledWindow* () const 
{ 
	return this ? gtk_scrolled_window() : 0;
}
	
Gtk::HScrollbar*
Gtk::ScrolledWindow::hscrollbar() const
{
	return G::Object::wrap<HScrollbar>((GtkHScrollbar*)gtk_scrolled_window()->hscrollbar);
}

Gtk::VScrollbar*
Gtk::ScrolledWindow::vscrollbar() const
{
	return G::Object::wrap<VScrollbar>((GtkVScrollbar*)gtk_scrolled_window()->vscrollbar);
}

Gtk::Adjustment*
Gtk::ScrolledWindow::get_hadjustment() const
{
	return G::Object::wrap<Adjustment>(gtk_scrolled_window_get_hadjustment(gtk_scrolled_window()));
}

Gtk::Adjustment*
Gtk::ScrolledWindow::get_vadjustment() const
{
	return G::Object::wrap<Adjustment>(gtk_scrolled_window_get_vadjustment(gtk_scrolled_window()));
}

void 
Gtk::ScrolledWindow::get_policy(PolicyType *hscrollbar_policy, PolicyType *vscrollbar_policy) const
{
	gtk_scrolled_window_get_policy(gtk_scrolled_window(), (GtkPolicyType*)hscrollbar_policy, (GtkPolicyType*)vscrollbar_policy);
}

Gtk::CornerType 
Gtk::ScrolledWindow::get_placement() const 
{
	return (CornerType)gtk_scrolled_window_get_placement(gtk_scrolled_window());
}

Gtk::ShadowType
Gtk::ScrolledWindow::get_shadow_type() const
{
	return (ShadowType)gtk_scrolled_window_get_shadow_type(gtk_scrolled_window());
}

void 
Gtk::ScrolledWindow::set_hadjustment(Adjustment *hadjustment)
{
	gtk_scrolled_window_set_hadjustment(gtk_scrolled_window(), *hadjustment);
}

void 
Gtk::ScrolledWindow::set_vadjustment(Adjustment *vadjustment)
{
	gtk_scrolled_window_set_vadjustment(gtk_scrolled_window(), *vadjustment);
}

void
Gtk::ScrolledWindow::set_policy(PolicyType hscrollbar_policy, PolicyType vscrollbar_policy)
{
	gtk_scrolled_window_set_policy(gtk_scrolled_window(), (GtkPolicyType)hscrollbar_policy, (GtkPolicyType)vscrollbar_policy);
}

void
Gtk::ScrolledWindow::set_policy_automatic()
{
	gtk_scrolled_window_set_policy(gtk_scrolled_window(), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
}

void
Gtk::ScrolledWindow::set_placement(CornerType window_placement)
{
	gtk_scrolled_window_set_placement(gtk_scrolled_window(), (GtkCornerType)window_placement);
}

void 
Gtk::ScrolledWindow::set_shadow_type(ShadowType type)
{
	gtk_scrolled_window_set_shadow_type(gtk_scrolled_window(), (GtkShadowType)type);
}

void 
Gtk::ScrolledWindow::add_with_viewport(Widget& child)
{
	gtk_scrolled_window_add_with_viewport(gtk_scrolled_window(), child.gtk_widget());
}

/*  Gtk::ScrolledWindowClass
 */

void
Gtk::ScrolledWindowClass::init(GtkScrolledWindowClass *g_class)
{
	BinClass::init((GtkBinClass*)g_class);
}

GType
Gtk::ScrolledWindowClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_SCROLLED_WINDOW, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::ScrolledWindowClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Properties
 */

const Gtk::ScrolledWindow::HAdjustmentPropertyType Gtk::ScrolledWindow::hadjustment_property("hadjustment");

const Gtk::ScrolledWindow::VAdjustmentPropertyType Gtk::ScrolledWindow::vadjustment_property("vadjustment");

const Gtk::ScrolledWindow::HScrollbarPolicyPropertyType Gtk::ScrolledWindow::hscrollbar_policy_property("hscrollbar_policy");

const Gtk::ScrolledWindow::VScrollbarPolicyPropertyType Gtk::ScrolledWindow::vscrollbar_policy_property("vscrollbar_policy");

const Gtk::ScrolledWindow::WindowPlacementPropertyType Gtk::ScrolledWindow::window_placement_property("window_placement");

const Gtk::ScrolledWindow::ShadowTypePropertyType Gtk::ScrolledWindow::shadow_type_property("shadow_type");

