use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

# Include file directories.
$INC  = '-I/usr/local/include';

# Alternative library specifications.
$LIBS = ['-L/usr/local/lib -lmdn -liconv'];

# Character codeset name that iconv() recognizes as Japanese EUC
# (for `make test').  Note that iconv() on Solaris accepts 'eucJP',
# not 'EUC-JP'.
$EUC_JP = 'EUC-JP';

# Subdirectories.
$DIR  = ['Log', 'UTF8', 'ResConf', 'API'];

######################################################################
make_localcodeset();
make_sub_Makefile_PL();

WriteMakefile(
    'NAME'	=> 'MDN',
    'DIR'       => $DIR,
    'VERSION_FROM' => 'ResConf/ResConf.pm',
    'clean'     => {FILES => 'eucjp'},
);

sub make_localcodeset () {
    open(FILE, "> eucjp")
    or die "$0: failed to open the file, $!: eucjp\n";
    print FILE "\$EUC_JP = '$EUC_JP';\n";
    print FILE "\$ENV{'MDN_LOCAL_CODESET'} = '$EUC_JP';\n";
    print FILE "1;\n";
    close(FILE);
}

sub make_sub_Makefile_PL () {
    my ($dir, $lib, $makefile_pl);

    foreach $dir (@{$DIR}) {
	$makefile_pl = "$dir/Makefile.PL";
	unlink($makefile_pl) if (-f $makefile_pl);
	open(FILE, "> $makefile_pl")
	or die "$0: failed to open the file, $!: $makefile_pl\n";
	print FILE "use ExtUtils::MakeMaker;\n\n";
	print FILE "WriteMakefile(\n";
	print FILE "    'NAME'      => 'MDN::$dir',\n";
	print FILE "    'VERSION_FROM' => '$dir.pm',\n";
	print FILE "    'LIBS'      => [";
	foreach $lib (@{$LIBS}) {
	    print FILE "'$lib', ";
	}
	print FILE "],\n";
	print FILE "    'DEFINE'    => '',\n";
	print FILE "    'INC'       => '$INC -I../common',\n";
	print FILE "    'TYPEMAPS'  => ['../common/typemap'],\n";
	print FILE ");\n";
	close(FILE);
    }
}
