#TLEX start=default
module Web
  module CSS
    class Scanner
      H          = "[0-9a-f]"
      NONASCII   = "[\302\240-\364\217\277\277]"
      UNICODE    = "\\\\#{H}{1,6}[ \\t\\r\\n\\f]?"
      ESCAPE     = "(?:#{UNICODE}|\\\\[ -~\302\240-\364\217\277\277])"
      NMSTART    = "(?:[a-z]|#{NONASCII}|#{ESCAPE})"
      NMCHAR     = "(?:[a-z0-9\-]|#{NONASCII}|#{ESCAPE})"
      NL         = "(?:\\n|\\r\\n|\\r|\\f)"
      STRING1    = "(?:\"([\\t !\#$%&(-~]|#{NL}|\'|#{NONASCII}|#{ESCAPE})*\")"
      STRING2    = "(?:\'([\\t !\#$%&(-~]|#{NL}|\"|#{NONASCII}|#{ESCAPE})*\')"
      IDENT      = "#{NMSTART}#{NMCHAR}*"
      NAME       = "#{NMCHAR}+"
      NUM        = "(?:[0-9]+|[0-9]*\.[0-9]+)"
      STRING     = "(?:#{STRING1}|#{STRING2})"
      URL        = "(?:[!\#$%&*-~]|#{NONASCII}|#{ESCAPE})*"
      W          = "[ \\t\\r\\n\\f]*"
      RANGE      = "\\?{1,6}|#{H}(\\?{0,5}|#{H}(\\?{0,4}|#{H}(\\?{0,3}|#{H}(\\?{0,2}|#{H}(\\?\\?|#{H})))))"
###
#:default
#/[ \t\r\n\f]+/ui
          push [:S,matched]

#/\/\*/ui
          transit_state :comment
#/<!--/ui
          push [:CDO,matched]
#/-->/ui
          push [:CDC,matched]
#/~=/ui
          push [:INCLUDES,matched]
#/\|=/ui
          push [:DASHMATCH,matched]
#/#{STRING}/ui
          push [:STRING,matched]
#/url\(#{W}(#{STRING})#{W}\)/ui
          push [:URI,matched]
#/url\(#{W}(#{URL})#{W}\)/ui
          push [:URI,matched]
#/#{IDENT}/ui
          push [:IDENT,matched]
#/\##{NAME}/ui
          push [:HASH,matched]
#/@#{IDENT}/ui
          case matched.downcase
          when "@import"
            push [:IMPORT_SYM,matched]
          when  "@page"
            push [:PAGE_SYM,matched]
          when  "@media"
            push [:MEDIA_SYM,matched]
          when "@font-face"
            push [:FONT_FACE_SYM,matched]
          when "@charset"
            push [:CHARSET_SYM,matched]
          else
            push [:ATKEYWORD,matched]
          end
#/!#{W}important/ui
          push [:IMPORTANT_SYM,matched]
#/(#{NUM})em/ui
          push [:EMS,matched]
#/(#{NUM})ex/ui
          push [:EXS,matched]
#/(#{NUM})px/ui
          push [:LENGTH,matched]
#/(#{NUM})cm/ui
          push [:LENGTH,matched]
#/(#{NUM})mm/ui
          push [:LENGTH,matched]
#/(#{NUM})in/ui
          push [:LENGTH,matched]
#/(#{NUM})pt/ui
          push [:LENGTH,matched]
#/(#{NUM})pc/ui
          push [:LENGTH,matched]
#/(#{NUM})deg/ui
          push [:ANGLE,matched]
#/(#{NUM})rad/ui
          push [:ANGLE,matched]
#/(#{NUM})grad/ui
          push [:ANGLE,matched]
#/(#{NUM})ms/ui
          push [:TIME,matched]
#/(#{NUM})s/ui
          push [:TIME,matched]
#/(#{NUM})Hz/ui
          push [:FREQ,matched]
#/(#{NUM})kHz/ui
          push [:FREQ,matched]
#/(#{NUM})(#{IDENT})/ui
          push [:DIMEN,matched]
#/(#{NUM})%/ui
          push [:PERCENTAGE,matched]
#/(#{NUM})/ui
          push [:NUMBER,matched]
#/(#{IDENT})\(/ui
          push [:FUNCTION,matched]
#/U\+#{RANGE}/ui
          push [:UNICODERANGE,matched]
#/U\+#{H}{1,6}-#{H}{1,6}/ui
          push [:UNICODERANGE,matched]
#/#{IDENT}/ui
          push [:IDENT,matched]
#/./ui
          push [matched.intern,matched]

#:comment
#/[^*]/ui
          #
#/\*\//ui
          transit_state :default
#/./ui
          #
###
     end # Scanner
  end # CSS
end # Web
if $0==__FILE__
  scan = Web::CSS::Scanner.new(ARGF)
  while token=scan.token
    p token
  end
end
