/***************************************************************************
  $RCSfile: keyfile.h,v $
  -------------------
  cvs         : $Id: keyfile.h,v 1.5 2003/05/18 21:46:36 aquamaniac Exp $
  begin       : Mon Apr 14 2003
  copyright   : (C) 2003 by Martin Preuss
  email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KEYFILE_H
#define KEYFILE_H



#include <openhbci/api.h>
#include <openhbci/mediumplugin.h>

#include "mediumkeyfile.h"

#define KEYFILE_PLUGIN_VMAJOR 1
#define KEYFILE_PLUGIN_VMINOR 0

#define KEYFILE_MODULE_CURRENT  0
#define KEYFILE_MODULE_REVISION 0
#define KEYFILE_MODULE_AGE      0

#ifdef __cplusplus
namespace HBCI {



/**
 * This is the plugin for RDH keyfiles in OpenHBCI's own format.
 * @author Martin Preuss<martin@libchipcard.de>
 */
class KeyFilePlugin: public MediumPlugin {
private:
  const API *_api;

public:
  KeyFilePlugin(const API *api);
  virtual ~KeyFilePlugin();

  virtual string name() const { return "KeyFilePlugin";};
  virtual string description() const { return "Plugin for RDH Keyfiles";};
  virtual unsigned int vmajor() const { return KEYFILE_PLUGIN_VMAJOR;};
  virtual unsigned int vminor() const { return KEYFILE_PLUGIN_VMINOR;};

  /**
   * Returns the name of the MediumType (such as "RSACard", "DDVCard").
   */
  virtual string mediumTypeName() const { return KEYFILE_TYPENAME;};

  virtual MediumType mediumType() const { return MediumTypeFile;};

  /**
   * This method should only be used if there is no configuration file.
   * It creates a medium with default settings.
   */
  virtual Pointer<Medium> mediumFactory(const string &name);

  Error mediumCheck(string &name) const;

  /**
   * Creates a new medium. This method checks whether the file already
   * exists. If it does that file will be used (no keys will be generated,
   * and the medium will not be checked for the context given).
   * If the file does not exist it will be created and user keys will be
   * generated.
   */
  virtual Pointer<Medium> createNewMedium(bool readonly,
					  int country,
					  const string &bankId,
					  const string &userid,
					  const string &name);

  /**
   * This method is used to create a medium object using the data given in
   * a configuration file.
   * There are some mandatory variables in this group:
   * <ul>
   *  <li>
   *   mediumtype: This is used to lookup the medium plugin that is
   *   responsible for this medium
   *  </li>
   *  <li>
   *   mediumname: This is used to identify a medium. Each medium MUST have
   *   a unique name. RDHFiles use the path and name of the keyfile here,
   *   while chipcard media use the card's serial number.
   *  </li>
   * </ul>
   * The plugin may additionally use whichever variables it finds necessary.
   */
  virtual Pointer<Medium> mediumFromConfig(SimpleConfig &cfg,
					   cfgPtr group);

  /**
   * This method is used to store information from a medium to a configuration
   * file (in order to be restorable by @ref mediumFromConfig).
   * See @ref mediumFromConfig for details about the config group.
   */
  virtual Error mediumToConfig(Pointer<Medium> m,
			       SimpleConfig &cfg,
			       cfgPtr group);


};

}; // namespace

#endif // __cplusplus

#endif



