/*  A normal roxen module that listens to a port */
/* 
 * $Log: pop3.pike,v $
 * Revision 1.3  1998/06/04 13:20:45  kiwi
 * Modification de files.port par Stdio.Port
 *
 * Revision 1.2  1998/01/07 15:17:08  kiwi
 * Ajout de cvs_version
 *
 * Revision 1.1.1.1  1998/01/07 14:54:09  kiwi
 * Modules pour le serveur Roxen de provance diverses
 *
 */

string cvs_version= "$Id: pop3.pike,v 1.3 1998/06/04 13:20:45 kiwi Exp $";

inherit "roxenlib";
inherit "http";
inherit "module";
#include <module.h>
#include <stdio.h>

int	connected=0;	// Current connections counter
int	nb_conn=0;	// Total connections counters
int	succ=0;		// Successful logins
int	fail=0;		// Fail logins	

array register_module()
{
  //   No type. :-)
  return ({ 0, "POP3 server module",
	      "This module acts as a POP3 server with Roxen... <br> This can be used as a remplacement of pop3d or popper runned from inetd." });
}

void create()
{
  defvar("port", 4711, "Listen port", TYPE_INT, "The port where this POP3 server listen.");
  defvar("mailspool", "/var/spool/mail/", "Mail Spool", TYPE_DIR, "The place where is stored mail files.");
  defvar("logfile","../logs/pop3.log", "Log file for POP3 server", TYPE_FILE, "The log file to POP3 server.");
}


class Connection
{
  inherit "module";
  inherit "http";
  inherit "roxenlib";
  

  class fake_id
  {
    // An object which fakes an instance of protocols/http.pike.
    // We fake the object since we don't need all the variables
    // and functions in protocols/http.pike. This object ought
    // to have been separated from protocols/http.pike a long
    // time ago.
    //		/grubba

    object conf;
    string raw_url = "pop3://";

    string method = "";

    string remote_addr;

    mapping(string:string) variables = ([]);
    mapping(string:mixed) misc = ([]);

    multiset   (string) prestate     = (< >);
    multiset   (string) config       = (< >);
    multiset   (string) supports     = (< >);

    array(string) client = ({});
    array(string) referer = ({});
    multiset(string) pragma = (<>);

    mapping(string:string) cookies = ([]);

    object my_fd;	// The client.

    string realfile, virtfile;
    string rest_query="";
    string raw;
    string query;
    string not_query;
    string extra_extension = ""; // special hack for the language module
    string data;
    array (int|string) auth;
    string rawauth, realauth;
  };
  
  object(fake_id) id = fake_id();

  object fd;
  object master;
  inherit Stdio;

  function logf;		// Fichier de log
  function mailbox;		// Mailbox file

  string buffer="";

  string username="";
  int	loginok=0;

  void send(string data)
  {
    if(!strlen(buffer))
      buffer = data[fd->write(data)..];
    else
      buffer += data;
  }

  void timeout()
  {
    send("-ERR Timeout (3600 seconds): closing connection.\r\n");
    master->connected--;
    destruct(this_object());
  }

  // This close the connection
  void user_quit()
  {
    send("+OK Bye, It was a pleasure to talk to you... See you later !\r\n");
    master->connected--;
    destruct(this_object());
  }

  // This check the login name given and sets the global
  // variable 'username' to the correct value
  int user_entry(string login)
  {
    string login_name="", login_junk="";
    
    if ( login=="")
    {
      send("-ERR you must enter an account name to use this server.\r\n");
      master->fail++;
      return 1;
    }
    if (sscanf(login, "%s %s", login_name, login_junk)>=2)
    {
      send("-ERR you must enter only ONE account name... Junk as \"" +
	   login_junk + "\" is NOT allowed.\r\n");
      master->fail++;
      return 2;
    }
    send("+OK Hello "+login+", send your pass with the PASS command.\r\n");
    username = login;
    return 0;
  } 

  // This check if 'username' is set, then check the password in regards of the
  // auth module, and tell the user the process is correct
  int user_pass(string mot_de_passe)
  {
    array y;
    string pass_real="", pass_junk="";

    if ( username == "" ) 
    {
      send("-ERR You must login before with the USER command "
	   "**BEFORE** using PASS command.\r\n");
      master->fail++;
      return 1;
    }
    if ( mot_de_passe == "") 
    {
      send("-ERR Sorry but for security reasons you MUST have a password "
	   "to user this server. Please contact your system administrator "
	   "for more information.\r\n");
      master->fail++;
      return 2;
    }
    if ( sscanf(mot_de_passe, "%s %s", pass_real, pass_junk)>=2) 
    {
      send("-ERR Sorry, but whitespace is NOT authorized in the password. "
	   "You should consider that \"" + pass_junk + "\" may not be in "
	   "your password.\r\n");
      master->fail++;
      return 3;
    }  
    // We can now login and test our passwords...

    id->method="LOGIN";
    y = ({"Basic", username+":"+mot_de_passe});
    id->realauth = y[1];
    if (id->conf && id->conf->auth_module)
    {
      y = id->conf->auth_module->auth( y, id );
     
      roxen_perror(sprintf("y: %O\n"
			   "id->auth: %O\n", y, id->auth));

      // Authentification is successfull !
      if ( y[0] == 1)
      {
        send("+OK User "+username+" is logged in.\r\n");
        loginok=1;		// Login is OK other functions are unlocked
        master->succ++;
      }
      else
      {
	send("-ERR User "+username+" is not allowed to user this server.\r\n");
        master->fail++;
	return 4;
      }
    } else {
      send("-ERR Sorry, the server does not have a user-database module "
	   "configured. Please contact your system administrator to "
	   "remedy.\r\n");
      master->fail++;
      return 5;
    }
  }




  /* --------------------------------------------------------------------- */
  /* Copie le contenu du fichier de nom "ofn" dans le fichier de nom "dfn" */
  /* --------------------------------------------------------------------- */
  void concatene_fichier(string s_ofn, string s_dfn )
  {
      /* object o_of,o_df; */    /* / fichier origine, fichier destiniation*/
      object(File) o_of = File();
      object(File) o_df = File();
      string s_tmp;                 /* 8/ chqine temporaire */
      int i_t;                   /*  / taille fichier  */
      int i_start=0, i_len=32,i_ret;
 
      /* Ouverture des fichiers */
      if(!o_df->open(s_dfn,"awc"))
         send("Couldn't open file "+s_dfn+".\n");
   
      if(!o_of->open(s_ofn,"awc"))
         send("Couldn't open file "+s_ofn+".\n");
      /* 
        if ( ! ( o_df->open( s_dfn ) )
         {
            send("Pb ouverture fichier dest !");
            retrun 2;
         }
         if ( ! ( o_of->open( s_ofn ) )
         {
            send("Pb ouverture fichier orig");
            return 2;
         }
      */

         /* Calcul de la taille du fichier destinaition */
         i_t = Stdio.file_size( s_dfn );
         send("DEBUG: taille fichier destination:" + i_t + "\r\n");
   
         o_df->seek(i_t);
    
        if ( s_tmp = o_of->read( i_len) )
        {
               i_start += i_len;
               send("debug:s_tmp='"+s_tmp+"'.\n");
               
               i_ret = o_df->write ( s_tmp );
               send("i_ret='"+i_ret+"'.\r\n");
        }
        o_of->close();
        o_df->close();
    }




  int user_stat()
  {
    object o_df,o_of; //origine,destination
    o_df = o_of = Stdio.File();

    string s_chemin = "/var/spool/mail/";
    string s_ofn,s_dfn,s_tmp;			 // Orig_file_name, dest_file_name
    int i_cpt,i_start,i_nbr;
    int i_nm,i_tm;                               // nbr_mail, taille_des_mails
	int i_t,i_ofs;				// orig_file_size
    int i_len, i_tmp, i_ret;
    i_tmp=0;
    int i_secur=0;

    roxen_perror(sprintf("Dde de stat\r\n"));
 
    if ( !loginok && (username == "") )
    {
      send("-ERR You must login before with the USER and PASS command "
           "**BEFORE** using STAT command.\r\n");
      return 1;
    }
  
    s_ofn = s_chemin + username;
    s_dfn = s_chemin + "." + username + ".pop3";

    send("DEBUG:orig_file='" + s_ofn + "'.\r\n" );
    send("DEBUG:dest_file='" + s_dfn + "'.\r\n" );

    i_ofs = Stdio.file_size ( s_ofn );     
    /* Calcul de la taille a ce niveau afin d'afficher lors de la sortie la taille 
       correspondante aux donnees traitees...
    */
    send("DEBUG: Taille fichier=" + i_ofs + ".\r\n");
    if ( i_ofs < 1 ) 		           /* Stdio->filesize ( s_ofn ) < 1 )  */
    {
       send("+OK 0 0\r\n");
       return 0;
    }
    
    if ( ! mv ( s_ofn, s_dfn ) )
    {
      send("-ERR Cannot open the mailbox file !!!!\r\n");
      send("__Please to use the 'quit' command__");
      return 2;
    }

    send ("DEBUG: creation du fichier temporaire");
    /* creation du fichier client 
       permett la reception de courrier pendant la consultation 
    */
    if( ! (o_of->open(s_ofn,"rwc")))
    {
      /* Pb de creation */
      send("-ERR Cannot open the mailbox file !!!!\r\n");
      return 2;
    }
    send(" reussie\r\n");
    o_of->close();

    send("DEBUG:av ouverture '"+ s_dfn +"'\r\n");
    if( ! (o_df->open( s_dfn,"r")))
    {
       send("-ERR Cannot open the temporary file !!!\r\n");
       return 2;
    }


    i_cpt = 0;
    i_len=512; /*1024;*/

    /* Calcul du nombre de messages contenu dans le fichier mail */
    /* M'ENFIN POUR L'INSTANT c'EST TOUT FAUX !!!!!!!!!!!! */
    while ( i_cpt < i_ofs ) 				//i_secur++ < 2 )
    {
         if ( s_tmp = o_df->read( i_len) )
         {
              /* Equiv bqrre progression... */
              i_cpt += i_len;
    
              /* Recherche de lq chaine "\r\nFrom " [+tard "\r\nFrom nom_user@" ]   */
              /* TODO !!!! */
              i_tmp = search( s_tmp,"From ");
   
//            send("debug:s_tmp='"+s_tmp+"'.\n");
         }
  
	 send("DEBUG:progress:"+i_cpt+"/"+i_ofs+"  \r\n");
    }
    o_df->close();   

    /* Test la reception de courrier pendant la consultation */
    if ( Stdio.file_size(s_ofn) > 0 )
    {
         send("DEBUG: Courrier recu pdt consultation ! Dde de concatenation ! ");
	 /* Dde de concatenation pour reconstituer le fichier de mail */
         concatene_fichier( s_ofn, s_dfn );
    }
    

    if ( ! mv ( s_dfn, s_ofn ) )
    {
        send("-ERR Cannot open the mailbox file !!!!\r\n");
        send("__Please to use the 'quit' command__");
        return 2;
    }
    send("+OK " + i_nm + " " + i_ofs +"\r\n"); 
    return 0;
  }

  void handle_command(string command)
  {
    string cmd="", arg="";
    
    // Decodes commands and args into 2 variables...
    if (sscanf(command, "%s %s",cmd,arg)<2)
      arg="", cmd=command;
    
    // Lower case the command to help the next switch
    cmd=lower_case(cmd);
   
    // Dispaches all the POP3 commands to their own respectives procedures...

    switch (cmd)
    {
     case "user" : user_entry(arg); break;
     case "pass" : user_pass(arg); break;
     case "quit" : user_quit(); break;
     case "stat" : user_stat(); break;

     default : send("-ERR Command \""+cmd+"\" is not implemented.\r\n");
    } 

  }
  
  string cache="";
  void got_data(object f, string data)
  {
    // do something with data...
    // This example code buffers it one line at a time, and calls a function
    // for each line.
    data -= "\r";
    array tmp;
    tmp = (cache + data)/"\n";
    cache = tmp[-1];
    foreach(tmp[..sizeof(tmp)-2]-({""}), data)
      handle_command(data);
  }

  void client_closed()
  {
    werror("Client closed connection.\n");
    destruct(this_object());
  }
  
  void write_more()
  {
    if(strlen(buffer))
    {
      int written = fd->write(buffer);
      if(written == 0)
	client_closed();
      else
	buffer = buffer[written..];
    }
  }

  void destroy()
  {
    m_delete(master->connections, this_object());
  }
  
  void create(object f, object m)
  {
    // Initialize the id object.
    id->conf = m->conf;
    id->my_fd = f;
    id->remote_addr = f->query_address();

    master = m;

    werror("Got connection from "+f->query_address()+"\n");
    fd = f;
    call_out(timeout,3600);
    master->connected++;
    master->nb_conn++;
    send("+OK POP3 server for Roxen Challenger 1.2 - Version pre-0.99 - (C)Copyright 1997 Xavier Beaudouin <kiwi@kazar.com>\r\n");
    f->set_nonblocking(got_data, write_more, client_closed);
  }
};

object conf;
object socket;
mapping connections = ([]);

object got_connection()
{
  object o = socket->accept();
  if(o) connections[Connection(o, this_object())]=1;
}

void stop()
{
  destruct(socket);
}

void start(int mode, object configuration)
{
  if(configuration)
  {
    conf = configuration;

    object privs = ((program)"privs")("Opening socket");
    if(socket) destruct(socket);
    socket = Stdio.Port();
    if(!socket->bind(query("port"), got_connection))
      report_error("Failed to bind to port "+query("port")+"\n");
  }
}

string status()
{
  return
    ("<h1>Security info</h1>"+
     "<b>Successful auths:</b> "+(string)succ+"<br>\n" +
     "<b>Failed auths:</b> "+(string)fail+"<br>\n" +
     "<h1>Hosts statistics</h1>" +
     "<b>Connected hosts:</b> "+(string)connected+"<br>\n"+
     "<b>Numbers of connections:</b> "+(string)nb_conn+"<br>\n"
    );
}
