// POP3.pmod
// $Id: POP3.pmod,v 1.4 2000/10/17 22:20:33 kiwi Exp $

class protocol {
  inherit Stdio.FILE : pop3;

  string rest;
  string return_string;
  int return_code;

  int get_return_code() {
    return return_code;
  }

  string get_return_string() {
    return return_string;
  }

  array(mixed) readreturncode() {
    int code;
    string tmp=pop3::gets();
    string str,err;

    if(!tmp) 
      return 0;
    sscanf(tmp,"%s %s",err,str);
    if (err == "+OK") {
      code=0;
    } else {
      code=-1;
    }
    return_code=code;
    return_string=str;
    return ({code,str});
  }

  /*  array(string) read_body_lines_with_progress(function update) {
    array(string) ret=({});
    string s;
    int size=0;
    while(s = pop3::gets()) {
      if (s=="." || s==".\r")
	return ret;
      ret+=({s});
      size+=sizeof(s);
      update(size);
    }
    return ret;
    } */

  array(string) read_body_lines() {
    array(string) ret=({});
    string s;
    while(s = pop3::gets())
    {
      if(s=="." || s==".\r") return ret;
      //      sscanf(s,".%s",s);
      ret+=({s});
    }
    return ret;
    //    throw(({"POP3: connection closed by news server.\n",backtrace()}));
  }

  string readreturnbody() {
    array(string) tmp=read_body_lines();
    return tmp*"\n"+"\n";
  }

  /*  void writebody(string s)
  {
  s=replace(s,"\r","");
  foreach(s/"\n",string line)
  {
  if(strlen(line) && line[0]=='.')
  line="."+line+"\r\n";
  else
  line=line+"\r\n";
  if(news::write(line) != strlen(line))
  throw(({"NNTP: Failed to write body\n",backtrace()}));
  }
  news::write(".\r\n");
  } */
  
  array(mixed) command(string cmd) {
    pop3::write(cmd+"\r\n");
    return readreturncode();
  }
  
  int failsafe_command(string cmd) {
    if(command(cmd)[0])
      throw(({"POP3 "+cmd+" failed\n",backtrace()}));
  }
  
  string do_cmd_with_body(string cmd) {
    failsafe_command(cmd);
    return readreturnbody();
  }
  
};

class client {

  inherit protocol;
  string server,user,pass;

  //  class Mail {
  //    int last;
  //    mapping(int:string) size;
  //  }

  //  object(Mail) m;
  int got_list=0;

  mapping(int:string) list_msgs() {
    mapping(int:string) info=([]);
    array(mixed) ret;

    ret=command("list");
    foreach(read_body_lines(),string line) {
      int id,size;
      sscanf(line,"%d %d",id,size);
      info[id]=size;
    }
    return info;
  }
  
  array(string) top(int ind, int lines) {
    failsafe_command("top "+ind+" "+lines);
    //    return readreturnbody();
    return read_body_lines();
  }
  
  array(string) body(int d) {
    failsafe_command("retr "+d);
    return read_body_lines();
  }
  
  array(mixed) dele(int d) {
    array(mixed) ret;
    ret=command("dele "+d);
    return(ret);
  }
  
  /*  array(string) body_with_progress(int d, function update) {
    command("retr "+d);
    return read_body_lines_with_progress(update);
    } */

  array(mixed) login(string user,string pass) {
    array(mixed) ret;
    ret=command("user "+user);
    if (ret[0]<0)
      return(ret);
    command("pass "+pass);
    ret=readreturncode();
    return(ret);
  }

  void quit() {
    command("quit");
  }

  array(int) stat() {
    array(mixed) ret;
    ret=command("stat");
    array td=ret[1]/" ";
    return (array(int))td;
  }

  void create(void|string s) {
    if (s)
      server=s;
  }
  
  void disconnect() {
    quit();
  }

  int doconnect(void|string s) {
    if (s)
      server=s;
    else if (!sizeof(server))
      server=getenv("POP3SERVER");

    if (!connect(server,110)) {
      return -1;
    }
  }
};
