/* Copyright (C) 1995 Bjoern Beutel. */

/* Description. =============================================================*/

/* This module contains structures and functions for the run-time lexicon. */

/* Functions. ===============================================================*/

extern void init_lexicon( string_t file_name );
/* Initialise this module. Read lexicon from file FILE_NAME. */

extern void terminate_lexicon( void );
/* Terminate this module. */

extern void search_for_prefix( string_t string );
/* Search lexicon for prefixes of STRING in increasing length. 
 * The results are obtained by calling "get_next_prefix". */

extern bool_t get_next_prefix( string_t *string_p, value_t *fs );
/* Get the next lexicon entry that is a prefix of STRING. 
 * Return FALSE iff no more entries exist.
 * If another entry exists, set *STRING_P to the remainder of STRING
 * and *FS to the feature structure assigned to the lexicon entry.
 * STRING must have been set by "search_for_prefix". */

/* End of file. =============================================================*/
