/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _MAS_CONSTANTS_H
#define _MAS_CONSTANTS_H

/***********************************************************************
 * mas_constants.h
 *
 * System-wide #define constants.
 ***********************************************************************/

#define MAS_VERSION_MAJOR 0
#define MAS_VERSION_MINOR 6
#define MAS_VERSION_TEENY 0
#define MAS_NAME          "Media Application Server"

/* UNIX domain socket listening post */
#define RTP_UNIX_LISTEN_FILE   "RTP"
#define RTCP_UNIX_LISTEN_FILE  "RTCP"

/* scheduling priorities.  higher numbers are higher priority. */
#define MAS_PRIORITY_IDLE         0
#define MAS_PRIORITY_DATAFLOW     20
#define MAS_PRIORITY_ROUNDTUIT    30
#define MAS_PRIORITY_ASAP         50
#define MAS_PRIORITY_YESTERDAY    100

/* port types */
/* 0 is undefined */
#define MAS_SOURCE   1
#define MAS_SINK     2
#define MAS_REACTION 3
#define MAS_RESPONSE 4

#define MAX_FNAME_LENGTH       512
#define MAX_PORT_NAME_LENGTH   256
#define MAX_DEV_NAME_LENGTH    128
#define MAX_DEVICE_PORTS       256
#define MAX_DATACHAR_VALUE_LEN 128
#define MAX_ACTION_NAME_LENGTH 128
#define MAX_STRING_LENGTH      256
#define MIN_PACKAGE_SIZE       64
#define MAX_MC_CLK_NAME_LENGTH 32
#define MAX_ASMB_NAME_LENGTH   256

#define MAS_ASM_INSTANCE 0
#define MAS_SCH_INSTANCE 1
#define MAS_MC_INSTANCE  2

/* used by *_get_port_by_name */
#define MAS_ALL_DEVICES -1

/* protocol type defs */

#define MAS_INT8    'c'
#define MAS_UINT8   'C'
#define MAS_INT16   's'
#define MAS_UINT16  'S'
#define MAS_INT32   'l'
#define MAS_UINT32  'L'
#define MAS_INT64   'q'
#define MAS_UINT64  'Q'
#define MAS_FLOAT   'f'
#define MAS_DOUBLE  'd'
#define MAS_STRING  'a'
#define MAS_PAYLOAD 'p'
#define MAS_PACKAGE 'P'

#define MAS_PAYLOAD_NUMLEN 5

#define MAS_CHANNEL_TYPE_DATA    0
#define MAS_CHANNEL_TYPE_CONTROL 1

#define MAS_ASTAT_WINDOW_SIZE 50

#define MAS_MC_SYSCLK_US 0
#define MAS_MC_8000      1
#define MAS_MC_11025     2
#define MAS_MC_16000     3
#define MAS_MC_22050     4
#define MAS_MC_32000     5
#define MAS_MC_44100     6
#define MAS_MC_48000     7
#define MAS_MC_96000     8

/* signal handling */
#define MAS_SIGHNDL_IGNORE   0
#define MAS_SIGHNDL_DEFAULT  1
#define MAS_SIGHNDL_MAS      2
#define MAS_SIGHNDL_SHUTDOWN 3

/* GENERIC
****************************************************************/
#undef FALSE
#define FALSE   0
#undef TRUE
#define TRUE    1

/* MATH */
#ifndef M_PI
# define M_PI 3.14159265358979323864
#endif /* M_PI */

/* fixed integer limits */
#include <limits.h> /* try getting the C99 limits */

#ifndef UINT32_MAX 
#define UINT32_MAX 4294967295U
#endif
#ifndef INT32_MAX 
#define INT32_MAX 2147483647
#endif
#ifndef INT32_MIN
#define INT32_MIN (-INT32_MAX - 1)
#endif
#ifndef UINT16_MAX 
#define UINT16_MAX 65535
#endif
#ifndef INT16_MAX
#define INT16_MAX 32767
#endif
#ifndef INT16_MIN 
#define INT16_MIN (-32768)
#endif
#ifndef UINT8_MAX 
#define UINT8_MAX 255
#endif
#ifndef INT8_MAX
#define INT8_MAX 127
#endif
#ifndef INT8_MIN 
#define INT8_MIN (-128)
#endif

#endif /* _MAS_CONSTANTS_H */
