/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
/*
 * $Id: mas_real_time_process.c,v 1.2 2003/03/28 21:55:26 rocko Exp $
 *
 * Copyright (c) 2000, 2001 by Shiman Associates Inc. and Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions: The above
 * copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the names of the authors or
 * copyright holders shall not be used in advertising or otherwise to
 * promote the sale, use or other dealings in this Software without
 * prior written authorization from the authors or copyright holders,
 * as applicable.
 *
 * All trademarks and registered trademarks mentioned herein are the
 * property of their respective owners. No right, title or interest in
 * or to any trademark, service mark, logo or trade name of the
 * authors or copyright holders or their licensors is granted.
 *
 */
#include "mas/mas_real_time_process.h"
#include "mas/mas_error.h"
#include "mas/mas_types.h"

#include <stdio.h>
#include <stdlib.h>
/*** scheduling is a POSIX.1b thing *****************************/
#ifdef _POSIX_C_SOURCE
#include <sched.h>
#include <unistd.h>
#include <errno.h>
#endif /* POSIX */

/***************************************************************************/

static int _sched_priority = 0;

/***************************************************************************
 * mas_set_real_time_priority
 *
 * arguments:
 *    none
 *
 * Sets real time process scheduling priority on supported platforms.
 * May require superuser privledge.
 *
 * returns: error
 *
 ***************************************************************************/
int32
masc_set_real_time_priority( int priority )
{
#ifdef _POSIX_C_SOURCE
#if _POSIX_C_SOURCE >= 199309L  /* POSIX.1b ******************************/

    struct sched_param sched;
    /* in testing ******************************/
    if ( priority == 0 )
    {
        sched.sched_priority = sched_get_priority_min(SCHED_FIFO);

        /* be sure we have at least priority 1 */
        if ( sched.sched_priority == 0 )
            sched.sched_priority++;
    }
    else
        sched.sched_priority = priority;

    if (sched_setscheduler(0, SCHED_FIFO, &sched) < 0)
        return mas_error(MERR_SCHED);

    _sched_priority = sched.sched_priority;

#else
    return mas_error(MERR_NOSUPP);
#endif /* POSIX.1b */

#else /* not POSIX */

    /* Not supported *****************************************************/
    return mas_error(MERR_NOSUPP);

#endif/* ! _POSIX_C_SOURCE >= 199309L */

    return 0;
}

int32
masc_get_real_time_priority( void )
{
    return _sched_priority;
}
