/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _FUNCPARAM_H
#define _FUNCPARAM_H

/* MAS_FUNC_SEGLEN should be <= the buffer length of the anx device,
   until we can handle it better. ugh. */

#define MAS_FUNC_SEGLEN 640 /* 3.628ms */
#define FUNC_TOL 0.1

struct pink_coeff
{
    int b0, b1, b2, b3, b4, b5, b6;
};

struct func_params
{
    float A;
    float freq;
    float nextfreq;
    int   rate;
    int   segsize;
    int   samples_in_period;
    int   samplenum;
    float inside;
    int   period_us;
    int   recompute;

    /* filter coefficients */
    struct pink_coeff pf;
};

#endif /* _FUNCPARAM_H */
