/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * $Id: keyspace.c,v 1.1 2000/08/12 23:19:16 kos Exp $
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#include <gmp.h>

#include "common.h"
#include "keyspace.h"
#include "xmalloc.h"

int
keyspace_init(key_index_t i) {
  mpz_init(i);
  return 0;
}

int
keyspace_destroy(key_index_t i) {
  mpz_clear(i);
  return 0;
}

int
keyspace_inc(key_index_t i) {
  mpz_t j;

  mpz_init_set_str(j, "1", KEYSPACE_BASE);
  mpz_add(i, i, j);
  mpz_clear(j);
  return 0;
}

char *
keyspace_ntoa(key_index_t i) {
  static char buf[1024];
  
  keyspace_tostr(buf, 1024, i);
  return buf;
}

int
keyspace_shr(key_index_t r, key_index_t i, unsigned int j) {
  mpz_fdiv_q_2exp(r, i, j);
  return 0;
}
