#ifndef SOUND_MENU_H
#define SOUND_MENU_H

#include <pglineedit.h>
#include "Menu.h"

class SoundMenu : public Menu
{
    MENU_SINGLETON(Sound);

  public:
    void eventShow();
    void eventHide();

  protected:

    PARAGUI_CALLBACK(onOk);
    PARAGUI_CALLBACK(onCancel);
    PARAGUI_CALLBACK(onSoundSlider);
    PARAGUI_CALLBACK(onMusicSlider);
    PARAGUI_CALLBACK(onSoundCheck);
    PARAGUI_CALLBACK(onMusicCheck);

    void updateSoundWidgets();
    void updateMusicWidgets();

    Uint8 m_soundVolume;
    Uint8 m_musicVolume;
    bool m_soundEnabled;
    bool m_musicEnabled;
    
    Uint8 m_lastSoundVolume;
    Uint8 m_lastMusicVolume;
    bool m_lastSoundEnabled;
    bool m_lastMusicEnabled;

    bool m_autoPress;
};

#endif // SOUND_MENU
