/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.c,v 1.8 2002/10/23 15:05:39 le_zas Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"

int mplugins_processor_mail_dlinit(mconfig *ext_conf) {
	config_processor *conf = NULL;

	if (0 != strcmp(ext_conf->version, VERSION)) {
		M_DEBUG2(ext_conf->debug_level, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "version string doesn't match: (mla) %s != (plugin) %s\n", ext_conf->version, VERSION);
		return -1;
	}

	conf = malloc(sizeof(config_processor));
	memset(conf, 0, sizeof(config_processor));

	/* init the internal variables */
	conf->ignore_sender	= mlist_init();
	conf->ignore_receipient	= mlist_init();
	conf->ignore_domain	= mlist_init();

	conf->hide_sender	= mlist_init();
	conf->hide_receipient	= mlist_init();
	conf->hide_domain	= mlist_init();

	conf->group_sender	= mlist_init();
	conf->group_receipient	= mlist_init();
	conf->group_domain	= mlist_init();

	ext_conf->plugin_conf = conf;

	return 0;
}

int mplugins_processor_mail_dlclose(mconfig *ext_conf) {
	config_processor *conf = ext_conf->plugin_conf;

	if (!conf) {
		M_DEBUG0(ext_conf->debug_level, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "conf is NULL !!\n");
		return -1;
	}

	/* free the internal variables */
	mlist_free(conf->ignore_sender);
	mlist_free(conf->ignore_receipient);
	mlist_free(conf->ignore_domain);

	mlist_free(conf->hide_sender);
	mlist_free(conf->hide_receipient);
	mlist_free(conf->hide_domain);

	mlist_free(conf->group_sender);
	mlist_free(conf->group_receipient);
	mlist_free(conf->group_domain);

	free(ext_conf->plugin_conf);
	ext_conf->plugin_conf = NULL;

	return 0;
}

int mplugins_processor_mail_parse_config(mconfig *ext_conf, const char *filename, const char *section) {
	config_processor *conf = ext_conf->plugin_conf;

	const mconfig_values config_values[] = {
		/* configvalues */
		{"groupsender", M_CONFIG_TYPE_SUBSTITUTE, M_CONFIG_VALUE_APPEND, &(conf->group_sender)},
		{"groupreceipient", M_CONFIG_TYPE_SUBSTITUTE, M_CONFIG_VALUE_APPEND, &(conf->group_receipient)},
		{"groupdomain", M_CONFIG_TYPE_SUBSTITUTE, M_CONFIG_VALUE_APPEND, &(conf->group_domain)},

		{"hidesender", M_CONFIG_TYPE_MATCH, M_CONFIG_VALUE_APPEND, &(conf->hide_sender)},
		{"hidereceipient", M_CONFIG_TYPE_MATCH, M_CONFIG_VALUE_APPEND, &(conf->hide_receipient)},
		{"hidedomain", M_CONFIG_TYPE_MATCH, M_CONFIG_VALUE_APPEND, &(conf->hide_domain)},

		{"ignoresender", M_CONFIG_TYPE_MATCH, M_CONFIG_VALUE_APPEND, &(conf->ignore_sender)},
		{"ignorereceipient", M_CONFIG_TYPE_MATCH, M_CONFIG_VALUE_APPEND, &(conf->ignore_receipient)},
		{"ignoredomain", M_CONFIG_TYPE_MATCH, M_CONFIG_VALUE_APPEND, &(conf->ignore_domain)},

		{NULL, M_CONFIG_TYPE_INT, 0, NULL}
	};

	return mconfig_parse_section(ext_conf, filename, section, config_values);
}


int mplugins_processor_mail_set_defaults(mconfig *ext_conf) {
	/* set some defaults, prepare the internals base on the configvalues */

	return 0;
}

int mplugins_init(mplugin *func) {
	func->dlinit = mplugins_processor_mail_dlinit;
	func->dlclose = mplugins_processor_mail_dlclose;
	func->parse_config = mplugins_processor_mail_parse_config;
	func->set_defaults = mplugins_processor_mail_set_defaults;
	func->get_next_record = NULL;
	func->insert_record = mplugins_processor_mail_insert_record;
	func->gen_report = NULL;
        func->gen_history = NULL;

	return 0;
}
