/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 gnuwordhash.h  -  the header file for QRP implementation

 the original version of this file was taken from Gnucleus
 (http://gnucleus.sourceforge.net)

                             -------------------
    begin                : Mon Oct 28 2002
    copyright            : (C) 2002 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef GNUWORDHASH_H
#define GNUWORDHASH_H

#define TABLE_BITS		16
#define TABLE_INFINITY	2


class MGnuShare;
class MGnuNode;
class MGnuDirector;

struct WordData
{
	CString      Text;
	vector<UINT> Indexes;
};

struct WordKey
{
	vector<WordData>* LocalKey;  // Locally indexed
	list<DWORD>*      RemoteKey; // Remotely indexed

	WordKey() {
		LocalKey  = NULL;
		RemoteKey = NULL;
	}
	~WordKey() {
		if(LocalKey)
		{
			delete LocalKey;
			LocalKey = NULL;
		}
		if(RemoteKey)
		{
			delete RemoteKey;
			RemoteKey = NULL;
		}
	}
};

/*struct RemoteIndex
{
	MGnuNode* pSock;

	IP		Host;
	UINT	Port;
	UINT	Speed;
	GUID    PushID;

	bool	Firewall;
	bool	Busy;
	bool	Stable;
	bool	RealSpeed;

	UINT	FilesCount;
	UINT	FilesSize;

	std::vector<RemoteFile> Files;
};*/

class MGnuWordHash
{
public:
	MGnuWordHash(MGnuDirector* pDirector);
	virtual ~MGnuWordHash();

	void ClearLocalTable();
	void ResetTable(DWORD dwResetNodeID);
	void ApplyPatch(MGnuNode* pNode, int EntryBits);

	void InsertString(CString sName, int nIndex, bool bBreakString=true, CString sMetaTag="");
	void InsertWordHash(int nWordHash, int nIndex);

	void BreakupName(CString sName, vector< CString >& vsKeywords);
	void BreakupMeta(CString& sQueryEx, vector< CString >& vsKeywords);

	void AddWord(vector< CString >& vsKeywords, CString sWord);

	void LookupQuery(QueryComp& SearchQuery, list<UINT>& Indexes, list<DWORD>& RemoteNodes);
	void LookupLocalSha1(const CString& sSha1, list<UINT> &Indexes);

	bool IntersectIndexes(list<UINT>& Index, vector<UINT>& CompIndex);
	bool IntersectNodes(list<DWORD>& Nodes, list<DWORD>& CompNodes);

	UINT Hash(CString x, BYTE bits);
	UINT HashFast(unsigned long long x, BYTE bits);


	WordKey m_HashTable[1 << TABLE_BITS];
	
	char    m_PatchTable[1 << TABLE_BITS];

	UINT m_dwTableSize;
	UINT m_dwHashedWords;
	UINT m_dwLargestRehash;
	UINT m_dwUniqueSlots;
	UINT m_dwRemoteSlots;

	MGnuShare*    m_pShare;
	MGnuDirector* m_pDirector;

	MMutex m_mutexTable;
};

#endif
