/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/**
 * @file myx_gc_style.cpp 
 * @brief Implementation of the base style class.
 * 
 */

#include "myx_gc.h"
#include "myx_gc_style.h"
#include "myx_gc_figure.h"

//----------------- CGCStyle -------------------------------------------------------------------------------------------

CGCStyle::CGCStyle(void)
{
  FDisplayList = 0;
  FDestroying = false;
}

//----------------------------------------------------------------------------------------------------------------------

CGCStyle::~CGCStyle(void)
{
  FDestroying = true;
  glDeleteLists(FDisplayList, 1);
  for (CElementSet::iterator Iterator = FListeners.begin(); Iterator != FListeners.end(); ++Iterator)
    (*Iterator)->UseStyle(NULL);
}

//----------------------------------------------------------------------------------------------------------------------

void CGCStyle::AddListener(CFigureElement* Element)
{
  if (!FDestroying)
    FListeners.insert(Element);
}

//----------------------------------------------------------------------------------------------------------------------

TBoundingBox* CGCStyle::BoundingBox(void)
{
  return &FBoundingBox;
}

//----------------------------------------------------------------------------------------------------------------------

GLuint CGCStyle::DisplayList(void)
{
  return FDisplayList;
}

//----------------------------------------------------------------------------------------------------------------------

void CGCStyle::RemoveListener(CFigureElement* Element)
{
  if (!FDestroying)
    FListeners.erase(Element);
}

//----------------------------------------------------------------------------------------------------------------------

