
if (WScript.FullName.indexOf("cscript.exe")==-1)
{
  WScript.Echo("This script may be runned only with CScript..  Try to run test.bat")
  WScript.Quit(1)
}

var one_of_tests_failed= 0

var opt_copy_dlls= 0
var opt_clear_dlls= 0

var opt_port_41= 0
var opt_host_41= ""
var opt_user_41= ""
var opt_password_41= ""
var opt_ansi_mode_41= ""

var opt_port= 0
var opt_host= "127.0.0.1"
var opt_user= "root"
var opt_password= ""
var opt_ansi_mode= ""
var opt_path= ""
var opt_version= ""
var opt_verbose= false

for(i= 0; i<WScript.Arguments.Count(); i++)
{
  var arg= WScript.Arguments(i)

  if (arg.indexOf("--copy-dlls" )==0){ opt_copy_dlls= 1;  continue;}
  if (arg.indexOf("--clear-dlls")==0){ opt_clear_dlls= 1; continue;}

  var prefix= "--port=";            if (arg.indexOf(prefix)==0) { opt_port=       parseInt(arg.substring(prefix.length,arg.length));  continue; }
  var prefix= "--path=";            if (arg.indexOf(prefix)==0) { opt_path=       arg.substring(prefix.length,arg.length);            continue; }
  var prefix= "--host=";            if (arg.indexOf(prefix)==0) { opt_host=       arg.substring(prefix.length,arg.length);            continue; }
  var prefix= "--user=";            if (arg.indexOf(prefix)==0) { opt_user=       arg.substring(prefix.length,arg.length);            continue; }
  var prefix= "--password=";        if (arg.indexOf(prefix)==0) { opt_password=   arg.substring(prefix.length,arg.length);            continue; }
  var prefix= "--ansi-quotas=";     if (arg.indexOf(prefix)==0) { opt_ansi_mode=  arg.substring(prefix.length,arg.length);            continue; }  

  if (arg.indexOf("--use-ready-server-4.0")==0) { opt_version= "4.0"; continue; }
  if (arg.indexOf("--use-ready-server-4.1")==0) { opt_version= "4.1"; continue; }
  if (arg.indexOf("--use-ready-server-5.0")==0) { opt_version= "5.0"; continue; }

  if (arg.indexOf("--verbose")==0) { opt_verbose= true; continue; }

  WScript.Echo("Unknown option : \"" + arg + "\"")
  WScript.Quit()
}

var fso=    new ActiveXObject("Scripting.FileSystemObject")
var shell=  new ActiveXObject("WScript.Shell");
var env=    shell.Environment("PROCESS")

var path_to_top=   "..\\..\\..\\..\\"
var path_to_utils= path_to_top + "mysql-gui-common\\tests\\"

if (!fso.FileExists(path_to_utils + "\\common.js"))
{
  var path_to_top=   "..\\..\\"
  var path_to_utils= path_to_top + "utils\\"
}

function read_stream_to(stream,file)
{
  while (!stream.AtEndOfStream)
  {
    var output= stream.ReadLine()
    file.WriteLine(output)
  }
}

function exec_to_file(cmd_line,out_fname)
{
  var file= fso.CreateTextFile(out_fname, true)
  var oExec= shell.Exec(cmd_line)
  while (oExec.Status == 0)
  {
    WScript.Sleep(10)
    read_stream_to(oExec.StdOut,file)
  }
  read_stream_to(oExec.StdOut,file)
  read_stream_to(oExec.StdErr,WScript.StdErr)
  file.Close()
}

function exec_everything_to_file(cmd_line,out_fname)
{
  var file= fso.CreateTextFile(out_fname, true)
  var oExec= shell.Exec(cmd_line)
  while (oExec.Status == 0)
  {
    WScript.Sleep(10)
    read_stream_to(oExec.StdOut,file)
  }
  read_stream_to(oExec.StdOut,file)
  read_stream_to(oExec.StdErr,file)
  file.Close()
}

function exec_from_file(cmd_line,out_fname)
{
  var file= fso.OpenTextFile(out_fname, 1)
  var oExec= shell.Exec(cmd_line)
  var closed= false
  while (oExec.Status == 0)
  {
    WScript.Sleep(10)
    while (!file.AtEndOfStream)
    {
      var line= file.ReadLine()
      if (oExec.StdIn!=null && oExec.Status == 0)
      {
        try
        {
          oExec.StdIn.WriteLine(line)
        }
        catch(e)
        {
        }
      }
      WScript.Sleep(10)
    }
    if (file.AtEndOfStream && !closed)
    {
      oExec.StdIn.Close()
      closed= true
    }
  }
  file.Close()
}

function server_check_connection(con_result)
{
  if (!this.enabled)
    return true
  var cmd_line= path_to_utils + "try_to_connect_mysqld.bat"
  cmd_line+= " \"" + this.path;
  cmd_line+= "\" " + this.host_name;
  cmd_line+= " " + this.port;
  cmd_line+= " " + this.user_name;
  cmd_line+= " " + this.password;
  for (i= 0; i<10; i++)
  {
    if (opt_verbose)
      WScript.StdOut.write("try to connect to mysqld-" + this.version + this.get_open_parameters() + " .. ")
    var res= shell.Run(cmd_line,0,true)
    if (opt_verbose)
      WScript.StdOut.write(res ? "fail\n" : "ok\n")
    if (res==con_result)
      return true
    WScript.Sleep(300)
  }
  return false
}

function get_connection_options(host,port,user,pass)
{
  var res= ""
  res+= " --host="      + host
  res+= " --port="      + port
  res+= " --user="      + user
  res+= " --password="  + pass
  return res
}

function server_get_connect_options()
{
  return get_connection_options(this.host_name,this.port,this.user_name,this.password)
}

function server_get_full_info()
{
  return "\"" + this.path + "\" "+ this.get_connect_options()
}

function server_start()
{
  if (opt_verbose)
    WScript.StdOut.write("start mysqld-" + this.version + this.get_open_parameters() + "\n")
  if (!this.enabled)
  {
    if (opt_verbose)
      WScript.StdOut.write("   .. disabled\n")
    return
  }  
  var cmd_line= "\"" + this.path + "\\bin\\mysqld-nt.exe\" --port=" + this.port
  shell.Run(cmd_line,0,false)
}

function server_execute_script(fname)
{
  if (opt_verbose)
    WScript.StdOut.write("execute script(\"" + fname + "\") on mysqld-" + this.version + this.get_open_parameters() + "\n")
  if (!this.enabled)
  {
    if (opt_verbose)
      WScript.StdOut.write("   .. disabled\n")
    return;
  }
  var cmd_line=  "\"" + this.path + "\\bin\\mysql.exe\" " + this.get_connect_options()
  exec_from_file(cmd_line,fname)
}

function server_mysqldump(extra_options,fname)
{
  if (!this.enabled)
    return;
  var cmd_line=  "\"" + this.path + "\\bin\\mysqldump.exe\" " + this.get_connect_options() + " " + extra_options
  exec_to_file(cmd_line,fname)
}

function server_stop()
{
  if (opt_verbose)
    WScript.StdOut.write("stop mysqld-" + this.version + this.get_open_parameters() + "\n")
  if (!this.enabled)
  {
    if (opt_verbose)
      WScript.StdOut.write("   .. disabled\n")
    return;
  }
  var cmd_line= "\"" + this.path + "\\bin\\mysqladmin.exe\" " + this.get_connect_options() + " shutdown"
  shell.Run(cmd_line,0,true)
  WScript.Sleep(500)
}

function server_safe_start()
{
  if (!this.enabled)
  {
    if (opt_verbose)
      WScript.StdOut.write("safe start mysqld-" + this.version + this.get_open_parameters() + " .. disabled\n")
    return true
  }
  if (this.use_ready_server)
  {
    if (!this.check_connection(0))
    {
      WScript.Echo("can't esteblish connection to server...")
      WScript.Echo(this.get_full_info())
      this.enabled= false
      one_of_tests_failed= 1
      return false
    }
  }
  else
  {
    if (!this.check_connection(1))
    {
      this.stop()
      if (!this.check_connection(1))
      {
        WScript.Echo("can't stop server...")
        WScript.Echo(this.get_full_info())
        this.enabled= false
        one_of_tests_failed= 1
        return false
      }
    }
    this.start()
    var i= 0
    for (; !this.check_connection(0) && i<10; i++ )
      this.start()
    if (i==10)
    {
      if (!this.check_connection(0))
      {
        WScript.Echo("can't esteblish connection to server...")
        WScript.Echo(this.get_full_info())
        this.enabled= false
        one_of_tests_failed= 1
        return false
      }
    }
  }
}

function server_safe_stop()
{
  if (!this.enabled)
  {
    if (opt_verbose)
      WScript.StdOut.write("safe stop mysqld-" + this.version + this.get_open_parameters() + " .. disabled\n")
    return true;
  }
  if (this.use_ready_server)
    return true
  return this.stop()
}

function server_use_options()
{
  this.path=      opt_path
  this.host_name= opt_host
  this.port=      opt_port
  this.user_name= opt_user
  this.password=  opt_password
  this.use_ready_server= true
}

function server_check_path()
{
  if (this.path=="")
  {
    this.enabled= false
  }
  else
  {
    var path= this.path + "\\bin\\mysqld-nt.exe"
    if (!fso.FileExists(path))
    {
      WScript.Echo("can't find the file \"" + path + "\"")
      this.enabled= false
    }
  }
}

function server_prepare_connection_file(fin,fout)
{
  if (!this.use_ready_server || !this.enabled)
  {
    fso.GetFile(fin).Copy(fout)
  }
  else
  {
    var connection_doc= new ActiveXObject("Msxml2.DOMDocument.3.0")
    connection_doc.load(fin)
    var       root_element= connection_doc.documentElement
    var connection_element= root_element.getElementsByTagName("user_connection").item(0)

    for (i= 0; i<connection_element.childNodes.length; i++)
    {  
      var connection_item= connection_element.childNodes.item(i)  
      if (connection_item.nodeName=="port")
      {
        connection_item.childNodes.item(0).nodeValue= this.port
      }
      else if (connection_item.nodeName=="hostname")
      {
        connection_item.childNodes.item(0).nodeValue= this.host_name
      }
      else if (connection_item.nodeName=="password")
      {
        if (connection_item.childNodes.length!=0)
        {
          connection_item.childNodes.item(0).nodeValue= this.password
        }
        else
        {
          var new_node= connection_doc.createTextNode(this.password)
          connection_item.appendChild(new_node);
        }
      }
      else if (connection_item.nodeName=="username")
      {    
        connection_item.childNodes.item(0).nodeValue= this.user_name
      }  
    }
    connection_doc.save(fout)
  }
}

function server_get_open_parameters()
{
  return "(" + this.host_name + "," + this.port +"," + this.user_name + ")"
}

function server()
{
  this.check_connection=        server_check_connection
  this.safe_start=              server_safe_start
  this.safe_stop=               server_safe_stop
  this.get_connect_options=     server_get_connect_options
  this.start=                   server_start
  this.stop=                    server_stop
  this.execute_script=          server_execute_script
  this.mysqldump=               server_mysqldump
  this.use_options=             server_use_options
  this.get_full_info=           server_get_full_info
  this.prepare_connection_file= server_prepare_connection_file
  this.check_path=              server_check_path
  this.get_open_parameters=     server_get_open_parameters
}

var server_40= new server()
server_40.path=  env("MYSQL_40_PATH")
server_40.host_name= "127.0.0.1"
server_40.port= 3307
server_40.user_name= "root"
server_40.password= ""
server_40.enabled= true
server_40.version="4.0"

var server_41= new server()
server_41.path=  env("MYSQL_41_PATH")
server_41.host_name= "127.0.0.1"
server_41.port= 3308
server_41.user_name= "root"
server_41.password= ""
server_41.enabled= true
server_41.version="4.1"

var server_50= new server()
server_50.path=  env("MYSQL_50_PATH")
server_50.host_name= "127.0.0.1"
server_50.port= 3309
server_50.user_name= "root"
server_50.password= ""
server_50.enabled= true
server_50.version="5.0"

function normalize_server_options()
{
  if (opt_port==0)  opt_port= 3306
  if (opt_host=="") opt_host= "127.0.0.1"
  if (opt_user=="") opt_user= "root"
  if (opt_version=="4.1" && opt_path=="") opt_path= env("MYSQL_41_PATH")
  if (opt_version=="4.0" && opt_path=="") opt_path= env("MYSQL_40_PATH")
  if (opt_version=="5.0" && opt_path=="") opt_path= env("MYSQL_50_PATH")
  if (opt_path=="") opt_path= env("MYSQL_40_PATH")
  if (opt_path=="") opt_path= env("MYSQL_41_PATH")
  if (opt_path=="") opt_path= env("MYSQL_50_PATH")
}

normalize_server_options()

if (opt_version=="4.0")
{
  server_40.use_options()
  server_41.enabled= false
  server_50.enabled= false
}

if (opt_version=="4.1")
{
  server_41.use_options()
  server_40.enabled= false
  server_50.enabled= false
}

if (opt_version=="5.0")
{
  server_50.use_options()
  server_40.enabled= false
  server_41.enabled= false
}

server_40.check_path()
server_41.check_path()
server_50.check_path()

function safe_copy(path_from, path_to)
{
  if (fso.FileExists(path_from))
    fso.GetFile(path_from).Copy(path_to)
}

function safe_delete(path)
{
  if (fso.FileExists(path))
    fso.GetFile(path).Delete()
}

function copy_dlls()
{
  if (fso.FileExists(path_to_top + "utils\\common.js"))
  {
    safe_copy(  path_to_top + "utils\\libmysqlx.dll",       ".\\")
    safe_copy(  path_to_top + "utils\\libmySQL.dll",        ".\\")
    safe_copy(  path_to_top + "utils\\msvcp71d.dll",        ".\\")
    safe_copy(  path_to_top + "utils\\msvcr71d.dll",        ".\\")
  
    safe_copy(  path_to_top + "utils\\libmysqladmin.dll",   ".\\")
    safe_copy(  path_to_top + "utils\\libmysqlqb.dll",      ".\\")

    safe_copy(  path_to_top + "utils\\libxml2.dll",         ".\\")
    safe_copy(  path_to_top + "utils\\iconv.dll",           ".\\")
    safe_copy(  path_to_top + "utils\\zlib.dll",            ".\\")

    safe_copy(  path_to_top + "utils\\libglib-2.0-0.dll",   ".\\")
    safe_copy(  path_to_top + "utils\\intl.dll",            ".\\")
  }
  else
  {    
    safe_copy(  path_to_top + "mysql-gui-win-res\\lib\\mysql\\libmySQL.dll",                ".\\")
    safe_copy(  path_to_top + "mysql-gui-win-res\\lib\\windows\\msvcp71d.dll",              ".\\")
    safe_copy(  path_to_top + "mysql-gui-win-res\\lib\\windows\\msvcr71d.dll",              ".\\")
    safe_copy(  path_to_top + "mysql-gui-common\\library\\Lib_debug\\libmysqlx.dll",        ".\\")
  
    safe_copy(  path_to_top + "mysql-administrator\\library\\Lib_Debug\\libmysqladmin.dll", ".\\")
    safe_copy(  path_to_top + "mysql-query-browser\\library\\Lib_Debug\\libmysqlqb.dll",    ".\\")

    safe_copy(  path_to_top + "mysql-gui-win-res\\lib\\libxml\\libxml2.dll",                ".\\")
    safe_copy(  path_to_top + "mysql-gui-win-res\\lib\\libxml\\iconv.dll",                  ".\\")
    safe_copy(  path_to_top + "mysql-gui-win-res\\lib\\libxml\\zlib.dll",                   ".\\")

    safe_copy(  path_to_top + "mysql-gui-win-res\\lib\\glib-2.0\\libglib-2.0-0.dll",        ".\\")
    safe_copy(  path_to_top + "mysql-gui-win-res\\lib\\glib-2.0\\intl.dll",                 ".\\")
  }
}

function clear_dlls()
{
  safe_delete(  "zlib.dll"          )
  safe_delete(  "iconv.dll"         )
  safe_delete(  "intl.dll"          )
  safe_delete(  "libglib-2.0-0.dll" )
  safe_delete(  "libmysqlx.dll"     )
  safe_delete(  "libxml2.dll"       )

  safe_delete( "libmysqladmin.dll"  )

  safe_delete( "libmysqlqb.dll"     )

  safe_delete(  "libmySQL.dll"      )
  safe_delete(  "msvcp71d.dll"      )
  safe_delete(  "msvcr71d.dll"      )
}

if (opt_copy_dlls!=0)
{
  copy_dlls()
  WScript.Quit(0)
}

if (opt_clear_dlls!=0)
{
  clear_dlls()
  WScript.Quit(0)
}

function extended_line(line,size,filler)
{
  while (line.length<size)
  {
    line+= filler
  }
  return line
}

function print_title(str)
{
  WScript.StdOut.Write(extended_line("--------- " + str + " : ",79,"-") + "\n")
}

function print_test_res(str,fc_result)
{
  WScript.StdOut.Write("- " + (fc_result==0 ? extended_line(str,73," ") + "[ok]\n" : extended_line(str,71," ") + "[fail]\n"))
}

function print_test_skipped(str)
{
  WScript.StdOut.Write("- " + extended_line(str,68," ") + "[skipped]\n")
}

function exec_to_stdout(cmd_line)
{
  var oExec= shell.Exec(cmd_line)
  while (oExec.Status == 0)
  {
    WScript.Sleep(100)
    read_stream_to(oExec.StdErr,WScript.StdErr)
    read_stream_to(oExec.StdOut,WScript.StdOut)
  }
  read_stream_to(oExec.StdErr,WScript.StdErr)
  read_stream_to(oExec.StdOut,WScript.StdOut)
}

function discard_volatile_results(file_src,file_dst)
{
  if (!fso.FileExists(file_src))
  {
    var file= fso.CreateTextFile(file_dst,true)
    file.Close()
  }
  else
  {
    exec_to_file("findstr /V \"Host\" " + file_src, "tmp_file1")
    exec_to_file("findstr /V \"version\" tmp_file1", file_dst)
    fso.GetFile("tmp_file1").Delete()
  }
  if (fso.FileExists(file_src))
    fso.GetFile(file_src).Delete()
}

function compare_results(name_etalon,name_result,name_diff)
{
  exec_to_file("fc.exe /L /N " + name_etalon + " " + name_result, name_diff)  
  var fc_result= 1
  var file= fso.OpenTextFile(name_diff, 1, false)
  if (!file.AtEndOfStream)
  {
    file.SkipLine()
    if (!file.AtEndOfStream)
    {
      var out= file.ReadLine();
      fc_result= (out.indexOf("FC: no differences encountered")==-1) ? 1 : 0
    }
  }
  file.Close()

  if (fc_result!=0)
  {
    one_of_tests_failed= 1
  }
  else
  {
    if (fso.FileExists(name_diff))
      fso.GetFile ( name_diff   ).Delete()
    if (fso.FileExists(name_result))
      fso.GetFile ( name_result ).Delete()
  }  
  return fc_result
}

function print_footer()
{
  if (one_of_tests_failed!=0)
  {
    WScript.StdOut.Write("-------------------------------------------------------------------tests-fail!-\n")
  }
  else
  {
    WScript.StdOut.Write("-------------------------------------------------------------------------------\n")
  }
}
