<?php
# $Id: cgicfg.php,v 1.5 2002/06/14 13:41:48 kemuri Exp $

/*
 * Copyright (c) 2002 Ypsilon.Net AG, Germany
 *
 * This file is part of Nagat.
 * 
 * Nagat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Nagat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Nagat; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

# Page variables
define("PAGE_ID","hosts");
define("PAGE_TITLE","Nagios CGI configuration");
define("OBJECTTYPE",'cgicfg');

require_once("local.inc");

$action = @strtolower($action);
$message = '';

# Actions before output is send
switch($action) {
	case 'save':
		$result = PluginSaveConfig("cgicfg",$cfg);
		if( $result != NULL ) {
			ErrorMsg($result);
		} else {
			header("Location: cgicfg.php?lastact=saved");
			exit();
		}
		break;
}
include_once(NGT_LIB."head.inc");

if( @$lastact == "saved" ) {
  $message = "Configuration has been saved.";
}

$cgicfg = PluginGetConfig("cgicfg");

$alter = "alter2";

foreach($confobjects[OBJECTTYPE] as $key => $propconf) {

	$values = isset($cgicfg[$key]) ? $cgicfg[$key] : array();
	$count = count($values);

	$required = $propconf[2] == TRUE ? 'required' : 'label';

	# Add an extra entry field when multi values are possible
	if( $propconf[0] == 'multistring' || $count == 0 ) {
		$count++;
	}

	# Set the default value if needed and if there is one
	if( isset($values[0]) == FALSE && $propconf[1] != '' ) {
		$values[0] = $propconf[1];
	}

	for($i = 0; $i < $count; $i++) {
		$value = isset($values[$i]) ? $values[$i] : '';
  		$show = NagiosObjPropEdit(OBJECTTYPE,$key,
			"cfg[$key][$i]",$value);
		$inputname = $key.'['.$i.']';
		$rows[] = <<<HTML
<tr>
  <td class="label">$key</td>
  <td class="$required" with="3">&nbsp;</td>
  <td class="value">
  $show
  </td>
</tr>
HTML;
	}
}

?>
<form action="cgicfg.php" method="post">
<table cellpadding="3" border="0">
<tr>
  <td colspan="3" align="left">
  <b><?=$message?>&nbsp;</b>
  </td>
</tr>
<tr>
  <td colspan="3" align="right">
  <input type="submit" name="action" value="Save">
  </td>
</tr>
<tr class="rowsep">
  <td colspan="3">cgi.cfg settings</td>
</tr>
<?=implode("\n", $rows)?>
</table>
</form>

<?php
include_once(NGT_LIB."tail.inc");
?>
