#TRUSTED 26877946e9387194f3b52129b388923ccd991a7ac3747effa03a999de343cd8eeb8f2b5038ce7ef9b45a86516c956dbf5c97519ecd168cd8d9a0988e277ff18f1de8c01430dc8624e2f8f991037978ef38888e3f603200853a8892ed4a8d830a6283eea40f7224bf873badef17945ee2f6ae6851f4854f062185175fb2b3f7406d5ac12e85c828359c1d19da2b1e0570b5a45bae59c0af7ee62446f8fe4d7269438bdc9b181195623b199514a3652e64d34291fbd83c86366a7e69cd7b07211f96a6d59f2de0d7b6fb88c9fd9aa48a82c0c3addbde9f223a0f36b5c368b7ecf16eb7ff75f099f40d506678348e1caf975578f032cdb8301a40a16010fc03310b980989ab1b0a116ace9fb27fbe119229430e24285f765ab3fc59c25bbef37031f9690aac00722e7e0b42150e72e6bb7f43d5b5ab5f6e4640afc50e55c6395c117141f2c2238b052ebd26d81a3c001988078f1f8f02c24b6ef74765d0266fad17b763956b6d1556eb7925557c8dbcc8313b2583f99b2a188cd6620a4411db00a3c3b5f914e25046acb26536ec185858f2a4cd09efce47c27386f075262b50aabf503bdfd777eab609675e0e24e69726aff294b2974cd40805fa52f7f44728ff43b93e7445cf2b724c440e89ffbbc330624336ad0867ee460abad38056a2553280b5caa4e6a799ec5d9f5d764fe3b0c5d3422511bee7acbc5958b67ea8a12b2ae6
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15889);
 script_version ("1.1");
 name["english"] = "Hydra: telnet";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find telnet passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force telnet authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/telnet", 23);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/telnet");
if (! port) port = 23;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "telnet";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/telnet/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following Telnet accounts:\n' + report);
