/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __gtk_hex_h
#define __gtk_hex_h

#include <gdk/gdk.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkradiobutton.h>
#include <gtk/gtktext.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_HEX          (gtk_hex_get_type())
#define GTK_HEX(obj)          GTK_CHECK_CAST (obj, gtk_hex_get_type (), GtkHex)
#define GTK_HEX_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_hex_get_type (), GtkHexClass)
#define GTK_IS_HEX(obj)       GTK_CHECK_TYPE (obj, gtk_hex_get_type ())


typedef enum {
  GTK_RAW_ASCII,
  GTK_RAW_HEX
} GtkRawMode;


typedef struct _GtkHex         GtkHex;
typedef struct _GtkHexClass    GtkHexClass;
typedef struct _GtkHexPrivate  GtkHexPrivate;

struct _GtkHex
{
  GtkVBox         vbox;

  GtkWidget      *mode_button_hex;
  GtkWidget      *mode_button_ascii;
  GtkWidget      *hex_text;

  GtkRawMode      mode;

  guchar         *data;
  guint           data_size;

  GtkHexPrivate  *priv;
};

struct _GtkHexClass
{
  GtkVBoxClass parent_class;

  void (* changed)      (GtkHex *hex,
			 gint         index,
			 gint         value);
  void (* move_cursor)  (GtkEditable *editable,
			 gint         index);
};


guint      gtk_hex_get_type(void);
GtkWidget *gtk_hex_new(void);
void       gtk_hex_set_content(GtkHex *hex, char *data, int data_size);
void       gtk_hex_set_mode(GtkHex *hex, GtkRawMode mode);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif
