#!/usr/bin/perl
#
# See LICENSE for copyright information
#
# check_procs.pl <host> [warn] [critical] [which type of processes] [port]
#
# NetSaint host script to get the number of processes from a client that is
# running netsaint_statd.
#

require 5.003;
BEGIN { $ENV{PATH} = '/bin' }
use Socket;
use POSIX;
use strict;

sub usage;

my $TIMEOUT = 15;

my %ERRORS = ('UNKNOWN', '-1',
		'OK', '0',
		'WARNING', '1',
		'CRITICAL', '2');
my $remote = shift || &usage(%ERRORS);
my $warn = shift || 150;
my $crit = shift || ($warn + 50);
my $args = shift || undef;
my $port = shift || 1040;

my $remoteaddr = inet_aton("$remote");
my $paddr = sockaddr_in($port, $remoteaddr) || die "Can't create info for connection: #!\n";;
my $proto = getprotobyname('tcp');
socket(Server, PF_INET, SOCK_STREAM, $proto) || die "Can't create socket: $!";
setsockopt(Server, SOL_SOCKET, SO_REUSEADDR, 1);
connect(Server, $paddr) || die "Can't connect to server: $!";

my $state = "OK";
my $answer = undef;

# Just in case of problems, let's not hang NetSaint
$SIG{'ALRM'} = sub { 
     close(Server);
     select(STDOUT);
     print "No Answer from Client\n";
     exit $ERRORS{"UNKNOWN"};
};
alarm($TIMEOUT);

select(Server);
$| = 1;
if ($args) {
	print Server "procs $args\n";
} else {
	print Server "procs\n";
}
my ($servanswer) = <Server>;
alarm(0);
close(Server);
select(STDOUT);

if ($servanswer =~ /^(\d*) (\w*)/) {
	my ($procs) = $1;
	my ($states) = $2;
	if ($procs < $warn) { 
		$answer = "Procs ok - $procs with $states status\n";
	} elsif ($procs < $crit) {
		$state = "WARNING";
		$answer = "$procs processes with $states status\n";
	} else {
		$state = "CRITICAL";
		$answer = "$procs processes with $states status\n";
	}
			
} else {
	$state = "UNKNOWN";
	$answer = "Number of processes unknown!\n";
}

print $answer;
exit $ERRORS{$state};

sub usage {
        print "Minimum arguments not supplied!\n";
        print "\n";
        print "Perl Check Process plugin for NetSaint\n";
        print "Copyright (c) 1999 Charlie Cook & Nick Reinking\n";
        print "\n";
        print "Usage: $0 <host> [<warn> [<crit> [<processes> [<port>]]]]\n";
        print "\n";
        print "<warn> = Number of processes to warn at.\n	Defaults to 150.\n";
        print "<crit> = Number of processes to go critical at.\n	Defaults to warn+50.\n";
      	print "<processes> = Only search for processes in this state.\n	Defaults to all processes.\n";
        print "<port> = Port that the status daemon is running on <host>.\n	Defaults to 1040.\n";
        exit $ERRORS{"UNKNOWN"};
}
