# Copyright (c) 2004 Divmod.
# See LICENSE for details.

import os, sys
from cStringIO import StringIO

from nevow import context, flat, inevow


class WSGIRequest(object):
    outgoingHeaders = None
    responseCode = "200 OK"
    args = {} # TODO Request arguments
    host = property(lambda self: (self.environ['REMOTE_ADDR'], self.environ['REMOTE_PORT']))
    method = property(lambda self: self.environ['REQUEST_METHOD'])
    uri = property(lambda self: self.environ['SCRIPT_URI'])

    def _getPath(self):
        pth = self.environ['SCRIPT_URL'][len(self.environ['SCRIPT_NAME']):]
        if not pth: pth = '/'
        return pth
    path = property(_getPath)

    def __init__(self, environ, start_response):
        self.environ = environ
        self.start_response = start_response

    def getHeader(self, header):
        return self.environ.get('HTTP_' + header.upper(), '')

    def setHeader(self, header, value):
        if self.outgoingHeaders is None:
            self.outgoingHeaders = []
        self.outgoingHeaders.append((header.lower(), value))

    def setResponseCode(self, code):
        self.responseCode = "%s %s" % (code, "?ASDF") # TODO response code strings

    def write(self, stuff):
        headers = self.outgoingHeaders or []
        headerkeys = [k for k,v in headers]
        if 'content-type' not in headerkeys:
            headers.append(('content-type', 'text/html'))
        self.write = self.start_response(self.responseCode, headers)
        self.write(stuff)

    def redirect(self, where):
        self.responseCode = '302 FOUND'
        self.setHeader('location', where)

    def URLPath(self):
        from nevow import url
        return url.URL.fromString(self.uri)


def createWSGIApplication(page):
    """Given a Page instance, return a WSGI callable.
    """
    page.flattenFactory = flat.iterflatten
    siteCtx = context.SiteContext(tag=None)
    def application(environ, start_response):
        request = WSGIRequest(environ, start_response)

        rctx = context.RequestContext(tag=request, parent=siteCtx)
        pctx = context.PageContext(tag=page, parent=rctx)
        segs = tuple(request.path[1:].split('/'))

        pctx.remember((), inevow.ICurrentSegments)
        pctx.remember(segs, inevow.IRemainingSegments)

        p = page
        while segs:
            old = segs
            p, segs = p.locateChild(pctx, segs)
            pctx = context.PageContext(tag=p, parent=pctx)

            pctx.remember(
                inevow.ICurrentSegments(pctx) + old[:len(old)-len(segs)],
                inevow.ICurrentSegments)
            pctx.remember(tuple(segs), inevow.IRemainingSegments)

        if p is None:
            from nevow import rend
            p = rend.FourOhFour()

        result = p.renderHTTP(pctx)
        if isinstance(result, str):
            request.write(result)
        else:
            ## Exhaust the generator
            list(result)

    return application

