/*=========================================================================
| Open Office QuickStarter
|--------------------------------------------------------------------------
| (c) 2002  Kumaran Santhanam  <kumaran@alumni.stanford.org>
|
| This project is released under the GNU General Public License.
| Please see the file COPYING for more details.
|--------------------------------------------------------------------------
| model.h
|
| This file contains all of the logic, separate from the various
| front-end interfaces.
 ========================================================================*/
#ifndef __model_h__
#define __model_h__


/*=========================================================================
| INCLUDES
 ========================================================================*/
#include <time.h>


/*=========================================================================
| TYPES
 ========================================================================*/
enum ModelStatus {
    MODEL_OFFICE_STOPPED,
    MODEL_OFFICE_STARTING,
    MODEL_OFFICE_RUNNING
};


/*=========================================================================
| CLASS
 ========================================================================*/
class Model {
  public:
    Model ();
    ~Model ();

    void setOpenOfficeDir (const char *dir);
    const char *getOpenOfficeDir () const {
        return _sofficeDir;
    }
    const char *getOpenOfficeProgram () const {
        return _soffice;
    }

    bool isValid () const { return (_soffice != 0); }
    
    void enable ()           { _enabled = true; }
    void disable ()          { _enabled = false; }
    bool getEnabled () const { return _enabled; }
    
    
    void process ();
    ModelStatus getStatus () const { return _status; }

    void startWriter  () const;
    void startCalc    () const;
    void startDraw    () const;
    void startImpress () const;

    
  private:
    bool         _enabled;
    int          _daemonPID;
    time_t       _tick;
    ModelStatus  _status;

    char        *_sofficeDir;
    char        *_soffice;
};


#endif
