#!tclsh
#
# Copyright (c) 1987 Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms are permitted
# provided that this notice is preserved and that due credit is given
# to the University of California at Berkeley. The name of the University
# may not be used to endorse or promote products derived from this
# software without specific prior written permission. This software
# is provided ``as is'' without express or implied warranty.
#

set makefile Makefile
set srcdir ""

while {1} {
	set arg [lindex $argv 0]
	switch -- $arg {
		"-f" {
			set makefile [lindex $argv 1]
			set argv [lrange $argv 2 end]
		}
		"-s" {
			set srcdir [lindex $argv 1]
			set argv [lrange $argv 2 end]
		}
		default {
			break
		}
	}
}

if { [llength $argv] == 0 } {
	puts stderr "usage: mkdep [-s srcdir] [-f makefile] [flags] file..."
	exit 1
}

if { ![file writable $makefile] } {
	puts stderr "mkdep: no writeable makefile: $makefile"
	exit 1
}

set tmpfile "/tmp/mkdep[pid]"

if [catch {open $makefile r} ifp] {
	puts stderr "Can't read makefile: $ifp"
	exit 1
}
if [catch {open $tmpfile w} ofp] {
	puts stderr "Can't write temp file $tmpfile: $ofp"
	exit 1
}

while { ![eof $ifp] } {
	set line [gets $ifp]
	if [string match " DO NOT DELETE THIS LINE*" $line] {
		break
	}
	puts $ofp $line
}
close $ifp

puts $ofp {
# DO NOT DELETE THIS LINE -- mkdep uses it.
# DO NOT PUT ANYTHING AFTER THIS LINE, IT WILL GO AWAY.

}

set cmd [list "g++" "-M"]
if { $srcdir != "" } {
	foreach arg $argv {
		if [string match "-*" $arg] {
			lappend cmd $arg
		} else {
			lappend cmd "$srcdir/$arg"
		}
	}
} else {
	set cmd [concat $cmd $argv]
}

#puts "running $cmd"

if [catch {open "|$cmd" r} ifp] {
	puts stderr "Can't exec g++: $ifp"
	exit 1
}

while { ![eof $ifp] } {
	set line [gets $ifp]

	# XXX this was in the old mkdep:
	# sed s; \./; ;g

	if [regexp -- {^([^ ]+): ([^ ]+) (.*)} $line match target file rest] {
		set oline $line

		# GNU cpp outputs assumes objects land in current directory
		# but we put them in subdirectories, so fix up the rules
		# accordingly i.e.,
		# make "foo.o: dir/foo.cc blah" turn into "dir/foo.o: dir/..."
		if { [string first "/" $target] == -1 && [string first "/" $file] != -1 } {
			set target "[file dirname $file]/$target"
		}

		# if we have srcdir at the beginning of the object
		# file path, strip it off
		regsub -- "^${srcdir}/" $target "" target

		set line "$target: $file $rest"
	}
	puts $ofp $line
}

puts $ofp {

# IF YOU PUT ANYTHING HERE IT WILL GO AWAY
}
close $ofp

if [file exists $makefile.bak] {
	file delete $makefile.bak
}
file rename $makefile $makefile.bak
file copy $tmpfile $makefile
file delete $tmpfile $makefile.bak

exit 0
