# otcl-mplug.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


Class MPlug


MPlug proc die { msg } {
	MPlug print $msg
	exit -1
}


MPlug proc print { msg } {
	puts stderr $msg
}


MPlug proc is_plugin { } {
	return [MPlugClient is_plugin]
}


MPlug public init { } {
	$self next
	set old [MPlugClient object]
	MPlugClient object $self

	$self copy $old
	delete $old

	pack propagate . false

	# set up the tcl_prompt variable, so if we get started up in
	# interactive mode i.e. there was no filename specified as
	# part of the commandline, we can print out an error

	global tcl_prompt1 tcl_prompt2
	set tcl_prompt1 "$self do_no_script"
	set tcl_prompt2 "$self do_no_script"
}


# copy all the instance variables from the original object into the new one
MPlug private copy { orig } {
	foreach var [$orig info vars] {
		$orig instvar "$var origvar"
		$self instvar "$var newvar"
		if [array exists origvar] {
			# this is an array
			foreach elem [array names origvar] {
				set newvar($elem) $origvar($elem)
			}
		} else {
			set newvar $origvar
		}
	}
}


# private method invoked when the plugin sends the MASH process a
# notification
MPlug private mimetype { type } {
	$self set mimetype_ $type
	$self tkvar got_mimetype_
	set got_mimetype_ 1
}


# private method invoked when the plugin sends the MASH process a
# notification
MPlug private mode { mode } {
	$self set mode_ $mode
}


# private method invoked when the plugin sends the MASH process a
# notification
MPlug private arguments { args } {
	$self instvar arguments_
	array set arguments_ $args
}


# private method invoked when the plugin sends the MASH process a
# notification
MPlug private reconfigure { width height } {
	wm geometry . ${width}x${height}

	# we need to explicitly configure what Tk thinks the width and
	# height of the root window are to get around a bug in the Windows
	# embedding code
	. configure -width $width -height $height
}


# private method invoked when the plugin sends the MASH process a
# notification
MPlug private url { url } {
	$self set url_ $url
}


# private method invoked when the plugin sends the MASH process a
# notification
MPlug private recv_stream { buffer } {
	$self instvar stream_
	append stream_ $buffer
}


# private method invoked when the plugin sends the MASH process a
# notification
MPlug private stream_done { reason } {
	$self tkvar stream_status_
	set stream_status_ $reason
}


# private method invoked when the plugin sends the MASH process a
# notification
MPlug private cleanup { } {
	exit
}


MPlug public wait_for_stream { } {
	$self tkvar stream_status_
	if [info exists stream_status_] { return $stream_status_ }
	vwait [$self tkvarname stream_status_]
	return $stream_status_
}


MPlug public get { what } {
	set varname "${what}_"
	$self instvar "$varname var"
	if [info exists var] { return $var } else {
		$self tkvar "$varname tkvar"
		if [info exists tkvar] { return $tkvar } else { return "" }
	}
}


MPlug private do_no_script { } {
	# wait for the start of the stream
	# that will mean that we have received the mimetype

	$self instvar stream_
	vwait [$self tkvarname got_mimetype_]

	set mimetype [string tolower [$self get mimetype]]
	$self instvar default_handlers_
	if [info exists default_handlers_($mimetype)] {
		eval $default_handlers_($mimetype) [list $mimetype]
		MPlug die "Default handlers should never return.\n\
				This can be enforced by using a\
				\"vwait forever\" statement at the end of\
				the handler script"
	} else {
		MPlug die "I do not know how to handle mimetype\
				'[$self get mimetype]'\nYour\
				.mash/prefs-mplug file is not configured\
				properly"
	}
}


MPlugClient private connect { port } {
	$self instvar chan_
	#FIXME should do async open
	set chan_ [socket 127.0.0.1 $port]
	fconfigure $chan_ -blocking false
	fconfigure $chan_ -translation {binary binary}
	fileevent $chan_ readable "$self dispatch $chan_"
}


MPlugClient private init { port } {
	$self next

	# create a connection to localhost:$port
	if [catch {$self connect $port}] {
		# error occurred while opening the channel
		# can't really do anything, so print an error
		# and exit

		MPlug die "could not connect to plugin"
	}

	# create a default MPlug object
	set mplug [new MPlug]
	MPlugClient object $mplug
}

