/*
 * session-rtcp.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef mash_rtcp_session_h
#define mash_rtcp_session_h

#include "net.h"
#include "rtp.h"

class RTCP_Session : public TclObject, public SessionHandler {
public:
  RTCP_Session();
  virtual ~RTCP_Session();
  virtual int command(int argc, const char*const* argv);
  virtual void recv(CtrlHandler *);
  virtual void recv(DataHandler *);
  virtual void announce(CtrlHandler *);
protected:
  CtrlHandler ch_[NLAYER];
  SourceManager *sm_;
  u_char *pktbuf_;

  void parse_sr(rtcphdr* rh, int flags, u_char* ep,
		Source* ps, u_int32_t addr, int layer);
  void parse_rr(rtcphdr* rh, int flags, u_char* ep,
		Source* ps, u_int32_t addr, int layer);
  void parse_rr_records(u_int32_t ssrc, rtcp_rr* r, int cnt,
			const u_char* ep, u_int32_t addr);
  int sdesbody(u_int32_t* p, u_char* ep, Source* ps,
	       u_int32_t addr, u_int32_t ssrc, int layer);
  void parse_sdes(rtcphdr* rh, int flags, u_char* ep, Source* ps,
		  u_int32_t addr, u_int32_t ssrc, int layer);
  void parse_bye(rtcphdr* rh, int flags, u_char* ep, Source* ps);
  virtual void parse_app(rtcphdr* rh, int flags, u_char* ep, Source* ps);
};




#endif
