# al-hm.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/as/al-hm.tcl,v 1.9 2002/02/03 04:25:20 lim Exp $


import AnnounceListenManager/AS

# Announce listen manager for the host manager (part of AS1)
# Author: Elan Amir
Class AnnounceListenManager/AS/HM -superclass AnnounceListenManager/AS

AnnounceListenManager/AS/HM instproc init { agent spec bw } {
	$self next $spec $bw hm
	$self set agent_ $agent

	[$self get_timer] threshold 10000
}

AnnounceListenManager/AS/HM instproc recv_msg { atype aspec addr srv_name srv_loc srv_inst ssg_port msg } {
	$self instvar agent_
#$agent_ log ""
#$agent_ log "$agent_ hm:recv {$msg}"
#$agent_ log ""
	switch $atype {
	srv {
		# nothing
	}
	hm {
		# sname holds the type of the message
		$self handle_hm_msg $aspec $msg $addr $srv_name $srv_inst
	}
	client {
		set load [HMAgent get_load]
		set hiload [$self get_option highLoad]
		if { [$self get_option noLoad] == "" &&  $load >= $hiload } {
			$agent_ log "HI LOAD load=$load $hiload"
		} else {
			# Wait a couple seconds to prevent any race conditions
			# between gateway announcement prompted by client
			# message and hm check.
			after 2000 $self "handle_client_msg $srv_name \
				$srv_loc $srv_inst {$msg} [gettimeofday]"
		}
	}
	}
}

AnnounceListenManager/AS/HM instproc duphm { name } {
	# A duplicate hm - break the tie with pids.
	if { [string compare $name [$self agent_instance]] < 0 } {
		$self instvar agent_
		$agent_ log "duplicate hm: $name [$self agent_instance] - exiting."
		$agent_ doexit
	}
}

AnnounceListenManager/AS/HM instproc handle_hm_msg { aspec msg addr srv_name srv_inst } {
	$self instvar agent_
#$agent_ log "hm:recv $srv_name from $addr"
	switch $srv_name {
	update {
		# Check if there's another hm on this host
		if { $addr == [localaddr] } {
			$self duphm $aspec
		}
	}
	launch {
		$agent_ suppress_timer $srv_inst
	}
	}
}

AnnounceListenManager/AS/HM instproc handle_client_msg { srv_name srv_loc srv_inst msg ts } {
	$self instvar agent_
	if [$agent_ pending_timer $srv_inst] {
#$agent_ log "pending"
		return
	}

	# If we don't have a record of a gateway for this session,
	# launch one.
	$self instvar agentbytype_ agenttab_ lastann_
	set srvlist $agentbytype_(srv)
	foreach srvspec $srvlist {
		set srv $agenttab_($srvspec)
		set inst [lindex $srv 4]
		if { $inst == $srv_inst } {
	     		set lastann $lastann_($srvspec,abs)
#$agent_ log "$lastann [expr $ts - 1]"
	     		if { $lastann < $ts - 1 } {
#$agent_ log "$self delete_agent $gwspec"
				$self delete_agent $srvspec
				break
			}
			return
		}
	}

	# Can't find a service record.  Set launch timer.
	$agent_ sched_launch $srv_name $srv_loc $srv_inst $msg
}

AnnounceListenManager/AS/HM instproc register { atype aspec addr srv_name srv_inst msg } {
	$self instvar agent_
	if { $addr != [localaddr] || $atype != "srv" } {
		return
	}
	$agent_ cancel_timer $srv_inst
}

AnnounceListenManager/AS/HM instproc unregister { atype aspec addr srv_name srv_inst ad } {
	$self instvar agent_
	if { $addr != [localaddr] || $atype != "srv" } {
		return
	}
	$agent_ unregister $aspec $ad
}

#
# This is really just an optimization since the gateways will kill each
# other off - but we must do this or performance will be very bad.
#
AnnounceListenManager/AS/HM instproc announce_launch { srv_inst } {

	set o "ASCP v[AnnounceListenManager/AS version]"
	set n hm
	set o $o\n$n
	set n [$self agent_instance]
	set o $o\n$n
	set n launch
	set o $o\n$n
	set n -
	set o $o\n$n
	set n $srv_inst
	set o $o\n$n
	set n -
	set o $o\n$n

	$self announce $o
}

#
# We build a simple message since we only use this to announce
# our presence.
AnnounceListenManager/AS/HM instproc send_announcement {} {
	$self instvar id1_ id2_

	set o "ASCP v[AnnounceListenManager/AS version]"
	set n hm
	set o $o\n$n
	set n [$self agent_instance]
	set o $o\n$n
	set n update
	set o $o\n$n
	set n -
	set o $o\n$n
	set n -
	set o $o\n$n
	set n -
	set o $o\n$n

	$self announce $o
}

AnnounceListenManager/AS/HM instproc hmnum {} {
	return [llength [$self hmaddrs]]
}

AnnounceListenManager/AS/HM instproc hmaddrs {} {
	$self instvar agenttab_
	set aspecs [array names agenttab_]

	foreach aspec $aspecs {
		set addr [lindex $agenttab_($aspec) 0]
		# remove duplicate entries
		set d($addr) 1
	}
	return [array names d]
}
