# peel.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import DaliSubprogram
import RealParameter

Class PeelSubprogram -superclass DaliSubprogram

PeelSubprogram instproc init {args} {
    eval $self next $args;

    $self instvar input_id_list_;
    $self instvar input_info_;

    lappend input_id_list_ i1;

    set input_info_(i1,spec) "";
    set input_info_(i1,trigger) 0;
    set input_info_(i1,buffertype) Uncompressed;
    set input_info_(i1,buffername) [new VidRep/Uncompressed];
    set input_info_(i1,decoder) "";

    lappend input_id_list_ i2;

    set input_info_(i2,spec) "";
    set input_info_(i2,trigger) 0;
    set input_info_(i2,buffertype) Uncompressed;
    set input_info_(i2,buffername) [new VidRep/Uncompressed];
    set input_info_(i2,decoder) "";

    # Set up outputs

    $self instvar output_id_list_;
    $self instvar output_info_;

    lappend output_id_list_ o1;

    set output_info_(o1,spec) "";
    set output_info_(o1,buffertype) Uncompressed;
    set output_info_(o1,buffername) [new VidRep/Uncompressed];
    set output_info_(o1,encoder) "";
    set output_info_(o1,format) JPEG;
    set output_info_(o1,vagent) "";

    # Set up parameters

    $self instvar parameter_id_list_;
    $self instvar parameter_info_;

    lappend parameter_id_list_ pfactor;
    set pobj [new RealParameter];
    set parameter_info_(pfactor,oname) $pobj;

    $pobj from 0.0
    $pobj to 1.0;

    $self instvar comm_obj_;
    $comm_obj_ setup;
}

PeelSubprogram instproc trigger {} {
    $self instvar comm_obj_;

    if {![$comm_obj_ parameter_attr_has_value pfactor value]} {
	return;
    }

    $self instvar parameter_info_;
    $self instvar input_info_;
    $self instvar output_info_;
    $self instvar init_done_;
    $self instvar old_pfactor_;
    $self instvar tb1_;

    $self instvar w_ h_ pix_pos_ x1_ x2_ y1_ y2_ aff_coords_
    $self instvar diag_bit_mask_ inv_diag_bit_mask_;
    $self instvar c_diag_bit_mask_ c_inv_diag_bit_mask_;

    set pobj $parameter_info_(pfactor,oname)

    set pfactor [$pobj get];

    set in_frame1 $input_info_(i1,buffername);
    set in_frame2 $input_info_(i2,buffername);
    set out_frame $output_info_(o1,buffername);

    if {![info exists init_done_]} {
	if {[$in_frame1 set w_] == 0} {
	    return
	}
	if {[$in_frame2 set w_] == 0} {
	    return
	}

	$out_frame copy_geometry $in_frame2;
	if {$output_info_(o1,format) == "JPEG"} {
	    $out_frame set h_subsample_ 2;
	    $out_frame set v_subsample_ 1;
	} else {
	    $out_frame set h_subsample_ 2;
	    $out_frame set v_subsample_ 2;
	}
	$out_frame allocate;
	set init_done_ 1;
	set old_pfactor_ "";

	set w_ [$in_frame2 set w_];
	set h_ [$in_frame2 set h_];

	if {$w_ > $h_} {
	    set d $w_;
	} else {
	    set d $h_;
	}

	set diag_bit_mask_ [bit_new $d $d];
	set inv_diag_bit_mask_ [bit_new $d $d];

	puts "here"

	set temp_byte [byte_new $d $d];

	for {set i 0} {$i < $d} {incr i} {
	    for {set j 0} {$j < $d} {incr j} {
		if {[expr $i + $j] < $d} {
		    byte_poke $temp_byte $i $j 64
		} else {
		    byte_poke $temp_byte $i $j 128
		}
	    }
	}

	bit_make_from_key $temp_byte 60 70 $diag_bit_mask_;
	bit_make_from_key $temp_byte 120 140 $inv_diag_bit_mask_;

	byte_free $temp_byte;

	set hs [$in_frame2 set h_subsample_];
	set vs [$in_frame2 set v_subsample_];

	set c_diag_bit_mask_ [bit_new [expr $d/$hs] [expr $d/$vs]];
	set c_inv_diag_bit_mask_ [bit_new [expr $d/$hs] [expr $d/$vs]];

	set temp_byte [byte_new [expr $d/$hs] [expr $d/$vs]];

	for {set i 0} {$i < [expr $d/$hs]} {incr i} {
	    for {set j 0} {$j < [expr $d/$vs]} {incr j} {
		if {[expr ($i*$hs) + ($j*$vs)] < $d} {
		    byte_poke $temp_byte $i $j 64
		} else {
		    byte_poke $temp_byte $i $j 128
		}
	    }
	}

	bit_make_from_key $temp_byte 60 70 $c_diag_bit_mask_;
	bit_make_from_key $temp_byte 120 140 $c_inv_diag_bit_mask_;

	byte_free $temp_byte;

	puts "there"
    }


    if {$old_pfactor_ != $pfactor} {

	set old_pfactor_ $pfactor;

	set pix_len [expr $w_+$h_];

	set pix_pos_ [expr int($pfactor * $pix_len)];

	if {[expr $pix_pos_%2] == 1} {
	    incr pix_pos_;
	}

	if {$pix_pos_ >= $w_} {
	    set x2_ [expr $w_ - 1];
	} else {
	    set x2_ $pix_pos_;
	}

	if {$pix_pos_ >= $h_} {
	    set y2_ [expr $h_ - 1];
	} else {
	    set y2_ $pix_pos_;
	}

	if {[expr $pix_pos_ - $h_] < 0} {
	    set x1_ 0;
	} else {
	    set x1_ [expr $pix_pos_ - $h_];
	}

	if {[expr $pix_pos_ - $w_] < 0} {
	    set y1_ 0;
	} else {
	    set y1_ [expr $pix_pos_ - $w_];
	}

	if {![info exists tb1_]} {
	    set tb1_ [new VidRep/Uncompressed];
	}

	set hs [$in_frame2 set h_subsample_];
	set vs [$in_frame2 set v_subsample_];

	$tb1_ set w_ [expr $x2_ - $x1_ + 1];
	$tb1_ set h_ [expr $y2_ - $y1_ + 1];
	$tb1_ set true_w_ [$tb1_ set w_]'
	$tb1_ set true_h_ [$tb1_ set h_]'
	$tb1_ set h_subsample_ $hs;
	$tb1_ set v_subsample_ $vs;

	$tb1_ allocate;

	set aff_coords_(a) 0;
	set aff_coords_(b) -1;
	set aff_coords_(c) [expr $pix_pos_ - $x1_];
	set aff_coords_(d) -1;
	set aff_coords_(e) 0;
	set aff_coords_(f) [expr $pix_pos_ - $y1_];

	set aff_coords_(ca) 0;
	set aff_coords_(cb) [expr -1 * $vs / $hs];
	set aff_coords_(cc) [expr ($pix_pos_ - $x1_)/$hs];
	set aff_coords_(cd) [expr -1 * $hs / $vs];
	set aff_coords_(ce) 0;
	set aff_coords_(cf) [expr ($pix_pos_ - $y1_) / $vs];
    }

    set i1_lum [$in_frame1 get_lum_name];
    set i2_lum [$in_frame2 get_lum_name];
    set out_lum [$out_frame get_lum_name];
    set tb1_lum [$tb1_ get_lum_name];

    set i1_cr [$in_frame1 get_cr_name];
    set i2_cr [$in_frame2 get_cr_name];
    set out_cr [$out_frame get_cr_name];
    set tb1_cr [$tb1_ get_cr_name];

    set i1_cb [$in_frame1 get_cb_name];
    set i2_cb [$in_frame2 get_cb_name];
    set out_cb [$out_frame get_cb_name];
    set tb1_cb [$tb1_ get_cb_name];

    set hs [$in_frame2 set h_subsample_];
    set vs [$in_frame2 set v_subsample_];

    # Rotate, scale and fill temp buffer with affine transform of
    # input 1.

    byte_affine $i1_lum $tb1_lum $aff_coords_(a) $aff_coords_(b) $aff_coords_(c) $aff_coords_(d) $aff_coords_(e) $aff_coords_(f);
    byte_affine $i1_cr $tb1_cr $aff_coords_(ca) $aff_coords_(cb) $aff_coords_(cc) $aff_coords_(cd) $aff_coords_(ce) $aff_coords_(cf);
    byte_affine $i1_cb $tb1_cb $aff_coords_(ca) $aff_coords_(cb) $aff_coords_(cc) $aff_coords_(cd) $aff_coords_(ce) $aff_coords_(cf);


    set tclip [byte_clip $i1_lum 0 0 1 1];
    set oclip [byte_clip $out_lum 0 0 1 1];

    if {$x1_ > 0} {
	byte_reclip $i2_lum 0 0 $x1_ $h_ $tclip;
	byte_reclip $out_lum 0 0 $x1_ $h_ $oclip;
	byte_copy $tclip $oclip;

	byte_reclip $i2_cr 0 0 [expr $x1_ / $hs] [expr $h_ / $vs] $tclip;
	byte_reclip $out_cr 0 0 [expr $x1_ / $hs] [expr $h_ / $vs] $oclip;
	byte_copy $tclip $oclip;

	byte_reclip $i2_cb 0 0 [expr $x1_ / $hs] [expr $h_ / $vs] $tclip;
	byte_reclip $out_cb 0 0 [expr $x1_ / $hs] [expr $h_ / $vs] $oclip;
	byte_copy $tclip $oclip;
    }

    if {$y1_ > 0} {
	byte_reclip $i2_lum $x1_ 0 [expr $x2_ - $x1_ +1] $y1_ $tclip;
	byte_reclip $out_lum $x1_ 0 [expr $x2_- $x1_ +1] $y1_ $oclip;
	byte_copy $tclip $oclip;

	byte_reclip $i2_cr [expr $x1_/$hs] 0 [expr ($x2_ - $x1_ +1)/$hs] [expr $y1_ / $vs] $tclip;
	byte_reclip $out_cr [expr $x1_/$hs] 0 [expr ($x2_ - $x1_ +1)/$hs] [expr $y1_ / $vs] $oclip;
	byte_copy $tclip $oclip;

	byte_reclip $i2_cb [expr $x1_/$hs] 0 [expr ($x2_ - $x1_ +1)/$hs] [expr $y1_ / $vs] $tclip;
	byte_reclip $out_cb [expr $x1_/$hs] 0 [expr ($x2_ - $x1_ +1)/$hs] [expr $y1_ / $vs] $oclip;
	byte_copy $tclip $oclip;
    }

    if {$x2_ < [expr $w_ -1]} {
	byte_reclip $i1_lum [expr $x2_ + 1] 0 [expr $w_ - $x2_ - 1] $h_ $tclip;
	byte_reclip $out_lum [expr $x2_+ 1] 0 [expr $w_ - $x2_ - 1] $h_ $oclip;
	byte_copy $tclip $oclip;

	byte_reclip $i1_cr [expr ($x2_ + 1)/$hs] 0 [expr ($w_ - $x2_ - 1)/$hs] [expr $h_/$vs] $tclip;
	byte_reclip $out_cr [expr ($x2_ + 1)/$hs] 0 [expr ($w_ - $x2_ - 1)/$hs] [expr $h_/$vs] $oclip;
	byte_copy $tclip $oclip;

	byte_reclip $i1_cb [expr ($x2_ + 1)/$hs] 0 [expr ($w_ - $x2_ - 1)/$hs] [expr $h_/$vs] $tclip;
	byte_reclip $out_cb [expr ($x2_ + 1)/$hs] 0 [expr ($w_ - $x2_ - 1)/$hs] [expr $h_/$vs] $oclip;
	byte_copy $tclip $oclip;
    }

    if {$y2_ < [expr $h_ -1]} {
	byte_reclip $i1_lum $x1_ [expr $y2_ + 1] [expr $x2_ - $x1_ + 1] [expr $h_ - $y2_ - 1] $tclip;
	byte_reclip $out_lum $x1_ [expr $y2_ + 1] [expr $x2_ - $x1_ + 1] [expr $h_ - $y2_ - 1] $oclip;
	byte_copy $tclip $oclip;

	byte_reclip $i1_cr [expr $x1_/$hs] [expr ($y2_ + 1)/$vs] [expr ($x2_ - $x1_ + 1)/$hs] [expr ($h_ - $y2_ - 1)/$vs] $tclip;
	byte_reclip $out_cr [expr $x1_/$hs] [expr ($y2_ + 1)/$vs] [expr ($x2_ - $x1_ + 1)/$hs] [expr ($h_ - $y2_ - 1)/$vs] $oclip;
	byte_copy $tclip $oclip;

	byte_reclip $i1_cb [expr $x1_/$hs] [expr ($y2_ + 1)/$vs] [expr ($x2_ - $x1_ + 1)/$hs] [expr ($h_ - $y2_ - 1)/$vs] $tclip;
	byte_reclip $out_cb [expr $x1_/$hs] [expr ($y2_ + 1)/$vs] [expr ($x2_ - $x1_ + 1)/$hs] [expr ($h_ - $y2_ - 1)/$vs] $oclip;
	byte_copy $tclip $oclip;
    }

    set diag_bit_clip [bit_clip $diag_bit_mask_ [expr ([bit_get_width $diag_bit_mask_] - ($x2_ - $x1_ + 1))/2] [expr ([bit_get_height $diag_bit_mask_] - ($y2_ - $y1_ + 1))/2] [expr $x2_ - $x1_ + 1] [expr $y2_ - $y1_ + 1]];

    set inv_diag_bit_clip [bit_clip $inv_diag_bit_mask_ [expr ([bit_get_width $diag_bit_mask_] - ($x2_ - $x1_ + 1))/2] [expr ([bit_get_height $diag_bit_mask_] - ($y2_ - $y1_ + 1))/2] [expr $x2_ - $x1_ + 1] [expr $y2_ - $y1_ + 1]];

    byte_reclip $i2_lum $x1_ $y1_ [expr $x2_ - $x1_ + 1] [expr $y2_ - $y1_ + 1] $tclip;
    byte_reclip $out_lum $x1_ $y1_ [expr $x2_ - $x1_ + 1] [expr $y2_ - $y1_ + 1] $oclip;

    byte_copy_with_mask $tclip $diag_bit_clip $oclip;
    byte_copy_with_mask $tb1_lum $inv_diag_bit_clip $oclip;

    bit_reclip $c_diag_bit_mask_ [expr ([bit_get_width $c_diag_bit_mask_] - (($x2_ - $x1_ + 1)/$hs))/2] [expr ([bit_get_height $c_diag_bit_mask_] - (($y2_ - $y1_ + 1)/$vs))/2] [expr ($x2_ - $x1_ + 1)/$hs] [expr ($y2_ - $y1_ + 1)/$vs] $diag_bit_clip;

    bit_reclip $c_inv_diag_bit_mask_ [expr ([bit_get_width $c_diag_bit_mask_] - (($x2_ - $x1_ + 1)/$hs))/2] [expr ([bit_get_height $c_diag_bit_mask_] - (($y2_ - $y1_ + 1)/$vs))/2] [expr ($x2_ - $x1_ + 1)/$hs] [expr ($y2_ - $y1_ + 1)/$vs] $inv_diag_bit_clip;

#    byte_reclip $out_cr [expr $x1_/$hs] [expr $y1_/$vs] [expr ($x2_ - $x1_ + 1)/$hs] [expr ($y2_ - $y1_ + 1)/$vs] $oclip;
#    byte_set $oclip 128;

#    byte_reclip $out_cb [expr $x1_/$hs] [expr $y1_/$vs] [expr ($x2_ - $x1_ + 1)/$hs] [expr ($y2_ - $y1_ + 1)/$vs] $oclip;
#    byte_set $oclip 128;


   byte_reclip $i2_cr [expr $x1_/$hs] [expr $y1_/$vs] [expr ($x2_ - $x1_ + 1)/$hs] [expr ($y2_ - $y1_ + 1)/$vs] $tclip;
    byte_reclip $out_cr [expr $x1_/$hs] [expr $y1_/$vs] [expr ($x2_ - $x1_ + 1)/$hs] [expr ($y2_ - $y1_ + 1)/$vs] $oclip;

    byte_copy_with_mask $tclip $diag_bit_clip $oclip;
    byte_copy_with_mask $tb1_cr $inv_diag_bit_clip $oclip;

    byte_reclip $i2_cb [expr $x1_/$hs] [expr $y1_/$vs] [expr ($x2_ - $x1_ + 1)/$hs] [expr ($y2_ - $y1_ + 1)/$vs] $tclip;
    byte_reclip $out_cb [expr $x1_/$hs] [expr $y1_/$vs] [expr ($x2_ - $x1_ + 1)/$hs] [expr ($y2_ - $y1_ + 1)/$vs] $oclip;

    byte_copy_with_mask $tclip $diag_bit_clip $oclip;
    byte_copy_with_mask $tb1_cb $inv_diag_bit_clip $oclip;


    bit_free $diag_bit_clip;
    bit_free $inv_diag_bit_clip;
    byte_free $tclip;
    byte_free $oclip;

    $out_frame set ts_ [$in_frame1 set ts_];

    set encoder $output_info_(o1,encoder);

    if {$encoder != ""} {
	$encoder recv $out_frame;
    }

    $self send_completion_token

    [[[[$input_info_(i1,decoder) set agent_] set network_] set net_(0)] set dn_] recv_flush
    [[[[$input_info_(i2,decoder) set agent_] set network_] set net_(0)] set dn_] recv_flush

}
