# rqmc.tcl --
#
#       An interface to talk to a QM app running remotely.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import DpClient

# use the Tcl namespace facility for global variables to prevent conflicts
namespace eval RemoteQuestionMonitorClient {
    variable mark
    variable debugOn
}

Class RemoteQuestionMonitorClient

RemoteQuestionMonitorClient instproc init {base host port {inVd 0}} {
    $self instvar rqm_ inVd_

    set inVd_ $inVd
    set RemoteQuestionMonitorClient::debugOn 0

    $self initUI $base

    if {[catch {set rqm_ [new DpClient $host $port]} err]} {
	return -code error "$err"
    }
}

RemoteQuestionMonitorClient instproc destroy {} {
    $self instvar rqm_

    # if the server is killed, this will fail
    catch {$rqm_ closeRPC}
}

RemoteQuestionMonitorClient instproc initUI {base} {
    $self instvar inVd_

#    button $base.enable -text "Enable" -command "$self enableQM"
#    pack $base.enable
#    button $base.disable -text "Disable" -command "$self disableQM"
#    pack $base.disable

    # FIXME - if someone else changes the QM's enable status, we won't know
    set curFrame $base.onOff
    frame $curFrame
    pack $curFrame -fill x -side top
    checkbutton $curFrame.onOff -text "Enabled" -variable RemoteQuestionMonitorClient::enabled -command "$self processEnabledDisabled"
    pack $curFrame.onOff -fill x -side left

    set curFrame $base.thresholdControl
    frame $curFrame -borderwidth 3
    pack $curFrame -side top -fill x -padx 3 -pady 2 -expand true
    $self buildThresholdControls $curFrame
    
    if {$RemoteQuestionMonitorClient::debugOn} {
	set curFrame $base.mark
	frame $curFrame -borderwidth 1 -relief solid
	pack $curFrame -side top

	label $curFrame.label -text "Mark Question"
	pack $curFrame.label -side top

	set curFrame $base.mark.buttons
	frame $curFrame
	pack $curFrame -side top

	checkbutton $curFrame.left -text "L" -variable RemoteQuestionMonitorClient::mark(left) -command "$self markQuestion left"
	pack $curFrame.left -side left
	checkbutton $curFrame.center -text "C" -variable RemoteQuestionMonitorClient::mark(center) -command "$self markQuestion center"
	pack $curFrame.center -side left
	checkbutton $curFrame.right -text "R" -variable RemoteQuestionMonitorClient::mark(right) -command "$self markQuestion right"
	pack $curFrame.right -side left
	# in case you can't tell where it's coming from
	checkbutton $curFrame.generic -text "G" -variable RemoteQuestionMonitorClient::mark(generic) -command "$self markQuestion generic"
	pack $curFrame.generic -side left
    }

    if {!$inVd_} {
	button $base.killServer -text "Kill Server" -command "$self killServer"
	pack $base.killServer
    }
}

RemoteQuestionMonitorClient instproc buildThresholdControls {base} {
    set curFrame $base.labelFrame
    frame $curFrame
    pack $curFrame -fill x -expand true -side top
    label $curFrame.label -text "Thresholds"
    pack $curFrame.label -fill x -side left
    $self makeBar $base "left" "L" 0 100 top 150
    $self makeBar $base "center" "C" 0 100 top 150
    $self makeBar $base "right" "R" 0 100 top 150
}

RemoteQuestionMonitorClient instproc makeBar {base name textLabel min max side size} {
    set curFrame "$base.$name"
    frame $curFrame
    pack $curFrame -fill x -side $side


    label $curFrame.label -text $textLabel
    pack $curFrame.label -fill x -side left

    set widget [scale $curFrame.bar -from $min -to $max -length $size -variable x.$name -orient horizontal -showvalue false -command "$self barHandler $name"]
    pack $curFrame.bar -fill x -side $side

    return $widget
}

RemoteQuestionMonitorClient instproc barHandler {name value} {
   # puts stdout "set value to $name"
}

RemoteQuestionMonitorClient instproc processEnabledDisabled {} {
    $self instvar rqm_

    if {$RemoteQuestionMonitorClient::enabled} {
	$rqm_ do enableQM
    } else {
	$rqm_ do disableQM
    }
}

RemoteQuestionMonitorClient instproc setOutput {output} {
    $self instvar rqm_

    $rqm_ do setOutput $output
}

RemoteQuestionMonitorClient instproc enableQM {} {
    set RemoteQuestionMonitorClient::enabled 1
    $self processEnabledDisabled
}

RemoteQuestionMonitorClient instproc disableQM {} {
    set RemoteQuestionMonitorClient::enabled 0
    $self processEnabledDisabled
}

RemoteQuestionMonitorClient instproc markQuestion {region} {
    $self instvar rqm_

    if {$RemoteQuestionMonitorClient::mark($region)} {
	$rqm_ do markQuestionStart $region
    } else {
	$rqm_ do markQuestionEnd $region
    }
}

RemoteQuestionMonitorClient public killServer {} {
    $self instvar rqm_

    $rqm_ do rqm_killServer
}
