#!/bin/sh
# path trick for tclsh variants \
exec tclsh $0 ${1+"$@"}

# assembleGraph.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

global g_files g_labels g_num g_title g_x g_y

proc showUsage {} {
    puts stdout "assembleGraph \[-t <title>\] \[-x <x axis>\] \[-y <y axis>\] \[-f <filename> -l <label>\] ..."
    exit
}

proc getArgs {argv} {
    global g_files g_labels g_num g_title g_x g_y

    set g_title ""
    set g_x ""
    set g_y ""
    set g_num 0
    set index 0

    set state flag
    foreach arg $argv {
        switch -exact -- $state {
            flag {
                switch -exact -- $arg {
                    -f {
                        set state "filename"
                    }
		    -t {
                        set state "title"
                    }
		    -x {
                        set state "x"
                    }
		    -y {
                        set state "y"
                    }
                    -help {
                        showUsage
                        exit
                    }
                    default {
                        showUsage
                        exit
                    }
                }
            }
	    filename {
		set g_files($index) $arg
		set state "getFileLabel"
	    }
	    title {
		set g_title $arg
		set state "flag"
	    }
	    x {
		set g_x $arg
		set state "flag"
	    }
	    y {
		set g_y $arg
		set state "flag"
	    }
	    getFileLabel {
		if {$arg != "-l"} {
		    showUsage
		}
		set state "fileLabel"
	    }
	    fileLabel {
		set g_labels($index) $arg
		set state "flag"
		set index [expr $index + 1]
	    }
	}
    }
    set g_num $index
    if {$g_num == 0} {
	showUsage
    }
}

proc makegraph {} {
    global g_files g_labels g_num g_title g_x g_y

    if {$g_title != ""} {
	puts stdout "TitleText: $g_title"
    }
    if {$g_x != ""} {
	puts stdout "XUnitText: $g_x"
    }
    if {$g_y != ""} {
	puts stdout "XUnitText: $g_y"
    }
    puts stdout ""
    # process each input file
    for {set x 0} {$x < $g_num} {incr x 1} {
  	if [catch {open $g_files($x) r} infile] {
  	    puts stdout "Cannot open file $g_files($x)"
  	    return 0
  	}
	puts stdout "\"$g_labels($x)\""
  	while {[gets $infile line] >= 0} {
  	    puts stdout $line
	}
	puts stdout ""
    }
    return 1
}

# main program

if {[llength $argv] < 1} {
    showUsage
}

getArgs $argv

makegraph
