# tracker.tcl --
#
#       Tcl part of the Module/Tracker split object.  Provides GUI controls
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import DpClient

# this line is needed so we can bind to it in tracker.cc
Module/Tracker set tracking_on_ 0

Module/Tracker public test_split {} {
    puts stdout "split object function works!"
}

Module/Tracker public blockoff {} {
    $self toggleblockonoff
}

Module/Tracker public rescaleWrap {} {
    $self instvar test_bar_

    $self rescale [$test_bar_ get]
}

Module/Tracker public toggle {} {
    # tracking_on_ is a class instance variable and is bound in the tracker.cc constructor
    $self instvar tracking_on_ frame_name_

#    puts stdout "tracking_on_ is $tracking_on_"

    if {$tracking_on_ == 1} {
	$frame_name_.togs2.cicanvas create rect 5 5 16 16 -fill green
	$self disable_tracking
    } else {
	$frame_name_.togs2.cicanvas create rect 5 5 16 16 -fill red
	$self enable_tracking
    }
}

Module/Tracker public print_stats {} {
    $self instvar agent_name_

    set stat_string [$agent_name_ stats]
    puts stdout "stat_string is $stat_string"
    $self get_stats
    return $stat_string
}

Module/Tracker public signal_crazy {} {
    $self instvar frame_name_ tracking_on_ amx_

    $self disable_tracking
    $frame_name_.togs3.zicanvas create rect 5 5 16 16 -fill red
    $frame_name_.togs2.cicanvas create rect 5 5 16 16 -fill green
    after 500
    $amx_ doNoWait camera_center speaker
}

Module/Tracker public undo_crazy {} {
    $self instvar frame_name_

    $frame_name_.togs3.zicanvas create rect 5 5 16 16 -fill green
}

Module/Tracker public move_camera {argument num_times} {
    $self instvar amx_ tracking_on_

    if {$tracking_on_ == 1} {
	$amx_ doNoWait camera_pulseMove speaker $argument $num_times
    }
}

Module/Tracker public move_camera_always {argument num_times} {
    $self instvar amx_

    $amx_ doNoWait camera_pulseMove speaker $argument $num_times
}

#
# This is called when a Tcl object is instantiated, the number of args must
#   match that in the New call
#
Module/Tracker public init {frame_name scale_size agent_name} {
#    puts stdout "in Module/Tracker::init"

    $self instvar frame_name_ scale_size_ agent_name_ amx_ tracking_on_

    set frame_name_ $frame_name
    set scale_size_ $scale_size
    set agent_name_ $agent_name
    set tracking_on_ 0
    set hostname htsr.bmrc.berkeley.edu
    set port 6901
    set amx_ [new DpClient $hostname $port]


#    puts stdout "frame_name is $frame_name"
#    puts stdout "scale_size is $scale_size"
#    puts stdout "agent_name is $agent_name"

    $self initUI

    # this causes the C++ constructor to be called with the args passed

    # FIXME - I don't use all the arguments anymore
    $self next $frame_name_ $scale_size_ $agent_name_

#    puts stdout "ending init"
}


Module/Tracker instproc initUI {} {
    $self instvar frame_name_ amx_

#    puts stdout "initing gui"

#    puts stdout "frame_name_ is $frame_name_"

    # controls for moving the camera
    frame $frame_name_.controls_frame

    pack $frame_name_.controls_frame -side top

    frame $frame_name_.controls_frame.top -borderwidth 3
    frame $frame_name_.controls_frame.middle -borderwidth 3
    frame $frame_name_.controls_frame.bottom -borderwidth 3
    frame $frame_name_.controls_frame.bottom2 -borderwidth 3

    button $frame_name_.controls_frame.top.up -text " Up " -command "$self move_camera_always up 5"
    button $frame_name_.controls_frame.middle.left -text "Left" -command "$self move_camera_always left 5"
    button $frame_name_.controls_frame.middle.center -text "Center" -width 4  -command "$amx_ doNoWait camera_center speaker"
    button $frame_name_.controls_frame.middle.right -text "Right" -command "$self move_camera_always right 5"
    button $frame_name_.controls_frame.bottom.down -text "Down" -command "$self move_camera_always down 5"
    button $frame_name_.controls_frame.bottom2.in -text "In" -width 3 -command "$self move_camera_always in 2"
    button $frame_name_.controls_frame.bottom2.out -text "Out" -width 3 -command "$self move_camera_always out 2"

    pack $frame_name_.controls_frame.top -side top -fill x
    pack $frame_name_.controls_frame.top.up -side top

    pack $frame_name_.controls_frame.middle -side top
    pack $frame_name_.controls_frame.middle.left -side left
    pack $frame_name_.controls_frame.middle.center -side left
    pack $frame_name_.controls_frame.middle.right -side right

    pack $frame_name_.controls_frame.bottom -side top
    pack $frame_name_.controls_frame.bottom.down -side top

    pack $frame_name_.controls_frame.bottom2 -side top
    pack $frame_name_.controls_frame.bottom2.in -side left -ipadx 2
    pack $frame_name_.controls_frame.bottom2.out -side right -ipadx 2

    # stats frame
    button $frame_name_.stats -text "Stats" -command "$self print_stats"
    pack $frame_name_.stats -side top

    # toggle buttons
    frame $frame_name_.fillerframe -width 100 -height 30
    frame $frame_name_.togs1 -borderwidth 4
    frame $frame_name_.togs2 -borderwidth 4
    frame $frame_name_.togs3 -borderwidth 4

    button $frame_name_.togs1.blockoff -text "Toggle Display" -width 16  -padx 4 -command "$self blockoff"
    label $frame_name_.togs1.filler -text ""
    button $frame_name_.togs2.togglecamera -text "Toggle Camera" -width 16  -padx 4 -command "$self toggle"
    label $frame_name_.togs2.filler -text ""
    button $frame_name_.togs3.crazy -text "Out of Control" -width 16  -padx 4 -command "$self undo_crazy"
    label $frame_name_.togs3.filler -text ""

#     button $frame_name_.togs3.crazy2 -text "make crazy" -width 16 -padx 4 -command "$self signal_crazy"

    canvas $frame_name_.togs1.bicanvas -width 20 -height 20 -borderwidth 0 -highlightthickness 0
    canvas $frame_name_.togs2.cicanvas -width 20 -height 20 -borderwidth 0 -highlightthickness 0
    canvas $frame_name_.togs3.zicanvas -width 20 -height 20 -borderwidth 0 -highlightthickness 0

    $frame_name_.togs1.bicanvas create rect 5 5 16 16 -fill green
    $frame_name_.togs2.cicanvas create rect 5 5 16 16 -fill green
    $frame_name_.togs3.zicanvas create rect 5 5 16 16 -fill green

    pack $frame_name_.togs1.blockoff -side left
    pack $frame_name_.togs1.filler -side left
    pack $frame_name_.togs1.bicanvas -side right
    pack $frame_name_.togs2.togglecamera -side left
    pack $frame_name_.togs2.filler -side left
    pack $frame_name_.togs2.cicanvas -side right
    pack $frame_name_.togs3.crazy -side left
    pack $frame_name_.togs3.filler -side left
    pack $frame_name_.togs3.zicanvas -side right

    pack $frame_name_.fillerframe
    pack $frame_name_.togs1
    pack $frame_name_.togs2
    pack $frame_name_.togs3

    canvas $frame_name_.t_canvas -width 176 -height 144
    pack $frame_name_.t_canvas

    canvas $frame_name_.t_output -width 100 -height 70 -highlightthickness 0
    pack $frame_name_.t_output

    button $frame_name_.rescale -text "rescale" -command "$self rescaleWrap"
    pack $frame_name_.rescale

    # scale entry
    $self instvar test_bar_
    set test_bar_ [scale $frame_name_.scale -from 1 -to 16 -length 256 -variable x -orient horizontal -label "Send camera command:" -showvalue true]
    pack $frame_name_.scale

#    puts stdout "made the gui"
}

