# vd.tcl --
#
#       wrapper around several different objects to create the "Virtual
#       Director".  Provides frame for each object and an API to let them
#       communicate b/w each other
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import BroadcastDescription RemoteQuestionMonitorClient

Class VirtualDirector

# the spec argument is a list of all the other arguments
#
# 0 broadcast description filename
# 1 DC host
# 2 DC port
# 3 recorder host
# 4 recorder port
# 5 VD application pointer
# 6 question monitor host
# 7 question monitor port
#
VirtualDirector instproc init {base spec} {
    $self instvar qm_ qmFrame_ bd_ bdFrame_

    $self initUI $base

    set host [lindex $spec 6]
    set port [lindex $spec 7]
    if {[catch {set qm_ [new RemoteQuestionMonitorClient $qmFrame_ $host $port 1]} result]} {
  	set msg "Warning: cannot connect to question monitor at $host/$port"
  	tk_messageBox -message $msg -type ok -title "Virtual Director: Warning" -icon "warning"
  	pack unpack $base.children.qmFrame
	set qm_ ""
	puts stderr "error was $result"
    }

    set bdSpec [list]
    # description file
    lappend bdSpec [lindex $spec 0]
    # DC host/port
    lappend bdSpec [lindex $spec 1] [lindex $spec 2]
    # recorder host/port
    lappend bdSpec [lindex $spec 3] [lindex $spec 4]
    lappend bdSpec $self
    set bd_ [new BroadcastDescription $bdFrame_ $bdSpec]
}

VirtualDirector instproc initUI {base} {
    $self instvar bdFrame_ qmFrame_

    #
    # put all the child services in a separate frame
    #

    frame $base.children
    pack $base.children -side top -fill both -expand true
    set base $base.children

    # QuestionMonitor service
    set curFrame $base.qmFrame
    frame $curFrame -borderwidth 3 -relief sunken
    pack $curFrame -side top -padx 5 -pady 5 -fill x -expand true

    label $curFrame.label -text "Question Monitor"
    pack $curFrame.label -side top
    
    set curFrame $base.qmFrame.appFrame
    set qmFrame_ $curFrame
    frame $curFrame -borderwidth 1
    pack $curFrame -side left -fill x

    # Broadcast Description service
    set curFrame $base.bdFrame
    frame $curFrame -borderwidth 3 -relief sunken
    pack $curFrame -side top -padx 5 -pady 5 -fill x -expand true

    label $curFrame.label -text "Broadcast Automation"
    pack $curFrame.label -side top
  
    set curFrame $base.bdFrame.appFrame
    set bdFrame_ $curFrame
    frame $curFrame -borderwidth 1
    pack $curFrame -side left -fill x
}

VirtualDirector public enableQM {} {
    $self instvar qm_

    if {$qm_ != ""} {
	$qm_ enableQM
    }
}

VirtualDirector public disableQM {} {
    $self instvar qm_

    if {$qm_ != ""} {
	$qm_ disableQM
    }
}

# this is called when the QM app exits
VirtualDirector public onExit {} {
    $self instvar qm_ bd_

    $bd_ destroy

    # commented out killing of QM in case need to restart VD
    #  w/o killing QM
#    catch {$qm_ killServer}
#    catch {$qm_ destroy}

}
