# cam-ctrl.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/vic/cam-ctrl.tcl,v 1.8 2002/02/03 04:39:54 lim Exp $


#
import CameraUI RendezvousManager

# class for attaching camera controls to a UserWindow --
# clicks on the UW are sent as camera cmds to addresses aquired
# from the CameraManager, and
# also attaches a button for accessing the full camera ctrl UI
# below the UW.
Class RemoteCamera

# attaches camera controls to userWindow (w is the userWindow frame)
RemoteCamera public init {userWindow w} {
    $self instvar uw_ addr_ camCli_ w_ as_ camMngr_ showUI_ isalloc_
    set uw_ $userWindow
    set w_ $w

    set camMngr_ [CameraManager info instances]
    if {$camMngr_ == ""} {
	puts "RemoteCamera::init: CameraManager should be allocated...?!?"
	#set camMngr_ [new CameraManager [$self get_option rendezSpec]]
	return
    }

    set cname "[[[$uw_ set as_] set src_] sdes cname]"
    set addr_ [$camMngr_ get_addr_for $cname]
    if {$addr_ == ""} {
	set isalloc_ 0
	return
    } else {
	set isalloc_ 1
    }
    bind $w.frame.video <ButtonPress-1> "$self click \"%x %y\""
    bind $w.frame.video <ButtonRelease-1> "$self clickup"

    frame $w.camFrame
    set camCli_ [new CameraUI $w.camFrame $addr_]
    set showUI_ 0  ; # frame remains unpacked until UI is asked for
}

# returns whether the remote camera control address is known,
# and therefore, the agent to control it is allocated.
RemoteCamera private isAllocated {} {
    $self instvar isalloc_
    return $isalloc_
}

# receive click on window -- send move command to camera
RemoteCamera private click {xy} {
    $self instvar hei_ wid_ camCli_
    $self update_hei_wid
    set al [$camCli_ set al_]
    # normalize click h and w
    set x [lindex $xy 0]
    set y [lindex $xy 1]
    set normH [expr ($y*1.0)/$hei_]
    set normW [expr ($x*1.0)/$wid_]
    #puts "click: $normH x $normW"

    if {$normH > 0.6} {
	# down
	if {$normW > 0.6} {
	    $al send move_downright
	} elseif {$normW < 0.4 } {
	    $al send move_downleft
	} else {
	    $al send move_down
	}
    } elseif {$normH < 0.4 } {
	# up
	if {$normW > 0.6} {
	    $al send move_upright
	} elseif {$normW < 0.4 } {
	    $al send move_upleft
	} else {
	    $al send move_up
	}
    } else {
	# only L/R movement or zoom
	if {$normW > 0.6} {
	    $al send move_right
	} elseif {$normW < 0.4 } {
	    $al send move_left
	} elseif {$normH > 0.5} {
	    # these next two zoom clauses are possibly unintuitive..
	    # maybe should leave them out... FIXME
	    $al send zoom_out
	} else {
	    $al send zoom_in
	}
    }
}

# stop when click in released
RemoteCamera private clickup {} {
    $self instvar camCli_
    set al [$camCli_ set al_]
    $al send "move_stop"
    $al send "zoom_stop"
}

# get current height,width
RemoteCamera private update_hei_wid {} {
    $self instvar uw_ hei_ wid_

    set vidWin [[$uw_ set vw_] window]
    set hei_ [$vidWin height]
    set wid_ [$vidWin width]
}

# toggle camera control UI next to userWindow
RemoteCamera private toggleUI {} {
    $self instvar showUI_ w_
    if $showUI_ {
	pack forget $w_.camFrame
	set showUI_ 0
    } else {
	pack $w_.camFrame -fill both
	set showUI_ 1
    }
}

## ------------------------------------------------------------

# an object that listens for information on
# camera control mappings (via the use of the RendezvousManager)
# and then stores them.
#
Class CameraManager -superclass Observer

#
CameraManager public init {} {
    $self next
    $self instvar rcList_ rv_ camList_
    set rcList_ ""

    set rv_ [new RendezvousManager]
    $rv_ attach_observer $self
}

#
CameraManager public destroy {} {
    $self instvar rv_
    $rv_ detach_observer $self
    $self next
}

#
CameraManager private add {camName camAddr} {
    $self instvar camList_
    # only print if new mapping
    if {([array names camList_ $camName] == "") || \
	    ($camList_($camName) != $camAddr)} {
	#puts "mapping $camName <--> $camAddr"
    }
    set camList_($camName) $camAddr
}

#
CameraManager private rm {name} {
    $self instvar camList_
    if {[$self get $name] != ""} {
	unset camList_($name)
    }
}

#
CameraManager private get {name} {
    $self instvar camList_
    #foreach i [array names camList_] {puts "$i : $camList_($i)"}
    if {[array names camList_ $name] != ""} {
	return $camList_($name)
    } else {
	return ""
    }
}

# try to match entire cname, then just address of machine
CameraManager private get_addr_for {src} {
    #puts "get_addr_for $src"
    set retVal [$self get $src]
    if {$retVal == ""} {
	set srcaddr [lindex [split $src "@"] 1]
	set retVal [$self get $srcaddr]
    }
    #if {$retVal != ""} {puts "cam ctrl addr for $src is $retVal"}
    return $retVal

}


#
# listens for one of three message formats:
# <br>- camera: camCtrl:spec cname:cname
# <br>- camera: camName:camName videoIn:addr
# <br>- camera: camName:camName camCtrl:spec
# <p>
#
CameraManager private rendez_recv_camera {rvmsg} {
    $self instvar camData_

    set data [$rvmsg get_msg]

    # clear updated "camName<-->videoIn" entries
    set msgLine [lrange $data 1 end]
    regsub -all ":" $msgLine " " datalist
    set cn [lindex $datalist 1]
    if {[lindex $datalist 0] == "camName"} {
	if ![info exists camData_($cn)] {set camData_($cn) ""}
	if {[lindex $datalist 2] == "videoIn"} {
	    #puts "$datalist"
	    set i [lsearch $camData_($cn) "videoIn"]
	    while {$i != -1} {
		set camData_($cn) [lreplace $camData_($cn) $i $i]
		set i [lsearch $camData_($cn) "videoIn"]
	    }
	    foreach i [array names camData_] {
		set ind [lsearch $camData_($i) [lindex $msgLine 1]]
		if {$ind != -1} {
		    set camData_($i) [lreplace $camData_($i) $ind $ind]
		}
	    }
	}
    }

    #foreach i [array names camData_] {puts "$i : $camData_($i)"}

    # data of form "camCtrl:spec cname:cname" is exact match
    if {([lindex $datalist 0] == "camCtrl") && \
	    ([lindex $datalist 2] == "cname")} {
	set camAddr [lindex $datalist 1]
	set cname [lindex $datalist 3]
	$self add $cname $camAddr
    }
    # other msgs must be matched together
    # first store them (sorted)...
    if {[lindex $datalist 0] == "camName"} {
	set cn [lindex $datalist 1]
	set entry [lindex $msgLine 1]
	if {[lsearch $camData_($cn) $entry] == -1} {
	    lappend camData_($cn) $entry
	    set camData_($cn) [lsort $camData_($cn)]
	}
	# ... then check for a match.
	# (if you have both a videoIn and a camCtrl for a camName, add it)
	set camdata $camData_($cn)
	#puts "$camdata"
	if {[llength $camdata] >= 2} {
	    regsub -all ":" $camdata " " cdl
	    set camAddr [lindex $cdl 1]
	    for {set i 1} {$i < [llength $camdata]} {incr i} {
		set cname [lindex $cdl [expr ($i*2)+1]]
		$self add $cname $camAddr
	    }
	}
    }

}

