// -*- C++ -*- 
#ifndef PROJECTIO_H
#define PROJECTIO_H

#include "openschedException.h"
#include "project.h"
#include "reporter.h"

class ProjectFile 
{
public :
    ProjectFile();
    Project & project() { return mProject; };
    Reporter & reporter() { return mReporter; };
    void Load(const char *name);
    void checkComplete();

private :
    Project mProject;
    Reporter mReporter;

    void Error(char *fmt, ...);
    void Warning(char *fmt, ...);
    void Debug(char *fmt, ...);

    int ParseLine(char *linebuf, char ***pwords);
    void Vacation(char *resid, char *d1name, char *d2name);
    void AddCandidates(char *taskid, char **resources, int Nresources);
    void WorkBlock(const char *taskid, const char *resid, 
		   char *day1, char *day2, TimeBlock::Type type);
    void AddTaskGraph( char *d1name, char *d2name, char *fname );
};


class ProjectFileException 
  : public OpenschedException
{
public:
    ProjectFileException( string reason );
    virtual ~ProjectFileException();
};

#endif
