/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols.pbcast;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.javagroups.Address;
import org.javagroups.log.Trace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Digest
implements Externalizable {
    Address[] senders;
    long[] low_seqnos;
    long[] high_seqnos;
    long[] high_seqnos_seen;
    int index;

    public void add(Address sender, long low_seqno, long high_seqno) {
        if (this.index >= this.senders.length) {
            Trace.error("Digest.add()", "index " + this.index + " out of bounds, please create new Digest if you want more members !");
            return;
        }
        if (sender == null) {
            Trace.error("Digest.add()", "sender is null, will not add it !");
            return;
        }
        this.senders[this.index] = sender;
        this.low_seqnos[this.index] = low_seqno;
        this.high_seqnos[this.index] = high_seqno;
        this.high_seqnos_seen[this.index] = -1;
        ++this.index;
    }

    public void add(Address sender, long low_seqno, long high_seqno, long high_seqno_seen) {
        if (this.index >= this.senders.length) {
            Trace.error("Digest.add()", "index " + this.index + " out of bounds, please create new Digest if you want more members !");
            return;
        }
        if (sender == null) {
            Trace.error("Digest.add()", "sender is null, will not add it !");
            return;
        }
        this.senders[this.index] = sender;
        this.low_seqnos[this.index] = low_seqno;
        this.high_seqnos[this.index] = high_seqno;
        this.high_seqnos_seen[this.index] = high_seqno_seen;
        ++this.index;
    }

    public void add(Digest d) {
        if (d != null) {
            int i = 0;
            while (i < d.size()) {
                Address sender = d.senderAt(i);
                long low_seqno = d.lowSeqnoAt(i);
                long high_seqno = d.highSeqnoAt(i);
                long high_seqno_seen = d.highSeqnoSeenAt(i);
                this.add(sender, low_seqno, high_seqno, high_seqno_seen);
                ++i;
            }
        }
    }

    public void merge(Digest d) {
        if (d == null) {
            Trace.error("Digest.merge()", "digest to be merged with is null");
            return;
        }
        int i = 0;
        while (i < d.size()) {
            Address sender = d.senderAt(i);
            long low_seqno = d.lowSeqnoAt(i);
            long high_seqno = d.highSeqnoAt(i);
            long high_seqno_seen = d.highSeqnoSeenAt(i);
            this.merge(sender, low_seqno, high_seqno, high_seqno_seen);
            ++i;
        }
    }

    public void merge(Address sender, long low_seqno, long high_seqno, long high_seqno_seen) {
        if (sender == null) {
            Trace.error("Digest.merge()", "sender == null");
            return;
        }
        int index = this.getIndex(sender);
        if (index == -1) {
            this.add(sender, low_seqno, high_seqno, high_seqno_seen);
            return;
        }
        long my_low_seqno = this.lowSeqnoAt(index);
        long my_high_seqno = this.highSeqnoAt(index);
        long my_high_seqno_seen = this.highSeqnoSeenAt(index);
        if (low_seqno < my_low_seqno) {
            this.setLowSeqnoAt(index, low_seqno);
        }
        if (high_seqno > my_high_seqno) {
            this.setHighSeqnoAt(index, high_seqno);
        }
        if (high_seqno_seen > my_high_seqno_seen) {
            this.setHighSeqnoSeenAt(index, high_seqno_seen);
        }
    }

    public int getIndex(Address sender) {
        int ret = -1;
        if (sender == null) {
            return ret;
        }
        int i = 0;
        while (i < this.senders.length) {
            if (sender.equals(this.senders[i])) {
                return i;
            }
            ++i;
        }
        return ret;
    }

    public boolean contains(Address sender) {
        boolean bl = false;
        if (this.getIndex(sender) != -1) {
            bl = true;
        }
        return bl;
    }

    public void incrementHighSeqno(Address sender) {
        if (sender == null) {
            return;
        }
        int i = 0;
        while (i < this.senders.length) {
            if (this.senders[i] != null && this.senders[i].equals(sender)) {
                this.high_seqnos[i] = this.high_seqnos[i] + 1L;
                break;
            }
            ++i;
        }
    }

    public int size() {
        return this.senders.length;
    }

    public Address senderAt(int index) {
        if (index < this.size()) {
            return this.senders[index];
        }
        Trace.error("Digest.senderAt()", "index " + index + " is out of bounds");
        return null;
    }

    public void resetAt(int index) {
        if (index < this.size()) {
            this.low_seqnos[index] = 0L;
            this.high_seqnos[index] = 0L;
            this.high_seqnos_seen[index] = -1;
        } else {
            Trace.error("Digest.resetAt()", "index " + index + " is out of bounds");
        }
    }

    public void reset(int size) {
        this.senders = new Address[size];
        this.low_seqnos = new long[size];
        this.high_seqnos = new long[size];
        this.high_seqnos_seen = new long[size];
        int i = 0;
        while (i < size) {
            this.high_seqnos_seen[i] = -1;
            ++i;
        }
        this.index = 0;
    }

    public long lowSeqnoAt(int index) {
        if (index < this.size()) {
            return this.low_seqnos[index];
        }
        Trace.error("Digest.lowSeqnoAt()", "index " + index + " is out of bounds");
        return 0L;
    }

    public long highSeqnoAt(int index) {
        if (index < this.size()) {
            return this.high_seqnos[index];
        }
        Trace.error("Digest.highSeqnoAt()", "index " + index + " is out of bounds");
        return 0L;
    }

    public long highSeqnoSeenAt(int index) {
        if (index < this.size()) {
            return this.high_seqnos_seen[index];
        }
        Trace.error("Digest.highSeqnoSeenAt()", "index " + index + " is out of bounds");
        return 0L;
    }

    public long highSeqnoAt(Address sender) {
        long ret = -1;
        if (sender == null) {
            return ret;
        }
        int index = this.getIndex(sender);
        if (index == -1) {
            return ret;
        }
        return this.high_seqnos[index];
    }

    public long highSeqnoSeenAt(Address sender) {
        long ret = -1;
        if (sender == null) {
            return ret;
        }
        int index = this.getIndex(sender);
        if (index == -1) {
            return ret;
        }
        return this.high_seqnos_seen[index];
    }

    public void setLowSeqnoAt(int index, long low_seqno) {
        if (index < this.size()) {
            this.low_seqnos[index] = low_seqno;
        } else {
            Trace.error("Digest.setLowSeqnoAt()", "index " + index + " is out of bounds");
        }
    }

    public void setHighSeqnoAt(int index, long high_seqno) {
        if (index < this.size()) {
            this.high_seqnos[index] = high_seqno;
        } else {
            Trace.error("Digest.setHighSeqnoAt()", "index " + index + " is out of bounds");
        }
    }

    public void setHighSeqnoSeenAt(int index, long high_seqno_seen) {
        if (index < this.size()) {
            this.high_seqnos_seen[index] = high_seqno_seen;
        } else {
            Trace.error("Digest.setHighSeqnoSeenAt()", "index " + index + " is out of bounds");
        }
    }

    public void setHighSeqnoAt(Address sender, long high_seqno) {
        int index = this.getIndex(sender);
        if (index < 0) {
            return;
        }
        this.setHighSeqnoAt(index, high_seqno);
    }

    public void setHighSeqnoSeenAt(Address sender, long high_seqno_seen) {
        int index = this.getIndex(sender);
        if (index < 0) {
            return;
        }
        this.setHighSeqnoSeenAt(index, high_seqno_seen);
    }

    public Digest copy() {
        Digest ret = new Digest(this.senders.length);
        ret.senders = (Address[])this.senders.clone();
        ret.low_seqnos = (long[])this.low_seqnos.clone();
        ret.high_seqnos = (long[])this.high_seqnos.clone();
        ret.high_seqnos_seen = (long[])this.high_seqnos_seen.clone();
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < this.senders.length) {
            if (!first) {
                sb.append(", ");
            } else {
                sb.append("[");
                first = false;
            }
            sb.append(this.senders[i]).append(": ").append("[").append(this.low_seqnos[i]).append(" : ");
            sb.append(this.high_seqnos[i]);
            if (this.high_seqnos_seen[i] >= 0L) {
                sb.append(" (").append(this.high_seqnos_seen[i]).append(")]");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public String printHighSeqnos() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < this.senders.length) {
            if (!first) {
                sb.append(", ");
            } else {
                sb.append("[");
                first = false;
            }
            sb.append(this.senders[i]);
            sb.append("#");
            sb.append(this.high_seqnos[i]);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public String printHighSeqnosSeen() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < this.senders.length) {
            if (!first) {
                sb.append(", ");
            } else {
                sb.append("[");
                first = false;
            }
            sb.append(this.senders[i]);
            sb.append("#");
            sb.append(this.high_seqnos_seen[i]);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeObject(this.senders);
        if (this.low_seqnos == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.low_seqnos.length);
            i = 0;
            while (i < this.low_seqnos.length) {
                out.writeLong(this.low_seqnos[i]);
                ++i;
            }
        }
        if (this.high_seqnos == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.high_seqnos.length);
            i = 0;
            while (i < this.high_seqnos.length) {
                out.writeLong(this.high_seqnos[i]);
                ++i;
            }
        }
        if (this.high_seqnos_seen == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.high_seqnos_seen.length);
            i = 0;
            while (i < this.high_seqnos_seen.length) {
                out.writeLong(this.high_seqnos_seen[i]);
                ++i;
            }
        }
        out.writeInt(this.index);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this.senders = (Address[])in.readObject();
        int num = in.readInt();
        if (num == 0) {
            this.low_seqnos = null;
        } else {
            this.low_seqnos = new long[num];
            i = 0;
            while (i < this.low_seqnos.length) {
                this.low_seqnos[i] = in.readLong();
                ++i;
            }
        }
        num = in.readInt();
        if (num == 0) {
            this.high_seqnos = null;
        } else {
            this.high_seqnos = new long[num];
            i = 0;
            while (i < this.high_seqnos.length) {
                this.high_seqnos[i] = in.readLong();
                ++i;
            }
        }
        num = in.readInt();
        if (num == 0) {
            this.high_seqnos_seen = null;
        } else {
            this.high_seqnos_seen = new long[num];
            i = 0;
            while (i < this.high_seqnos_seen.length) {
                this.high_seqnos_seen[i] = in.readLong();
                ++i;
            }
        }
        this.index = in.readInt();
    }

    private final /* synthetic */ void this() {
        this.senders = null;
        this.low_seqnos = null;
        this.high_seqnos = null;
        this.high_seqnos_seen = null;
        this.index = 0;
    }

    public Digest() {
        this.this();
    }

    public Digest(int size) {
        this.this();
        this.reset(size);
    }
}

