<?php
// $Id: console.php,v 1.7 2002/12/02 05:23:00 jon Exp $

/**
 * The Log_console class is a concrete implementation of the Log::
 * abstract class which writes message to the text console.
 * 
 * @author  Jon Parise <jon@php.net>
 * @version $Revision: 1.7 $
 * @package Log
 */
class Log_console extends Log
{
    /**
     * Constructs a new Log_console object.
     * 
     * @param string $name     Ignored.
     * @param string $ident    The identity string.
     * @param array  $conf     The configuration array.
     * @param array  $maxLevel Maximum priority level at which to log.
     * @access public
     */
    function Log_console($name, $ident = '', $conf = array(),
                         $maxLevel = PEAR_LOG_DEBUG)
    {
        $this->_ident = $ident;
        $this->_maxLevel = $maxLevel;
    }

    /**
     * Writes $message to the text console. Also, passes the message
     * along to any Log_observer instances that are observing this Log.
     * 
     * @param string $message  The textual message to be logged.
     * @param string $priority The priority of the message.  Valid
     *                  values are: PEAR_LOG_EMERG, PEAR_LOG_ALERT,
     *                  PEAR_LOG_CRIT, PEAR_LOG_ERR, PEAR_LOG_WARNING,
     *                  PEAR_LOG_NOTICE, PEAR_LOG_INFO, and PEAR_LOG_DEBUG.
     *                  The default is PEAR_LOG_INFO.
     * @return boolean  True on success or false on failure.
     * @access public
     */
    function log($message, $priority = PEAR_LOG_INFO)
    {
        /* Abort early if the priority is above the maximum logging level. */
        if ($priority > $this->_maxLevel) {
            return false;
        }

        printf("%s %s [%s] %s\n", strftime('%b %d %H:%M:%S'), $this->_ident,
            Log::priorityToString($priority), $message);

        $this->notifyAll(array('priority' => $priority, 'message' => $message));

        return true;
    }
}

?>
