#line 1 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
/* -*- c -*-
|| This file is part of Pike. For copyright information see COPYRIGHT.
|| Pike is distributed under GPL, LGPL and MPL. See the file COPYING
|| for more information.
|| $Id: SDL.cmod,v 1.15 2003/09/04 14:59:48 mast Exp $
*/

#include "global.h"
#include "stralloc.h"
RCSID("$Id: SDL.cmod,v 1.15 2003/09/04 14:59:48 mast Exp $");
#include "pike_macros.h"
#include "interpret.h"
#include "program.h"
#include "program_id.h"
#include "object.h"
#include "operators.h"
#include "fdlib.h"
#include "fd_control.h"
#include "backend.h"
#include "module_support.h"
#include "array.h"
#include "builtin_functions.h"
#include "mapping.h"

#include "sdl_config.h"

#ifdef HAVE_SDL

/*! @module SDL
 *!
 *! SDL or Simple DirectMedia Layer is a cross-platform multimedia
 *! library designed to provide fast access to the graphics
 *! framebuffer, audio device, input and other devices. This module
 *! implements a wrapper for SDL and other relevant libraries like
 *! SDL_mixer. The interface is similar to the C one, but using
 *! generally accepted Pike syntax.
 *! 
 *! This means that classes are used when appropriate and that method
 *! names use all lowercase letters with words separated by _. For
 *! example SDL_SetVideoMode is named SDL.set_video_mode. Also note
 *! that unless otherwise noted, errors result in an error being
 *! thrown rather than returning -1 or 0, as commonly done in SDL methods.
 */


/* To be able to access image functionality */
#include  "modules/Image/image.h" 
struct svalue _image_program = {
  T_INT, 0,
#ifdef HAVE_UNION_INIT
  {0}, /* Only to avoid warnings. */
#endif
};
struct svalue _image_color_program = {
  T_INT, 0,
#ifdef HAVE_UNION_INIT
  {0}, /* Only to avoid warnings. */
#endif
};

struct program *image_program;
struct program *image_color_program;


static struct object *image_make_rgb_color(INT32 r,INT32 g,INT32 b)
{
   struct color_struct *cs;
   struct object *color;
   if (r<0) r=0; else if (r>COLORMAX) r=COLORMAX;
   if (g<0) g=0; else if (g>COLORMAX) g=COLORMAX;
   if (b<0) b=0; else if (b>COLORMAX) b=COLORMAX;

   color = clone_object(image_color_program,0);

   cs=(struct color_struct*)
      get_storage(color, image_color_program);

   cs->rgb.r=(COLORTYPE)r;
   cs->rgb.g=(COLORTYPE)g;
   cs->rgb.b=(COLORTYPE)b;
   RGB_TO_RGBL(cs->rgbl,cs->rgb);
   return color;
}


/* SDL needs this defined in it its own way */
#undef DECLSPEC
#include <SDL.h>
#include "constants.h"

#ifdef HAVE_SDL_MIXER
# ifdef HAVE_SDL_SDL_MIXER_H
#  include <SDL/SDL_mixer.h>
# elif defined(HAVE_SDL_MIXER_H)
#  include <SDL_mixer.h>
# endif
#endif

#define THIS_OBJ Pike_interpreter.frame_pointer->current_object
#define RET_THIS() do { pop_n_elems(args); ref_push_object(THIS_OBJ); return; } while(0)

/* Fall back to a normal index on this object, in case
 * someone inherited us. */
 #define OBJ_INDEX() do { \
      struct svalue res; \
      object_index_no_free2 (&res, Pike_fp->current_object, Pike_sp-1); \
      pop_stack(); \
      *Pike_sp++ = res; \
    } while(0) \


#define CHECK_CLASS(o, name, arg)\
  if(o->prog != PIKE_CONCAT(name, _program)) { \
    Pike_error("Invalid class for argument %d\n", arg); \
  }


/*! @decl void init(int flags)
 *!
 *! Initializes SDL.  This should be called before all other SDL
 *! functions.
 *!
 *! @param flags
 *!  The flags parameter specifies what part(s) of SDL to
 *!  initialize. It can be one of many of the following ORed together.
 *! 
 *! @dl
 *!   @item SDL.INIT_TIMER
 *!    Initializes the timer subsystem.
 *! 
 *!   @item SDL.INIT_AUDIO
 *!    Initializes the audio subsystem.
 *! 
 *!   @item SDL.INIT_VIDEO
 *!    Initializes the video subsystem.
 *! 
 *!   @item SDL.INIT_CDROM
 *!    Initializes the cdrom subsystem.
 *! 
 *!   @item SDL.INIT_JOYSTICK
 *!    Initializes the joystick subsystem.
 *! 
 *!   @item SDL.INIT_EVERYTHING
 *!    Initialize all of the above.
 *! 
 *!   @item SDL.INIT_NOPARACHUTE
 *!    Prevents SDL from catching fatal signals.
 *! 
 *!   @item SDL.INIT_EVENTTHREAD
 *!    Run event polling in a separate thread. Not always supported.
 *! @enddl
 *!
 *! @seealso
 *!   @[SDL.quit()], @[SDL.init_sub_system()], @[SDL.quit_sub_system()]
 *!
 */
#define f_init_defined
void f_init(INT32 args) {
#line 157 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE flags;
#line 157 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("init",args,1);
#line 157 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("init",1,"int");
flags=Pike_sp[0-1].u.integer;
#line 157 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  if( SDL_Init(flags) == -1) {
    Pike_error("SDL Initialization failed: %s\n", SDL_GetError());
  }
}

}
/*! @decl void|string get_error()
 *!
 *! Get the last internal SDL error.
 *! @returns
 *!   The error string, or zero if there was no error.
 */
#define f_get_error_defined
void f_get_error(INT32 args) {
#line 169 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("get_error",args,0);
#line 169 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  const char *err = SDL_GetError();
  pop_n_elems(args);
  if(err != NULL) {
    push_text(err);
  } else {
    push_int(0);
  }
}

}
/*! @decl void init_sub_system(int flags)
 *! 
 *! After SDL has been initialized with @[init()] you may initialize
 *! uninitialized subsystems with this method.
 *! 
 *! @param flags
 *!  The same as what is used in @[SDL.init()].
 */
#define f_init_sub_system_defined
void f_init_sub_system(INT32 args) {
#line 187 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE flags;
#line 187 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("init_sub_system",args,1);
#line 187 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("init_sub_system",1,"int");
flags=Pike_sp[0-1].u.integer;
#line 187 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  do { INT_TYPE ret_=(SDL_InitSubSystem(flags)); pop_stack(); push_int(ret_); return; }while(0);
#line 189 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
/*! @decl void init_sub_system(int flags)
 *! 
 *! After SDL has been initialized with @[SDL.init()] you may initialize
 *! uninitialized subsystems with this method.
 *! 
 *! @param  flags
 *! a bitwise OR'd combination of the subsystems
 *! you wish to check (see @[SDL.init()] for a list of subsystem flags).
 *! @seealso
 *!  @[SDL.init()],  @[SDL.quit()], @[SDL.quit_sub_system()]
 */
#define f_quit_sub_system_defined
void f_quit_sub_system(INT32 args) {
#line 202 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE flags;
#line 202 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("quit_sub_system",args,1);
#line 202 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("quit_sub_system",1,"int");
flags=Pike_sp[0-1].u.integer;
#line 202 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  SDL_QuitSubSystem(flags);
}

}
/*! @decl int was_init(int flags)
 *! This method allows you to see which SDL subsytems have been
 *! initialized.
 *! @param  flags
 *! a bitwise OR'd combination of the subsystems
 *! you wish to check (see @[SDL.init()] for a list of subsystem flags).
 *! @returns
 *!  a bitwised OR'd combination of the initialized subsystems
 *! @seealso
 *!  @[SDL.init()], @[SDL.init_sub_system()]
 *!
 */
#define f_was_init_defined
void f_was_init(INT32 args) {
#line 218 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE flags;
#line 218 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("was_init",args,1);
#line 218 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("was_init",1,"int");
flags=Pike_sp[0-1].u.integer;
#line 218 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  do { INT_TYPE ret_=(SDL_WasInit(flags)); pop_stack(); push_int(ret_); return; }while(0);
#line 220 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
/*! @decl void quit()
 *! Shuts down all SDL subsystems and frees the resources allocated to
 *! them. This should always be called before you exit.
 *! @note
 *! You can use the @[atexit()] method to ensure that this method is always
 *! called when Pike exits normally. 
 *! @seealso
 *!  @[SDL.init()],  @[SDL.init_sub_system()], @[SDL.quit_sub_system()]
 */ 
#define f_quit_defined
void f_quit(INT32 args) {
#line 231 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("quit",args,0);
#line 231 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  SDL_Quit();
}


}
/*! @decl int enable_unicode(int enable)
 *!
 *! Enables/Disables UNICODE keyboard translation.
 *!
 *! If you wish to translate a keysym to it's printable
 *! representation, you need to enable UNICODE translation using this
 *! function and then look in the @b{unicode@} member of the
 *! @[SDL.Keysym] class. This value will be zero for keysyms that do
 *! not have a printable representation.  UNICODE translation is
 *! disabled by default as the conversion can cause a slight
 *! overhead.
 *! 
 *! @param enable
 *!   A value of 1 enables Unicode translation, 0 disables it and -1
 *!   leaves it unchanged (useful for querying the current translation
 *!   mode). 
 *! 
 *! @returns
 *!   The previous translation mode (1 enabled, 0 disabled). If
 *!   @b{enable@} is -1, the return value is the current translation
 *!   mode.
 *!   
 *! @seealso
 *!   
 *!   @[SDL.Keysym]
 */
#define f_enable_unicode_defined
void f_enable_unicode(INT32 args) {
#line 262 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE enable;
#line 262 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("enable_unicode",args,1);
#line 262 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("enable_unicode",1,"int");
enable=Pike_sp[0-1].u.integer;
#line 262 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  do { INT_TYPE ret_=(SDL_EnableUNICODE(enable)); pop_stack(); push_int(ret_); return; }while(0);
#line 264 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}


}
/*! @decl int get_mod_state()
 *!
 *! Returns the current state of the modifier keys (CTRL, ALT, etc.).
 *! 
 *! @returns
 *! The return value can be an OR'd combination of the following:
 *! SDL.KMOD_NONE, SDL.KMOD_LSHIFT, SDL.KMOD_RSHIFT, SDL.KMOD_LCTRL,
 *! SDL.KMOD_RCTRL, SDL.KMOD_LALT, SDL.KMOD_RALT, SDL.KMOD_LMETA,
 *! SDL.KMOD_RMETA, SDL.KMOD_NUM, SDL.KMOD_CAPS, and
 *! SDL.KMOD_MODE. For convenience the following are also defined:
 *! SDL.KMOD_CTRL, SDL.KMOD_SHIFT, SDL.KMOD_ALT and SDL.KMOD_META
 *!   
 *! @seealso
 *!   
 *!   @[SDL.get_key_state()]
 */
#define f_get_mod_state_defined
void f_get_mod_state(INT32 args) {
#line 283 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("get_mod_state",args,0);
#line 283 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  do { INT_TYPE ret_=(SDL_GetModState());  push_int(ret_); return; }while(0);
#line 285 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
/*! @decl string get_key_state()
 *! 
 *! Gets a snapshot of the current keyboard state. The current state
 *! is return as a string. The string is indexed by the SDL.K_* symbols. A
 *! value of 1 means the key is pressed and a value of 0 means its
 *! not. 
 *! 
 *! @note
 *!  @[SDL.pump_events()] to update the state array.
 *! 
 */

#define f_get_key_state_defined
void f_get_key_state(INT32 args) {
#line 299 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("get_key_state",args,0);
#line 299 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  int numkeys;
  char *state = SDL_GetKeyState(&numkeys);
  push_string(make_shared_binary_string(state, numkeys));
}

}
/*! @class Rect
 *! 
 *! Used in SDL to define a rectangular area. It is sometimes also used
 *! to specify only points or sizes (i.e only one of the position and
 *! dimension is used). 
 *! @decl int x
 *! @decl int y
 *!   Position of the upper-left corner of the rectangle.
 *! @decl int w
 *! @decl int h
 *!   The width and height of the rectangle.
 */

#undef class_Rect_defined
#define class_Rect_defined
struct program *Rect_program=0;

#undef var_rect_Rect_defined
#define var_rect_Rect_defined

#undef THIS
#define THIS ((struct Rect_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_RECT
#define THIS_RECT ((struct Rect_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_RECT
#define OBJ2_RECT(o) ((struct Rect_struct *)(o->storage+Rect_storage_offset))

#undef GET_RECT_STORAGE
#define GET_RECT_STORAGE ((struct Rect_struct *)(o->storage+Rect_storage_offset)
static ptrdiff_t Rect_storage_offset;
struct Rect_struct {

#ifdef var_rect_Rect_defined
#line 318 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
SDL_Rect rect;
#endif /* var_rect_Rect_defined */
};

#undef internal_init_Rect_defined
#define internal_init_Rect_defined

#undef Rect_event_handler_defined
#define Rect_event_handler_defined
static void init_Rect_struct(void)
#line 321 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    THIS->rect.x = THIS->rect.y = 0;
    THIS->rect.w = THIS->rect.h = 0;
  }
  
  #define f_Rect_cq__backtick_2D_3E_defined
void f_Rect_cq__backtick_2D_3E(INT32 args) {
#line 326 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 326 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`->",args,1);
#line 326 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`->",1,"string");
#line 326 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 326 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    struct pike_string *x, *y, *w, *h;
    MAKE_CONSTANT_SHARED_STRING( x, "x" );     
    MAKE_CONSTANT_SHARED_STRING( y, "y" );     
    MAKE_CONSTANT_SHARED_STRING( w, "w" );     
    MAKE_CONSTANT_SHARED_STRING( h, "h" );     
    if(key == x) {
      pop_stack(); push_int(THIS->rect.x); 
    } else if(key == y) {
      pop_stack(); push_int(THIS->rect.y); 
    } else if(key == w) {
      pop_stack(); push_int(THIS->rect.w); 
    } else if(key == h) {
      pop_stack(); push_int(THIS->rect.h); 
    } else { 
      OBJ_INDEX();
    }
  }
    
  }
#define f_Rect_cq__backtick_2D_3E_eq_defined
void f_Rect_cq__backtick_2D_3E_eq(INT32 args) {
#line 345 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 345 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE value;
#line 345 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 2) wrong_number_of_args_error("`->=",args,2);
#line 345 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`->=",1,"string");
#line 345 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-2].u.string);
#line 345 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`->=",2,"int");
value=Pike_sp[1-2].u.integer;
#line 345 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    struct pike_string *x, *y, *w, *h;
    MAKE_CONSTANT_SHARED_STRING( x, "x" );     
    MAKE_CONSTANT_SHARED_STRING( y, "y" );     
    MAKE_CONSTANT_SHARED_STRING( w, "w" );     
    MAKE_CONSTANT_SHARED_STRING( h, "h" );     
    if(key == x) {
      THIS->rect.x = value;
    } else if(key == y) {
      THIS->rect.y = value;
    } else if(key == w) {
      THIS->rect.w = value;
    } else if(key == h) {
      THIS->rect.h = value;
    } else { 
      Pike_error("Trying to set invalid value.\n");
    }
    do { INT_TYPE ret_=(value); pop_n_elems(2); push_int(ret_); return; }while(0);/* Return what we got in */
  }
    
  }
#define f_Rect_cq__backtick_5B_5D_defined
void f_Rect_cq__backtick_5B_5D(INT32 args) {
#line 365 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 365 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`[]",args,1);
#line 365 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`[]",1,"string");
#line 365 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 365 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    f_Rect_cq__backtick_2D_3E(args);
  }

  }
#define f_Rect_cq__backtick_5B_5D_eq_defined
void f_Rect_cq__backtick_5B_5D_eq(INT32 args) {
#line 369 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 369 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE value;
#line 369 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 2) wrong_number_of_args_error("`[]=",args,2);
#line 369 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`[]=",1,"string");
#line 369 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-2].u.string);
#line 369 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`[]=",2,"int");
value=Pike_sp[1-2].u.integer;
#line 369 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    f_Rect_cq__backtick_2D_3E_eq(args);
  }
  
  }
#define f_Rect_cast_defined
void f_Rect_cast(INT32 args) {
#line 373 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * type;
#line 373 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("cast",args,1);
#line 373 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("cast",1,"string");
#line 373 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(type=Pike_sp[0-1].u.string);
{
    struct pike_string *array_t;
    struct pike_string *mapping_t;
    MAKE_CONSTANT_SHARED_STRING( array_t, "array" ); 
    MAKE_CONSTANT_SHARED_STRING( mapping_t, "mapping" ); 

    if( type == array_t )
    {
      pop_n_elems( args );
      push_int(THIS->rect.x);
      push_int(THIS->rect.y);
      push_int(THIS->rect.w); 
      push_int(THIS->rect.h);
      f_aggregate(4);
      return;
    } else if( type == mapping_t ) {
      pop_n_elems( args );
      push_text("x");
      push_int(THIS->rect.x);
      push_text("y");
      push_int(THIS->rect.y);
      push_text("w");
      push_int(THIS->rect.w);
      push_text("h");
      push_int(THIS->rect.h);
      f_aggregate_mapping(8);
      return;
    }

    Pike_error("Cannot cast to %s\n", type->str );
  }
}

#ifdef Rect_event_handler_defined
static void Rect_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Rect_defined
  case PROG_EVENT_INIT: init_Rect_struct(); break;

#endif /* internal_init_Rect_defined */
  default: break; 
  }
}

#endif /* Rect_event_handler_defined */
/*! @endclass Rect */

/*! @class Keysym
 *! The Keysym class is used to report key presses and releases. It's
 *! available from the @[SDL.Event] class for keyboard events.
 *! 
 *! The scancode field should generally be left alone - it is the
 *! hardware dependent scancode returned by the keyboard. The sym
 *! field is extremely useful. It is the SDL-defined value of the key. 
 *! This field is very useful when you are checking for certain key presses.
 *! 
 *! mod stores the current state of the keyboard modifiers as
 *! explained in @[SDL.get_mod_state()]. The unicode field is only used
 *! when UNICODE translation is enabled with @[SDL.enable_unicode()]. If
 *! unicode is non-zero then this a the UNICODE character
 *! corresponding to the keypress. If the high 9 bits of the character
 *! are 0, then this maps to the equivalent ASCII character.
 *! 
 *! @note
 *!   UNICODE translation does have a slight overhead so don't
 *!   enable it unless its needed.
 *! 
 *! @decl int scancode
 *!  Hardware specific scancode
 *! @decl int sym
 *!  SDL virtual keysym
 *! @decl int mod
 *!  Current key modifiers
 *! @decl int unicode
 *!  Translated character
 */


#undef class_Keysym_defined
#define class_Keysym_defined
struct program *Keysym_program=0;

#undef var_keysym_Keysym_defined
#define var_keysym_Keysym_defined

#undef THIS
#define THIS ((struct Keysym_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_KEYSYM
#define THIS_KEYSYM ((struct Keysym_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_KEYSYM
#define OBJ2_KEYSYM(o) ((struct Keysym_struct *)(o->storage+Keysym_storage_offset))

#undef GET_KEYSYM_STORAGE
#define GET_KEYSYM_STORAGE ((struct Keysym_struct *)(o->storage+Keysym_storage_offset)
static ptrdiff_t Keysym_storage_offset;
struct Keysym_struct {

#ifdef var_keysym_Keysym_defined
#line 439 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
SDL_keysym keysym;
#endif /* var_keysym_Keysym_defined */
};
#define f_Keysym_cq__backtick_2D_3E_defined
void f_Keysym_cq__backtick_2D_3E(INT32 args) {
#line 441 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 441 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`->",args,1);
#line 441 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`->",1,"string");
#line 441 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 441 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{                              
    struct pike_string *mod;
    struct pike_string *scancode;
    struct pike_string *sym;
    struct pike_string *unicode;
    MAKE_CONSTANT_SHARED_STRING(mod, "mod");
    MAKE_CONSTANT_SHARED_STRING(scancode, "scancode");
    MAKE_CONSTANT_SHARED_STRING(sym, "sym");
    MAKE_CONSTANT_SHARED_STRING(unicode, "unicode");
    if(key == mod) {
      pop_stack(); push_int(THIS->keysym.mod);
    } else if(key == scancode) {
      pop_stack(); push_int(THIS->keysym.scancode);
    } else if(key == sym) {
      pop_stack(); push_int(THIS->keysym.sym);
    } else if(key == unicode) {
      pop_stack(); push_int(THIS->keysym.unicode);
    } else {
      OBJ_INDEX();
    }
  }
  }
#define f_Keysym_cq__backtick_5B_5D_defined
void f_Keysym_cq__backtick_5B_5D(INT32 args) {
#line 462 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 462 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`[]",args,1);
#line 462 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`[]",1,"string");
#line 462 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 462 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    f_Keysym_cq__backtick_2D_3E(args);
  }
}
/*! @endclass Keysym */  

#line 469 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
#define CHECK_INIT() if(THIS->fmt == NULL) { Pike_error("PixelFormat unitialized!\n"); }

/*! @class PixelFormat
 *! This describes the format of the pixel data stored at the pixels field
 *! of a @[SDL.Surface]. Every surface stores a PixelFormat in the format
 *! field.
 *! @decl int bits_per_pixel
 *!   The number of bits used to represent each pixel in a
 *!   surface. Usually 8, 16, 24 or 32.
 *! @decl int bytes_per_pixel
 *!   The number of bytes used to represent each pixel in a
 *!   surface. Usually one to four.
 *! @decl int rmask
 *! @decl int gmask
 *! @decl int bmask
 *! @decl int amask
 *!  Binary mask used to retrieve individual color values.
 *! @decl int rloss
 *! @decl int gloss
 *! @decl int bloss
 *! @decl int aloss
 *!  Precision loss of each color component.
 *! @decl int rshift
 *! @decl int gshift
 *! @decl int bshift
 *! @decl int ashift
 *!  Binary left shift of each color component in the pixel value.
 *! @decl int colorkey
 *!  Pixel value of transparent pixels.
 *! @decl int alpha
 *!  Overall surface alpha value.
 */


#undef class_PixelFormat_defined
#define class_PixelFormat_defined
struct program *PixelFormat_program=0;
#line 503 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
/* THIS->fmt is never freed by ys since the it's always a pointer to that
     of a Surface class */
  
#undef var_fmt_PixelFormat_defined
#define var_fmt_PixelFormat_defined

#undef THIS
#define THIS ((struct PixelFormat_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_PIXELFORMAT
#define THIS_PIXELFORMAT ((struct PixelFormat_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_PIXELFORMAT
#define OBJ2_PIXELFORMAT(o) ((struct PixelFormat_struct *)(o->storage+PixelFormat_storage_offset))

#undef GET_PIXELFORMAT_STORAGE
#define GET_PIXELFORMAT_STORAGE ((struct PixelFormat_struct *)(o->storage+PixelFormat_storage_offset)
static ptrdiff_t PixelFormat_storage_offset;
struct PixelFormat_struct {

#ifdef var_fmt_PixelFormat_defined
#line 505 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
SDL_PixelFormat *fmt;
#endif /* var_fmt_PixelFormat_defined */
};

#undef internal_init_PixelFormat_defined
#define internal_init_PixelFormat_defined

#undef PixelFormat_event_handler_defined
#define PixelFormat_event_handler_defined
static void init_PixelFormat_struct(void)
#line 507 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    THIS->fmt = NULL; 
  }
  /* FIXME: SDL_Palette *palette; */
  #define f_PixelFormat_cq__backtick_2D_3E_defined
void f_PixelFormat_cq__backtick_2D_3E(INT32 args) {
#line 511 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 511 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`->",args,1);
#line 511 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`->",1,"string");
#line 511 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 511 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    struct pike_string *aloss;
    struct pike_string *alpha;
    struct pike_string *amask;
    struct pike_string *ashift;
    struct pike_string *bits_per_pixel;
    struct pike_string *bloss;
    struct pike_string *bmask;
    struct pike_string *bshift;
    struct pike_string *bytes_per_pixel;
    struct pike_string *colorkey;
    struct pike_string *gloss;
    struct pike_string *gmask;
    struct pike_string *gshift;
    struct pike_string *rloss;
    struct pike_string *rmask;
    struct pike_string *rshift;
    CHECK_INIT(); /* Make sure this is inited */
    MAKE_CONSTANT_SHARED_STRING(aloss, "aloss");
    MAKE_CONSTANT_SHARED_STRING(alpha, "alpha");
    MAKE_CONSTANT_SHARED_STRING(amask, "amask");
    MAKE_CONSTANT_SHARED_STRING(ashift, "ashift");
    MAKE_CONSTANT_SHARED_STRING(bits_per_pixel, "bits_per_pixel");
    MAKE_CONSTANT_SHARED_STRING(bloss, "bloss");
    MAKE_CONSTANT_SHARED_STRING(bmask, "bmask");
    MAKE_CONSTANT_SHARED_STRING(bshift, "bshift");
    MAKE_CONSTANT_SHARED_STRING(bytes_per_pixel, "bytes_per_pixel");
    MAKE_CONSTANT_SHARED_STRING(colorkey, "colorkey");
    MAKE_CONSTANT_SHARED_STRING(gloss, "gloss");
    MAKE_CONSTANT_SHARED_STRING(gmask, "gmask");
    MAKE_CONSTANT_SHARED_STRING(gshift, "gshift");
    MAKE_CONSTANT_SHARED_STRING(rloss, "rloss");
    MAKE_CONSTANT_SHARED_STRING(rmask, "rmask");
    MAKE_CONSTANT_SHARED_STRING(rshift, "rshift");
    if(key == aloss) {
      pop_stack(); push_int(THIS->fmt->Aloss);
    } else if(key == alpha) {
      pop_stack(); push_int(THIS->fmt->alpha);
    } else if(key == amask) {
      pop_stack(); push_int(THIS->fmt->Amask);
    } else if(key == ashift) {
      pop_stack(); push_int(THIS->fmt->Ashift);
    } else if(key == bits_per_pixel) {
      pop_stack(); push_int(THIS->fmt->BitsPerPixel);
    } else if(key == bloss) {
      pop_stack(); push_int(THIS->fmt->Bloss);
    } else if(key == bmask) {
      pop_stack(); push_int(THIS->fmt->Bmask);
    } else if(key == bshift) {
      pop_stack(); push_int(THIS->fmt->Bshift);
    } else if(key == bytes_per_pixel) {
      pop_stack(); push_int(THIS->fmt->BytesPerPixel);
    } else if(key == colorkey) {
      pop_stack(); push_int(THIS->fmt->colorkey);
    } else if(key == gloss) {
      pop_stack(); push_int(THIS->fmt->Gloss);
    } else if(key == gmask) {
      pop_stack(); push_int(THIS->fmt->Gmask);
    } else if(key == gshift) {
      pop_stack(); push_int(THIS->fmt->Gshift);
    } else if(key == rloss) {
      pop_stack(); push_int(THIS->fmt->Rloss);
    } else if(key == rmask) {
      pop_stack(); push_int(THIS->fmt->Rmask);
    } else if(key == rshift) {
      pop_stack(); push_int(THIS->fmt->Rshift);
    } else {
      OBJ_INDEX();
    }
  }

  }
#define f_PixelFormat_cq__backtick_5B_5D_defined
void f_PixelFormat_cq__backtick_5B_5D(INT32 args) {
#line 582 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 582 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`[]",args,1);
#line 582 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`[]",1,"string");
#line 582 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 582 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    f_PixelFormat_cq__backtick_2D_3E(args);
  }

  }
/*! @decl array(int) losses()
   *!  Convenience method returning the RGBA precision loss as an array.
   */
  #define f_PixelFormat_losses_defined
void f_PixelFormat_losses(INT32 args) {
#line 589 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("losses",args,0);
#line 589 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    push_int(THIS->fmt->Rloss);
    push_int(THIS->fmt->Gloss);
    push_int(THIS->fmt->Bloss);
    push_int(THIS->fmt->Aloss);
    f_aggregate(4);
  }

  }
/*! @decl array(int) masks()
   *!  Convenience method returning the RGBA masks as an array.
   */
  #define f_PixelFormat_masks_defined
void f_PixelFormat_masks(INT32 args) {
#line 600 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("masks",args,0);
#line 600 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    push_int(THIS->fmt->Rmask);
    push_int(THIS->fmt->Gmask);
    push_int(THIS->fmt->Bmask);
    push_int(THIS->fmt->Amask);
    f_aggregate(4);
  }

  }
/*! @decl array(int) shifts()
   *!  Convenience method returning the RGBA shifts as an array.
   */
  #define f_PixelFormat_shifts_defined
void f_PixelFormat_shifts(INT32 args) {
#line 611 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("shifts",args,0);
#line 611 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    push_int(THIS->fmt->Rshift);
    push_int(THIS->fmt->Gshift);
    push_int(THIS->fmt->Bshift);
    push_int(THIS->fmt->Ashift);
    f_aggregate(4);
  }
  
  }
/*! @decl int map_rgb(int r, int g, int b)
   *! @decl int map_rgb(Image.Color.Color color)
   *! 
   *! Maps the RGB color value to the specified pixel format and
   *! returns the pixel value as an integer.
   *!
   *! If the format has a palette (8-bit) the index of the closest
   *! matching color in the palette will be returned.
   *!
   *! If the pixel format has an alpha component it will be
   *! returned as all 1 bits (fully opaque).
   *!
   *! @param r
   *! @param g
   *! @param b
   *! 
   *! The red, green and blue components specified as an integer
   *! between 0 and 255.
   *!
   *! @param color
   *! The color as represented by an @[Image.Color.Color] object.
   *! @returns
   *! A pixel value best approximating the given RGB color value for a
   *! given pixel format.
   *!
   *! @seealso
   *!   @[map_rgba()], @[get_rgb()], @[get_rgba()]
   */
  #define f_PixelFormat_map_rgb_1_defined
void f_PixelFormat_map_rgb_1(INT32 args) {
#line 647 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE r;
#line 647 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE g;
#line 647 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE b;
#line 647 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 3) wrong_number_of_args_error("map_rgb",args,3);
#line 647 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-3].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("map_rgb",1,"int");
r=Pike_sp[0-3].u.integer;
#line 647 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-3].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("map_rgb",2,"int");
g=Pike_sp[1-3].u.integer;
#line 647 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[2-3].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("map_rgb",3,"int");
b=Pike_sp[2-3].u.integer;
#line 647 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(SDL_MapRGB(THIS->fmt, r, g, b)); pop_n_elems(3); push_int(ret_); return; }while(0);
#line 649 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
#define f_PixelFormat_map_rgb_2_defined
void f_PixelFormat_map_rgb_2(INT32 args) {
#line 651 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct object * color;
#line 651 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("map_rgb",args,1);
#line 651 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("map_rgb",1,"object");
#line 651 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(color=Pike_sp[0-1].u.object);
#line 651 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    struct color_struct *cs;
    CHECK_CLASS(color, image_color, 1);
    cs = ((struct color_struct *)(color->storage));
    do { INT_TYPE ret_=(SDL_MapRGB(THIS->fmt, cs->rgb.r, cs->rgb.g, cs->rgb.b)); pop_stack(); push_int(ret_); return; }while(0);
#line 656 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }

#if defined(f_PixelFormat_map_rgb_1_defined) || defined(f_PixelFormat_map_rgb_2_defined)
#define f_PixelFormat_map_rgb_defined
void f_PixelFormat_map_rgb(INT32 args) {
  if(args < 1) wrong_number_of_args_error("map_rgb",args,1);
  switch(Pike_sp[0-args].type) {
   case PIKE_T_OBJECT:

#ifdef f_PixelFormat_map_rgb_2_defined
    f_PixelFormat_map_rgb_2(args);
    return;

#endif /* f_PixelFormat_map_rgb_2_defined */
    break;
   case PIKE_T_INT:

#ifdef f_PixelFormat_map_rgb_1_defined
    f_PixelFormat_map_rgb_1(args);
    return;

#endif /* f_PixelFormat_map_rgb_1_defined */
    break;
   default:
    SIMPLE_BAD_ARG_ERROR("map_rgb",1,"object|int");
  }
}

#endif /* f_PixelFormat_map_rgb_1_defined, f_PixelFormat_map_rgb_2_defined */
/*! @decl int map_rgba(int r, int g, int b, int a)
   *! @decl int map_rgba(Image.Color.Color color, int a)
   *!
   *! Maps the RGBA color value to the specified pixel format and
   *! returns the pixel value as an integer.
   *!
   *! If the format has a palette (8-bit) the index of the closest
   *! matching color in the palette will be returned.
   *!
   *! If the pixel format has an alpha component it will be
   *! returned as all 1 bits (fully opaque).
   *!
   *! @param r
   *! @param g
   *! @param b
   *! @param a
   *! 
   *! The red, green and blue components specified as an integer
   *! between 0 and 255.
   *!
   *! @param color
   *! The color as represented by an @[Image.Color.Color] object.
   *! 
   *! @returns
   *! A pixel value best approximating the given RGB color value for a
   *! given pixel format. 
   *! 
   *! @seealso
   *!   @[map_rgb()], @[get_rgb()], @[get_rgba()]
   */
  #define f_PixelFormat_map_rgba_1_defined
void f_PixelFormat_map_rgba_1(INT32 args) {
#line 688 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE r;
#line 688 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE g;
#line 688 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE b;
#line 688 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE a;
#line 688 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 4) wrong_number_of_args_error("map_rgba",args,4);
#line 688 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("map_rgba",1,"int");
r=Pike_sp[0-4].u.integer;
#line 688 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("map_rgba",2,"int");
g=Pike_sp[1-4].u.integer;
#line 688 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[2-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("map_rgba",3,"int");
b=Pike_sp[2-4].u.integer;
#line 688 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[3-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("map_rgba",4,"int");
a=Pike_sp[3-4].u.integer;
#line 688 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(SDL_MapRGBA(THIS->fmt, r, g, b, a)); pop_n_elems(4); push_int(ret_); return; }while(0);
#line 690 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
#define f_PixelFormat_map_rgba_2_defined
void f_PixelFormat_map_rgba_2(INT32 args) {
#line 692 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct object * color;
#line 692 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE a;
#line 692 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 2) wrong_number_of_args_error("map_rgba",args,2);
#line 692 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-2].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("map_rgba",1,"object");
#line 692 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(color=Pike_sp[0-2].u.object);
#line 692 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("map_rgba",2,"int");
a=Pike_sp[1-2].u.integer;
#line 692 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    struct color_struct *cs;
    CHECK_CLASS(color, image_color, 1);
    cs = ((struct color_struct *)(color->storage));
    do { INT_TYPE ret_=(SDL_MapRGBA(THIS->fmt, cs->rgb.r, cs->rgb.g, cs->rgb.b, a)); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 697 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }

#if defined(f_PixelFormat_map_rgba_1_defined) || defined(f_PixelFormat_map_rgba_2_defined)
#define f_PixelFormat_map_rgba_defined
void f_PixelFormat_map_rgba(INT32 args) {
  if(args < 1) wrong_number_of_args_error("map_rgba",args,2);
  switch(Pike_sp[0-args].type) {
   case PIKE_T_OBJECT:

#ifdef f_PixelFormat_map_rgba_2_defined
    f_PixelFormat_map_rgba_2(args);
    return;

#endif /* f_PixelFormat_map_rgba_2_defined */
    break;
   case PIKE_T_INT:

#ifdef f_PixelFormat_map_rgba_1_defined
    f_PixelFormat_map_rgba_1(args);
    return;

#endif /* f_PixelFormat_map_rgba_1_defined */
    break;
   default:
    SIMPLE_BAD_ARG_ERROR("map_rgba",1,"object|int");
  }
}

#endif /* f_PixelFormat_map_rgba_1_defined, f_PixelFormat_map_rgba_2_defined */
/*! @decl Image.Color.Color get_rgb(int pixel)
   *! 
   *! Get RGB component values from a pixel stored in this pixel format.
   *!
   *! @param pixel
   *!   A pixel retrieved from a surface with this pixel format or a color
   *!   previously mapped with @[map_rgb()] or @[map_rgba()].
   *! @returns
   *!  A @[Image.Color.Color] object with the RGB components of the pixel.
   *! 
   *! @seealso
   *!   @[map_rgb()], @[map_rgba()], @[get_rgba()]
   */
  #define f_PixelFormat_get_rgb_defined
void f_PixelFormat_get_rgb(INT32 args) {
#line 712 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE pixel;
#line 712 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("get_rgb",args,1);
#line 712 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("get_rgb",1,"int");
pixel=Pike_sp[0-1].u.integer;
#line 712 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    Uint8 r, g, b;
    SDL_GetRGB((Uint32)pixel, THIS->fmt, &r, &g, &b);
    do { struct object * ret_=(image_make_rgb_color(r, g, b)); pop_stack(); push_object(ret_); return; }while(0);
#line 716 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
/*! @decl mapping(string:Image.Color.Color|int) get_rgba(int pixel)
   *! 
   *! Get RGB component values from a pixel stored in this pixel format.
   *!
   *! @param pixel
   *!   A pixel retrieved from a surface with this pixel format or a color
   *!   previously mapped with @[map_rgb()] or @[map_rgba()].
   *! @returns
   *!  A mapping containing with the RGBA components of the pixel as described below.
   *! @mapping
   *!   @member Image.Color.Color color
   *!     The RGB color value of the pixel.
   *!   @member int alpha
   *!     The alpha value of the pixel in the range 0-255.
   *! @endmapping
   *! @seealso
   *!   @[map_rgb()], @[map_rgba()], @[get_rgb()]
   */
  #define f_PixelFormat_get_rgba_defined
void f_PixelFormat_get_rgba(INT32 args) {
#line 736 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE pixel;
#line 736 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("get_rgba",args,1);
#line 736 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("get_rgba",1,"int");
pixel=Pike_sp[0-1].u.integer;
#line 736 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    Uint8 r, g, b, a;
    SDL_GetRGBA((Uint32)pixel, THIS->fmt, &r, &g, &b, &a);
    pop_n_elems(args);
    push_text("color");
    push_object(image_make_rgb_color(r, g, b));
    push_text("alpha");
    push_int(a);
    f_aggregate_mapping(4);
  }  
}

#ifdef PixelFormat_event_handler_defined
static void PixelFormat_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_PixelFormat_defined
  case PROG_EVENT_INIT: init_PixelFormat_struct(); break;

#endif /* internal_init_PixelFormat_defined */
  default: break; 
  }
}

#endif /* PixelFormat_event_handler_defined */
/*! @endclass PixelFormat */
#line 748 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
#undef CHECK_INIT


#define CHECK_INIT() if(THIS->vidinfo == NULL) { Pike_error("VideoInfo unitialized!\n"); }

/*! @class VideoInfo
 *! This (read-only) class is returned by @[SDL.get_video_info()]. It
 *! contains information on either the 'best' available mode (if
 *! called before @[SDL.set_video_mode()]) or the current video mode.
 *!
 #! @decl int hw_available
 #!   Is it possible to create hardware surfaces?
 #! @decl int wm_available
 #!   Is there a window manager available
 #! @decl int blit_hw
 #!   Are hardware to hardware blits accelerated?
 *! @decl int blit_hw_cc
 *!   Are hardware to hardware colorkey blits accelerated?
 *! @decl int blit_hw_a
 *!   Are hardware to hardware alpha blits accelerated?
 *! @decl int blit_sw
 *!   Are software to hardware blits accelerated?
 *! @decl int blit_sw_cc
 *!   Are software to hardware colorkey blits accelerated?
 *! @decl int blit_sw_a
 *!   Are software to hardware alpha blits accelerated?
 *! @decl int blit_fill
 *!   Are color fills accelerated?
 *! @decl int video_mem
 *!   Total amount of video memory in KB.
 *! @decl SDL.PixelFormat format
 *!   Pixel format of the video device.
 */

#undef class_VideoInfo_defined
#define class_VideoInfo_defined
struct program *VideoInfo_program=0;
#line 782 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
/* THIS->vidinfo is never freed by us since SDL manages that */
  
#undef var_vidinfo_VideoInfo_defined
#define var_vidinfo_VideoInfo_defined

#undef THIS
#define THIS ((struct VideoInfo_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_VIDEOINFO
#define THIS_VIDEOINFO ((struct VideoInfo_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_VIDEOINFO
#define OBJ2_VIDEOINFO(o) ((struct VideoInfo_struct *)(o->storage+VideoInfo_storage_offset))

#undef GET_VIDEOINFO_STORAGE
#define GET_VIDEOINFO_STORAGE ((struct VideoInfo_struct *)(o->storage+VideoInfo_storage_offset)
static ptrdiff_t VideoInfo_storage_offset;
struct VideoInfo_struct {

#ifdef var_vidinfo_VideoInfo_defined
#line 783 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
const SDL_VideoInfo *vidinfo;
#endif /* var_vidinfo_VideoInfo_defined */
};

#undef internal_init_VideoInfo_defined
#define internal_init_VideoInfo_defined

#undef VideoInfo_event_handler_defined
#define VideoInfo_event_handler_defined
static void init_VideoInfo_struct(void)
#line 785 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    THIS->vidinfo = NULL; 
  }
  #define f_VideoInfo_cq__backtick_2D_3E_defined
void f_VideoInfo_cq__backtick_2D_3E(INT32 args) {
#line 788 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 788 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`->",args,1);
#line 788 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`->",1,"string");
#line 788 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 788 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    struct pike_string *blit_fill;
    struct pike_string *blit_hw;
    struct pike_string *blit_hw_a;
    struct pike_string *blit_hw_cc;
    struct pike_string *blit_sw;
    struct pike_string *blit_sw_a;
    struct pike_string *blit_sw_cc;
    struct pike_string *hw_available;
    struct pike_string *video_mem;
    struct pike_string *wm_available;
    struct pike_string *vfmt;
    CHECK_INIT(); /* Make sure this is inited */
    MAKE_CONSTANT_SHARED_STRING(blit_fill, "blit_fill");
    MAKE_CONSTANT_SHARED_STRING(blit_hw, "blit_hw");
    MAKE_CONSTANT_SHARED_STRING(blit_hw_a, "blit_hw_a");
    MAKE_CONSTANT_SHARED_STRING(blit_hw_cc, "blit_hw_cc");
    MAKE_CONSTANT_SHARED_STRING(blit_sw, "blit_sw");
    MAKE_CONSTANT_SHARED_STRING(blit_sw_a, "blit_sw_a");
    MAKE_CONSTANT_SHARED_STRING(blit_sw_cc, "blit_sw_cc");
    MAKE_CONSTANT_SHARED_STRING(hw_available, "hw_available");
    MAKE_CONSTANT_SHARED_STRING(video_mem, "video_mem");
    MAKE_CONSTANT_SHARED_STRING(wm_available, "wm_available");
    MAKE_CONSTANT_SHARED_STRING(vfmt, "format");
    if(key == blit_fill) {
      pop_stack(); push_int(THIS->vidinfo->blit_fill);
    } else if(key == blit_hw) {
      pop_stack(); push_int(THIS->vidinfo->blit_hw);
    } else if(key == blit_hw_a) {
      pop_stack(); push_int(THIS->vidinfo->blit_hw_A);
    } else if(key == blit_hw_cc) {
      pop_stack(); push_int(THIS->vidinfo->blit_hw_CC);
    } else if(key == blit_sw) {
      pop_stack(); push_int(THIS->vidinfo->blit_sw);
    } else if(key == blit_sw_a) {
      pop_stack(); push_int(THIS->vidinfo->blit_sw_A);
    } else if(key == blit_sw_cc) {
      pop_stack(); push_int(THIS->vidinfo->blit_sw_CC);
    } else if(key == hw_available) {
      pop_stack(); push_int(THIS->vidinfo->hw_available);
    } else if(key == video_mem) {
      pop_stack(); push_int(THIS->vidinfo->video_mem);
    } else if(key == wm_available) {
      pop_stack(); push_int(THIS->vidinfo->wm_available);
    }  else if(key == vfmt) {
      struct object *fmt;
      CHECK_INIT();
      fmt = clone_object( PixelFormat_program, 0 );
      OBJ2_PIXELFORMAT(fmt)->fmt = THIS->vidinfo->vfmt;
      push_object(fmt);
    } else {
      OBJ_INDEX();
    }
  }
  }
#define f_VideoInfo_cq__backtick_5B_5D_defined
void f_VideoInfo_cq__backtick_5B_5D(INT32 args) {
#line 842 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 842 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`[]",args,1);
#line 842 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`[]",1,"string");
#line 842 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 842 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    f_VideoInfo_cq__backtick_2D_3E(args);
  }
}

#ifdef VideoInfo_event_handler_defined
static void VideoInfo_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_VideoInfo_defined
  case PROG_EVENT_INIT: init_VideoInfo_struct(); break;

#endif /* internal_init_VideoInfo_defined */
  default: break; 
  }
}

#endif /* VideoInfo_event_handler_defined */
/*! @endclass VideoInfo */
#line 847 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
#undef CHECK_INIT

#define CHECK_INIT() if(THIS->_s == NULL) { Pike_error("Surface unitialized!\n"); }
/*! @class Surface
 *!
 *! Surface's represent areas of "graphical" memory, memory that can
 *! be drawn to.  The video framebuffer is returned as a
 *! @[SDL.Surface] by @[SDL.set_video_mode()] and
 *! @[SDL.get_video_surface()].

 *! @decl int w
 *! @decl int h
 *!   The width and height of the surface in pixels.
 *! @decl SDL.Rect clip_rect
 *!  This is the clipping rectangle as set by @[set_clip_rect()].
 *! @decl int flags
 *!   The following are supported in the flags field.
 *!   @dl
 *!     @item SDL.SWSURFACE
 *!       Surface is stored in system memory
 *!     @item SDL.HWSURFACE
 *!       Surface is stored in video memory
 *!     @item SDL.ASYNCBLIT
 *!       Surface uses asynchronous blits if possible.
 *!     @item SDL.ANYFORMAT
 *!       Allows any pixel-format (Display  surface).
 *!     @item SDL.HWPALETTE
 *!       Surface has exclusive palette.
 *!     @item SDL.DOUBLEBUF
 *!       Surface is double buffered (Display surface).
 *!     @item SDL.FULLSCREEN
 *!       Surface is full screen (Display  Sur face).
 *!     @item SDL.OPENGL
 *!       Surface has an OpenGL context (Display Surface).
 *!     @item SDL.OPENGLBLIT
 *!       Surface supports OpenGL blitting (Display Surface).
 *!     @item SDL.RESIZABLE
 *!       Surface is resizable (Display Surface).
 *!     @item SDL.HWACCEL
 *!       Surface blit uses hardware acceleration.
 *!     @item SDL.SRCCOLORKEY
 *!       Surface use colorkey blitting.
 *!     @item SDL.RLEACCEL
 *!       Colorkey  blitting is accelerated with RLE.
 *!     @item SDL.SRCALPHA
 *!       Surface blit uses alpha blending.
 *!     @item SDL.PREALLOC
 *!       Surface uses preallocated memory.
 *!   @enddl
 *! 
 *! @decl SDL.PixelFormat format
 *!   The pixel format of this surface.
 */

#undef class_Surface_defined
#define class_Surface_defined
struct program *Surface_program=0;

#undef var_cq__s_Surface_defined
#define var_cq__s_Surface_defined

#undef var_void_Surface_defined
#define var_void_Surface_defined

#undef THIS
#define THIS ((struct Surface_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_SURFACE
#define THIS_SURFACE ((struct Surface_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_SURFACE
#define OBJ2_SURFACE(o) ((struct Surface_struct *)(o->storage+Surface_storage_offset))

#undef GET_SURFACE_STORAGE
#define GET_SURFACE_STORAGE ((struct Surface_struct *)(o->storage+Surface_storage_offset)
static ptrdiff_t Surface_storage_offset;
struct Surface_struct {

#ifdef var_cq__s_Surface_defined
#line 901 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
SDL_Surface *_s;
#endif /* var_cq__s_Surface_defined */

#ifdef var_void_Surface_defined
#line 902 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
void (*fast_set_pixel)(Uint16 x, Uint16 y, Uint32 pixel);
#endif /* var_void_Surface_defined */
};
static void fast_set_pixel1(Uint16 x, Uint16 y, Uint32 pixel) {
    SDL_Surface *screen = THIS->_s;
    *((Uint8 *)screen->pixels + y * screen->pitch + x) = pixel;
  }
  static void fast_set_pixel2(Uint16 x, Uint16 y, Uint32 pixel) {
    SDL_Surface *screen = THIS->_s;
    *((Uint16 *)screen->pixels +  y * (screen->pitch>>1) + x) = pixel;
  }
  static void fast_set_pixel3(Uint16 x, Uint16 y, Uint32 pixel) { 
    SDL_Surface *screen = THIS->_s;
    Uint8 *pix = (Uint8 *)screen->pixels + y * screen->pitch + x * 3; 
    if(SDL_BYTEORDER == SDL_BIG_ENDIAN) { 
      pix[2] = pixel & 0xff; 
      pix[1] = (pixel >> 8) & 0xff; 
      pix[0] = (pixel >> 16) & 0xff; 
    } else { 
      pix[0] = pixel; 
      pix[1] = (pixel >> 8) & 0xff; 
      pix[2] = (pixel >> 16) & 0xff; 
    } 
  } 
  static void fast_set_pixel4(Uint16 x, Uint16 y, Uint32 pixel) {
    SDL_Surface *screen = THIS->_s;
    *((Uint32 *)screen->pixels + y * (screen->pitch>>2) + x) = pixel;
  }
  static void (*get_fast_set_pixel(int bpp))(Uint16 x, Uint16 y, Uint32 pixel) {
    switch(bpp) {
    case 1: return &fast_set_pixel1; 
    case 2: return &fast_set_pixel2; 
    case 3: return &fast_set_pixel3; 
    case 4: return &fast_set_pixel4; 
    }
    return NULL;
  }
  /*! @decl int get_pixel(int x, int y)
   *! Get the value of the specified pixel. The surface needs to be
   *! locked before this method can be used.
   *! @param x
   *! @param y
   *!  Pixel coordinate to get.
   *! @returns
   *!   The value of the specified pixel.
   *! @seealso
   *!  @[set_pixel()], @[unlock()], @[lock()]
   */
  #define f_Surface_get_pixel_defined
void f_Surface_get_pixel(INT32 args) {
#line 950 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE x;
#line 950 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE y;
#line 950 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 2) wrong_number_of_args_error("get_pixel",args,2);
#line 950 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("get_pixel",1,"int");
x=Pike_sp[0-2].u.integer;
#line 950 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("get_pixel",2,"int");
y=Pike_sp[1-2].u.integer;
#line 951 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    if(THIS->fast_set_pixel) {
      SDL_Surface *surface = THIS->_s;
      int bpp = surface->format->BytesPerPixel;
      Uint8 *p;
      if(x < 0 || y < 0 || x > surface->w || y > surface->h) {
	Pike_error("Pixel out of bounds!\n");
      }
      p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;
      
      switch(bpp) {
      case 1:  do { INT_TYPE ret_=(*p); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 964 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
case 2:  do { INT_TYPE ret_=(*(Uint16 *)p); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 965 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
case 3:
	if(SDL_BYTEORDER == SDL_BIG_ENDIAN) {
	  do { INT_TYPE ret_=(p[0] << 16 | p[1] << 8 | p[2]); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 968 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
} else {
	  do { INT_TYPE ret_=(p[0] | p[1] << 8 | p[2] << 16); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 970 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}
      case 4:  do { INT_TYPE ret_=(*(Uint32 *)p); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 972 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
default: do { INT_TYPE ret_=(0); pop_n_elems(2); push_int(ret_); return; }while(0);/* shouldn't happen, but avoids warnings */
      }
    } else {
      Pike_error("Surface must be locked before you can set or get pixels.\n");
    }      
  }

  }
/*! @decl int set_pixel(int x, int y, int pixel)
   *! Set the value of the specified pixel. The surface needs to be
   *! locked before this method can be used.
   *! @param x
   *! @param y
   *!  Pixel coordinate to modify.
   *! @param pixel
   *!  Pixel value to set to the specified pixel.
   *! @returns
   *!   A reference to the surface itself.
   *! @seealso
   *!  @[get_pixel()], @[unlock()], @[lock()]
   */
  #define f_Surface_set_pixel_defined
void f_Surface_set_pixel(INT32 args) {
#line 992 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE x;
#line 992 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE y;
#line 992 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE pixel;
#line 992 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 3) wrong_number_of_args_error("set_pixel",args,3);
#line 992 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-3].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_pixel",1,"int");
x=Pike_sp[0-3].u.integer;
#line 992 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-3].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_pixel",2,"int");
y=Pike_sp[1-3].u.integer;
#line 992 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[2-3].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_pixel",3,"int");
pixel=Pike_sp[2-3].u.integer;
#line 992 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    if(THIS->fast_set_pixel) {
      if(x < 0 || y < 0 || x > THIS->_s->w || y > THIS->_s->h) {
	Pike_error("Pixel out of bounds!\n");
      }
      THIS->fast_set_pixel(x, y, pixel);
      RET_THIS();
    }
    Pike_error("Surface must be locked before you can set or get pixels.\n");
  }

  }

#undef internal_init_Surface_defined
#define internal_init_Surface_defined

#undef Surface_event_handler_defined
#define Surface_event_handler_defined
static void init_Surface_struct(void)
#line 1004 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    THIS->_s = NULL;
    THIS->fast_set_pixel = NULL;
  }
  
  
#undef internal_exit_Surface_defined
#define internal_exit_Surface_defined

#undef Surface_event_handler_defined
#define Surface_event_handler_defined
static void exit_Surface_struct(void)
#line 1009 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    if(THIS->_s) {
      SDL_FreeSurface(THIS->_s);
      THIS->_s = NULL;
    }
    THIS->fast_set_pixel = NULL;
  }

  /* Query methods (struct vars) */
  #define f_Surface_cq__backtick_2D_3E_defined
void f_Surface_cq__backtick_2D_3E(INT32 args) {
#line 1018 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 1018 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`->",args,1);
#line 1018 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`->",1,"string");
#line 1018 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 1018 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{                      
    struct pike_string *flags;
    struct pike_string *h;
/*  struct pike_string *pitch;*/
    struct pike_string *w;
    struct pike_string *clip_rect;
    struct pike_string *format;
    struct pike_string *init;
    struct pike_string *set_image;
    MAKE_CONSTANT_SHARED_STRING(flags, "flags");
    MAKE_CONSTANT_SHARED_STRING(h, "h");
/*    MAKE_CONSTANT_SHARED_STRING(pitch, "pitch");*/
    MAKE_CONSTANT_SHARED_STRING(w, "w");
    MAKE_CONSTANT_SHARED_STRING(clip_rect, "clip_rect");
    MAKE_CONSTANT_SHARED_STRING(format, "format");
    MAKE_CONSTANT_SHARED_STRING(init, "init");
    MAKE_CONSTANT_SHARED_STRING(set_image, "set_image");

    if(key == init || key == set_image) {
      /* These actually (re)initialize the module and do not */
      /* a previously initialized module.  */
      OBJ_INDEX();
      return;
    }
    CHECK_INIT(); /* Make sure this is inited */
    if(key == flags) {
      pop_stack(); push_int(THIS->_s->flags);
    } else if(key == h) {
      pop_stack(); push_int(THIS->_s->h);
/*    } else if(key == pitch) {
      pop_stack(); push_int(THIS->_s->pitch); */
    } else if(key == w) {
      pop_stack(); push_int(THIS->_s->w);
    } else if(key == clip_rect) {
      struct object *rect;
      rect = clone_object( Rect_program, 0 );
      OBJ2_RECT(rect)->rect = THIS->_s->clip_rect;
      pop_stack(); push_object(rect);
    } else if(key == format) {
      struct object *fmt;
      fmt = clone_object( PixelFormat_program, 0 );
      OBJ2_PIXELFORMAT(fmt)->fmt = THIS->_s->format;
      pop_stack(); push_object(fmt);
    } else {
      OBJ_INDEX();
    }
  }
  }
#define f_Surface_cq__backtick_5B_5D_defined
void f_Surface_cq__backtick_5B_5D(INT32 args) {
#line 1065 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 1065 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`[]",args,1);
#line 1065 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`[]",1,"string");
#line 1065 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 1065 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    f_Surface_cq__backtick_2D_3E( args );
  }
  
  }
/*! @decl int lock()
   *! This methods locks the surface to allow direct access to the pixels using the
   *! @[get_pixel()] and @[set_pixel()] methods. Note that although all surfaces in SDL don't require
   *! locking, you still need to call this method to enable the set/get pixel
   *! methods. You should unlock the surface when you're doing modifying it.
   *!
   *! @note
   *!   Calling this method multiple times means that you need to call
   *!   unlock an equal number of times for the surface to become unlocked.
   *! @returns
   *!   1 for success or 0 if the surface couldn't be locked.
   *! @seealso
   *!  @[unlock()], @[set_pixel()], @[get_pixel()]
   */
  #define f_Surface_lock_defined
void f_Surface_lock(INT32 args) {
#line 1083 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("lock",args,0);
#line 1083 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    int locked = 1;
    CHECK_INIT();
    if ( SDL_MUSTLOCK(THIS->_s) ) {
      locked = SDL_LockSurface(THIS->_s) != -1;
    }
    if(locked) {
      THIS->fast_set_pixel = get_fast_set_pixel(THIS->_s->format->BytesPerPixel);
    }
    do { INT_TYPE ret_=(locked);  push_int(ret_); return; }while(0);
#line 1093 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}
  
  }
/*! @decl void unlock()
   *! Surfaces that were previously locked using @[lock()] must be
   *! unlocked with @[unlock()].  Surfaces should be unlocked as soon
   *! as possible.
   *! @seealso
   *!  @[lock()]
   */
  #define f_Surface_unlock_defined
void f_Surface_unlock(INT32 args) {
#line 1102 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("unlock",args,0);
#line 1102 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    THIS->fast_set_pixel = NULL;
    if ( SDL_MUSTLOCK(THIS->_s) ) {
      SDL_UnlockSurface(THIS->_s);
    }
  }

  }
/*! @decl SDL.Surface init(int flags, int width, int height, int depth, @
   *!                        int Rmask, int Gmask, int Bmask, int Amask)
   *! This (re)initializes this surface using the specified
   *! parameters.  Any previously allocated data will be freed. 
   *! If @b{depth@} is 8 bits an empty palette is allocated for the surface,
   *! otherwise a 'packed-pixel' @[SDL.PixelFormat] is created using
   *! the @b{[RGBA]mask@}'s provided. @b{width@} and @b{height@} specifies
   *! the desired size of the image. The @b{flags@} specifies the type of
   *! surface that should be created. It is an OR'd combination of the
   *! following possible values:
   *! 
   *! @dl
   *!   @item SDL.SWSURFACE
   *!     SDL will create the surface in system memory. This improves
   *!     the performance of pixel level access, however you may not
   *!     be able to take advantage of some types of hardware
   *!     blitting.
   *!
   *!   @item SDL.HWSURFACE
   *!     SDL will attempt to create the surface in video memory. This
   *!     will allow SDL to take advantage of Video->Video blits
   *!     (which are often accelerated).
   *!
   *!   @item SDL.SRCCOLORKEY
   *!     
   *!     This flag turns on colourkeying for blits from this
   *!     surface. If SDL.HWSURFACE is also specified and colourkeyed
   *!     blits are hardware-accelerated, then SDL will attempt to
   *!     place the surface in video memory. Use @[set_color_key()] to
   *!     set or clear this flag after surface creation.
   *!
   *!   @item SDL.SRCALPHA
   *!     This flag turns on alpha-blending for blits from this
   *!     surface. If SDL.HWSURFACE is also specified and alpha
   *!     blending blits are hardware-accelerated, then the surface
   *!     will be placed in video memory if possible.  Use
   *!     @[set_alpha()] to set or clear this flag after surface
   *!     creation.
   *! @enddl
   *! 
   *! @note
   *!   If an alpha-channel is specified (that is, if Amask is
   *!   nonzero), then the SDL.SRCALPHA flag is automatically set. You
   *!   may remove this flag by calling @[set_alpha()] after surface
   *!   creation.
   *! @returns
   *!  A reference to itself.
   *! @note
   *!  If this method fails, the surface will become uninitialized.
   *! @seealso
   *!  @[set_image()]
   */
  #define f_Surface_init_defined
void f_Surface_init(INT32 args) {
#line 1162 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE flags;
#line 1162 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE width;
#line 1162 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE height;
#line 1162 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE depth;
INT_TYPE Rmask;
#line 1163 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE Gmask;
#line 1163 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE Bmask;
#line 1163 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE Amask;
#line 1162 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 8) wrong_number_of_args_error("init",args,8);
#line 1162 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-8].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("init",1,"int");
flags=Pike_sp[0-8].u.integer;
#line 1162 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-8].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("init",2,"int");
width=Pike_sp[1-8].u.integer;
#line 1162 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[2-8].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("init",3,"int");
height=Pike_sp[2-8].u.integer;
#line 1162 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[3-8].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("init",4,"int");
depth=Pike_sp[3-8].u.integer;
#line 1163 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[4-8].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("init",5,"int");
Rmask=Pike_sp[4-8].u.integer;
#line 1163 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[5-8].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("init",6,"int");
Gmask=Pike_sp[5-8].u.integer;
#line 1163 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[6-8].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("init",7,"int");
Bmask=Pike_sp[6-8].u.integer;
#line 1163 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[7-8].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("init",8,"int");
Amask=Pike_sp[7-8].u.integer;
#line 1163 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    if(THIS->_s) {
      SDL_FreeSurface(THIS->_s);
    }
    THIS->_s = SDL_CreateRGBSurface(flags, width, height, depth, 
				    Rmask, Gmask, Bmask, Amask);
    if(THIS->_s == NULL) {
      Pike_error("Failed to create SDL surface: %s\n", SDL_GetError());
    } else {
      RET_THIS();
    }
  }

  }
/*!  @decl SDL.Surface set_image(Image.Image image, int|void flags)
   *!  @decl SDL.Surface set_image(Image.Image image, Image.Image alpha, int|void flags) 
   *! This (re)initializes this surface from the @[Image.Image] in
   *! @b{image@}. Any previously allocated data will be freed.
   *! If initialization is successful, this surface will use RGBA8888
   *! format. For good blitting performance, it should be converted to
   *! the display format using @[display_format()].
   *! 
   *! @param image
   *!  The source image.
   *! @param alpha
   *!   Optional alpha channel. In Pike, the alpha channel can have
   *!   different alpha values for red, green and blue. Since SDL
   *!   doesn't support this, only the alpha value of the red color is
   *!   used in the conversion. When this calling convention is used,
   *!   the surface alpha value of @b{image@} is ignored.
   *! @param flags
   *! 
   *! When present this specifies the type of surface that should be
   *! created. It is an OR'd combination of the following possible
   *! values:
   *! 
   *! @dl
   *!   @item SDL.SWSURFACE
   *!     SDL will create the surface in system memory. This improves
   *!     the performance of pixel level access, however you may not
   *!     be able to take advantage of some types of hardware
   *!     blitting.
   *!
   *!   @item SDL.HWSURFACE
   *!     SDL will attempt to create the surface in video memory. This
   *!     will allow SDL to take advantage of Video->Video blits
   *!     (which are often accelerated).
   *!
   *!   @item SDL.SRCCOLORKEY
   *!     
   *!     This flag turns on colourkeying for blits from this
   *!     surface. If SDL.HWSURFACE is also specified and colourkeyed
   *!     blits are hardware-accelerated, then SDL will attempt to
   *!     place the surface in video memory. Use @[set_color_key()] to
   *!     set or clear this flag after surface creation.
   *!
   *!   @item SDL.SRCALPHA
   *!     This flag turns on alpha-blending for blits from this
   *!     surface. If SDL.HWSURFACE is also specified and alpha
   *!     blending blits are hardware-accelerated, then the surface
   *!     will be placed in video memory if possible. Note that if
   *!     this surface has an alpha value specified, this flag is
   *!     enabled automatically. Use @[set_alpha()] to modify this
   *!     flag at a later point.
   *! @enddl
   *! @note
   *!  If this method fails, the surface will become uninitialized.
   *! @returns
   *!  A reference to itself.
   *! @seealso
   *!  @[init()]
   */
  #define f_Surface_set_image_1_defined
void f_Surface_set_image_1(INT32 args) {
#line 1234 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct object * image;
#line 1234 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct svalue * _flags;
#line 1234 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args < 1) wrong_number_of_args_error("set_image_1",args,1);
#line 1234 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args > 2) wrong_number_of_args_error("set_image_1",args,2);
#line 1234 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-args].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("set_image",1,"object");
#line 1234 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(image=Pike_sp[0-args].u.object);
if(args > 1) { 
#line 1234 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
_flags=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
}else{
_flags=0;
}
#line 1234 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    int flags = 0;
    int x, y;
    struct image *i;
    Uint32 *dest;
    rgb_group rgb;
    if(THIS->_s != NULL) {
      SDL_FreeSurface(THIS->_s);
    }
    /*    if(image_program != NULL) { */
    CHECK_CLASS(image, image, 1);
    /*    } */
    if(_flags) {
      if(_flags->type != PIKE_T_INT) {
	SIMPLE_BAD_ARG_ERROR("set_image",2,"int|void");
      }
      flags = _flags->u.integer;
    }
    i = ((struct image *)(image->storage));
    if(i->alpha) {
      flags &= SDL_SRCALPHA;
    }
    THIS->_s =
      SDL_CreateRGBSurface(flags, i->xsize, i->ysize, 32,
			   0xff000000, 0x00ff0000, 0x0000ff00,  0x000000ff);
    if(!THIS->_s) {
      Pike_error("Failed to create SDL surface: %s\n", SDL_GetError());
    }
    SDL_LockSurface(THIS->_s);
    dest = THIS->_s->pixels;

#define pixel(_img,x,y) ((_img)->img[((int)(x))+((int)(y))*(int)(_img)->xsize])
    for(y = 0; y < i->ysize; y++) {
      int off = y*THIS->_s->pitch/4;
      for(x = 0; x < i->xsize; x++) {
	rgb = pixel(i, x, y);
	*((Uint32 *)dest + off + x) = 
	  (rgb.r << 24) + (rgb.g << 16) + (rgb.b << 8) + (255 - i->alpha);
      }
    }
#undef pixel
    SDL_UnlockSurface(THIS->_s);
    RET_THIS();
  }

  }
#define f_Surface_set_image_2_defined
void f_Surface_set_image_2(INT32 args) {
#line 1279 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct object * image;
#line 1279 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct object * alpha;
#line 1279 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct svalue * _flags;
#line 1279 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args < 2) wrong_number_of_args_error("set_image_2",args,2);
#line 1279 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args > 3) wrong_number_of_args_error("set_image_2",args,3);
#line 1279 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-args].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("set_image",1,"object");
#line 1279 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(image=Pike_sp[0-args].u.object);
#line 1279 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-args].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("set_image",2,"object");
#line 1279 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(alpha=Pike_sp[1-args].u.object);
if(args > 2) { 
#line 1279 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
_flags=Pike_sp+2-args; dmalloc_touch_svalue(Pike_sp+2-args);
}else{
_flags=0;
}
#line 1279 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    int flags = 0;
    int x, y;
    struct image *i, *a;
    Uint32 *dest;
    rgb_group rgb, argb;
    if(THIS->_s != NULL) {
      SDL_FreeSurface(THIS->_s);
    }

    CHECK_CLASS(image, image, 1);
    CHECK_CLASS(alpha, image, 2);

    if(_flags) {
      if(_flags->type != PIKE_T_INT) {
	SIMPLE_BAD_ARG_ERROR("set_image",3,"int|void");
      }
      flags = _flags->u.integer;
    }
    i = ((struct image *)(image->storage));
    a = ((struct image *)(alpha->storage));
    
    THIS->_s =
      SDL_CreateRGBSurface(flags, i->xsize, i->ysize, 32,
			   0xff000000, 0x00ff0000, 0x0000ff00,  0x000000ff);
    if(!THIS->_s) {
      Pike_error("Failed to create SDL surface: %s\n", SDL_GetError());
    }
    SDL_LockSurface(THIS->_s);
    dest = THIS->_s->pixels;

#define pixel(_img,x,y) ((_img)->img[((int)(x))+((int)(y))*(int)(_img)->xsize])
    for(y = 0; y < i->ysize; y++) {
      int off = y*THIS->_s->pitch/4;
      for(x = 0; x < i->xsize; x++) {
	rgb = pixel(i, x, y);
	argb = pixel(a, x, y);
	*((Uint32 *)dest + off + x) = 
	  (rgb.r << 24) + (rgb.g << 16) + (rgb.b << 8) + (255 - argb.r);
      }
    }
#undef pixel
    SDL_UnlockSurface(THIS->_s);
    RET_THIS();
  }

  }

#if defined(f_Surface_set_image_1_defined) || defined(f_Surface_set_image_2_defined)
#define f_Surface_set_image_defined
void f_Surface_set_image(INT32 args) {
  switch(args) {
   case 1:

#ifdef f_Surface_set_image_1_defined
    f_Surface_set_image_1(args);
    return;

#endif /* f_Surface_set_image_1_defined */
    break;
   case 2:

#ifdef f_Surface_set_image_2_defined
    f_Surface_set_image_2(args);
    return;

#endif /* f_Surface_set_image_2_defined */
    break;
   default:
    wrong_number_of_args_error("set_image",args,1);
  }
}

#endif /* f_Surface_set_image_1_defined, f_Surface_set_image_2_defined */
/*! @decl SDL.Surface display_format()
   *!
   *! This function takes a surface and copies it to a new  surface
   *! of  the  pixel format and colors of the video framebuffer,
   *! suitable for fast blitting onto the  display  surface. It calls
   *! @[convert_surface()]. 
   *! 
   *! If you want to take advantage of hardware colorkey or alpha blit
   *! acceleration, you should set the colorkey and / or alpha value
   *! before calling this function.
   *! 
   *! If you want an alpha channel, see @[display_format_alpha()].
   *!
   *! @returns
   *!   The new surface. An error is thrown if the conversion fails.
   */
  #define f_Surface_display_format_defined
void f_Surface_display_format(INT32 args) {
#line 1341 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("display_format",args,0);
#line 1341 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    SDL_Surface *tmp;
    CHECK_INIT();
    tmp = SDL_DisplayFormat(THIS->_s);
    if(tmp) {
      struct object *new_surface = clone_object( Surface_program, 0 );
      OBJ2_SURFACE(new_surface)->_s = tmp;
      do { struct object * ret_=(new_surface);  push_object(ret_); return; }while(0);
#line 1349 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
} else {
      Pike_error("Failed to create SDL surface: %s\n", SDL_GetError());
    }      
  }

  }
/*! @decl SDL.Surface display_format_alpha()
   *!
   *! This function takes a surface and copies it to a new  surface
   *! of  the  pixel format and colors of the video framebuffer,
   *! suitable for fast blitting onto the  display  surface. It calls
   *! @[convert_surface()]. 
   *! 
   *! If you want to take advantage of hardware colorkey or alpha blit
   *! acceleration, you should set the colorkey and / or alpha value
   *! before calling this function.
   *! 
   *! This function can be used to convert a colourkey to an alpha
   *! channel, if the SDL.SRCCOLORKEY flag is set on the surface. The
   *! generated surface will then be transparent (alpha=0) where the
   *! pixels match the colourkey, and opaque (alpha=255) elsewhere.
   *!
   *! @returns
   *!   The new surface. An error is thrown if the conversion fails.
   */
   #define f_Surface_display_format_alpha_defined
void f_Surface_display_format_alpha(INT32 args) {
#line 1373 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("display_format_alpha",args,0);
#line 1373 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    SDL_Surface *tmp;
    CHECK_INIT();
    tmp = SDL_DisplayFormatAlpha(THIS->_s);
    if(tmp) {
      struct object *new_surface = clone_object( Surface_program, 0 );
      OBJ2_SURFACE(new_surface)->_s = tmp;
      do { struct object * ret_=(new_surface);  push_object(ret_); return; }while(0);
#line 1381 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
} else {
      Pike_error("Failed to create SDL surface: %s\n", SDL_GetError());
    }
  }

  }
#define f_Surface_blit_defined
void f_Surface_blit(INT32 args) {
#line 1386 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct object * dst;
#line 1386 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct svalue * _srcrect;
#line 1386 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct svalue * _dstrect;
#line 1386 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args < 1) wrong_number_of_args_error("blit",args,1);
#line 1386 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args > 3) wrong_number_of_args_error("blit",args,3);
#line 1386 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-args].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("blit",1,"object");
#line 1386 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(dst=Pike_sp[0-args].u.object);
if(args > 1) { 
#line 1386 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
_srcrect=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
}else{
_srcrect=0;
}if(args > 2) { 
#line 1386 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
_dstrect=Pike_sp+2-args; dmalloc_touch_svalue(Pike_sp+2-args);
}else{
_dstrect=0;
}
#line 1386 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    SDL_Rect *srcrect = NULL, *dstrect = NULL;
    CHECK_CLASS(dst, Surface, 1);
    if(_srcrect) {
      if( _srcrect->type != PIKE_T_OBJECT ) {
	SIMPLE_BAD_ARG_ERROR("blit_surface",2,"SDL.Rect|zero");
      }
      CHECK_CLASS(_srcrect->u.object, Rect, 2);
      srcrect = &(OBJ2_RECT(_srcrect->u.object)->rect);
    }
    if(_dstrect) {
      if( _dstrect->type != PIKE_T_OBJECT ) {
	SIMPLE_BAD_ARG_ERROR("blit_surface",3,"SDL.Rect|void");
      }
      CHECK_CLASS(_dstrect->u.object, Rect, 3);
      dstrect = &(OBJ2_RECT(_dstrect->u.object)->rect);
    }
    
    SDL_BlitSurface(THIS->_s, srcrect,
		    OBJ2_SURFACE(dst)->_s, dstrect);
    RET_THIS();
  }

  }
#define f_Surface_fill_rect_defined
void f_Surface_fill_rect(INT32 args) {
#line 1409 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE color;
#line 1409 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct object * dstrect;
#line 1409 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 2) wrong_number_of_args_error("fill_rect",args,2);
#line 1409 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("fill_rect",1,"int");
color=Pike_sp[0-2].u.integer;
#line 1409 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-2].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("fill_rect",2,"object");
#line 1409 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(dstrect=Pike_sp[1-2].u.object);
#line 1409 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    CHECK_CLASS(dstrect, Rect, 2);
    SDL_FillRect(THIS->_s,&(OBJ2_RECT(dstrect)->rect), (Uint32)color);
    RET_THIS();
  }
  
  }
#define f_Surface_fill_defined
void f_Surface_fill(INT32 args) {
#line 1416 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE color;
#line 1416 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("fill",args,1);
#line 1416 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("fill",1,"int");
color=Pike_sp[0-1].u.integer;
#line 1416 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    SDL_FillRect(THIS->_s, NULL, (Uint32)color);
    RET_THIS();
  }

  }
#define f_Surface_set_color_key_defined
void f_Surface_set_color_key(INT32 args) {
#line 1422 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE flag;
#line 1422 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE key;
#line 1422 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 2) wrong_number_of_args_error("set_color_key",args,2);
#line 1422 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_color_key",1,"int");
flag=Pike_sp[0-2].u.integer;
#line 1422 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_color_key",2,"int");
key=Pike_sp[1-2].u.integer;
#line 1422 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    SDL_SetColorKey(THIS->_s, flag, key);
    RET_THIS();
  }

  }
#define f_Surface_set_alpha_defined
void f_Surface_set_alpha(INT32 args) {
#line 1428 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE flag;
#line 1428 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE alpha;
#line 1428 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 2) wrong_number_of_args_error("set_alpha",args,2);
#line 1428 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_alpha",1,"int");
flag=Pike_sp[0-2].u.integer;
#line 1428 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_alpha",2,"int");
alpha=Pike_sp[1-2].u.integer;
#line 1428 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    SDL_SetAlpha(THIS->_s, flag, alpha);
    RET_THIS();
  }

  }
#define f_Surface_set_clip_rect_defined
void f_Surface_set_clip_rect(INT32 args) {
#line 1434 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct object * rect;
#line 1434 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("set_clip_rect",args,1);
#line 1434 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("set_clip_rect",1,"object");
#line 1434 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(rect=Pike_sp[0-1].u.object);
#line 1434 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    CHECK_CLASS(rect, Rect, 1);
    SDL_SetClipRect(THIS->_s, &OBJ2_RECT(rect)->rect);
    RET_THIS();
  }

  }
#define f_Surface_convert_surface_defined
void f_Surface_convert_surface(INT32 args) {
#line 1441 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct object * fmt;
#line 1441 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE flags;
#line 1441 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 2) wrong_number_of_args_error("convert_surface",args,2);
#line 1441 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-2].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("convert_surface",1,"object");
#line 1441 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(fmt=Pike_sp[0-2].u.object);
#line 1441 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("convert_surface",2,"int");
flags=Pike_sp[1-2].u.integer;
#line 1441 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    struct object *new_surface;
    SDL_Surface *tmp;
    CHECK_INIT();
    CHECK_CLASS(fmt, PixelFormat, 1);
    
    tmp = SDL_ConvertSurface(THIS->_s, OBJ2_PIXELFORMAT(fmt)->fmt, flags);
    pop_n_elems(args);
    if(!tmp) {
      Pike_error("Failed to convert surface: %s\n", SDL_GetError());
    }
    new_surface = clone_object( Surface_program, 0 );
    OBJ2_SURFACE(new_surface)->_s = tmp;
    push_object(new_surface);
  }

}

#ifdef Surface_event_handler_defined
static void Surface_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Surface_defined
  case PROG_EVENT_INIT: init_Surface_struct(); break;

#endif /* internal_init_Surface_defined */

#ifdef internal_exit_Surface_defined
  case PROG_EVENT_EXIT: exit_Surface_struct(); break;

#endif /* internal_exit_Surface_defined */
  default: break; 
  }
}

#endif /* Surface_event_handler_defined */
/*! @endclass Surface */
#line 1459 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
#undef CHECK_INIT

/* SDL Video Method */

#define f_video_mode_ok_defined
void f_video_mode_ok(INT32 args) {
#line 1463 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE width;
#line 1463 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE height;
#line 1463 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE bpp;
#line 1463 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE flags;
#line 1463 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 4) wrong_number_of_args_error("video_mode_ok",args,4);
#line 1463 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("video_mode_ok",1,"int");
width=Pike_sp[0-4].u.integer;
#line 1463 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("video_mode_ok",2,"int");
height=Pike_sp[1-4].u.integer;
#line 1463 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[2-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("video_mode_ok",3,"int");
bpp=Pike_sp[2-4].u.integer;
#line 1463 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[3-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("video_mode_ok",4,"int");
flags=Pike_sp[3-4].u.integer;
#line 1463 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  do { INT_TYPE ret_=(SDL_VideoModeOK(width, height, bpp, flags)); pop_n_elems(4); push_int(ret_); return; }while(0);
#line 1465 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}


}
/*! @decl int flip(SDL.Surface|void screen)
 *! On  hardware that supports double-buffering, this function
 *! sets up a flip and returns. The  hardware  will  wait  for
 *! vertical  retrace,  and then swap video buffers before the
 *! next video surface blit or lock will return.  On  hardware
 *! that  doesn't support double-buffering, this is equivalent
 *! to calling @[SDL.update_rect(screen, 0, 0, 0, 0)]
 *! 
 *! The  SDL.DOUBLEBUF  flag  must   have   been   passed   to
 *! SDL_SetVideoMode,  when  setting  the  video mode for this
 *! function to perform hardware flipping.
 *! 
 *! @param screen
 *!  The screen object to flip. If missing, the default screen is used.
 *! @returns
 *!  This function returns 1 if successful, or 0 if there was an error.
 *! 
 *! @seealso
 *!  @[SDL.update_rect()] 
 */

#define f_flip_defined
void f_flip(INT32 args) {
#line 1489 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct svalue * screen;
#line 1489 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args > 1) wrong_number_of_args_error("flip",args,1);
if(args > 0) { 
#line 1489 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
screen=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
}else{
screen=0;
}
#line 1489 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  SDL_Surface *vs = NULL;    
  if(!screen) {
    vs = SDL_GetVideoSurface();
  } else {
    if( screen->type == PIKE_T_OBJECT ) {
      CHECK_CLASS(screen->u.object, Surface, 5);
      vs = OBJ2_SURFACE(screen->u.object)->_s;
    } else {
      SIMPLE_BAD_ARG_ERROR("SDL.flip",5,"SDL.Surface");      
    }      
  }
  do { INT_TYPE ret_=(SDL_Flip(vs) == 0); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 1502 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
#line 1504 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
/*PIKEFUN void SDL_UpdateRects(object|void screen, int numrects, array rects);*/

/*! @decl void update_rect(int x, int y, int w, int h, SDL.Surface|void screen)
 *! 
 *! Makes sure the given area is updated on the given screen.  The
 *! rectangle must be confined within the screen boundaries (no clipping
 *! is done).
 *! 
 *! If 'x', 'y', 'w' and 'h' are all 0, SDL_UpdateRect will update
 *! the entire screen.
 *! 
 *! This function should not be called while 'screen' is locked.
 *! 
 *! @param x
 *! @param y
 *!  Top left corner of the rectangle to update.
 *! @param w
 *! @param h
 *!  Width and height of the rectangle to update.
 *! @param screen
 *!  The screen object to flip. If missing, the default screen is used.
 *! @seealso
 *!  @[SDL.flip()] 
 */
#define f_update_rect_defined
void f_update_rect(INT32 args) {
#line 1528 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE x;
#line 1528 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE y;
#line 1528 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE w;
#line 1528 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE h;
#line 1528 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct svalue * screen;
#line 1528 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args < 4) wrong_number_of_args_error("update_rect",args,4);
#line 1528 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args > 5) wrong_number_of_args_error("update_rect",args,5);
#line 1528 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("update_rect",1,"int");
x=Pike_sp[0-args].u.integer;
#line 1528 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("update_rect",2,"int");
y=Pike_sp[1-args].u.integer;
#line 1528 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[2-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("update_rect",3,"int");
w=Pike_sp[2-args].u.integer;
#line 1528 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[3-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("update_rect",4,"int");
h=Pike_sp[3-args].u.integer;
if(args > 4) { 
#line 1528 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
screen=Pike_sp+4-args; dmalloc_touch_svalue(Pike_sp+4-args);
}else{
screen=0;
}
#line 1528 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  SDL_Surface *vs;
  if(!screen) {
    vs = SDL_GetVideoSurface();
  } else {
    if( screen->type == PIKE_T_OBJECT ) {
      CHECK_CLASS(screen->u.object, Surface, 5);
      vs = OBJ2_SURFACE(screen->u.object)->_s;
    } else {
      SIMPLE_BAD_ARG_ERROR("SDL.update_rect",5,"SDL.Surface");      
    }      
  }
  SDL_UpdateRect(vs, x, y, w, h);
}

}
#define f_set_gamma_defined
void f_set_gamma(INT32 args) {
#line 1543 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
FLOAT_TYPE red;
#line 1543 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
FLOAT_TYPE green;
#line 1543 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
FLOAT_TYPE blue;
#line 1543 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 3) wrong_number_of_args_error("set_gamma",args,3);
#line 1543 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-3].type != PIKE_T_FLOAT) SIMPLE_BAD_ARG_ERROR("set_gamma",1,"float");
red=Pike_sp[0-3].u.float_number;
#line 1543 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-3].type != PIKE_T_FLOAT) SIMPLE_BAD_ARG_ERROR("set_gamma",2,"float");
green=Pike_sp[1-3].u.float_number;
#line 1543 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[2-3].type != PIKE_T_FLOAT) SIMPLE_BAD_ARG_ERROR("set_gamma",3,"float");
blue=Pike_sp[2-3].u.float_number;
#line 1543 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  do { INT_TYPE ret_=(SDL_SetGamma(red, green, blue)); pop_n_elems(3); push_int(ret_); return; }while(0);
#line 1545 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
#define f_get_video_surface_defined
void f_get_video_surface(INT32 args) {
#line 1547 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("get_video_surface",args,0);
{
  SDL_Surface *screen = SDL_GetVideoSurface();
  if(screen != NULL) {
    struct object *surface = clone_object( Surface_program, 0 );
    /* to avoid freeing when the new Surface class is destroyed */
    screen->refcount ++; 
    OBJ2_SURFACE(surface)->_s = screen;
    push_object(surface);
    return;
  }
  push_int(0);
}

}
#define f_get_video_info_defined
void f_get_video_info(INT32 args) {
#line 1561 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("get_video_info",args,0);
{
  const SDL_VideoInfo *vidinfo = SDL_GetVideoInfo();
  if(vidinfo != NULL) {
    struct object *viptr = clone_object( VideoInfo_program, 0 );
    /* to avoid freeing when the new Surface class is destroyed */
    OBJ2_VIDEOINFO(viptr)->vidinfo = vidinfo;
    push_object(viptr);
    return;
  }
  push_int(0);
}

}
#define f_gl_set_attribute_defined
void f_gl_set_attribute(INT32 args) {
#line 1574 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE attribute;
#line 1574 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE value;
#line 1574 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 2) wrong_number_of_args_error("gl_set_attribute",args,2);
#line 1574 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("gl_set_attribute",1,"int");
attribute=Pike_sp[0-2].u.integer;
#line 1574 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("gl_set_attribute",2,"int");
value=Pike_sp[1-2].u.integer;
#line 1575 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  SDL_GL_SetAttribute( attribute, value );
}

}
#define f_gl_get_attribute_defined
void f_gl_get_attribute(INT32 args) {
#line 1579 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE attribute;
#line 1579 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("gl_get_attribute",args,1);
#line 1579 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("gl_get_attribute",1,"int");
attribute=Pike_sp[0-1].u.integer;
#line 1580 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  int res;
  SDL_GL_GetAttribute( attribute, &res );
  do { INT_TYPE ret_=(res); pop_stack(); push_int(ret_); return; }while(0);
#line 1584 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
#define f_show_cursor_defined
void f_show_cursor(INT32 args) {
#line 1586 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE show;
#line 1586 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("show_cursor",args,1);
#line 1586 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("show_cursor",1,"int");
show=Pike_sp[0-1].u.integer;
#line 1587 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  do { INT_TYPE ret_=(SDL_ShowCursor( show )); pop_stack(); push_int(ret_); return; }while(0);
#line 1589 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
#define f_warp_mouse_defined
void f_warp_mouse(INT32 args) {
#line 1591 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE xpos;
#line 1591 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE ypos;
#line 1591 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 2) wrong_number_of_args_error("warp_mouse",args,2);
#line 1591 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("warp_mouse",1,"int");
xpos=Pike_sp[0-2].u.integer;
#line 1591 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("warp_mouse",2,"int");
ypos=Pike_sp[1-2].u.integer;
#line 1592 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  SDL_WarpMouse( xpos, ypos );
}

}
#define f_gl_swap_buffers_defined
void f_gl_swap_buffers(INT32 args) {
#line 1596 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("gl_swap_buffers",args,0);
{
  SDL_GL_SwapBuffers( );
}

}
#define f_set_video_mode_defined
void f_set_video_mode(INT32 args) {
#line 1601 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE width;
#line 1601 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE height;
#line 1601 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE bpp;
#line 1601 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE flags;
#line 1601 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 4) wrong_number_of_args_error("set_video_mode",args,4);
#line 1601 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_video_mode",1,"int");
width=Pike_sp[0-4].u.integer;
#line 1601 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_video_mode",2,"int");
height=Pike_sp[1-4].u.integer;
#line 1601 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[2-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_video_mode",3,"int");
bpp=Pike_sp[2-4].u.integer;
#line 1601 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[3-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_video_mode",4,"int");
flags=Pike_sp[3-4].u.integer;
#line 1602 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  SDL_Surface *screen;
  if(width <= 0 || height <= 0) { /* To avoid core dump in SDL */
    SDL_SetError("Tried to open window with width and/or height smaller than 1.");
  } else { 
    SDL_Surface *screen = NULL;
    switch(bpp) { /* Switch to avoid coredump in SDL */
    case 0: case 8: case 16: case 24: case 32:  
      screen = SDL_SetVideoMode(width, height, bpp, flags);
      if(screen != NULL) {
	struct object *surface = clone_object( Surface_program, 0 );
	/* to avoid freeing when the new Surface class is destroyed, since
	 * it's a reference to the screen surface, which SDL handles.
	 */
	screen->refcount ++; 
	OBJ2_SURFACE(surface)->_s = screen;
	pop_n_elems(args);
	push_object(surface);
	return;
      }
      break;
    default:
      SDL_SetError("Invalid bpp, expected 8, 16, 24 or 32.");
    }
  }
  Pike_error("Failed to set video mode: %s\n", SDL_GetError());
}

}
#define f_blit_surface_defined
void f_blit_surface(INT32 args) {
#line 1630 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct object * src;
#line 1630 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct object * dst;
struct svalue * _srcrect;
struct svalue * _dstrect;
#line 1630 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args < 2) wrong_number_of_args_error("blit_surface",args,2);
#line 1630 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args > 4) wrong_number_of_args_error("blit_surface",args,4);
#line 1630 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-args].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("blit_surface",1,"object");
#line 1630 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(src=Pike_sp[0-args].u.object);
#line 1630 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-args].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("blit_surface",2,"object");
#line 1630 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(dst=Pike_sp[1-args].u.object);
if(args > 2) { _srcrect=Pike_sp+2-args; dmalloc_touch_svalue(Pike_sp+2-args);
}else{
_srcrect=0;
}if(args > 3) { 
#line 1632 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
_dstrect=Pike_sp+3-args; dmalloc_touch_svalue(Pike_sp+3-args);
}else{
_dstrect=0;
}
#line 1632 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  SDL_Rect *srcrect = NULL, *dstrect = NULL;
  CHECK_CLASS(src, Surface, 1);
  CHECK_CLASS(dst, Surface, 2);
  if(_srcrect) {
    if( _srcrect->type != PIKE_T_OBJECT ) {
      SIMPLE_BAD_ARG_ERROR("blit_surface",3,"SDL.Rect|zero");
    }
    CHECK_CLASS(_srcrect->u.object, Rect, 3);
    srcrect = &(OBJ2_RECT(_srcrect->u.object)->rect);
  }
  if(_dstrect) {
    if( _dstrect->type != PIKE_T_OBJECT ) {
      SIMPLE_BAD_ARG_ERROR("blit_surface",4,"SDL.Rect|void");
    }
    CHECK_CLASS(_dstrect->u.object, Rect, 4);
    dstrect = &(OBJ2_RECT(_dstrect->u.object)->rect);
  }
      
  do { INT_TYPE ret_=(SDL_BlitSurface(OBJ2_SURFACE(src)->_s, srcrect,
			 OBJ2_SURFACE(dst)->_s, dstrect)); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 1653 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
#define f_video_driver_name_defined
void f_video_driver_name(INT32 args) {
#line 1655 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("video_driver_name",args,0);
#line 1655 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  char tmp[256];
  tmp[0] = 0;
  SDL_VideoDriverName(tmp, 255);
  if(!*tmp) {
    push_int(0);
    return;
  }
  push_text(tmp);
}
  
}
#define f_set_caption_defined
void f_set_caption(INT32 args) {
#line 1666 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * title;
#line 1666 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * icon;
#line 1666 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 2) wrong_number_of_args_error("set_caption",args,2);
#line 1666 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("set_caption",1,"string");
#line 1666 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(title=Pike_sp[0-2].u.string);
#line 1666 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("set_caption",2,"string");
#line 1666 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(icon=Pike_sp[1-2].u.string);
#line 1666 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  SDL_WM_SetCaption(title->str, icon->str);
}

}
#define f_get_caption_defined
void f_get_caption(INT32 args) {
#line 1670 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("get_caption",args,0);
#line 1670 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  char *title, *icon;
  SDL_WM_GetCaption(&title, &icon);
  pop_n_elems(args);
  push_text(title == NULL ? "" : title);
  push_text(icon == NULL ? "" : icon);
  f_aggregate(2);
}

}
#define f_iconify_window_defined
void f_iconify_window(INT32 args) {
#line 1679 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("iconify_window",args,0);
#line 1679 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  do { INT_TYPE ret_=(SDL_WM_IconifyWindow());  push_int(ret_); return; }while(0);
#line 1681 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
#define f_toggle_fullscreen_defined
void f_toggle_fullscreen(INT32 args) {
#line 1683 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct svalue * screen;
#line 1683 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args > 1) wrong_number_of_args_error("toggle_fullscreen",args,1);
if(args > 0) { 
#line 1683 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
screen=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
}else{
screen=0;
}
#line 1683 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  SDL_Surface *vs = 0;
  if(!screen) {
    vs = SDL_GetVideoSurface();
  } else {
    if( screen->type == PIKE_T_OBJECT ) {
      CHECK_CLASS(screen->u.object, Surface, 1);
      vs = OBJ2_SURFACE(screen->u.object)->_s;
    }
  }
  if(!vs) { do { INT_TYPE ret_=(-1); pop_n_elems(args); push_int(ret_); return; }while(0);}
  do { INT_TYPE ret_=(SDL_WM_ToggleFullScreen(vs)); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 1695 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
#define f_grab_input_defined
void f_grab_input(INT32 args) {
#line 1697 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE mode;
#line 1697 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("grab_input",args,1);
#line 1697 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("grab_input",1,"int");
mode=Pike_sp[0-1].u.integer;
#line 1697 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  do { INT_TYPE ret_=(SDL_WM_GrabInput(mode)); pop_stack(); push_int(ret_); return; }while(0);
#line 1699 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
#line 1701 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
/* Joystick related functionality */

#define CHECK_INIT() if(THIS->joystick == NULL) { Pike_error("Joystick uninitialized!\n"); }

#undef class_Joystick_defined
#define class_Joystick_defined
struct program *Joystick_program=0;

#undef var_joystick_Joystick_defined
#define var_joystick_Joystick_defined

#undef THIS
#define THIS ((struct Joystick_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_JOYSTICK
#define THIS_JOYSTICK ((struct Joystick_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_JOYSTICK
#define OBJ2_JOYSTICK(o) ((struct Joystick_struct *)(o->storage+Joystick_storage_offset))

#undef GET_JOYSTICK_STORAGE
#define GET_JOYSTICK_STORAGE ((struct Joystick_struct *)(o->storage+Joystick_storage_offset)
static ptrdiff_t Joystick_storage_offset;
struct Joystick_struct {

#ifdef var_joystick_Joystick_defined
#line 1705 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
SDL_Joystick *joystick;
#endif /* var_joystick_Joystick_defined */
};

#undef internal_init_Joystick_defined
#define internal_init_Joystick_defined

#undef Joystick_event_handler_defined
#define Joystick_event_handler_defined
static void init_Joystick_struct(void)
#line 1706 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    THIS->joystick = NULL;
  }

  
#undef internal_exit_Joystick_defined
#define internal_exit_Joystick_defined

#undef Joystick_event_handler_defined
#define Joystick_event_handler_defined
static void exit_Joystick_struct(void)
#line 1710 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    if(THIS->joystick != NULL) {
      SDL_JoystickClose(THIS->joystick);
      THIS->joystick = NULL;
    }
  }
  
  #define f_Joystick_create_defined
void f_Joystick_create(INT32 args) {
#line 1717 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE device_index;
#line 1717 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("create",args,1);
#line 1717 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",1,"int");
device_index=Pike_sp[0-1].u.integer;
#line 1717 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    THIS->joystick = SDL_JoystickOpen(device_index);
    if(!THIS->joystick) {
      Pike_error("Failed to open joystick %d: %s\n", device_index,
		 SDL_GetError());
    }
  }

  }
#define f_Joystick_index_defined
void f_Joystick_index(INT32 args) {
#line 1725 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("index",args,0);
#line 1725 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    do { INT_TYPE ret_=(SDL_JoystickIndex(THIS->joystick));  push_int(ret_); return; }while(0);
#line 1728 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}
  
  }
#define f_Joystick_num_axes_defined
void f_Joystick_num_axes(INT32 args) {
#line 1730 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("num_axes",args,0);
#line 1730 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    do { INT_TYPE ret_=(SDL_JoystickNumAxes(THIS->joystick));  push_int(ret_); return; }while(0);
#line 1733 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
#define f_Joystick_num_balls_defined
void f_Joystick_num_balls(INT32 args) {
#line 1735 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("num_balls",args,0);
#line 1735 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    do { INT_TYPE ret_=(SDL_JoystickNumBalls(THIS->joystick));  push_int(ret_); return; }while(0);
#line 1738 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
#define f_Joystick_num_hats_defined
void f_Joystick_num_hats(INT32 args) {
#line 1740 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("num_hats",args,0);
#line 1740 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    do { INT_TYPE ret_=(SDL_JoystickNumHats(THIS->joystick));  push_int(ret_); return; }while(0);
#line 1743 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
#define f_Joystick_num_buttons_defined
void f_Joystick_num_buttons(INT32 args) {
#line 1745 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("num_buttons",args,0);
#line 1745 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    do { INT_TYPE ret_=(SDL_JoystickNumButtons(THIS->joystick));  push_int(ret_); return; }while(0);
#line 1748 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
#define f_Joystick_get_axis_defined
void f_Joystick_get_axis(INT32 args) {
#line 1750 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE axis;
#line 1750 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("get_axis",args,1);
#line 1750 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("get_axis",1,"int");
axis=Pike_sp[0-1].u.integer;
#line 1750 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    int axis_value;
    CHECK_INIT();
    axis_value = SDL_JoystickGetAxis(THIS->joystick, axis);
    do { FLOAT_TYPE ret_=((FLOAT_TYPE)axis_value / (FLOAT_TYPE)32768); pop_stack(); push_float(ret_); return; }while(0);
#line 1755 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}
  
  }
#define f_Joystick_get_hat_defined
void f_Joystick_get_hat(INT32 args) {
#line 1757 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE hat;
#line 1757 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("get_hat",args,1);
#line 1757 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("get_hat",1,"int");
hat=Pike_sp[0-1].u.integer;
#line 1757 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    do { INT_TYPE ret_=(SDL_JoystickGetHat(THIS->joystick, hat)); pop_stack(); push_int(ret_); return; }while(0);
#line 1760 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}
  
  }
#define f_Joystick_get_ball_defined
void f_Joystick_get_ball(INT32 args) {
#line 1762 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE ball;
#line 1762 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("get_ball",args,1);
#line 1762 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("get_ball",1,"int");
ball=Pike_sp[0-1].u.integer;
#line 1762 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    int dx, dy;
    CHECK_INIT();
    SDL_JoystickGetBall(THIS->joystick, ball, &dx, &dy);
    pop_n_elems(args);
    push_int(dx);
    push_int(dy);
    f_aggregate(2);
  }

  }
#define f_Joystick_get_button_defined
void f_Joystick_get_button(INT32 args) {
#line 1772 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE button;
#line 1772 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("get_button",args,1);
#line 1772 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("get_button",1,"int");
button=Pike_sp[0-1].u.integer;
#line 1772 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    CHECK_INIT();
    do { INT_TYPE ret_=(SDL_JoystickGetButton(THIS->joystick, button)); pop_stack(); push_int(ret_); return; }while(0);
#line 1775 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
#define f_Joystick_name_defined
void f_Joystick_name(INT32 args) {
#line 1777 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("name",args,0);
#line 1777 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    const char *name;
    CHECK_INIT();
    name = SDL_JoystickName(SDL_JoystickIndex(THIS->joystick));
    pop_n_elems(args);
    if(name == NULL) {
      push_int(0);
    } else {
      push_text(name);
    }
  }
}

#ifdef Joystick_event_handler_defined
static void Joystick_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Joystick_defined
  case PROG_EVENT_INIT: init_Joystick_struct(); break;

#endif /* internal_init_Joystick_defined */

#ifdef internal_exit_Joystick_defined
  case PROG_EVENT_EXIT: exit_Joystick_struct(); break;

#endif /* internal_exit_Joystick_defined */
  default: break; 
  }
}

#endif /* Joystick_event_handler_defined */
#line 1789 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
#undef CHECK_INIT

#define f_num_joysticks_defined
void f_num_joysticks(INT32 args) {
#line 1791 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("num_joysticks",args,0);
#line 1791 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  do { INT_TYPE ret_=(SDL_NumJoysticks());  push_int(ret_); return; }while(0);
#line 1793 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
#define f_joystick_name_defined
void f_joystick_name(INT32 args) {
#line 1795 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE device_index;
#line 1795 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("joystick_name",args,1);
#line 1795 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("joystick_name",1,"int");
device_index=Pike_sp[0-1].u.integer;
#line 1795 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  const char *name = SDL_JoystickName(device_index);
  pop_n_elems(args);
  if(name == NULL) {
    push_int(0);
  } else {
    push_text(name);
  }
}

}
#define f_joystick_opened_defined
void f_joystick_opened(INT32 args) {
#line 1805 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE device_index;
#line 1805 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("joystick_opened",args,1);
#line 1805 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("joystick_opened",1,"int");
device_index=Pike_sp[0-1].u.integer;
#line 1805 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  do { INT_TYPE ret_=(SDL_JoystickOpened(device_index)); pop_stack(); push_int(ret_); return; }while(0);
#line 1807 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
#define f_joystick_update_defined
void f_joystick_update(INT32 args) {
#line 1809 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("joystick_update",args,0);
#line 1809 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  SDL_JoystickUpdate();
}

}
#define f_joystick_event_state_defined
void f_joystick_event_state(INT32 args) {
#line 1813 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE state;
#line 1813 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("joystick_event_state",args,1);
#line 1813 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("joystick_event_state",1,"int");
state=Pike_sp[0-1].u.integer;
#line 1813 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  do { INT_TYPE ret_=(SDL_JoystickEventState(state)); pop_stack(); push_int(ret_); return; }while(0);
#line 1815 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
#line 1817 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
/* CD Related methods */


#undef class_CDTrack_defined
#define class_CDTrack_defined
struct program *CDTrack_program=0;

#undef var_track_CDTrack_defined
#define var_track_CDTrack_defined

#undef THIS
#define THIS ((struct CDTrack_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_CDTRACK
#define THIS_CDTRACK ((struct CDTrack_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_CDTRACK
#define OBJ2_CDTRACK(o) ((struct CDTrack_struct *)(o->storage+CDTrack_storage_offset))

#undef GET_CDTRACK_STORAGE
#define GET_CDTRACK_STORAGE ((struct CDTrack_struct *)(o->storage+CDTrack_storage_offset)
static ptrdiff_t CDTrack_storage_offset;
struct CDTrack_struct {

#ifdef var_track_CDTrack_defined
#line 1820 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
SDL_CDtrack track;
#endif /* var_track_CDTrack_defined */
};

#undef internal_init_CDTrack_defined
#define internal_init_CDTrack_defined

#undef CDTrack_event_handler_defined
#define CDTrack_event_handler_defined
static void init_CDTrack_struct(void)
#line 1821 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    THIS->track.id     = 0;
    THIS->track.type   = 0;
    THIS->track.length = 0;
    THIS->track.offset = 0;
  }
  #define f_CDTrack_cq__backtick_2D_3E_defined
void f_CDTrack_cq__backtick_2D_3E(INT32 args) {
#line 1827 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 1827 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`->",args,1);
#line 1827 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`->",1,"string");
#line 1827 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 1827 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    struct pike_string *id;
    struct pike_string *length;
    struct pike_string *offset;
    struct pike_string *type;
    MAKE_CONSTANT_SHARED_STRING(id, "id");
    MAKE_CONSTANT_SHARED_STRING(length, "length");
    MAKE_CONSTANT_SHARED_STRING(offset, "offset");
    MAKE_CONSTANT_SHARED_STRING(type, "type");
    if(key == id) {
      pop_stack(); push_int(THIS->track.id);
    } else if(key == length) {
      pop_stack(); push_int(THIS->track.length);
    } else if(key == offset) {
      pop_stack(); push_int(THIS->track.offset);
    } else if(key == type) {
      pop_stack(); push_int(THIS->track.type);
    } else {
      OBJ_INDEX();
    }
  }
  }
#define f_CDTrack_cq__backtick_5B_5D_defined
void f_CDTrack_cq__backtick_5B_5D(INT32 args) {
#line 1848 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 1848 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`[]",args,1);
#line 1848 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`[]",1,"string");
#line 1848 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 1848 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    f_CDTrack_cq__backtick_2D_3E(args);
  }

}

#ifdef CDTrack_event_handler_defined
static void CDTrack_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_CDTrack_defined
  case PROG_EVENT_INIT: init_CDTrack_struct(); break;

#endif /* internal_init_CDTrack_defined */
  default: break; 
  }
}

#endif /* CDTrack_event_handler_defined */
#line 1854 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
#define CHECK_INIT() if(THIS->cd == NULL) { Pike_error("CD unitialized!\n"); }

#undef class_CD_defined
#define class_CD_defined
struct program *CD_program=0;

#undef var_cd_CD_defined
#define var_cd_CD_defined

#undef THIS
#define THIS ((struct CD_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_CD
#define THIS_CD ((struct CD_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_CD
#define OBJ2_CD(o) ((struct CD_struct *)(o->storage+CD_storage_offset))

#undef GET_CD_STORAGE
#define GET_CD_STORAGE ((struct CD_struct *)(o->storage+CD_storage_offset)
static ptrdiff_t CD_storage_offset;
struct CD_struct {

#ifdef var_cd_CD_defined
#line 1856 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
SDL_CD *cd;
#endif /* var_cd_CD_defined */
};

#undef internal_init_CD_defined
#define internal_init_CD_defined

#undef CD_event_handler_defined
#define CD_event_handler_defined
static void init_CD_struct(void)
#line 1857 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    THIS->cd = NULL;
  }
  
#undef internal_exit_CD_defined
#define internal_exit_CD_defined

#undef CD_event_handler_defined
#define CD_event_handler_defined
static void exit_CD_struct(void)
#line 1860 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    if(THIS->cd) {
      SDL_CDClose(THIS->cd);
      THIS->cd = NULL;
    };
  }
  
  #define f_CD_create_defined
void f_CD_create(INT32 args) {
#line 1867 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE drive;
#line 1867 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("create",args,1);
#line 1867 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",1,"int");
drive=Pike_sp[0-1].u.integer;
#line 1867 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    THIS->cd = SDL_CDOpen(drive);
    if(!THIS->cd) {
      Pike_error("Failed to open CD %d: %s\n", drive, SDL_GetError());
    }
  }
  
  
  }
#define f_CD_cq__backtick_2D_3E_defined
void f_CD_cq__backtick_2D_3E(INT32 args) {
#line 1875 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 1875 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`->",args,1);
#line 1875 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`->",1,"string");
#line 1875 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 1875 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    struct pike_string *current_frame;
    struct pike_string *current_track;
    struct pike_string *id;
    struct pike_string *numtracks;
    CHECK_INIT(); /* Make sure this is inited */
    MAKE_CONSTANT_SHARED_STRING(current_frame, "current_frame");
    MAKE_CONSTANT_SHARED_STRING(current_track, "current_track");
    MAKE_CONSTANT_SHARED_STRING(id, "id");
    MAKE_CONSTANT_SHARED_STRING(numtracks, "numtracks");
    if(key == current_frame) {
      pop_stack(); push_int(THIS->cd->cur_frame);
    } else if(key == current_track) {
      pop_stack(); push_int(THIS->cd->cur_track);
    } else if(key == id) {
      pop_stack(); push_int(THIS->cd->id);
    } else if(key == numtracks) {
      pop_stack(); push_int(THIS->cd->numtracks);
    } else {
      OBJ_INDEX();
    }
  }    

  }
#define f_CD_cq__backtick_5B_5D_defined
void f_CD_cq__backtick_5B_5D(INT32 args) {
#line 1898 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 1898 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`[]",args,1);
#line 1898 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`[]",1,"string");
#line 1898 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 1898 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    ref_push_object(Pike_fp->current_object);
    stack_swap();
    f_arrow(2); 
  }
    
  }
#define f_CD_track_defined
void f_CD_track(INT32 args) {
#line 1904 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE track;
#line 1904 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("track",args,1);
#line 1904 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("track",1,"int");
track=Pike_sp[0-1].u.integer;
#line 1904 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    struct object *trackobj;
    if(track >= THIS->cd->numtracks || track < 0) {
      Pike_error("Track ID out of range.\n");
    }
    trackobj = clone_object( CDTrack_program, 0 );
    OBJ2_CDTRACK(trackobj)->track = THIS->cd->track[track];
    do { struct object * ret_=(trackobj); pop_stack(); push_object(ret_); return; }while(0);
#line 1912 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}
    
  }
#define f_CD_status_defined
void f_CD_status(INT32 args) {
#line 1914 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("status",args,0);
#line 1914 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(SDL_CDStatus(THIS->cd));  push_int(ret_); return; }while(0);
#line 1916 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
#define f_CD_play_defined
void f_CD_play(INT32 args) {
#line 1918 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE start;
#line 1918 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE length;
#line 1918 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 2) wrong_number_of_args_error("play",args,2);
#line 1918 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("play",1,"int");
start=Pike_sp[0-2].u.integer;
#line 1918 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("play",2,"int");
length=Pike_sp[1-2].u.integer;
#line 1918 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(SDL_CDPlay(THIS->cd, start, length)); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 1920 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}
  }
#define f_CD_play_tracks_defined
void f_CD_play_tracks(INT32 args) {
#line 1921 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE start_track;
#line 1921 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE start_frame;
INT_TYPE ntracks;
#line 1922 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE nframes;
#line 1921 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 4) wrong_number_of_args_error("play_tracks",args,4);
#line 1921 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("play_tracks",1,"int");
start_track=Pike_sp[0-4].u.integer;
#line 1921 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("play_tracks",2,"int");
start_frame=Pike_sp[1-4].u.integer;
#line 1922 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[2-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("play_tracks",3,"int");
ntracks=Pike_sp[2-4].u.integer;
#line 1922 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[3-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("play_tracks",4,"int");
nframes=Pike_sp[3-4].u.integer;
#line 1922 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(SDL_CDPlayTracks(THIS->cd, start_track, start_frame,
			    ntracks, nframes)); pop_n_elems(4); push_int(ret_); return; }while(0);
#line 1925 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}
    
  }
#define f_CD_pause_defined
void f_CD_pause(INT32 args) {
#line 1927 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("pause",args,0);
#line 1927 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(SDL_CDPause(THIS->cd));  push_int(ret_); return; }while(0);
#line 1929 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}
    
  }
#define f_CD_resume_defined
void f_CD_resume(INT32 args) {
#line 1931 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("resume",args,0);
#line 1931 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(SDL_CDResume(THIS->cd));  push_int(ret_); return; }while(0);
#line 1933 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
#define f_CD_stop_defined
void f_CD_stop(INT32 args) {
#line 1935 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("stop",args,0);
#line 1935 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(SDL_CDStop(THIS->cd));  push_int(ret_); return; }while(0);
#line 1937 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
#define f_CD_eject_defined
void f_CD_eject(INT32 args) {
#line 1939 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("eject",args,0);
#line 1939 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(SDL_CDEject(THIS->cd));  push_int(ret_); return; }while(0);
#line 1941 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}
}

#ifdef CD_event_handler_defined
static void CD_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_CD_defined
  case PROG_EVENT_INIT: init_CD_struct(); break;

#endif /* internal_init_CD_defined */

#ifdef internal_exit_CD_defined
  case PROG_EVENT_EXIT: exit_CD_struct(); break;

#endif /* internal_exit_CD_defined */
  default: break; 
  }
}

#endif /* CD_event_handler_defined */
#line 1943 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
#undef CHECK_INIT

#define f_cd_num_drives_defined
void f_cd_num_drives(INT32 args) {
#line 1945 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("cd_num_drives",args,0);
#line 1945 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  do { INT_TYPE ret_=(SDL_CDNumDrives());  push_int(ret_); return; }while(0);
#line 1947 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

}
#define f_cd_name_defined
void f_cd_name(INT32 args) {
#line 1949 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE drive;
#line 1949 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("cd_name",args,1);
#line 1949 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("cd_name",1,"int");
drive=Pike_sp[0-1].u.integer;
#line 1949 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  const char *name = SDL_CDName(drive);
  pop_n_elems(args);
  if(name != NULL) {
    push_text(name);
  } else {
    push_int(0);
  }
}

}
#line 1959 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
#ifdef HAVE_SDL_MIXER
/* This section contains all audio code, and it requires the SDL_mixer
 * library.
 */


#undef class_Music_defined
#define class_Music_defined
struct program *Music_program=0;

#undef var_music_Music_defined
#define var_music_Music_defined

#undef THIS
#define THIS ((struct Music_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_MUSIC
#define THIS_MUSIC ((struct Music_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_MUSIC
#define OBJ2_MUSIC(o) ((struct Music_struct *)(o->storage+Music_storage_offset))

#undef GET_MUSIC_STORAGE
#define GET_MUSIC_STORAGE ((struct Music_struct *)(o->storage+Music_storage_offset)
static ptrdiff_t Music_storage_offset;
struct Music_struct {

#ifdef var_music_Music_defined
#line 1965 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
Mix_Music *music;
#endif /* var_music_Music_defined */
};

#undef internal_init_Music_defined
#define internal_init_Music_defined

#undef Music_event_handler_defined
#define Music_event_handler_defined
static void init_Music_struct(void)
#line 1967 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    THIS->music = NULL;
  }
  
#undef internal_exit_Music_defined
#define internal_exit_Music_defined

#undef Music_event_handler_defined
#define Music_event_handler_defined
static void exit_Music_struct(void)
#line 1970 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    if(THIS->music != NULL) {
      Mix_FreeMusic(THIS->music);
      THIS->music = NULL;
    }
  }

  #define f_Music_create_defined
void f_Music_create(INT32 args) {
#line 1977 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * fname;
#line 1977 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("create",args,1);
#line 1977 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("create",1,"string");
#line 1977 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(fname=Pike_sp[0-1].u.string);
#line 1977 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    if(THIS->music) {
      /* Since you can manually call this... */
      Mix_FreeMusic(THIS->music); 
    }
    THIS->music = Mix_LoadMUS(fname->str);
    if(THIS->music == NULL) {
      Pike_error("Failed to load %s: %s\n",
		 fname->str, SDL_GetError());
    }
  }

  }
#define f_Music_pause_defined
void f_Music_pause(INT32 args) {
#line 1989 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("pause",args,0);
#line 1989 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    Mix_PauseMusic();
    RET_THIS();
  }
  }
#define f_Music_halt_defined
void f_Music_halt(INT32 args) {
#line 1993 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("halt",args,0);
#line 1993 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    Mix_HaltMusic();
    RET_THIS();
  }
  }
#define f_Music_resume_defined
void f_Music_resume(INT32 args) {
#line 1997 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("resume",args,0);
#line 1997 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    Mix_ResumeMusic();
    RET_THIS();
  }
  }
#define f_Music_rewind_defined
void f_Music_rewind(INT32 args) {
#line 2001 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("rewind",args,0);
#line 2001 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    Mix_RewindMusic();
    RET_THIS();
  }
  }
#line 2005 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
/* Status queries */
  #define f_Music_paused_defined
void f_Music_paused(INT32 args) {
#line 2006 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("paused",args,0);
#line 2006 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(Mix_PausedMusic());  push_int(ret_); return; }while(0);
#line 2008 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}
  }
#define f_Music_playing_defined
void f_Music_playing(INT32 args) {
#line 2009 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("playing",args,0);
#line 2009 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(Mix_PlayingMusic());  push_int(ret_); return; }while(0);
#line 2011 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}
  }
#define f_Music_fading_defined
void f_Music_fading(INT32 args) {
#line 2012 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("fading",args,0);
#line 2012 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(Mix_FadingMusic());  push_int(ret_); return; }while(0);
#line 2014 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
#define f_Music_play_defined
void f_Music_play(INT32 args) {
#line 2016 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct svalue * _loops;
#line 2016 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args > 1) wrong_number_of_args_error("play",args,1);
if(args > 0) { 
#line 2016 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
_loops=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
}else{
_loops=0;
}
#line 2016 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    int loops = -1;
    if(_loops) {
      if(_loops->type == PIKE_T_INT) {
	loops = _loops->u.integer;
      } else {
	SIMPLE_BAD_ARG_ERROR("Music.play", 1, "void|int");
      }
    }
    Mix_PlayMusic(THIS->music, loops);
    RET_THIS();
  }

  }
#define f_Music_fade_in_defined
void f_Music_fade_in(INT32 args) {
#line 2029 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE ms;
#line 2029 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct svalue * _loops;
#line 2029 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args < 1) wrong_number_of_args_error("fade_in",args,1);
#line 2029 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args > 2) wrong_number_of_args_error("fade_in",args,2);
#line 2029 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("fade_in",1,"int");
ms=Pike_sp[0-args].u.integer;
if(args > 1) { 
#line 2029 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
_loops=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
}else{
_loops=0;
}
#line 2029 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    int loops = -1;
    if(_loops) {
      if(_loops->type == PIKE_T_INT) {
	loops = _loops->u.integer;
      } else {
	SIMPLE_BAD_ARG_ERROR("Music.fade_in", 2, "void|int");
      }
    }
    Mix_FadeInMusic(THIS->music, loops, ms);
    RET_THIS();
  }

  }
#define f_Music_fade_out_defined
void f_Music_fade_out(INT32 args) {
#line 2042 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE ms;
#line 2042 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("fade_out",args,1);
#line 2042 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("fade_out",1,"int");
ms=Pike_sp[0-1].u.integer;
#line 2042 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    Mix_FadeOutMusic(ms);
    RET_THIS();
  }
  
  }
#define f_Music_set_volume_defined
void f_Music_set_volume(INT32 args) {
#line 2047 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
FLOAT_TYPE vol;
#line 2047 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("set_volume",args,1);
#line 2047 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_FLOAT) SIMPLE_BAD_ARG_ERROR("set_volume",1,"float");
vol=Pike_sp[0-1].u.float_number;
#line 2047 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    if(vol > 1.0)       { vol = 1.0; }
    else if(vol < 0.0)  { vol = 0.0; }
    do { FLOAT_TYPE ret_=((FLOAT_TYPE)Mix_VolumeMusic((int)(128 * vol)) / 128.0); pop_stack(); push_float(ret_); return; }while(0);
#line 2051 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
#define f_Music_volume_defined
void f_Music_volume(INT32 args) {
#line 2053 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("volume",args,0);
#line 2053 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { FLOAT_TYPE ret_=((FLOAT_TYPE)Mix_VolumeMusic(-1) / 128.0);  push_float(ret_); return; }while(0);
#line 2055 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}
}

#ifdef Music_event_handler_defined
static void Music_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Music_defined
  case PROG_EVENT_INIT: init_Music_struct(); break;

#endif /* internal_init_Music_defined */

#ifdef internal_exit_Music_defined
  case PROG_EVENT_EXIT: exit_Music_struct(); break;

#endif /* internal_exit_Music_defined */
  default: break; 
  }
}

#endif /* Music_event_handler_defined */
#define f_open_audio_defined
void f_open_audio(INT32 args) {
#line 2058 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE frequency;
#line 2058 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE format;
#line 2058 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE channels;
#line 2058 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
INT_TYPE bufsize;
#line 2058 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 4) wrong_number_of_args_error("open_audio",args,4);
#line 2058 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("open_audio",1,"int");
frequency=Pike_sp[0-4].u.integer;
#line 2058 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[1-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("open_audio",2,"int");
format=Pike_sp[1-4].u.integer;
#line 2058 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[2-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("open_audio",3,"int");
channels=Pike_sp[2-4].u.integer;
#line 2058 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[3-4].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("open_audio",4,"int");
bufsize=Pike_sp[3-4].u.integer;
#line 2058 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
  SDL_InitSubSystem(SDL_INIT_AUDIO); /* Just in case */
  if(Mix_OpenAudio(frequency, format, channels, bufsize) == -1) {
    Pike_error("Failed to open audio: %s\n", SDL_GetError());
  }
}

}
#line 2065 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
/* HAVE_SDL_MIXER */
#endif


/* SDL_event handling */

#undef class_Event_defined
#define class_Event_defined
struct program *Event_program=0;

#undef var_event_Event_defined
#define var_event_Event_defined

#undef THIS
#define THIS ((struct Event_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_EVENT
#define THIS_EVENT ((struct Event_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_EVENT
#define OBJ2_EVENT(o) ((struct Event_struct *)(o->storage+Event_storage_offset))

#undef GET_EVENT_STORAGE
#define GET_EVENT_STORAGE ((struct Event_struct *)(o->storage+Event_storage_offset)
static ptrdiff_t Event_storage_offset;
struct Event_struct {

#ifdef var_event_Event_defined
#line 2071 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
SDL_Event event;
#endif /* var_event_Event_defined */
};

#undef internal_init_Event_defined
#define internal_init_Event_defined

#undef Event_event_handler_defined
#define Event_event_handler_defined
static void init_Event_struct(void)
#line 2073 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    THIS->event.type = SDL_NOEVENT;
  }

  #define f_Event_get_defined
void f_Event_get(INT32 args) {
#line 2077 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("get",args,0);
#line 2077 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(SDL_PollEvent(&THIS->event));  push_int(ret_); return; }while(0);
#line 2079 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}
  
  }
#define f_Event_wait_defined
void f_Event_wait(INT32 args) {
#line 2081 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("wait",args,0);
#line 2081 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(SDL_WaitEvent(&THIS->event));  push_int(ret_); return; }while(0);
#line 2083 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
#define f_Event_poll_defined
void f_Event_poll(INT32 args) {
#line 2085 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 0) wrong_number_of_args_error("poll",args,0);
#line 2085 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    do { INT_TYPE ret_=(SDL_PollEvent(NULL));  push_int(ret_); return; }while(0);
#line 2087 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
}

  }
#define f_Event_cq__backtick_5B_5D_defined
void f_Event_cq__backtick_5B_5D(INT32 args) {
#line 2089 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 2089 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`[]",args,1);
#line 2089 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`[]",1,"string");
#line 2089 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 2089 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    ref_push_object(Pike_fp->current_object);
    stack_swap();
    f_arrow(2); 
  }

  }
#define f_Event_cq__backtick_2D_3E_defined
void f_Event_cq__backtick_2D_3E(INT32 args) {
#line 2095 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
struct pike_string * key;
#line 2095 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(args != 1) wrong_number_of_args_error("`->",args,1);
#line 2095 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`->",1,"string");
#line 2095 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
#line 2095 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
{
    struct pike_string *axis;
    struct pike_string *ball;
    struct pike_string *button;
    struct pike_string *code;
    struct pike_string *gain;
    struct pike_string *h;
    struct pike_string *hat;
    struct pike_string *keysym;
    struct pike_string *state;
    struct pike_string *type;
    struct pike_string *value;
    struct pike_string *w;
    struct pike_string *which;
    struct pike_string *x;
    struct pike_string *xrel;
    struct pike_string *y;
    struct pike_string *yrel;

    MAKE_CONSTANT_SHARED_STRING(axis, "axis");
    MAKE_CONSTANT_SHARED_STRING(ball, "ball");
    MAKE_CONSTANT_SHARED_STRING(button, "button");
    MAKE_CONSTANT_SHARED_STRING(code, "code");
    MAKE_CONSTANT_SHARED_STRING(gain, "gain");
    MAKE_CONSTANT_SHARED_STRING(h, "h");
    MAKE_CONSTANT_SHARED_STRING(hat, "hat");
    MAKE_CONSTANT_SHARED_STRING(keysym, "keysym");
    MAKE_CONSTANT_SHARED_STRING(state, "state");
    MAKE_CONSTANT_SHARED_STRING(type, "type");
    MAKE_CONSTANT_SHARED_STRING(value, "value");
    MAKE_CONSTANT_SHARED_STRING(w, "w");
    MAKE_CONSTANT_SHARED_STRING(which, "which");
    MAKE_CONSTANT_SHARED_STRING(x, "x");
    MAKE_CONSTANT_SHARED_STRING(xrel, "xrel");
    MAKE_CONSTANT_SHARED_STRING(y, "y");
    MAKE_CONSTANT_SHARED_STRING(yrel, "yrel");

    if(key == axis) {
      switch(THIS->event.type) {
      case SDL_JOYAXISMOTION:
        pop_stack(); push_int(THIS->event.jaxis.axis); return;
      default:
        Pike_error("Event->axis is not valid for this event type. \n");
      }
    }

    if(key == ball) {
      switch(THIS->event.type) {
      case SDL_JOYBALLMOTION:
        pop_stack(); push_int(THIS->event.jball.ball); return;
      default:
        Pike_error("Event->ball is not valid for this event type. \n");
      }
    }

    if(key == button) {
      switch(THIS->event.type) {
      case SDL_JOYBUTTONDOWN:
      case SDL_JOYBUTTONUP:
        pop_stack(); push_int(THIS->event.jbutton.button); return;
      case SDL_MOUSEBUTTONDOWN:
      case SDL_MOUSEBUTTONUP:
        pop_stack(); push_int(THIS->event.button.button); return;
      default:
        Pike_error("Event->button is not valid for this event type. \n");
      }
    }

    if(key == code) {
      switch(THIS->event.type) {
      case SDL_USEREVENT:
        pop_stack(); push_int(THIS->event.user.code); return;
      default:
        Pike_error("Event->code is not valid for this event type. \n");
      }
    }

    if(key == gain) {
      switch(THIS->event.type) {
      case SDL_ACTIVEEVENT:
        pop_stack(); push_int(THIS->event.active.gain); return;
      default:
        Pike_error("Event->gain is not valid for this event type. \n");
      }
    }

    if(key == h) {
      switch(THIS->event.type) {
      case SDL_VIDEORESIZE:
        pop_stack(); push_int(THIS->event.resize.h); return;
      default:
        Pike_error("Event->h is not valid for this event type. \n");
      }
    }

    if(key == hat) {
      switch(THIS->event.type) {
      case SDL_JOYHATMOTION:
        pop_stack(); push_int(THIS->event.jhat.hat); return;
      default:
        Pike_error("Event->hat is not valid for this event type. \n");
      }
    }
    if(key == keysym) {
      struct object *keysym_obj;
      switch(THIS->event.type) {
      case SDL_KEYDOWN:
      case SDL_KEYUP: 
	pop_stack();
	keysym_obj = clone_object(Keysym_program, 0);
	OBJ2_KEYSYM(keysym_obj)->keysym = THIS->event.key.keysym;
	push_object(keysym_obj);
	return;
      default:
        Pike_error("Event->keysym is not valid for this event type. \n");
      }
    }
    if(key == state) {
      switch(THIS->event.type) {
      case SDL_ACTIVEEVENT:
        pop_stack(); push_int(THIS->event.active.state); return;
      case SDL_JOYBUTTONDOWN:
      case SDL_JOYBUTTONUP:
        pop_stack(); push_int(THIS->event.jbutton.state); return;
      case SDL_KEYDOWN:
      case SDL_KEYUP:
        pop_stack(); push_int(THIS->event.key.state); return;
      case SDL_MOUSEBUTTONDOWN:
      case SDL_MOUSEBUTTONUP:
        pop_stack(); push_int(THIS->event.button.state); return;
      case SDL_MOUSEMOTION:
        pop_stack(); push_int(THIS->event.motion.state); return;
      default:
        Pike_error("Event->state is not valid for this event type. \n");
      }
    }

    if(key == type) {
      pop_stack(); push_int(THIS->event.type); return;
    }

    if(key == value) {
      switch(THIS->event.type) {
      case SDL_JOYAXISMOTION:
        pop_stack(); push_int(THIS->event.jaxis.value); return;
      case SDL_JOYHATMOTION:
        pop_stack(); push_int(THIS->event.jhat.value); return;
      default:
        Pike_error("Event->value is not valid for this event type. \n");
      }
    }

    if(key == w) {
      switch(THIS->event.type) {
      case SDL_VIDEORESIZE:
        pop_stack(); push_int(THIS->event.resize.w); return;
      default:
        Pike_error("Event->w is not valid for this event type. \n");
      }
    }

    if(key == which) {
      switch(THIS->event.type) {
      case SDL_JOYAXISMOTION:
        pop_stack(); push_int(THIS->event.jaxis.which); return;
      case SDL_JOYBALLMOTION:
        pop_stack(); push_int(THIS->event.jball.which); return;
      case SDL_JOYBUTTONDOWN:
      case SDL_JOYBUTTONUP:
        pop_stack(); push_int(THIS->event.jbutton.which); return;
      case SDL_JOYHATMOTION:
        pop_stack(); push_int(THIS->event.jhat.which); return;
      case SDL_KEYDOWN:
      case SDL_KEYUP:
        pop_stack(); push_int(THIS->event.key.which); return;
      case SDL_MOUSEBUTTONDOWN:
      case SDL_MOUSEBUTTONUP:
        pop_stack(); push_int(THIS->event.button.which); return;
      case SDL_MOUSEMOTION:
        pop_stack(); push_int(THIS->event.motion.which); return;
      default:
        Pike_error("Event->which is not valid for this event type. \n");
      }
    }

    if(key == x) {
      switch(THIS->event.type) {
      case SDL_MOUSEBUTTONDOWN:
      case SDL_MOUSEBUTTONUP:
        pop_stack(); push_int(THIS->event.button.x); return;
      case SDL_MOUSEMOTION:
        pop_stack(); push_int(THIS->event.motion.x); return;
      default:
        Pike_error("Event->x is not valid for this event type. \n");
      }
    }

    if(key == xrel) {
      switch(THIS->event.type) {
      case SDL_JOYBALLMOTION:
        pop_stack(); push_int(THIS->event.jball.xrel); return;
      case SDL_MOUSEMOTION:
        pop_stack(); push_int(THIS->event.motion.xrel); return;
      default:
        Pike_error("Event->xrel is not valid for this event type. \n");
      }
    }

    if(key == y) {
      switch(THIS->event.type) {
      case SDL_MOUSEBUTTONDOWN:
      case SDL_MOUSEBUTTONUP:
        pop_stack(); push_int(THIS->event.button.y); return;
      case SDL_MOUSEMOTION:
        pop_stack(); push_int(THIS->event.motion.y); return;
      default:
        Pike_error("Event->y is not valid for this event type. \n");
      }
    }

    if(key == yrel) {
      switch(THIS->event.type) {
      case SDL_JOYBALLMOTION:
        pop_stack(); push_int(THIS->event.jball.yrel); return;
      case SDL_MOUSEMOTION:
        pop_stack(); push_int(THIS->event.motion.yrel); return;
      default:
        Pike_error("Event->yrel is not valid for this event type. \n");
      }
    }
    OBJ_INDEX();
  }
}

#ifdef Event_event_handler_defined
static void Event_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Event_defined
  case PROG_EVENT_INIT: init_Event_struct(); break;

#endif /* internal_init_Event_defined */
  default: break; 
  }
}

#endif /* Event_event_handler_defined */
#line 2328 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
/* Pike initialization modules below */

PIKE_MODULE_INIT
{
  
#ifdef class_Rect_defined

#ifdef PROG_RECT_ID
  START_NEW_PROGRAM_ID(RECT);
#else
  start_new_program();

#endif /* PROG_RECT_ID */

#ifdef THIS_RECT

  Rect_storage_offset=ADD_STORAGE(struct Rect_struct);

#endif /* THIS_RECT */

#ifdef Rect_event_handler_defined
  pike_set_prog_event_callback(Rect_event_handler);

#endif /* Rect_event_handler_defined */

#ifdef f_Rect_cq__backtick_2D_3E_defined
#line 326 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`->", f_Rect_cq__backtick_2D_3E, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Rect_cq__backtick_2D_3E_defined */

#ifdef f_Rect_cq__backtick_2D_3E_eq_defined
#line 345 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`->=", f_Rect_cq__backtick_2D_3E_eq, tFunc(tString "\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Rect_cq__backtick_2D_3E_eq_defined */

#ifdef f_Rect_cq__backtick_5B_5D_defined
#line 365 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`[]", f_Rect_cq__backtick_5B_5D, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Rect_cq__backtick_5B_5D_defined */

#ifdef f_Rect_cq__backtick_5B_5D_eq_defined
#line 369 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`[]=", f_Rect_cq__backtick_5B_5D_eq, tFunc(tString "\10\200\0\0\0\177\377\377\377",tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Rect_cq__backtick_5B_5D_eq_defined */

#ifdef f_Rect_cast_defined
#line 373 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("cast", f_Rect_cast, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Rect_cast_defined */
  Rect_program=end_program();
  add_program_constant("Rect",Rect_program,0);

#endif /* class_Rect_defined */

#ifdef class_Keysym_defined

#ifdef PROG_KEYSYM_ID
  START_NEW_PROGRAM_ID(KEYSYM);
#else
  start_new_program();

#endif /* PROG_KEYSYM_ID */

#ifdef THIS_KEYSYM

  Keysym_storage_offset=ADD_STORAGE(struct Keysym_struct);

#endif /* THIS_KEYSYM */

#ifdef f_Keysym_cq__backtick_2D_3E_defined
#line 441 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`->", f_Keysym_cq__backtick_2D_3E, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Keysym_cq__backtick_2D_3E_defined */

#ifdef f_Keysym_cq__backtick_5B_5D_defined
#line 462 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`[]", f_Keysym_cq__backtick_5B_5D, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Keysym_cq__backtick_5B_5D_defined */
  Keysym_program=end_program();
  add_program_constant("Keysym",Keysym_program,0);

#endif /* class_Keysym_defined */

#ifdef class_PixelFormat_defined

#ifdef PROG_PIXELFORMAT_ID
  START_NEW_PROGRAM_ID(PIXELFORMAT);
#else
  start_new_program();

#endif /* PROG_PIXELFORMAT_ID */

#ifdef THIS_PIXELFORMAT

  PixelFormat_storage_offset=ADD_STORAGE(struct PixelFormat_struct);

#endif /* THIS_PIXELFORMAT */

#ifdef PixelFormat_event_handler_defined
  pike_set_prog_event_callback(PixelFormat_event_handler);

#endif /* PixelFormat_event_handler_defined */

#ifdef f_PixelFormat_cq__backtick_2D_3E_defined
#line 511 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`->", f_PixelFormat_cq__backtick_2D_3E, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_PixelFormat_cq__backtick_2D_3E_defined */

#ifdef f_PixelFormat_cq__backtick_5B_5D_defined
#line 582 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`[]", f_PixelFormat_cq__backtick_5B_5D, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_PixelFormat_cq__backtick_5B_5D_defined */

#ifdef f_PixelFormat_losses_defined
#line 589 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("losses", f_PixelFormat_losses, tFunc(tNone,tArr("\10\200\0\0\0\177\377\377\377")), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_PixelFormat_losses_defined */

#ifdef f_PixelFormat_masks_defined
#line 600 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("masks", f_PixelFormat_masks, tFunc(tNone,tArr("\10\200\0\0\0\177\377\377\377")), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_PixelFormat_masks_defined */

#ifdef f_PixelFormat_shifts_defined
#line 611 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("shifts", f_PixelFormat_shifts, tFunc(tNone,tArr("\10\200\0\0\0\177\377\377\377")), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_PixelFormat_shifts_defined */

#ifdef f_PixelFormat_map_rgb_defined
#line 651 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("map_rgb", f_PixelFormat_map_rgb, tOr(tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"),tFunc(tObj,"\10\200\0\0\0\177\377\377\377")), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_PixelFormat_map_rgb_defined */

#ifdef f_PixelFormat_map_rgba_defined
#line 692 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("map_rgba", f_PixelFormat_map_rgba, tOr(tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"),tFunc(tObj "\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377")), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_PixelFormat_map_rgba_defined */

#ifdef f_PixelFormat_get_rgb_defined
#line 712 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("get_rgb", f_PixelFormat_get_rgb, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_PixelFormat_get_rgb_defined */

#ifdef f_PixelFormat_get_rgba_defined
#line 736 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("get_rgba", f_PixelFormat_get_rgba, tFunc("\10\200\0\0\0\177\377\377\377",tMap(tString,tOr(tObj,"\10\200\0\0\0\177\377\377\377"))), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_PixelFormat_get_rgba_defined */
  PixelFormat_program=end_program();
  add_program_constant("PixelFormat",PixelFormat_program,0);

#endif /* class_PixelFormat_defined */

#ifdef class_VideoInfo_defined

#ifdef PROG_VIDEOINFO_ID
  START_NEW_PROGRAM_ID(VIDEOINFO);
#else
  start_new_program();

#endif /* PROG_VIDEOINFO_ID */

#ifdef THIS_VIDEOINFO

  VideoInfo_storage_offset=ADD_STORAGE(struct VideoInfo_struct);

#endif /* THIS_VIDEOINFO */

#ifdef VideoInfo_event_handler_defined
  pike_set_prog_event_callback(VideoInfo_event_handler);

#endif /* VideoInfo_event_handler_defined */

#ifdef f_VideoInfo_cq__backtick_2D_3E_defined
#line 788 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`->", f_VideoInfo_cq__backtick_2D_3E, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_VideoInfo_cq__backtick_2D_3E_defined */

#ifdef f_VideoInfo_cq__backtick_5B_5D_defined
#line 842 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`[]", f_VideoInfo_cq__backtick_5B_5D, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_VideoInfo_cq__backtick_5B_5D_defined */
  VideoInfo_program=end_program();
  add_program_constant("VideoInfo",VideoInfo_program,0);

#endif /* class_VideoInfo_defined */

#ifdef class_Surface_defined

#ifdef PROG_SURFACE_ID
  START_NEW_PROGRAM_ID(SURFACE);
#else
  start_new_program();

#endif /* PROG_SURFACE_ID */

#ifdef THIS_SURFACE

  Surface_storage_offset=ADD_STORAGE(struct Surface_struct);

#endif /* THIS_SURFACE */

#ifdef Surface_event_handler_defined
  pike_set_prog_event_callback(Surface_event_handler);

#endif /* Surface_event_handler_defined */

#ifdef f_Surface_get_pixel_defined
#line 950 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("get_pixel", f_Surface_get_pixel, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_get_pixel_defined */

#ifdef f_Surface_set_pixel_defined
#line 992 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("set_pixel", f_Surface_set_pixel, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_set_pixel_defined */

#ifdef f_Surface_cq__backtick_2D_3E_defined
#line 1018 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`->", f_Surface_cq__backtick_2D_3E, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_cq__backtick_2D_3E_defined */

#ifdef f_Surface_cq__backtick_5B_5D_defined
#line 1065 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`[]", f_Surface_cq__backtick_5B_5D, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_cq__backtick_5B_5D_defined */

#ifdef f_Surface_lock_defined
#line 1083 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("lock", f_Surface_lock, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_lock_defined */

#ifdef f_Surface_unlock_defined
#line 1102 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("unlock", f_Surface_unlock, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_unlock_defined */

#ifdef f_Surface_init_defined
#line 1162 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("init", f_Surface_init, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_init_defined */

#ifdef f_Surface_set_image_defined
#line 1279 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("set_image", f_Surface_set_image, tOr(tFunc(tObj tOr("\10\200\0\0\0\177\377\377\377",tVoid),tObj),tFunc(tObj tObj tOr("\10\200\0\0\0\177\377\377\377",tVoid),tObj)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_set_image_defined */

#ifdef f_Surface_display_format_defined
#line 1341 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("display_format", f_Surface_display_format, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_display_format_defined */

#ifdef f_Surface_display_format_alpha_defined
#line 1373 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("display_format_alpha", f_Surface_display_format_alpha, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_display_format_alpha_defined */

#ifdef f_Surface_blit_defined
#line 1386 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("blit", f_Surface_blit, tFunc(tObj tOr(tObj,tVoid) tOr(tObj,tVoid),tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_blit_defined */

#ifdef f_Surface_fill_rect_defined
#line 1409 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("fill_rect", f_Surface_fill_rect, tFunc("\10\200\0\0\0\177\377\377\377" tObj,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_fill_rect_defined */

#ifdef f_Surface_fill_defined
#line 1416 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("fill", f_Surface_fill, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_fill_defined */

#ifdef f_Surface_set_color_key_defined
#line 1422 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("set_color_key", f_Surface_set_color_key, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_set_color_key_defined */

#ifdef f_Surface_set_alpha_defined
#line 1428 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("set_alpha", f_Surface_set_alpha, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_set_alpha_defined */

#ifdef f_Surface_set_clip_rect_defined
#line 1434 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("set_clip_rect", f_Surface_set_clip_rect, tFunc(tObj,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_set_clip_rect_defined */

#ifdef f_Surface_convert_surface_defined
#line 1441 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("convert_surface", f_Surface_convert_surface, tFunc(tObj "\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Surface_convert_surface_defined */
  Surface_program=end_program();
  add_program_constant("Surface",Surface_program,0);

#endif /* class_Surface_defined */

#ifdef class_Joystick_defined

#ifdef PROG_JOYSTICK_ID
  START_NEW_PROGRAM_ID(JOYSTICK);
#else
  start_new_program();

#endif /* PROG_JOYSTICK_ID */

#ifdef THIS_JOYSTICK

  Joystick_storage_offset=ADD_STORAGE(struct Joystick_struct);

#endif /* THIS_JOYSTICK */

#ifdef Joystick_event_handler_defined
  pike_set_prog_event_callback(Joystick_event_handler);

#endif /* Joystick_event_handler_defined */

#ifdef f_Joystick_create_defined
#line 1717 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("create", f_Joystick_create, tFunc("\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Joystick_create_defined */

#ifdef f_Joystick_index_defined
#line 1725 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("index", f_Joystick_index, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Joystick_index_defined */

#ifdef f_Joystick_num_axes_defined
  ADD_FUNCTION2("num_axes", f_Joystick_num_axes, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Joystick_num_axes_defined */

#ifdef f_Joystick_num_balls_defined
  ADD_FUNCTION2("num_balls", f_Joystick_num_balls, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Joystick_num_balls_defined */

#ifdef f_Joystick_num_hats_defined
  ADD_FUNCTION2("num_hats", f_Joystick_num_hats, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Joystick_num_hats_defined */

#ifdef f_Joystick_num_buttons_defined
  ADD_FUNCTION2("num_buttons", f_Joystick_num_buttons, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Joystick_num_buttons_defined */

#ifdef f_Joystick_get_axis_defined
  ADD_FUNCTION2("get_axis", f_Joystick_get_axis, tFunc("\10\200\0\0\0\177\377\377\377",tFloat), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Joystick_get_axis_defined */

#ifdef f_Joystick_get_hat_defined
#line 1757 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("get_hat", f_Joystick_get_hat, tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Joystick_get_hat_defined */

#ifdef f_Joystick_get_ball_defined
  ADD_FUNCTION2("get_ball", f_Joystick_get_ball, tFunc("\10\200\0\0\0\177\377\377\377",tArr("\10\200\0\0\0\177\377\377\377")), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Joystick_get_ball_defined */

#ifdef f_Joystick_get_button_defined
#line 1772 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("get_button", f_Joystick_get_button, tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Joystick_get_button_defined */

#ifdef f_Joystick_name_defined
  ADD_FUNCTION2("name", f_Joystick_name, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Joystick_name_defined */
  Joystick_program=end_program();
  add_program_constant("Joystick",Joystick_program,0);

#endif /* class_Joystick_defined */

#ifdef class_CDTrack_defined

#ifdef PROG_CDTRACK_ID
  START_NEW_PROGRAM_ID(CDTRACK);
#else
  start_new_program();

#endif /* PROG_CDTRACK_ID */

#ifdef THIS_CDTRACK

  CDTrack_storage_offset=ADD_STORAGE(struct CDTrack_struct);

#endif /* THIS_CDTRACK */

#ifdef CDTrack_event_handler_defined
  pike_set_prog_event_callback(CDTrack_event_handler);

#endif /* CDTrack_event_handler_defined */

#ifdef f_CDTrack_cq__backtick_2D_3E_defined
#line 1827 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`->", f_CDTrack_cq__backtick_2D_3E, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CDTrack_cq__backtick_2D_3E_defined */

#ifdef f_CDTrack_cq__backtick_5B_5D_defined
#line 1848 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`[]", f_CDTrack_cq__backtick_5B_5D, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CDTrack_cq__backtick_5B_5D_defined */
  CDTrack_program=end_program();
  add_program_constant("CDTrack",CDTrack_program,0);

#endif /* class_CDTrack_defined */

#ifdef class_CD_defined

#ifdef PROG_CD_ID
  START_NEW_PROGRAM_ID(CD);
#else
  start_new_program();

#endif /* PROG_CD_ID */

#ifdef THIS_CD

  CD_storage_offset=ADD_STORAGE(struct CD_struct);

#endif /* THIS_CD */

#ifdef CD_event_handler_defined
  pike_set_prog_event_callback(CD_event_handler);

#endif /* CD_event_handler_defined */

#ifdef f_CD_create_defined
#line 1867 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("create", f_CD_create, tFunc("\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CD_create_defined */

#ifdef f_CD_cq__backtick_2D_3E_defined
#line 1875 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`->", f_CD_cq__backtick_2D_3E, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CD_cq__backtick_2D_3E_defined */

#ifdef f_CD_cq__backtick_5B_5D_defined
#line 1898 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`[]", f_CD_cq__backtick_5B_5D, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CD_cq__backtick_5B_5D_defined */

#ifdef f_CD_track_defined
#line 1904 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("track", f_CD_track, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CD_track_defined */

#ifdef f_CD_status_defined
#line 1914 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("status", f_CD_status, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CD_status_defined */

#ifdef f_CD_play_defined
#line 1918 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("play", f_CD_play, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CD_play_defined */

#ifdef f_CD_play_tracks_defined
#line 1921 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("play_tracks", f_CD_play_tracks, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CD_play_tracks_defined */

#ifdef f_CD_pause_defined
#line 1927 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("pause", f_CD_pause, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CD_pause_defined */

#ifdef f_CD_resume_defined
#line 1931 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("resume", f_CD_resume, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CD_resume_defined */

#ifdef f_CD_stop_defined
#line 1935 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("stop", f_CD_stop, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CD_stop_defined */

#ifdef f_CD_eject_defined
#line 1939 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("eject", f_CD_eject, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CD_eject_defined */
  CD_program=end_program();
  add_program_constant("CD",CD_program,0);

#endif /* class_CD_defined */

#ifdef class_Music_defined

#ifdef PROG_MUSIC_ID
  START_NEW_PROGRAM_ID(MUSIC);
#else
  start_new_program();

#endif /* PROG_MUSIC_ID */

#ifdef THIS_MUSIC

  Music_storage_offset=ADD_STORAGE(struct Music_struct);

#endif /* THIS_MUSIC */

#ifdef Music_event_handler_defined
  pike_set_prog_event_callback(Music_event_handler);

#endif /* Music_event_handler_defined */

#ifdef f_Music_create_defined
#line 1977 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("create", f_Music_create, tFunc(tString,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Music_create_defined */

#ifdef f_Music_pause_defined
#line 1989 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("pause", f_Music_pause, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Music_pause_defined */

#ifdef f_Music_halt_defined
#line 1993 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("halt", f_Music_halt, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Music_halt_defined */

#ifdef f_Music_resume_defined
#line 1997 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("resume", f_Music_resume, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Music_resume_defined */

#ifdef f_Music_rewind_defined
#line 2001 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("rewind", f_Music_rewind, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Music_rewind_defined */

#ifdef f_Music_paused_defined
  ADD_FUNCTION2("paused", f_Music_paused, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Music_paused_defined */

#ifdef f_Music_playing_defined
#line 2009 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("playing", f_Music_playing, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Music_playing_defined */

#ifdef f_Music_fading_defined
#line 2012 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("fading", f_Music_fading, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Music_fading_defined */

#ifdef f_Music_play_defined
#line 2016 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("play", f_Music_play, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tVoid),tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Music_play_defined */

#ifdef f_Music_fade_in_defined
#line 2029 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("fade_in", f_Music_fade_in, tFunc("\10\200\0\0\0\177\377\377\377" tOr("\10\200\0\0\0\177\377\377\377",tVoid),tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Music_fade_in_defined */

#ifdef f_Music_fade_out_defined
#line 2042 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("fade_out", f_Music_fade_out, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Music_fade_out_defined */

#ifdef f_Music_set_volume_defined
  ADD_FUNCTION2("set_volume", f_Music_set_volume, tFunc(tFloat,tFloat), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Music_set_volume_defined */

#ifdef f_Music_volume_defined
#line 2053 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("volume", f_Music_volume, tFunc(tNone,tFloat), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Music_volume_defined */
  Music_program=end_program();
  add_program_constant("Music",Music_program,0);

#endif /* class_Music_defined */

#ifdef class_Event_defined

#ifdef PROG_EVENT_ID
  START_NEW_PROGRAM_ID(EVENT);
#else
  start_new_program();

#endif /* PROG_EVENT_ID */

#ifdef THIS_EVENT

  Event_storage_offset=ADD_STORAGE(struct Event_struct);

#endif /* THIS_EVENT */

#ifdef Event_event_handler_defined
  pike_set_prog_event_callback(Event_event_handler);

#endif /* Event_event_handler_defined */

#ifdef f_Event_get_defined
#line 2077 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("get", f_Event_get, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Event_get_defined */

#ifdef f_Event_wait_defined
#line 2081 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("wait", f_Event_wait, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Event_wait_defined */

#ifdef f_Event_poll_defined
#line 2085 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("poll", f_Event_poll, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Event_poll_defined */

#ifdef f_Event_cq__backtick_5B_5D_defined
#line 2089 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`[]", f_Event_cq__backtick_5B_5D, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Event_cq__backtick_5B_5D_defined */

#ifdef f_Event_cq__backtick_2D_3E_defined
#line 2095 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("`->", f_Event_cq__backtick_2D_3E, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Event_cq__backtick_2D_3E_defined */
  Event_program=end_program();
  add_program_constant("Event",Event_program,0);

#endif /* class_Event_defined */

#ifdef f_init_defined
#line 157 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("init", f_init, tFunc("\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_init_defined */

#ifdef f_get_error_defined
#line 169 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("get_error", f_get_error, tFunc(tNone,tOr(tVoid,tString)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_get_error_defined */

#ifdef f_init_sub_system_defined
#line 187 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("init_sub_system", f_init_sub_system, tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_init_sub_system_defined */

#ifdef f_quit_sub_system_defined
#line 202 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("quit_sub_system", f_quit_sub_system, tFunc("\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_quit_sub_system_defined */

#ifdef f_was_init_defined
#line 218 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("was_init", f_was_init, tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_was_init_defined */

#ifdef f_quit_defined
#line 231 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("quit", f_quit, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_quit_defined */

#ifdef f_enable_unicode_defined
#line 262 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("enable_unicode", f_enable_unicode, tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_enable_unicode_defined */

#ifdef f_get_mod_state_defined
#line 283 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("get_mod_state", f_get_mod_state, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_get_mod_state_defined */

#ifdef f_get_key_state_defined
#line 299 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("get_key_state", f_get_key_state, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_get_key_state_defined */

#ifdef f_video_mode_ok_defined
#line 1463 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("video_mode_ok", f_video_mode_ok, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_video_mode_ok_defined */

#ifdef f_flip_defined
#line 1489 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("flip", f_flip, tFunc(tOr(tObj,tVoid),"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_flip_defined */

#ifdef f_update_rect_defined
#line 1528 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("update_rect", f_update_rect, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" tOr(tObj,tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_update_rect_defined */

#ifdef f_set_gamma_defined
#line 1543 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("set_gamma", f_set_gamma, tFunc(tFloat tFloat tFloat,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_set_gamma_defined */

#ifdef f_get_video_surface_defined
#line 1547 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("get_video_surface", f_get_video_surface, tFunc(tNone,tOr(tVoid,tObj)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_get_video_surface_defined */

#ifdef f_get_video_info_defined
#line 1561 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("get_video_info", f_get_video_info, tFunc(tNone,tOr(tVoid,tObj)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_get_video_info_defined */

#ifdef f_gl_set_attribute_defined
#line 1574 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("gl_set_attribute", f_gl_set_attribute, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_gl_set_attribute_defined */

#ifdef f_gl_get_attribute_defined
  ADD_FUNCTION2("gl_get_attribute", f_gl_get_attribute, tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_gl_get_attribute_defined */

#ifdef f_show_cursor_defined
#line 1586 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("show_cursor", f_show_cursor, tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_show_cursor_defined */

#ifdef f_warp_mouse_defined
  ADD_FUNCTION2("warp_mouse", f_warp_mouse, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_warp_mouse_defined */

#ifdef f_gl_swap_buffers_defined
  ADD_FUNCTION2("gl_swap_buffers", f_gl_swap_buffers, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_gl_swap_buffers_defined */

#ifdef f_set_video_mode_defined
  ADD_FUNCTION2("set_video_mode", f_set_video_mode, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_set_video_mode_defined */

#ifdef f_blit_surface_defined
#line 1630 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("blit_surface", f_blit_surface, tFunc(tObj tObj tOr(tObj,tVoid) tOr(tObj,tVoid),"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_blit_surface_defined */

#ifdef f_video_driver_name_defined
#line 1655 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("video_driver_name", f_video_driver_name, tFunc(tNone,tOr(tVoid,tString)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_video_driver_name_defined */

#ifdef f_set_caption_defined
#line 1666 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("set_caption", f_set_caption, tFunc(tString tString,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_set_caption_defined */

#ifdef f_get_caption_defined
#line 1670 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("get_caption", f_get_caption, tFunc(tNone,tArr(tString)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_get_caption_defined */

#ifdef f_iconify_window_defined
#line 1679 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("iconify_window", f_iconify_window, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_iconify_window_defined */

#ifdef f_toggle_fullscreen_defined
#line 1683 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("toggle_fullscreen", f_toggle_fullscreen, tFunc(tOr(tVoid,tObj),"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_toggle_fullscreen_defined */

#ifdef f_grab_input_defined
#line 1697 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("grab_input", f_grab_input, tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_grab_input_defined */

#ifdef f_num_joysticks_defined
#line 1791 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("num_joysticks", f_num_joysticks, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_num_joysticks_defined */

#ifdef f_joystick_name_defined
#line 1795 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("joystick_name", f_joystick_name, tFunc("\10\200\0\0\0\177\377\377\377",tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_joystick_name_defined */

#ifdef f_joystick_opened_defined
#line 1805 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("joystick_opened", f_joystick_opened, tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_joystick_opened_defined */

#ifdef f_joystick_update_defined
#line 1809 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("joystick_update", f_joystick_update, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_joystick_update_defined */

#ifdef f_joystick_event_state_defined
#line 1813 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("joystick_event_state", f_joystick_event_state, tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_joystick_event_state_defined */

#ifdef f_cd_num_drives_defined
#line 1945 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("cd_num_drives", f_cd_num_drives, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_cd_num_drives_defined */

#ifdef f_cd_name_defined
#line 1949 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("cd_name", f_cd_name, tFunc("\10\200\0\0\0\177\377\377\377",tOr(tString,tVoid)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_cd_name_defined */

#ifdef f_open_audio_defined
#line 2058 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
  ADD_FUNCTION2("open_audio", f_open_audio, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_open_audio_defined */
#line 2332 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
;
  
  init_sdl_constants();
   
 push_text("Image.Image");
  SAFE_APPLY_MASTER("resolv", 1);

  if(Pike_sp[-1].type == T_PROGRAM) {
    _image_program = Pike_sp[-1];
    image_program = program_from_svalue(&_image_program);
  } else {
    image_program = NULL;
  }
  Pike_sp--;

  push_text("Image.Color.Color");
  SAFE_APPLY_MASTER("resolv", 1);
  
  if(Pike_sp[-1].type == T_PROGRAM) {
    _image_color_program = Pike_sp[-1];
    image_color_program = program_from_svalue(&_image_color_program);
  } else {
    image_color_program = NULL;
  }
  Pike_sp--;
}

PIKE_MODULE_EXIT
{
  
#ifdef class_Rect_defined
  if(Rect_program) {
    free_program(Rect_program);
    Rect_program=0;
  }

#endif /* class_Rect_defined */

#ifdef class_Keysym_defined
  if(Keysym_program) {
    free_program(Keysym_program);
    Keysym_program=0;
  }

#endif /* class_Keysym_defined */

#ifdef class_PixelFormat_defined
  if(PixelFormat_program) {
    free_program(PixelFormat_program);
    PixelFormat_program=0;
  }

#endif /* class_PixelFormat_defined */

#ifdef class_VideoInfo_defined
  if(VideoInfo_program) {
    free_program(VideoInfo_program);
    VideoInfo_program=0;
  }

#endif /* class_VideoInfo_defined */

#ifdef class_Surface_defined
  if(Surface_program) {
    free_program(Surface_program);
    Surface_program=0;
  }

#endif /* class_Surface_defined */

#ifdef class_Joystick_defined
  if(Joystick_program) {
    free_program(Joystick_program);
    Joystick_program=0;
  }

#endif /* class_Joystick_defined */

#ifdef class_CDTrack_defined
  if(CDTrack_program) {
    free_program(CDTrack_program);
    CDTrack_program=0;
  }

#endif /* class_CDTrack_defined */

#ifdef class_CD_defined
  if(CD_program) {
    free_program(CD_program);
    CD_program=0;
  }

#endif /* class_CD_defined */

#ifdef class_Music_defined
  if(Music_program) {
    free_program(Music_program);
    Music_program=0;
  }

#endif /* class_Music_defined */

#ifdef class_Event_defined
  if(Event_program) {
    free_program(Event_program);
    Event_program=0;
  }

#endif /* class_Event_defined */
#line 2361 "/tmp/pikedeb.20bb6f0000/7.4/src/post_modules/SDL/SDL.cmod"
;
  free_svalue(&_image_color_program);
  _image_color_program.type = PIKE_T_INT;
  free_svalue(&_image_program);
  _image_program.type = PIKE_T_INT;
  SDL_Quit();
}


/*! @endmodule SDL */

#else /* HAVE_SDL */

PIKE_MODULE_INIT {
}
PIKE_MODULE_EXIT {
}
#endif /* HAVE_SDL */

