# --------------------------------------------------------------------------- #
# $Id: gnuplot.py,v 1.5 2004/01/04 17:31:01 weismann Exp $
# --------------------------------------------------------------------------- #
#
# GnuPLOT support
#
# This file contains a bunch of hacks that demonstrate how you can try
# to integrate support for your favorite tool into pointless. There is NOT 
# much error checking at the moment. The aim was merely to demonstrate how to
# integrate support for external tools.
#
# The integration of a given tool <foo> can be split into four sections, the
# register_foo section, the write_foo section, the run_foo section and
# the _foo section. The register_foo is used to registre the command
# into the PLL language. The _foo function is the one that will be
# called as part of the parsing of the pll-input whenever a =foo (or a
# =begin-foo ... =end-foo section is detected. Finally, the write_foo 
# and run_foo functions are auxilary functions for the _foo function. 
# The write_foo is used to modify the input with additinon commands
# required for the run and the run_foo is finally used to run the
# external foo application.
#

from pllshared import *
import os
import re
import pllmodules
import eps 

pll = None

def register():
	gnuplot = pll.add_command("gnuplot", _gnuplot, transform=1, vars=1)
	gnuplot.set_attrs({'scale':1.0})

def write_gnuplot_file(gnuplotfile, psfile, content):
	f = open(gnuplotfile, 'w')
	f.write("set terminal postscript eps enhanced color\n")
	f.write("set out '"+psfile+"'\n")
	## remove all set term and all set out commands from content
	content = re.sub('[.*]?set *term.*', '', content)
	content = re.sub('[.*]?set *out.*', '', content)
	f.write(content)
	f.write("\nset out\n")
	f.close()

def run_gnuplot(filename):
	gnuplot = pllmodules.find_program("gnuplot")
	errormsg = ""
	if gnuplot:
		failed = os.system("%s %s" % (gnuplot, filename))
	else:
		failed = 1
		errormsg = "Unable to find the gnuplot program";
	return not failed, errormsg

def _gnuplot(args, text, vars):
	filename = pll.get_tempfilename()
	gnuplotfile = filename+".gnuplot"
	tmppsfile = filename+"tmp.ps"
	psfile = filename+".ps"
	pngfile = filename+".png"

	oldmd5 = pllmodules.md5_file(gnuplotfile)
	write_gnuplot_file(gnuplotfile, tmppsfile, text)
	newmd5 = pllmodules.md5_file(gnuplotfile)

	if oldmd5 != newmd5 or not os.path.isfile(tmppsfile):
		ok, error = run_gnuplot(gnuplotfile)
		if not ok:
			os.unlink(gnuplotfile) # to purge cache
			errmsg = "Error running gnuplotfile on '%s'.\n" % text
			errmsg += error
			raise PllCommandError(errmsg)

	ok, error = eps.run_eps2eps(tmppsfile, psfile)
	if not ok:
		os.unlink(tmppsfile) # to purge cache
		errmsg = "Error running eps2eps '%s %s'.\n" % (tmppsfile, psfile)
		errmsg += error
		raise PllCommandError(errmsg)

	ok, error = eps.eps2png(psfile, pngfile, vars['scale']*pll.scale)
	if not ok:
		os.unlink(psfile) # to purge cache
		errmsg = "Error converting eps '%s'.\n" % epsfile
		errmsg += error
		raise PllCommandError(errmsg)

	return '=gaimage("%s")' % pngfile

# --------------------------------------------------------------------------- #

