/*                               
Utils.cc
*/

#include "Utils.h"
#include "Language.h"

extern Language *L;
extern int errno;

#define DU "du --bytes --summarize"

void initStr (char *thestr)
  {
  thestr [0] = '\0';
  }

void SaveFileDebug (char *fn, char *pc, int len)
  {
  FILE *fw;
  fw = fopen (fn, "w");
  for (int i=0; i<len; ++i) {fprintf (fw, "%c", pc[i]);}
  fclose (fw);
  }
  
void SaveFileDebug (char *fn, char *pc)
  {
  int len;
  len = strlen (pc);
  FILE *fw;
  fw = fopen (fn, "w");
  for (int i=0; i<len; ++i) {fprintf (fw, "%c", pc[i]);}
  fclose (fw);
  }  
  
char *xstrdup (char const *str)
  {
  return (strcpy(new char [strlen(str) + 1], str));
  }

char *ReturnUsersDir (const char *basepath, const char *user, const char *server, TBuffer ABuf)
  {
  sprintf (ABuf, "%s/%s/%c%c/%s", basepath, server, user[0], user[1], user);
  return ABuf;
  }

char *ReturnUserLockFileName (const char *user, TBuffer ABuf)
  {
  sprintf (ABuf, "%s/%s.lock", LOCKSDIR, user);
  return ABuf;
  }

char *getExtensionFromFile (const char *fn)
  {
  if (fn == NULL) return "";
  if (strchr(fn, '.') == NULL) return "";
  if (fn[strlen(fn) - 1] == '.') return "";
  return (strrchr (fn, '.') + 1);
  }  
  
char *ReturnSignatureFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf)
  {
  TBuffer tmpbuf;
  sprintf (ABuf, "%s/%s", ReturnUsersDir(basepath, user, server, tmpbuf), SIGNATURENAME);
  return ABuf;
  }

char *ReturnSieveFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf)
  {
  TBuffer tmpbuf;
  sprintf (ABuf, "%s/%s", ReturnUsersDir(basepath, user, server, tmpbuf), SIEVENAME);
  return ABuf;
  }

char *ReturnRestrictedDirNameFileBrowser (const char *basepath, const char *user, const char *server, TBuffer ABuf)
  {
  TBuffer tmpbuf;
  sprintf (ABuf, "%s/files/", ReturnUsersDir(basepath, user, server, tmpbuf));
  return ABuf;
  }

char *ReturnSubscribedNNGroupsFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf)
  {
  TBuffer tmpbuf;
  sprintf (ABuf, "%s/%s", ReturnUsersDir(basepath, user, server, tmpbuf), SUBSCRIBEDGROUPSNAME);
  return ABuf;
  }

char *ReturnRcNNGroupsFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf)
  {
  TBuffer tmpbuf;
  sprintf (ABuf, "%s/%s", ReturnUsersDir(basepath, user, server, tmpbuf), RCGROUPSNAME);
  return ABuf;
  }

char *ReturnAllNNGroupsFileName (const char *server, TBuffer abuf)
  {
  sprintf (abuf, "%s/%s.allgroups", NETNEWS_PATH, server);
  return abuf;
  }

char *ReturnUserOptionsFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf)
  {
  TBuffer tmpbuf;
  sprintf (ABuf, "%s/%s", ReturnUsersDir(basepath, user, server, tmpbuf), USEROPTIONSNAME);
  return ABuf;
  }
  
char *ReturnUserDatabasesDir (const char *basepath, const char *user, const char *server, TBuffer ABuf)
  {
  TBuffer tmpbuf;
  sprintf (ABuf, "%s/databases", ReturnUsersDir(basepath, user, server, tmpbuf));
  return ABuf;
  }  
  
char *ReturnUserAddressbookFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf)
  {
  TBuffer tmpbuf;
  sprintf (ABuf, "%s/%s", ReturnUsersDir(basepath, user, server, tmpbuf), USERADDRESSBOOKNAME);
  return ABuf;
  }  
  
char *ReturnUserSavedMsgFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf)
  {
  TBuffer tmpbuf;
  sprintf (ABuf, "%s/%s", ReturnUsersDir(basepath, user, server, tmpbuf), SAVEDINCOMPOSE);
  return ABuf;
  }   
 
char *ReturnUserSavedNNTPMsgFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf)
  {
  TBuffer tmpbuf;
  sprintf (ABuf, "%s/%s", ReturnUsersDir(basepath, user, server, tmpbuf), SAVEDNNTPINCOMPOSE);
  return ABuf;
  }    
 
/*WARNING: this is hard coded en cgi-lib.c 
  If you change this, must change that file*/  
char *ReturnUserAttachsDir (const char *basepath, const char *user, const char *server, TBuffer ABuf)
  {
  TBuffer tmpbuf;
  sprintf (ABuf, "%s/attachs", ReturnUsersDir(basepath, user, server, tmpbuf));
  return ABuf;
  }  
  
bool CreateDir (char *path, mode_t mode)
  {
  int i;
  bool b;
  i = mkdir (path, S_IREAD | S_IWRITE | S_IEXEC);
  if (i == 0) 
    {
    chmod (path, mode); 
    b = true;
    }
  else 
    {
    if (errno == EEXIST) b = true; 
    else 
      {
      TSBuffer abuf;
      xstrncpy (abuf, CSMALLBUFFER, "ERROR: I can not create the dir ");
      xstrncat (abuf, CSMALLBUFFER, path);
      LOG (abuf);
      b = false;
      }
    }
  return b;
  }

bool DeleteFile (const char *fname)
  {
  int i;
  i = unlink (fname);
  if (i == 0) 
    {
    return true;
    }
  else 
    {
    TSBuffer abuf;
    xsnprintf (abuf, CSMALLBUFFER, "ERROR: I can not delete the file '%s'", fname);
    LOG (abuf);
    return false;
    }
  }

int CreateAndLockFile (char *fn)
  {
  TSBuffer abuf;
  time_t tloc; tloc = 0;
  int fd;
  fd = open (fn, O_WRONLY | O_CREAT, 0600);
  lockf (fd, F_LOCK, 0);
  sprintf (abuf, "%10d\n", getpid());
  write (fd, abuf, strlen(abuf));
  sprintf (abuf, "%20d\n", (xuint)time(&tloc));
  write (fd, abuf, strlen(abuf));
  return fd;
  }
  
void EscribePIDenLockFile (int fd)
  {
  TSBuffer abuf;
  time_t tloc; tloc = 0;
  lseek (fd, (off_t)0, SEEK_SET);  
  sprintf (abuf, "%10d\n", getpid());
  write (fd, abuf, strlen(abuf));
  sprintf (abuf, "%20d\n", (xuint)time(&tloc));
  write (fd, abuf, strlen(abuf));
  }  
  
int IsLocked (char *fn, int *fd)
  {
  int res;
  *fd = open (fn, O_RDWR);
  if (*fd < 0) {return 2;}          //NO EXISTE EL FICHERO
  res = lockf (*fd, F_TLOCK, 0);    //EL TLOCK NO SE ESPERA
  if (res == 0) return 0;           //NO HAY LOCK
  else return 1;                    //SI HAY LOCK
  }   
  
void UnlockAndCloseFile (int fd)
  {
  close (fd);
  }  

int GetPIDFromLockFile (int fd)
  {
  int r;
  char abuf[11];
  lseek (fd, (off_t)0, SEEK_SET);
  read (fd, abuf, 10);
  abuf[10] = '\0';
  r = atoi(abuf);
  return r;
  }

long GetTimeFromLockFile (int fd)
  {
  long r;
  char abuf[21];
  lseek (fd, (off_t)11, SEEK_SET);
  read (fd, abuf, 20);
  abuf[20] = '\0';
  r = xatoldef(abuf, -1);
  return r;
  }

long GetTimeFromLockFileOpening (char *fn)
  {
  if (fn == NULL) return -1;
  long r;
  char abuf[21];
  int fd;
  fd = open (fn, O_RDONLY);
  if (fd == -1) return -1;
  lseek (fd, (off_t)11, SEEK_SET);
  read (fd, abuf, 20);
  close (fd);
  abuf[20] = '\0';
  r = xatoldef(abuf, -1);
  return r;
  }
  
void QuitaRetornoCarroDeLinea (char *linea)
  {
  if (linea == NULL) return;
  if (strcmp (linea, "") == 0) return;  
  if (linea[strlen(linea) - 1] == '\013') linea[strlen(linea) - 1] = '\0';  
  if ((linea[strlen(linea) - 1] != '\n') && (linea[strlen(linea) - 1] != '\r')) return;
  linea[strlen(linea) - 1] = '\0';
  if ((linea[strlen(linea) - 1] != '\n') && (linea[strlen(linea) - 1] != '\r')) return;
  linea[strlen(linea) - 1] = '\0';    
  }

void Randomize ()
  {
  xuint seed;
  time_t tloc;
  tloc = 0;
  seed = (xuint)getpid() + (xuint)time(&tloc);
  srand (seed);
  srandom (seed);
  }  

int Rand (int max)
  {
  int res;
  res = rand() % max + 1;
  return res;
  }
  
bool FileExists (const char *fn) 
  {
  int res;
  struct stat STAT;
  res = stat (fn, &STAT);
  if (res == 0) return true; else return false;
  }          

int FileSize (const char *fn)
  {
  struct stat STAT;
  stat (fn, &STAT);
  return STAT.st_size;
  }  

time_t FileDate (char *fn)
  {
  struct stat STAT;
  stat (fn, &STAT);
  return STAT.st_mtime;
  }  
  
char *xucase (char *s)
  {
  if (s == NULL) return NULL;
  char *t;
  for (t = s; *t; t++) if (!(*t & 0x80) && islower (*t)) *t = toupper (*t);
  return s;           
  }

char *xlcase (char *s)
  {
  if (s == NULL) return NULL;  
  char *t;
  for (t = s; *t; t++) if (!(*t & 0x80) && isupper (*t)) *t = tolower (*t);
  return s;   
  }  
  
  
//CONVIERTE UN INTEGER EN UN PCHAR
char *xitoa (int n, TNumber abuf)
  {
  sprintf (abuf, "%d", n);
  return abuf;
  } 

//CONVIERTE UN LONG EN UN PCHAR
char *xltoa (long n, TNumber abuf)
  {
  sprintf (abuf, "%ld", n);
  return abuf;
  }
  
//CONVIERTE UN PCHAR A INT Y SI ES INVALIDO DEVUELVE EL DEFAULT  
int xatoidef (const char *stnum, int def)
  {
  if (stnum == NULL) return def;
  if (strcmp (stnum, "") == 0) return def;
  int i;
  char *chk;
  i = (int) strtol (stnum, &chk, 10);
  if (*chk != '\0') {return def;}  //BAD INTEGER
  return i;
  } 

//CONVIERTE UN STRING A LONG DANDO UN DEFECTO EN ERROR
long int xatoldef (const char *stnum, long int def)
  {
  if (stnum == NULL) return def;
  if (strcmp (stnum, "") == 0) return def;
  long int i;
  char *chk;
  i = strtol (stnum, &chk, 10);
  if (*chk != '\0') {return def;}  //BAD INTEGER
  return i;
  }

//CONVIERTE UN PCHAR A BOOL Y SI ES INVALIDO DEVUELVE EL DEFAULT  
bool xatobdef (const char *stnum, bool def)
  {
  if (stnum == NULL) return def;
  if (strcmp (stnum, "") == 0) return def;  
  if      (strcmp (stnum, "0") == 0) return false; 
  else if (strcmp (stnum, "1") == 0) return true;
  else return def;
  } 
const char *make_random_cgi_sep (void)
  {
  char session_chars[] = ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
  int i, p;
  char rawid[LEN_SEP_CGI_VAR + 1], letra[2];
  
  letra[1] = '\0';
  initStr (rawid);
  for (i = 1; i <= LEN_SEP_CGI_VAR; ++i)
    {
    p = (int) Rand(62);
    letra[0] = session_chars[p - 1];
    xstrncat (rawid, LEN_SEP_CGI_VAR + 1, letra);
    }
  return xstrdup (rawid);
  }

char *make_session_id (const char *server, TBuffer abuf)
  {
  char session_chars[] = ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
  int i, p;
  char rawid[24 + 1], letra[2];
  
  letra[1] = '\0';
  initStr (rawid);
  for (i = 1; i <= 24; ++i)
    {
    p = (int) Rand(62);
    letra[0] = session_chars[p - 1];
    xstrncat (rawid, 24 + 1, letra);
    }
  xstrncpy (abuf, CMAXBUFFER, server); 
  xstrncat (abuf, CMAXBUFFER, "@"); 
  xstrncat (abuf, CMAXBUFFER, rawid);  
  return abuf;
  }

char *extract_server_from_connid (const char *connid, TBuffer Buf)
  {
  int pos;
  pos = Cstrstr (connid, "@");
  if (pos <= 0) {initStr (Buf);}
  else {xstrncpy (Buf, CMAXBUFFER, connid);}
  return Buf;
  }

char *make_root_socket (TBuffer Buf)
  {
  sprintf (Buf, "%s/%s", UNIX_SOCKETS_PATH, PROGNAME);
  return Buf;
  }
  
char *make_session_socket (const char *username, const char *connid, TBuffer Buf)
  {
  sprintf (Buf, "%s/%s:%s", SOCK_SESSIONS_PATH, username, connid);
  return Buf;
  }
                    
void ini (char *connid, char *stlang, char *stcmd, char *stsubcmd, char *allparms, char *allparms2,
          char *parm1, char *parm2, char *parm3, char *parm4)
  {
  connid[0]    = '\0';
  stlang[0]    = '\0';
  stcmd[0]     = '\0';
  stsubcmd[0]  = '\0';  
  allparms[0]  = '\0';
  allparms2[0] = '\0';
  parm1[0]     = '\0';
  parm2[0]     = '\0';
  parm3[0]     = '\0';
  parm4[0]     = '\0';
  }            

//DEVUELVE LA POSICION DE UN SUBSTRING EN UN STRING SIN IMPORTAR EL CASE  
int NCstrstr (const char *linea, const char *token)
  {
  int res;
  char *p;
  TBuffer UPlinea, UPtoken;
  xstrncpy (UPlinea, CMAXBUFFER, linea); xucase (UPlinea);
  xstrncpy (UPtoken, CMAXBUFFER, token); xucase (UPtoken);
  p = strstr (UPlinea, UPtoken);  if (p == NULL) res = 0;
  else res = p - UPlinea + 1;
  return res;
  }  

//DEVUELVE LA POSICION DE UN SUBSTRING EN UN STRING IMPORTANDO EL CASE  
int Cstrstr (const char *linea, const char *token)
  {
  char *p;  
  p = strstr (linea, token);  
  if (p == NULL) return 0;
  return (p - linea + 1);  
  }

//OPEN THE LOG
void OPENLOG (void)
  {  
  openlog (PROGNAME, XLOGOPTIONS, XLOGFACILITY);
  }                                                 

//CLOSE THE LOG
void CLOSELOG (void)
  {  
  closelog();
  }                                                 

//IMPRIME UN MSG EN EL LOG    
void LOG (long i)
  {
  TNumber anum;
  syslog(XLOGPRIORITY, xltoa(i, anum));
  }  
  
//IMPRIME UN MSG EN EL LOG    
void LOG (char *fmt, ...)
  {
  TBuffer linea;
  va_list args;
  va_start (args, fmt);
  xvsnprintf (linea, CMAXBUFFER, fmt, args);
  syslog(XLOGPRIORITY, linea);
  va_end (args);
  }    
 
//IMPRIME UN MSG EN EL LOG CON LA ETIQUETA DE DEBUG     
void DEBUG (char *fmt, ...)
  {
  TBuffer linea, linea2;
  va_list args;
  va_start (args, fmt);
  xvsnprintf (linea, CMAXBUFFER, fmt, args);
  sprintf (linea2, "DEBUG: '%s'", linea);
  syslog(XLOGPRIORITY, linea2);
  va_end (args);
  }      
  
void DEBUG (int imsg)
  {
  TBuffer l;
  sprintf (l, "DEBUG: '%d'", imsg);
  syslog(XLOGPRIORITY, l);
  }    
  
char *FormatCountBytes (long count, TBuffer abuf)
  {
  TNumber anum;
  char stnum[30], stres[50], stres2[50];
  long L, j;
  xstrncpy (stnum, 30, xltoa (count, anum));
  L = strlen (stnum);
  if (L <= 3) {xstrncpy (stres, 50, "&#60;1K");}
  else if ((L > 3) && (L <= 6)) 
    {
    j = (long) ((long)count / (long)1024); if (j == 0) j = 1; 
    xstrncpy (stres, 50, xltoa(j, anum)); 
    xstrncat(stres, 30, "K");
    }
  else if ((L > 6) && (L <= 9)) 
    {
    j = (long) ((long)count / (long)1048576); if (j == 0) j = 1; 
    xstrncpy (stres, 50, xltoa(j, anum)); 
    xstrncat(stres, 50, "M");
    }
  else 
    {
    xstrncpy (stres, 50, stnum); 
    xstrncat(stres, 50, "b");
    }
  if (strlen (stres) == 2) 
    {
    xstrncpy (stres2, 50, "  "); 
    xstrncat (stres2, 50, stres); 
    xstrncpy (abuf, CMAXBUFFER, stres2); 
    return abuf;
    }
  else if (strlen (stres) == 3) 
    {
    xstrncpy (stres2, 50, " "); 
    xstrncat (stres2, 50, stres); 
    xstrncpy (abuf, CMAXBUFFER, stres2);
    return abuf;
    }
  xstrncpy (abuf, CMAXBUFFER, stres);  
  return abuf;
  }

char *FormatCountBytes1Dec (long count, TBuffer abuf)
  {
  TNumber anum;
  char stnum[30], stres[50];
  long L;
  float f;
  xstrncpy (stnum, 30, xltoa (count, anum));
  L = strlen (stnum);
  if (L <= 3) {xstrncpy (stres, 50, "&#60;1.0 KB");}
  else if ((L > 3) && (L <= 6)) 
    {
    f = (float)count / (float)1024.0;    
    if (f == 0.0) f = 1.0; 
    sprintf (stres, "%.1f", f); 
    xstrncat(stres, 50, " KB");
    }
  else if ((L > 6) && (L <= 9)) 
    {
    f = (float)count / (float)1048576.0; 
    if (f == 0.0) f = 1.0; 
    sprintf (stres, "%.1f", f); 
    xstrncat(stres, 50, " MB");
    }
  else 
    {
    xstrncpy (stres, 50, stnum); 
    xstrncat(stres, 50, " B");
    }
  xstrncpy (abuf, CMAXBUFFER, stres);
  return abuf;
  }

void Redirect (const char *newurl)
  {
  printf ("Status: 302 Moved\n");
  printf ("Location: %s\n", newurl);
  printf ("Content-Type: text/html\n\n");
  }  

void ErrorPage (const char *error)
  {        
  printf ("Content-type: text/html\n\n");  
  printf ("%s\n<HTML>\n", HTML_DOCTYPE);
  printf ("<HEAD>\n");
  printf ("<TITLE>%s</TITLE>", L->get(L_ERROR));
  printf ("</HEAD>\n");
  printf ("<BODY link=\"%s\" vlink=\"%s\" alink=\"%s\">\n", BLUE, BLUE2, RED);
  printf ("<p><h1><FONT color=\"%s\">%s:</font> %s</h1><p>\n", RED, L->get(L_ERROR), error);
  printf ("<HR noshade size=2>\n");
  printf ("<SMALL>%s</SMALL>\n", L->get (L_COPYRIGHT));
  printf ("</BODY>\n");
  printf ("</HTML>\n");    
  } 

//COPIA UN FICHERO, SI EL NUEVO EXISTE NO LO HACE Y DEVUELVE FALSE
bool CopyFile (char *oldfile, char *newfile)
  {
  if (FileExists (oldfile) == false) return false;
  if (FileExists (newfile) == true)  return false;
  char buffer[CMAXBUFFER];
  FILE *FR, *FW;   
  int sz, leido, res1, res2; 
  sz = FileSize (oldfile);
  FR = fopen (oldfile, "r"); FW = fopen (newfile, "w");
  if ((FR == NULL) || (FW == NULL)) return false;
  int totalleido = 0, porleer;
  bool PRIMER = false;
  while (!feof(FR) && (PRIMER == false))
    {
    if (totalleido + CMAXBUFFER <= sz) porleer = CMAXBUFFER;
    else {porleer = sz - totalleido; PRIMER = true;}
    leido = fread (buffer, 1, porleer, FR);
    totalleido += leido;
    fwrite (buffer, 1, (int)leido, FW);
    }
  res1 = fclose (FR);  
  res2 = fclose (FW);
  if ((res1 == EOF) || (res2 == EOF)) return false;
  return true;
  }  

//COPIA SIEMPRE UN FICHERO, SI EL NUEVO EXISTE LO COPIA PONIENDOLE UN PREFIJO
bool CopyFileWin (char *oldfile, char *newfile)
  {
  TBuffer xnewfile;
  char buffer[CMAXBUFFER];
  FILE *FR, *FW;   
  int ppos, i, sz, leido, res1, res2; 
  XString XS; 
       
  xstrncpy (xnewfile, CMAXBUFFER, newfile);
  if (FileExists (oldfile) == false) return false;
  if (FileExists (xnewfile) == true) 
    {
    ppos = 0;
    XS = newfile;
    for (i = 0; i < (signed)strlen (newfile); ++i) {if (newfile[i] == '/') ppos = i;}
    i = 1;
    do
      {
      xsnprintf (xnewfile, CMAXBUFFER, "%s/Copy_%d_%s", 
                 XS.substring(0, ppos).cstr(), i, XS.substring(ppos + 1).cstr());
      ++i;
      }
    while (FileExists (xnewfile) == true);
    }
  sz = FileSize (oldfile);
  FR = fopen (oldfile, "r"); FW = fopen (xnewfile, "w");
  if ((FR == NULL) || (FW == NULL)) return false;
  int totalleido = 0, porleer;
  bool PRIMER = false;
  while (!feof(FR) && (PRIMER == false))
    {
    if (totalleido + CMAXBUFFER <= sz) porleer = CMAXBUFFER;
    else {porleer = sz - totalleido; PRIMER = true;}
    leido = fread (buffer, 1, porleer, FR);
    totalleido += leido;
    fwrite (buffer, 1, (int)leido, FW);
    }
  res1 = fclose (FR);  
  res2 = fclose (FW);
  if ((res1 == EOF) || (res2 == EOF)) return false;
  return true;
  }
    
//COPIA UN FICHERO, SI EL NUEVO EXISTE LO SOBRESCRIBE
bool CopyFileOverWrite (const char *oldfile, const char *newfile)
  {
  if (FileExists (newfile) == true) DeleteFile (newfile);
  char buffer[CMAXBUFFER];
  FILE *FR, *FW;   
  int sz, leido, res1, res2; 
  sz = FileSize (oldfile);
  FR = fopen (oldfile, "r"); FW = fopen (newfile, "w");
  if ((FR == NULL) || (FW == NULL)) return false;
  int totalleido = 0, porleer;
  bool PRIMER = false;
  while (!feof(FR) && (PRIMER == false))
    {
    if (totalleido + CMAXBUFFER <= sz) porleer = CMAXBUFFER;
    else {porleer = sz - totalleido; PRIMER = true;}
    leido = fread (buffer, 1, porleer, FR);
    totalleido += leido;
    fwrite (buffer, 1, (int)leido, FW);
    }
  res1 = fclose (FR);  
  res2 = fclose (FW);
  if ((res1 == EOF) || (res2 == EOF)) return false;
  return true;
  }    
  
char *Text2HTML (const char *ast, char *res)
  {
  if (ast == NULL) return res;
  long L, LENORIG, LENNEW, SIZENEW;
  const int INCMEM = 1001;
  char c, letra[2], *pc;
  letra[1] = '\0';
  LENNEW = 0;
  SIZENEW = strlen(ast) + INCMEM;
  pc = (char *) malloc ((uint)SIZENEW);
  pc[0] = '\0';
  
  LENORIG = strlen (ast);
  for (L=0; L < LENORIG; ++L)
    {
    c = ast[L];
    switch (c)
      {                              
      case '\010':  //\n _J
        break;  
      case '\013':  //\r _M
        LENNEW = LENNEW + strlen (HTML_CR);
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}
        xstrncat (pc, SIZENEW, HTML_CR);
        break;  
      case '>':
        LENNEW = LENNEW + strlen (HTML_MAYOR);
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}
        xstrncat (pc, SIZENEW, HTML_MAYOR);
        break;
      case '<':
        LENNEW = LENNEW + strlen (HTML_MENOR);
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}
        xstrncat (pc, SIZENEW, HTML_MENOR);
        break;
      case '"':
        LENNEW = LENNEW + strlen (HTML_DCOMILLAS);
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}        
        xstrncat (pc, SIZENEW, HTML_DCOMILLAS);
        break;        
      case '%':
        LENNEW = LENNEW + strlen (HTML_PORC);
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}        
        xstrncat (pc, SIZENEW, HTML_PORC);
        break;
      case '[':
        LENNEW = LENNEW + strlen (HTML_SQU_OPEN_PAR);
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}        
        xstrncat (pc, SIZENEW, HTML_SQU_OPEN_PAR);
        break;        
      case ']':
        LENNEW = LENNEW + strlen (HTML_SQU_CLOS_PAR);
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}        
        xstrncat (pc, SIZENEW, HTML_SQU_CLOS_PAR);
        break;                
      case char(225): 
        LENNEW = LENNEW + strlen (HTML_aACUTE); 
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}        
        xstrncat (pc, SIZENEW, HTML_aACUTE);
        break;        
      case char(193): 
        LENNEW = LENNEW + strlen (HTML_AACUTE); 
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}        
        xstrncat (pc, SIZENEW, HTML_AACUTE);
        break;        
      case char(233): 
        LENNEW = LENNEW + strlen (HTML_eACUTE); 
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}        
        xstrncat (pc, SIZENEW, HTML_eACUTE);
        break;        
      case char(201): 
        LENNEW = LENNEW + strlen (HTML_EACUTE); 
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}        
        xstrncat (pc, SIZENEW, HTML_EACUTE);
        break;        
      case char(232): 
        LENNEW = LENNEW + strlen (HTML_eGRAVE); 
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}        
        xstrncat (pc, SIZENEW, HTML_eGRAVE);
        break;        
      case char(200): 
        LENNEW = LENNEW + strlen (HTML_EGRAVE); 
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}        
        xstrncat (pc, SIZENEW, HTML_EGRAVE);
        break;        
      case char(242): 
        LENNEW = LENNEW + strlen (HTML_oGRAVE); 
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}        
        xstrncat (pc, SIZENEW, HTML_oGRAVE);
        break;                   
      case char(210): 
        LENNEW = LENNEW + strlen (HTML_OGRAVE); 
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}        
        xstrncat (pc, SIZENEW, HTML_OGRAVE);
        break;                           
      case char(243): 
        LENNEW = LENNEW + strlen (HTML_oACUTE); 
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}        
        xstrncat (pc, SIZENEW, HTML_oACUTE);
        break;                
      case char(211): 
        LENNEW = LENNEW + strlen (HTML_OACUTE); 
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}        
        xstrncat (pc, SIZENEW, HTML_OACUTE);
        break;                        
      default:
        LENNEW = LENNEW + 1;
        if (LENNEW >= SIZENEW) {SIZENEW = SIZENEW + INCMEM; pc = (char *)realloc (pc, (uint)SIZENEW);}      
        letra[0] = c;
        xstrncat (pc, SIZENEW, letra);
        break;  
      }
    }
  res = pc;
  return res;  
  }  
  
bool IsEmpty (const char *pc)
  {
  if (pc == NULL) return true;
  if (strcmp (pc, "") == 0) return true;
  for (xuint i=0; i<strlen(pc); ++i)
    {
    char c;
    c = pc[i];
    if ((c != ' ') && (c != '\t')) return false;
    }
  return true;  
  }
  
bool IsNull (const char *pc)
  {
  if (pc == NULL) return true;
  if (strcmp (pc, "") == 0) return true;
  return false;  
  }  
  
bool IsGoodValidator (int cmd, int validator, int validatorgood, int service, int lastservice)
  {
  if (service != lastservice) {return true;}
  if (validator == validatorgood) {return true;}
  if (
      (cmd == CMD_MAIN_LOGOUT)      || (cmd == CMD_CCLIENT_MB_INDEX) || (cmd == CMD_CCLIENT_MB_SHOW)   ||
      (cmd == CMD_CCLIENT_MB_CHANGE)|| (cmd == CMD_CCLIENT_MB_CREATE)|| (cmd == CMD_MAIN_CONF_ACT)  ||
      (cmd == CMD_CCLIENT_CM)       || (cmd == CMD_CCLIENT_CMNNTP)   || (cmd == CMD_CCLIENT_CM_SEND)   || (cmd == CMD_CCLIENT_CM_CANCEL) ||
      (cmd == CMD_CONFIG)           || (cmd == CMD_CONFIG_CANCEL) || 
      (cmd == CMD_CONFIG_CCLIENT)   || (cmd == CMD_CONFIG_CCLIENT_SAVE) ||
      (cmd == CMD_CONFIG_NNTP)      || (cmd == CMD_CONFIG_NNTP_SAVE)    ||
      (cmd == CMD_CCLIENT_AB)       || 
      (cmd == CMD_CCLIENT_AT_SHOW)  || (cmd == CMD_CCLIENT_AT_SAVE)     || (cmd == CMD_CCLIENT_AT_ERASE)  ||
      (cmd == CMD_SPECIAL_CHECK_COOKIE)
     ) 
      {return true;}
  return false;
  }

void Ltrim (char *linea)
  {
  if (strlen (linea) <= 0) return;
  if (linea[0] != SP) return;
  char *p;
  xuint i, j = 0, ESPACIO = true, L;
  
  L = strlen (linea);
  p = strdup (linea);
  for (i = 0; i < strlen(linea); ++i)
    {
    if (ESPACIO == true)
      {
      if (linea[i] != SP) {ESPACIO = false; p[j] = linea[i]; ++j;}
      }
    else
      {
      p[j] = linea[i];
      ++j;
      }
    }
  p[j] = '\0';  
  xstrncpy (linea, L, p);  
  free (p);
  }
  
void Rtrim (char *linea)
  {
  int L;
  L = strlen (linea);
  if (L <= 0) return;
  if (linea[L - 1] != SP) return;
  int i, ESPACIO = true;
  i = L - 1;
  while ((i >= 0) && (ESPACIO == true)) 
    {
    if (linea [i] != SP) {ESPACIO = false; linea[i + 1] = '\0';}
    --i;
    }
  }
  
void trim  (char *linea)
  {
  Ltrim (linea);
  Rtrim (linea);
  }

//Delete spaces, \n, \r, \t from a pchar
void Rclean (char *linea)
  {
  int L;
  L = strlen (linea);
  if (L <= 0) return;
  int i, ADELANTE = true;
  i = L - 1;
  while ((i >= 0) && (ADELANTE == true)) 
    {
    if ((linea [i] != SP) && (linea [i] != '\n') && (linea [i] != '\r') && (linea [i] != '\t')) 
      {
      ADELANTE = false; linea[i + 1] = '\0';
      }
    --i;
    }
  }

const char *ForceSpace (const char *value)
  {
  if (IsEmpty(value)) return HTML_SP;
  else return value;
  }
  
char *Cut (const char *pc, int maxlong, TBuffer abuf)
  {
  xstrncpy (abuf, CMAXBUFFER, pc);
  if ((xuint)maxlong <= strlen(abuf))
    {
    abuf[maxlong] = '\0';
    }
  return abuf;
  }
  
char *CutSign (const char *pc, int maxlong, const char *signal, TBuffer abuf)
  {
  xstrncpy (abuf, CMAXBUFFER, pc);
  if ((xuint)maxlong <= strlen(abuf))
    {
    abuf[maxlong - strlen(signal)] = '\0';
    xstrncat (abuf, CMAXBUFFER, signal);
    }
  return abuf;
  }

//Coge un intervalo de lineas en el fichero entre x e y
char *getLineFile (const char *flname, int x, int y, TBuffer abuf)
  {
#define CMAXY 100000  
  TBuffer linea;
  FILE *fr;
  int cont, maxy;
  cont = 1;
  XString XS;
  XS = "";
  fr = fopen (flname, "r");
  if (fr == NULL) return "";
  maxy = y;
  if (maxy == -1) maxy = CMAXY;
  while ((fgets (linea, CMAXBUFFER, fr) != NULL) && (cont <= maxy))
    {
    if ((cont >= x) && (cont <= maxy))
      {
      if (maxy != CMAXY) QuitaRetornoCarroDeLinea (linea); 
      XS += linea;
      }
    ++cont;
    }
  fclose (fr);
  if (abuf == NULL)
    {
    return xstrdup (XS.cstr());
    }
  else
    {
    xstrncpy (abuf, CMAXBUFFER, XS.cstr());
    return abuf;
    }
  }

void CreaFileSavedMsg (const char *fn)
  {
  FILE *FW;
  FW = fopen (fn, "w");
  fprintf (FW, "0\n");
  fprintf (FW, "\n");
  fprintf (FW, "\n");   
  fprintf (FW, "\n");   
  fprintf (FW, "\n");   
  fprintf (FW, "\n");
  fclose (FW);  
  }

bool Touch (const char *fn)
  {
  int res;
  FILE *FW;
  FW = fopen (fn, "w");
  if (FW == NULL) return false;
  res = fprintf (FW, "\n");
  if (res != 1) {fclose (FW); return false;}
  res = fclose (FW);  
  if (res != 0) return false;
  return true;
  }
                      
char *MakeTmpName (TBuffer fntmp, int maxlong)
  {
  xstrncpy (fntmp, maxlong, tempnam(TMP, NULL));
  return fntmp;
  }

//Return true if the line will be cutted
bool ConcatLineToLineOfFile (const char *fn, int numlinea, const char *whatadd, const char *sep, int MAX) 
  {
  XString XS;
  int cont;
  bool res;
  FILE *FR, *FW;
  THBuffer linea; 
  TBuffer fntmp;
  MakeTmpName (fntmp, CMAXBUFFER);
  FR = fopen (fn, "r");
  FW = fopen (fntmp, "w");
  res = false;
  cont = 0;
  while (fgets (linea, CMAXHBUFFER, FR) != NULL)
    {
    ++cont;
    QuitaRetornoCarroDeLinea (linea);
    if (cont == numlinea)
      {
      if (!IsEmpty(linea))
        {
        XS  = linea;
        XS += sep;
        XS += whatadd;
        }
      else XS = whatadd;
      if (XS.length() > MAX) {res = true; XS.Cut (MAX);}
      fprintf (FW, "%s\n", XS.cstr());
      }
    else
      {
      fprintf (FW, "%s\n", linea);
      }
    }
  fclose (FW);
  fclose (FR);
  CopyFileOverWrite (fntmp, fn);
  DeleteFile (fntmp);
  return res;
  }
  
int CountChar (char *string, char tocount)
  {
  if (string == NULL) return 0;
  int cont = 0;
  for (xuint i=0; i < strlen(string); ++i)
    {
    if (string[i] == tocount) ++cont;
    }
  return cont;  
  }  
  
pid_t WritePidFile (void)
  {
  pid_t thepid;
  TSBuffer fn;
  FILE *FW;
  thepid = getpid ();
  sprintf (fn, "%s/%s.pid", PIDDIR, PROGNAME);
  FW = fopen (fn, "w");
  fprintf (FW, "%d\n", (unsigned)thepid);
  fclose (FW);     
  return thepid;
  }    
  
void DeletePidFile (void)
  {
  TSBuffer fn;
  sprintf (fn, "%s/%s.pid", PIDDIR, PROGNAME);
  DeleteFile (fn);
  }
  
void DelAllFilesFromDir (char *thedir)
  {
  DIR *dirp;
  struct dirent *dp;
  TBuffer abuf;

  dirp = opendir(thedir);
  if (dirp == NULL) return;
  while ((dp = readdir(dirp)) != NULL) 
    {
    if ((strcmp ("..", dp->d_name) != 0) && (strcmp (".", dp->d_name) != 0))
      {
      sprintf (abuf, "%s/%s", thedir, dp->d_name);
      DeleteFile (abuf);
      }
    }
  (void) closedir(dirp);
  }
  
char *getMailcapTipoFromFilename (const char *fn, const char *fnmailcap)
  {
  if (fn == NULL) return "";
  LINEA linea, exts, tipo, miext;
  FILE *FR;
  FR = fopen (fnmailcap, "r");
  if (FR == NULL) 
    {
    LOG ("Error: Can not open mailcap file:'%s'", fnmailcap);
    return "APPLICATION/OCTET-STREAM";
    }
  xstrncpy (miext, MAXLENGTHLINE, "."); 
  xstrncat (miext, MAXLENGTHLINE, getExtensionFromFile (fn)); 
  xstrncat (miext, MAXLENGTHLINE, ".");
  while (fgets (linea, MAXLENGTHLINE, FR) != NULL) 
    {   
    sscanf (linea, "%s %s", exts, tipo);
    if (NCstrstr (exts, miext) > 0)
      {
      fclose (FR);
      return strdup(tipo);
      }
    }
  fclose (FR);
  return "APPLICATION/OCTET-STREAM";
  } 

void PrintCGILoginPage (const char *lang)
  {
  if (strcmp (lang, "spa") == 0) DumpHTMLPage (HOMEPAGE_SPA, "", stdout);
  else if (strcmp (lang, "val") == 0) DumpHTMLPage (HOMEPAGE_VAL, "", stdout);
  else if (strcmp (lang, "eus") == 0) DumpHTMLPage (HOMEPAGE_EUS, "", stdout);  
  else DumpHTMLPage (HOMEPAGE_ENG, "", stdout);
  }  

void DumpHTMLPage (const char *fn, const char *progparm1, FILE *Foutput)
  {
  if (fn == NULL) return;
  LINEA linea;
  char c, CHARCOMMAND = '^';
  int ires;
  
  fflush (Foutput);
  ires = fprintf (Foutput, "%s", "Pragma: no-cache\n");
  fprintf (Foutput, "%s", "Cache-Control: no-cache\n");
  fprintf (Foutput, "%s", "Expires: Thu, 01 Dec 1994 16:00:00 GMT\n");
  fprintf (Foutput, "%s", "Content-type: text/html\n\n");   
  fflush (Foutput); 
  FILE *FR;
  FR = fopen (fn, "r");
  if (FR == NULL) return;
  while (fgets (linea, MAXLENGTHLINE, FR) != NULL) 
    {   
    if (strcmp (linea, "") != 0)
      {
      c = linea[0];
      if (c == CHARCOMMAND)
        {
        TSBuffer charcommand, command, parm1;
        sscanf (linea, "%s %s %s", charcommand, command, parm1);
        if (strcmp (command, "INC") == 0)
          {
          FILE *f;
          TBuffer abuf;
          if (FileExists (parm1) == true)
            {
            f = fopen (parm1, "r");
            if (f != NULL)
              {
              while (fgets (abuf, CMAXBUFFER, f) != NULL)
                {
                fprintf (Foutput, "%s", abuf);
                }
              fclose (f);
              }
            }  
          }
        if (strcmp (command, "MAILTO") == 0)
          {
          TBuffer abuf;
          xsnprintf (abuf, CMAXBUFFER, " <A HREF=\"%s/%s/cm/noop/_/%s/_/_/_/_/%s/Postman/Postman/\">%s</A> ", PATH_CGI, SERVICE_CCLIENT, progparm1, parm1, parm1);
          fprintf (Foutput, "%s", abuf);
          }          
        }
      else
        {
        fprintf (Foutput, "%s", linea);
        }
      }
    }
  fclose (FR);
  fflush (Foutput);
  }
          
long min (long i, long j)
  {
  return ((i < j) ? i : j);
  }

int imin (int i, int j)
  {
  return ((i < j) ? i : j);
  }
  
void XTICK (char *label)
  {
  static struct tms T0 = {0,0,0};
  struct tms T1;
  times (&T1); 
  if (label != NULL) {LOG ("%s TIME WASTED: User=%ld System=%ld", label, T1.tms_utime - T0.tms_utime, T1.tms_stime - T0.tms_stime);}
  T0 = T1;
  }

void PChar2SL (char *chunk, StringList *SL)
  {
  int cont, i;
  char c, letra[2];
  XString Ad;
  letra[1] = '\0';
  SL->Clear();
  Ad = "";
  cont = -1;
  for (i = 0; i < (xsint)strlen(chunk); ++i)
    {
    ++cont;
    c = chunk[i]; 
    letra[0] = c;
    switch (c)
      {
      case '\t':
      case ' ':
           {
           if (cont == 0)
             {
             Ad = SL->getString(SL->Count() - 1);
             Ad.Cut (Ad.length() - 2);
             SL->removeElementAt (SL->Count() - 1);
             }
           else
             {
             Ad += " ";
             if (i == (xsint)strlen(chunk) - 1) 
               {
               Ad += "\r\n"; 
               SL->Add(Ad);
               }
             }  
           break;
           }
      case '\r': 
           break;
      case '\n': 
           cont = -1;
           Ad += "\r\n";
           SL->Add(Ad);
           Ad = "";        
           break;
      default:
           Ad += letra;
           if (i == (xsint)strlen(chunk) - 1) 
             {
             Ad += "\r\n"; 
             SL->Add(Ad);
             }
           break;
      }
    }
  int pos = -1;  
  for (i = 0; i < SL->Count(); ++i)
    {
    Ad = XString(SL->getString(i)).toUpperCase();
    if (strstr(Ad.cstr(), "CONTENT-TRANSFER-ENCODING:") != NULL) pos = i;
    }      
  if (pos > -1) SL->removeElementAt (pos);  
  }
                
void ResaltaURLsEnText (char *txt, XSocket *aXS, int MaxLongLine, bool IsUencoded, TBuffer urltouudecode)
  {
  const unsigned int MAXPALABRA = 1000;
  int INCR, sizeorig, contlonglinea, cont_uuencoded = 0;
  int pos_initxt;
  char c, letra[2], palabra[MAXPALABRA + 1];
  TBuffer abuf;
  bool BeginUencodedAlcanzado = false, RecienAlcanzadoEndUuencoded = false;

  sizeorig = strlen (txt);
  INCR = (int)((float)sizeorig * (float)(5.0 / 100.0));  if (INCR <= 1000) INCR = 1000;
  letra[1] = '\0';
  palabra[0] = '\0';
  contlonglinea = 0;
  for (pos_initxt = 0; pos_initxt < sizeorig; ++pos_initxt)
    {
    ++contlonglinea;
    if (IsMultiplo (contlonglinea, MaxLongLine) == true) {contlonglinea=0; aXS->Write ("\n", 1);}
    c = txt[pos_initxt];
    switch (c)
      {
      case '\r':
      case '\n': contlonglinea = 0;
      case ' ' :
      case '\t':
      case '(' :
      case ')' :
      case '<' :
      case '>' :
      //There are urls with that char-->   case ',' :
      case '\"':
        {
        if (strlen(palabra) > 0)
          {
          if (IsUencoded == true)
            {
            if (((strcmp (palabra, "begin") == 0) && (BeginUencodedAlcanzado == false)) ||
                ((strcmp (palabra, "begin-base64") == 0) && (BeginUencodedAlcanzado == false)))
              {
              ++cont_uuencoded;
              
              TBuffer linea, abuf2, abuf3;
              int ppos, mode;
              char c2, letra2[2];
              
              letra2[1] = '\0';
              initStr (linea);
              ppos = pos_initxt; 
              c2 = txt[ppos]; letra2[0] = c2;
              while ((ppos < sizeorig) && (c2 != '\n'))
                {
                xstrncat (linea, CMAXBUFFER, letra2);
                ++ppos;
                c2 = txt[ppos];
                letra2[0] = c2;
                }
              sscanf (linea, "%o %[^]]s", &mode, abuf2);  
              
              sprintf (abuf3, L->get(L_DISPLAY_UUENCODED), abuf2);
              BeginUencodedAlcanzado = true;
              sprintf (abuf, "%s%d/\">%s</A><BR>\n", urltouudecode, cont_uuencoded, abuf3);
              aXS->Write (abuf, (uint)strlen(abuf));
              }
            if ((strcmp (palabra, "end") == 0) && (BeginUencodedAlcanzado == true))
              {
              BeginUencodedAlcanzado = false;
              RecienAlcanzadoEndUuencoded = true;
              }                            
            }
          if ((strncasecmp (palabra, "http://",  7) == 0)  || (strncasecmp (palabra, "ftp://",  6) == 0) ||
              (strncasecmp (palabra, "https://", 8) == 0)  || (strncasecmp (palabra, "mailto:", 7) == 0) ||
              (strncasecmp (palabra, "news://",  7) == 0))
            {
            sprintf (abuf, "<A HREF=\"%s\">%s</A>", palabra, palabra);
            }           
          else 
            {
            xstrncpy (abuf, CMAXBUFFER, palabra);
            }
          if (BeginUencodedAlcanzado == false) 
            {
            if (RecienAlcanzadoEndUuencoded == false) aXS->Write (abuf, (uint)strlen(abuf)); 
            RecienAlcanzadoEndUuencoded = false;
            }
          }
        if (c == '<')
          {
          if (BeginUencodedAlcanzado == false) aXS->Write (HTML_MENOR, (uint)strlen(HTML_MENOR));
          }
        else if (c == '>')
          {
          if (BeginUencodedAlcanzado == false) aXS->Write (HTML_MAYOR, (uint)strlen(HTML_MAYOR));
          }
        else
          {    
          letra[0] = c; 
          if (BeginUencodedAlcanzado == false) aXS->Write (letra, (uint)strlen(letra));
          }
        palabra[0] = '\0';          
        break;
        }
      default:
        {                  
        if (strlen(palabra) >= MAXPALABRA - 1)
          {
          if ((strncasecmp (palabra, "http://",  7) == 0)  || (strncasecmp (palabra, "ftp://",  6) == 0) ||
              (strncasecmp (palabra, "https://", 8) == 0)  || (strncasecmp (palabra, "mailto:", 7) == 0) ||
              (strncasecmp (palabra, "news://",  7) == 0))
            {
            sprintf (abuf, "<A HREF=\"%s\">%s</A>", palabra, palabra);
            }
          else xstrncpy (abuf, CMAXBUFFER, palabra);
          if (BeginUencodedAlcanzado == false) aXS->Write (abuf, (uint)strlen(abuf)); 
          palabra[0] = '\0';
          }
        letra[0] = c; 
        xstrncat (palabra, MAXPALABRA, letra);
        break;
        }
      }
    }  
  if (strlen(palabra) > 0)
    {
    if ((strncasecmp (palabra, "http://",  7) == 0)  || (strncasecmp (palabra, "ftp://",  6) == 0) ||
        (strncasecmp (palabra, "https://", 8) == 0)  || (strncasecmp (palabra, "mailto:", 7) == 0) ||
        (strncasecmp (palabra, "news://",  7) == 0))
      {
      sprintf (abuf, "<A HREF=\"%s\">%s</A>", palabra, palabra);
      }
    else xstrncpy (abuf, CMAXBUFFER, palabra);
    aXS->Write (abuf, (uint)strlen(abuf));
    }
  }  
    
//Devuelve true si dividendo es un multiplo de divisor
bool IsMultiplo (int dividendo, int divisor)
  {
  if (dividendo % divisor == 0.0) return true;
  else return false;
  }  
  
//Una implementation, ma o menos, de sscanf para que separe los tokens con quoting ""
void xscanf (const char *linea, 
             char *c0,
             int *int1, int *int2, int *int3, 
             char *c1, char *c2, 
             int *int4, 
             char *c3, char *c4, char *c5, char *c6, char *c7, char *c8, char *c9)
  {
#define MODO_COM 0
#define MODO_ESP 1  
  TBuffer palabra;
  char c, letra[2];
  int L, i, MODO;
  StringList *SL;    
  
  MODO = MODO_ESP;
  letra[1] = '\0';
  initStr (palabra);
  SL  = new StringList ();
  L = strlen (linea);
  for (i=0; i<L; ++i)
    {
    c = linea[i]; 
    letra[0] = c;
    switch (c)
      {
      case '\"': 
        {
        if (MODO == MODO_COM)
          {
          if (strcmp (palabra, "") != 0) 
            {
            SL->Add(palabra);
            initStr (palabra);
            }
          MODO = MODO_ESP;  
          }
        else 
          {
          MODO = MODO_COM;
          }        
        break;
        }
      case ' ': 
        {
        if (MODO == MODO_ESP)
          {
          if (strcmp (palabra, "") != 0) 
            {
            SL->Add(palabra);
            initStr (palabra);
            }
          }
        else 
          {
          xstrncat (palabra, CMAXBUFFER, letra);
          }
        break;
        }
      default:
        {
        xstrncat (palabra, CMAXBUFFER, letra);               
        }
      }
    }
  if (strcmp (palabra, "") != 0) {SL->Add(palabra);}  
    
  for (i = 0; i < SL->Count(); ++i)
    {
    switch (i)
      {                                                                                  
      case  0: xstrncpy (c0, CSMALLBUFFER, SL->getString(i).cstr()); break;                    
      case  1: *int1 = xatoidef (SL->getString(i).cstr(), 0); break;
      case  2: *int2 = xatoidef (SL->getString(i).cstr(), 0); break;              
      case  3: *int3 = xatoidef (SL->getString(i).cstr(), 0); break;              
      case  4: if (c1 != NULL) {xstrncpy (c1, CSMALLBUFFER, SL->getString(i).cstr());} break;        
      case  5: if (c2 != NULL) {xstrncpy (c2, CSMALLBUFFER, SL->getString(i).cstr());} break;          
      case  6: *int4 = xatoidef (SL->getString(i).cstr(), 0); break;                  
      case  7: if (c3 != NULL) {xstrncpy (c3, CSMALLBUFFER, SL->getString(i).cstr());} break;                      
      case  8: if (c4 != NULL) {xstrncpy (c4, CSMALLBUFFER, SL->getString(i).cstr());} break;                      
      case  9: if (c5 != NULL) {xstrncpy (c5, CSMALLBUFFER, SL->getString(i).cstr());} break;              
      case 10: if (c6 != NULL) {xstrncpy (c6, CSMALLBUFFER, SL->getString(i).cstr());} break;              
      case 11: if (c7 != NULL) {xstrncpy (c7, CSMALLBUFFER, SL->getString(i).cstr());} break;              
      case 12: if (c8 != NULL) {xstrncpy (c8, CSMALLBUFFER, SL->getString(i).cstr());} break;                    
      case 13: if (c9 != NULL) {xstrncpy (c9, CSMALLBUFFER, SL->getString(i).cstr());} break;                          
      }
    }  

  delete SL;
  }  
  
char *ProcesaDate (char *tmp, TBuffer abuf)
  {
  char c, letra[2];
  int L, i, cont, nowyear, dateyear;
  TSBuffer smalltmp, nuevafecha, dia, mes, anyo, resto;
  time_t now; 
  struct tm *xtm;  
  now = time (NULL);
  xtm = localtime (&now);
  nowyear = xtm->tm_year + 1900;
  letra[1] = '\0';
  L = strlen (tmp);
  cont = 0;
  initStr(nuevafecha); initStr (dia), initStr (mes); initStr (anyo); initStr(resto);

  for (i = 0; i < L; ++i)
    {
    c = tmp[i];
    letra[0] = c;
    if (c == '-') {++cont;}                   // Count the hyphens in " 8-Sep-2000"
    else if ((c == ' ') && (i > 0)) {++cont;} // Skip any spaces, but not if it was in tmp[0].
                                        // For the first space, insert two &nbsp;
                                        // This used to be one &nbsp; but with proportional
                                        // spaced fonts, I find two spaces is about the
                                        // same width as a printable character space. 
    else if ((c == ' ') && (i == 0))
      {  
      xstrncat (dia, CSMALLBUFFER, HTML_HSP);
      xstrncat (dia, CSMALLBUFFER, HTML_HSP);
      } 
    else
      {
      switch (cont)
        {
        // Collect the day, month and year in separate strings.
        case 0: xstrncat (dia, CSMALLBUFFER, letra); break; 
        case 1: xstrncat (mes, CSMALLBUFFER, letra); break; 
        case 2: xstrncat (anyo, CSMALLBUFFER, letra); break; 
        // Collect everything else here: 08:51:13+0100
        default: xstrncat (resto, CSMALLBUFFER, letra); break; 
        }
      }
    }
  dateyear = xatoidef ((const char *)anyo, 2000);  

  xstrncat (nuevafecha, CSMALLBUFFER, dia);  
  xstrncat (nuevafecha, CSMALLBUFFER, "-"); 
  xstrncat (nuevafecha, CSMALLBUFFER, mes); 
                
  // If the message is not from this year, output the year preceded by "-".  
  if (nowyear != dateyear) 
    {
    xstrncat (nuevafecha, CSMALLBUFFER, "-"); 
    xstrncat (nuevafecha, CSMALLBUFFER, anyo); 
    }
  else
    {
    // Now we want to output the first 5 chars of everything else, which is typically
    // the time, but first output two spaces.
    if (DISPLAY_MSG_TIME_IN_INDEX == 1)
      {
      xstrncat (nuevafecha, CSMALLBUFFER, HTML_HSP);
      xstrncat (nuevafecha, CSMALLBUFFER, HTML_HSP);
      xstrncat (nuevafecha, CSMALLBUFFER, "("); 
      xstrncpy (smalltmp, 6, resto); 
      xstrncat (nuevafecha, CSMALLBUFFER, smalltmp); 
      xstrncat (nuevafecha, CSMALLBUFFER, ")");
      xstrncat (nuevafecha, CSMALLBUFFER, HTML_HSP);    
      xstrncat (nuevafecha, CSMALLBUFFER, HTML_HSP);    
      xstrncat (nuevafecha, CSMALLBUFFER, HTML_HSP);    
      xstrncat (nuevafecha, CSMALLBUFFER, HTML_HSP);    
      }
    }
  xstrncpy (abuf, CMAXBUFFER, nuevafecha);  
  return abuf;
  }  
  
int GetBufferFromFile (char *afile, char *abuf, int maxlength)
  {
  TBuffer linea;
  int cont = 0;
  FILE *fr;
  
  initStr (abuf);
  fr = fopen (afile, "r");
  if (fr == NULL) {return 0;}
  while (fgets (linea, CMAXBUFFER, fr) != NULL)
    {
    cont = cont + strlen (linea);
    if (cont < maxlength) 
      {
      xstrncat (abuf, maxlength, linea);
      }
    else {fclose (fr); return cont - strlen (linea);}
    }
  fclose (fr);  
  return cont;
  }
  
char *bool2char (bool b)
  {
  if (b == true) return "1"; else return "0";
  }
  
bool char2bool (char *c)
  {
  if (c == NULL) return false;
  if (strcmp (c, "0") == 0) return false; else return true;  
  }  

int getNumChilds (void)
  {
  int ires;
  FILE *FR;
  char abuf[500 + 1];

  initStr (abuf);
  FR = popen(CMDNUMCHILDS, "r");
  if (FR != NULL)
    {
    //Only must get one line.
    while (fgets (abuf, 500, FR) != NULL) {/*NOTHING HERE*/};
    pclose (FR);
    FR = fopen (TMPSERVERCOUNT, "r");
    if (FR == NULL) {LOG ("Error opening '%s'", TMPSERVERCOUNT); return -1;}
    fgets (abuf, 500, FR);
    fclose (FR);
    QuitaRetornoCarroDeLinea(abuf);
    trim(abuf);
    ires = xatoidef (abuf, -1);
    }
  else 
    {
    ires = -1; 
    LOG ("Error haciendo popen!\n");
    }
  return ires;
  }
  
int SeparaTokensEnStringList (const char *pc, const char sep, StringList *SL)
  {
  XString XS;
  char c; 
  int counter = 0;
  
  SL->Clear();
  XS = "";
  for (int i = 0; (unsigned int)i < strlen(pc); ++i)
    {
    c = pc[i];
    if (c == sep)
      {   
      if (XS.length() > 0) {++counter; SL->Add (XS.cstr());}
      XS = "";
      }
    else
      {
      XS += c;
      }
    }
  if (XS.length() > 0) {++counter; SL->Add (XS.cstr());}
  return counter;
  }  
  
int CountTokensEnString (const char *pc, const char sep)
  {
  XString XS;
  char c; 
  int counter = 0;
  
  for (int i = 0; (unsigned int)i < strlen(pc); ++i)
    {
    c = pc[i];
    if (c == sep)
      {   
      if (XS.length() > 0) {++counter;}
      XS = "";
      }
    else
      {
      XS += c;
      }
    }
  if (XS.length() > 0) {++counter;}
  return counter;
  }    
  
//Extract addresses cutting by <>. Gap is ,
void ExtraeAddresses (StringList *SL, char *linea, bool ClearSL)
  {
  int menor, mayor;
  char c, letra[2];
  XString Ad;
  bool iniciocom = false;
  
  letra[1] = '\0';
  if (ClearSL == true) {SL->Clear();}
  Ad = "";
  for (int i = 0; i < (xsint)strlen(linea); ++i)
    {
    c = linea[i]; 
    letra[0] = c;
    switch (c)
      {
      case '"':
            { 
            if (iniciocom == false) {iniciocom = true;} else {iniciocom = false;}
            break;
            }
      case ',': 
           {
           if (iniciocom == false)
             {
             if (Ad.length() > 0)
               {
               menor = Ad.indexOf ('<'); mayor = Ad.indexOf ('>');
               if ((menor >= 0) && (mayor >= 0)) {SL->Add(Ad.substring(menor, mayor + 1));}
               else SL->Add(Ad);
               Ad = "";        
               }
             }
           else
             {
             Ad += letra;
             }  
           break;
           }
      default:
           {
           Ad += letra;
           break;
           }
      }
    }
  if (Ad.length() > 0) 
    {
    menor = Ad.indexOf ('<'); mayor = Ad.indexOf ('>');
    if ((menor >= 0) && (mayor >= 0)) {SL->Add(Ad.substring(menor, mayor + 1));}
    else SL->Add(Ad);
    Ad = "";            
    }
  }  
  
//Extract full addresses. Gap is ,
void ExtraeFullAddresses (StringList *SL, const char *linea, bool ClearSL)
  {
  char c, lastletra, letra[2];
  XString Ad;
  letra[1] = '\0';
  if (ClearSL == true) {SL->Clear();}
  Ad = "";
  lastletra = ' '; c = ' ';
  for (int i = 0; i < (xsint)strlen(linea); ++i)
    {
    lastletra = c;
    c = linea[i]; 
    if ((c != ' ') || (lastletra != ' '))
      {
      letra[0] = c;
      switch (c)
        {
        case ',': 
             if (Ad.length() > 0) 
               {
               if (SL->indexOf(Ad) < 0) {SL->Add(Ad);}
               Ad = "";        
               }
             break;
        default:
             Ad += letra;
             break;
        }
      }  
    }
  if (Ad.length() > 0) 
    {
    if (SL->indexOf(Ad) < 0) {SL->Add(Ad);}
    Ad = "";            
    }
  }    
  
//Must I show the ReplyAll button?
bool MustDoReplayAll (const char *ato, const char *afrom, const char *areplyto, const char *acc)
  {
  if (((strcmp(areplyto, "") != 0) && (strcmp (areplyto, afrom) != 0)) || 
      (strcmp(acc, "") != 0) || 
      (strchr (ato, ',') != NULL))
    return true;
  else
    return false;  
  }

//Reply to fields FROM, REPLYTO, CC and TO multiples
char *getReplyAllAddresses (const char *ato, const char *afrom, const char *areplyto, const char *acc)
  {
  StringList SL;
  XString AllAddresses;
  
  ExtraeFullAddresses (&SL, afrom, false);
  if (strchr (ato, ',') != NULL) {ExtraeFullAddresses (&SL, ato, false);}
  if (strcmp (areplyto, afrom) != 0) {ExtraeFullAddresses (&SL, areplyto, false);}
  ExtraeFullAddresses (&SL, acc, false);
  for (int i=0; i<SL.Count(); ++i) 
    {
    if (AllAddresses.length() + strlen (SL.getString(i).cstr()) + 1 < MAXLENGTH_TO)
      {
      AllAddresses += SL.getString(i).cstr(); 
      if (i < SL.Count() - 1) {AllAddresses += ",";}
      }
    }
  return xstrdup (AllAddresses.cstr());   
  } 
  
int xvsnprintf(char *str, size_t size, const char *fmt, va_list ap)
  {
#ifdef HAVE_VSNPRINTF  
  return vsnprintf(str, size, fmt, ap);
#else
  return vsprintf(str, fmt, ap);
#endif
  }

int xsnprintf(char *str, size_t size, const char *fmt, ...)
  {
  int ret;
  va_list args;
  va_start (args, fmt);
#ifdef HAVE_VSNPRINTF  
  ret = vsnprintf(str, size, fmt, args);
#else
  ret = vsprintf(str, fmt, args);
#endif
  va_end (args);
  return ret;
  }
  
void DisableHTMLTokens (char *htmltxt)
  {
  char *pc;
  pc = strstr (htmltxt, "<STYLE>");   if (pc != NULL) {htmltxt[pc - htmltxt + 1] = 'x';}
  pc = strstr (htmltxt, "</STYLE>");  if (pc != NULL) {htmltxt[pc - htmltxt + 1] = 'x';}  
  pc = strstr (htmltxt, "<HTML>");    if (pc != NULL) {htmltxt[pc - htmltxt + 1] = 'x';}
  pc = strstr (htmltxt, "<BODY ");    if (pc != NULL) {htmltxt[pc - htmltxt + 1] = 'x';}  
  pc = strstr (htmltxt, "</BODY>");   if (pc != NULL) {htmltxt[pc - htmltxt + 2] = 'x';}    
  pc = strstr (htmltxt, "</HTML>");   if (pc != NULL) {htmltxt[pc - htmltxt + 2] = 'x';}  
  }

// Expect something like:
// 2 APPLICATION/OCTET-STREAM 27326 bytes, "This is a comment", "SYSTEM 3.doc"
// 2 IMAGE/JPEG 441362 bytes, "", "alba,k.JPG"
// and we want to return the last field or a default filename
char *get_filename (const char *str)
  { 
  int begin, end;
  TBuffer fn;  
  XString xs;
  
  xs = XString(str).substring(1);
  xstrncpy (fn, CMAXBUFFER, xs.substring(0, xs.indexOf (" ")).cstr());
  xstrncat (fn, CMAXBUFFER, ".att");
  begin = xs.lastIndexOf ("\", \"");
  end   = xs.lastIndexOf ("\"");
  if ((begin == -1) || (end == -1)) 
    {
    //NOTHING
    }
  else
    {  
    xstrncpy (fn, CMAXBUFFER, xs.substring(begin + strlen("\", \""), end).cstr());
    }
  xs = XString(fn); 
//  xs.replace (" ", "%20"); 
  xs.replace (" ", "_");
  xstrncpy (fn, CMAXBUFFER, xs.cstr());
  return xstrdup(fn);  
  }

//Merge two StringList in one 
int MergeStringList (StringList *SLBase, StringList *SL2Merge, bool check_exists)
  {
  int counter = 0;
  for (int i = 0; i < SL2Merge->Count (); ++i)
    {
    if (check_exists == true) //TO AVOID DUPLICATES
      {
      //DEBUG ("--%s--", SL2Merge->getString(i).cstr());
      if (SLBase->indexOf(SL2Merge->getString(i).cstr()) == -1) 
        {
        ++counter;
        SLBase->Add (SL2Merge->getString(i).cstr());
        }
      }
    else
      {
      ++counter;
      SLBase->Add (SL2Merge->getString(i).cstr());
      }
    }
  return counter;  
  }

//Routine for display memory usage.
void MEMLOG (char *LineInfo)
  {
  StringList *SL;
  TBuffer procfn, linea;
  int pid;
  FILE *FR;
  
  pid = getpid();
  sprintf (procfn, "/proc/%d/status", pid);
  SL = new StringList ();  
  FR = fopen (procfn, "r");
  while (fgets (linea, CMAXBUFFER, FR) != NULL) {SL->Add (linea);}
  fclose (FR);
  DEBUG ("%s", LineInfo);
  /*
  VmSize:   3724 kB
  VmLck:       0 kB
  VmRSS:    1664 kB
  VmData:    536 kB
  VmStk:      84 kB
  VmExe:     992 kB
  VmLib:    1992 kB
  */
  for (int i=0; i < SL->Count(); ++i)
    {
    if ((NCstrstr (SL->getString(i).cstr(), "VmSize") > 0)  ||
        (NCstrstr (SL->getString(i).cstr(), "VmRSS")  > 0)  ||
        (NCstrstr (SL->getString(i).cstr(), "VmData") > 0))
      {
      DEBUG ("   pid=%d, %s", pid, SL->getString(i).cstr());
      }
    }
  delete SL;    
  }
 
int string_matching (const char *s, const char *w, int slen)
  {
  while (*w)
    {
    if (*s == 0)
      {
      if (*w == '*')
        {
        w++;
        continue;
        }
      return 0;
      }
    else if (*w == *s)
      {
      w++;
      s++;
      slen--;
      }
    else if (*w == '#')
      {
      if (*s == 0) return 0;
      if (*s >= '0' && *s <= '9')
        {
        s++;
        slen--;
        w++;
        }
      else return 0;
      }
    else if (*w == '?')
      {
      if (*s == 0) return 0;
      s++;
      slen--;
      w++;
      }
    else if (*w == '*')
      {
      w++;
      if (*w == 0) return 1;
      while (*w)
        {
        if (string_matching(s, w, slen)) return 1;
        if (slen == 0 || *s == 0) break;
        s++;
        slen--;
        }
      break;
      }
    else return 0;
    }
  if (*w != 0) return 0;
  if (slen != 0 && *s != 0) return 0;
  return 1;
  }

bool StringsLike (const char *text, const char *wildcard)
  {
  /*usage: if (StringsLike("gtestasdfasdf", "?test*")) printf ("matching"); else printf ("not matching");*/    
  if (!text || !wildcard) return false;
  if (string_matching(text, wildcard, strlen(text)) == 0) return false; else return true;
  }

bool SavePchar (const char *pc, int len, const char *fn)
  {
  int fd;
  fd = open (fn, O_WRONLY | O_CREAT, 0600);
  if (fd < 0) return false;
  if (write (fd, pc, len) != len) return false;      
  if (close (fd) != 0) return false;
  return true;
  } 

char *c2x (unsigned char letra, TNumber anum)
  {             
  xsnprintf (anum, CMAXNUMBER, "%X", (unsigned int)letra);
  return anum;
  }

//\x00-\x20"#%/;<>?\x7F-\xFF
char *escape_url (const char *source, TBuffer dest)
  {
  TNumber anum;
  unsigned char letra;
  unsigned char stletra[2];
  stletra[1] = '\0';
  initStr (dest);
  for (int i=0; i < (signed)strlen(source); ++i)
    {
    letra = source[i];
    stletra[0] = letra;
    if (letra == ' ') 
      {
      xstrncat (dest, CMAXBUFFER, "+");
      }
    else if ((letra == '"') || (letra == '#') || (letra == '%') || (letra == ';')  || (letra == '/')  || (letra == '<')  || (letra == '>') || 
             (letra == '?'))
      {
      xstrncat (dest, CMAXBUFFER, "%"); 
      xstrncat (dest, CMAXBUFFER, c2x(letra, anum)); 
      }         
    else if (((letra > 0x00) && (letra <= 0x20)) || ((letra >= 0x7F) && (letra <= 0xFF)))
      {
      xstrncat (dest, CMAXBUFFER, "%"); 
      xstrncat (dest, CMAXBUFFER, c2x(letra, anum)); 
      }
    else 
      {
      xstrncat (dest, CMAXBUFFER, (char *)stletra); 
      }
    }
  return dest;
  }

char x2c(char *what)
  {
  register char digit;
  digit = (what[0] >= 'A' ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
  digit *= 16;
  digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));
  return(digit);
  }

void utils_unescape (char *value)
  {
  register int x, y;
  for (x=0, y=0; value[y]; ++x, ++y) 
    {
    if((value[x] = value[y]) == '%') 
      {
      value[x] = x2c(&value[y+1]);
      y+=2;
      }
    }
  value[x] = '\0';
  }

const char *cgienv_GetVarSeparator (const char *fnenv, TBuffer Sep)
  {
  char *p;
  FILE *fr;
  fr = fopen (fnenv, "r");
  if (fr == NULL) {initStr(Sep); return Sep;}
  fgets (Sep, CMAXBUFFER, fr);
  fclose (fr); 
  QuitaRetornoCarroDeLinea (Sep);
  //_SEP_=CONTENT_LENGTH
  p = strchr(Sep, '=');
  if (p == NULL)
    {
    initStr (Sep);
    }
  else
    {
    Sep[p - Sep] = '\0';
    } 
  return Sep;         
  }

//Return the value of a simple cgi var (in one line only)
const char *cgienv_GetSimpleVar (const char *fnenv, const char *EnvVarname, TBuffer abuf, bool DeleteComillas)
  {
  FILE *fr;
  XString xs;
  TBuffer Sep, linea;

  initStr (abuf);
  xs = cgienv_GetVarSeparator(fnenv, Sep); xs += "="; xs += EnvVarname;
  fr = fopen (fnenv, "r");
  if (fr == NULL) {initStr(abuf); return abuf;}
  bool ENCONTRADO = false;
  while ((fgets (linea, CMAXBUFFER, fr) != NULL) && (ENCONTRADO == false))
    {
    QuitaRetornoCarroDeLinea (linea);
    if (strcmp (linea, xs.cstr()) == 0)
      {
      ENCONTRADO = true;
      fgets (linea, CMAXBUFFER, fr);
      QuitaRetornoCarroDeLinea (linea);
      if (DeleteComillas == true)
        {
        if ((linea[0] == '"') & (linea[strlen(linea) - 1] == '"'))
          {
          int L = strlen (linea);
          for (int i = 0; i < L - 2; ++i) {linea[i] = linea [i + 1];}
          linea[L - 2] = '\0';
          }
        }
      xstrncat (abuf, CMAXBUFFER, linea);
      }
    }    
  fclose (fr);  
  return abuf;
  }

//Return all the simple input cgi vars (in one line only)
//       Return something like "pepe=1&eat=apple"
const char *cgienv_GetAllSimpleVarINPUTPC (const char *fnenv, TBuffer abuf, bool DeleteComillas)
  {
  FILE *fr;
  XString xs;
  int ppos, num_token = 0, num_linea_en_token = 0;
  TBuffer Sep, linea, nomvar;
  bool ACABADO = false, EncontradoLineaSep = false;

  initStr (abuf);
  xs = cgienv_GetVarSeparator(fnenv, Sep); xs += "="; 
  fr = fopen (fnenv, "r");
  if (fr == NULL) {initStr(abuf); return abuf;}
  while ((fgets (linea, CMAXBUFFER, fr) != NULL) && (ACABADO == false))
    {
    if (EncontradoLineaSep == true)
      {
      ppos = Cstrstr (linea, xs.cstr());
      if (ppos == 1)
        {
        ++num_token;
        num_linea_en_token = 0;
        xstrncpy (nomvar, CMAXBUFFER, linea + strlen(xs.cstr()));
        QuitaRetornoCarroDeLinea (nomvar);
        if (strcmp (nomvar, "LAST_LINE") == 0) 
          {
          ACABADO = true;
          }
        else
          {
          if (num_token > 1) {xstrncat (abuf, CMAXBUFFER, "&");}     
          xstrncat (abuf, CMAXBUFFER, nomvar);
          xstrncat (abuf, CMAXBUFFER, "=");
          }
        }
      else
        {
        TBuffer linea2;
        ++num_linea_en_token; 
        xstrncpy (linea2, CMAXBUFFER, linea);       
        QuitaRetornoCarroDeLinea (linea2);
        if (IsEmpty(linea2)) 
          {
          xstrncat (abuf, CMAXBUFFER, linea);
          }
        else
          {  
          xstrncat (abuf, CMAXBUFFER, linea2);
          }
        }  
      }
    if (Cstrstr (linea, SEPLINE_ENV_INPUT) == 1) {EncontradoLineaSep = true;}
    }    
  fclose (fr);
  if (LastChar(abuf) == '&') {abuf[strlen(abuf) - 1]='\0';}   
  //DEBUG ("cgienv_GetAllSimpleVarINPUTPC=--%d--%s--", strlen(abuf), abuf);  
  return abuf;
  }

//Return all the simple cgi vars (in one line only)                                       
//       Return something like "pepe=1" in each line
void cgienv_GetAllSimpleVarINPUTSL (const char *fnenv, bool DeleteComillas, StringList *SLVars)
  {
  FILE *fr;
  XString xs;
  int ppos;
  TBuffer Sep, linea, nomvar, abuf;
  bool ACABADO = false, EncontradoLineaSep = false;
  
  SLVars->Clear();
  initStr (abuf);
  xs = cgienv_GetVarSeparator(fnenv, Sep); xs += "="; 
  fr = fopen (fnenv, "r");
  if (fr == NULL) {return;}
  while ((fgets (linea, CMAXBUFFER, fr) != NULL) && (ACABADO == false))
    {
    QuitaRetornoCarroDeLinea (linea);
    if (EncontradoLineaSep == true)
      {              
      ppos = Cstrstr (linea, xs.cstr());
      if (ppos == 1)
        {
        xstrncpy (nomvar, CMAXBUFFER, linea + strlen(xs.cstr()));
        if (strcmp (nomvar, "LAST_LINE") == 0) 
          {ACABADO = true;}
        else
          {
          fgets (linea, CMAXBUFFER, fr);
          QuitaRetornoCarroDeLinea (linea);
          if (DeleteComillas == true)
            {
            if ((linea[0] == '"') & (linea[strlen(linea) - 1] == '"'))
              {
              int L = strlen (linea);
              for (int i = 0; i < L - 2; ++i) {linea[i] = linea [i + 1];}
              linea[L - 2] = '\0';
              }
            }        
          xstrncpy (abuf, CMAXBUFFER, nomvar);
          xstrncat (abuf, CMAXBUFFER, "=");
          xstrncat (abuf, CMAXBUFFER, linea);
          SLVars->Add (abuf);
          }
        }
      }
    if (strcmp (linea, SEPLINE_ENV_INPUT) == 0) {EncontradoLineaSep = true;}  
    }    
  fclose (fr);  
  }

//Return if one cgi var exists.
bool cgienv_ExistsVar (const char *fnenv, const char *EnvVarname)
  {
  FILE *fr;
  XString xs;
  TBuffer Sep, linea;

  xs = cgienv_GetVarSeparator(fnenv, Sep); xs += "="; xs += EnvVarname;
  fr = fopen (fnenv, "r");
  if (fr == NULL) {return false;}
  bool ENCONTRADO = false;
  while ((fgets (linea, CMAXBUFFER, fr) != NULL) && (ENCONTRADO == false))
    {
    QuitaRetornoCarroDeLinea (linea);
    if (strcmp (linea, xs.cstr()) == 0)
      {
      ENCONTRADO = true;
      }
    }    
  fclose (fr);  
  return ENCONTRADO;
  }

//Return the value of a boolean simple cgi var
bool cgienv_GetEntryBool (const char *fnenv, const char *EnvVarname)
  {
  TBuffer abuf;
  cgienv_GetSimpleVar (fnenv, EnvVarname, abuf, true);  
  if (abuf == NULL) 
    {
    return false;
    }
  else 
    {
    if (strcmp(abuf, "") == 0) 
      {
      return false;
      }
    else 
      {
      return true;
      }
    }  
  }

//Return the value of a simple cgi var with a default (in one line only)
const char *cgienv_GetSimpleVarDef (const char *fnenv, const char *EnvVarname, TBuffer abuf, TBuffer def)
  {
  cgienv_GetSimpleVar (fnenv, EnvVarname, abuf, true);  
  if (abuf == NULL) 
    {
    xstrncpy (abuf, CMAXBUFFER, def);
    }
  else 
    {
    if (strcmp(abuf, "") == 0) 
      {
      xstrncpy (abuf, CMAXBUFFER, def);
      }
    }      
  return abuf;
  }

//Return the value of a simple cgi var with possible multiple values (every in one line only)
const char *cgienv_GetSimpleMultipleEntries (const char *fnenv, const char *EnvVarname, const char *SEP, TBuffer abuf, bool DeleteComillas)
  {
  FILE *fr;
  XString xs;
  TBuffer Sep, linea;

  initStr (abuf);
  xs = cgienv_GetVarSeparator(fnenv, Sep); xs += "="; xs += EnvVarname;
  fr = fopen (fnenv, "r");
  if (fr == NULL) {initStr(abuf); return abuf;}
  while (fgets (linea, CMAXBUFFER, fr) != NULL)
    {
    QuitaRetornoCarroDeLinea (linea);
    if (strcmp (linea, xs.cstr()) == 0)
      {
      fgets (linea, CMAXBUFFER, fr);
      QuitaRetornoCarroDeLinea (linea);
      if (DeleteComillas == true)
        {
        if ((linea[0] == '"') & (linea[strlen(linea) - 1] == '"'))
          {
          int L = strlen (linea);
          for (int i = 0; i < L - 2; ++i) {linea[i] = linea [i + 1];}
          linea[L - 2] = '\0';
          }
        }
      xstrncat (abuf, CMAXBUFFER, linea);
      xstrncat (abuf, CMAXBUFFER, SEP);
      }
    }    
  abuf[strlen(abuf) - 1] = '\0';      
  fclose (fr);  
  
  return abuf;  
  }

//Return the value of a simple cgi var with possible multiple values in one StringList
const char *cgienv_GetSimpleMultipleEntriesSL (const char *fnenv, const char *EnvVarname, StringList *SL, bool DeleteComillas)
  {
  FILE *fr;
  XString xs;
  TBuffer Sep, linea, abuf;

  SL->Clear();
  xs = cgienv_GetVarSeparator(fnenv, Sep); xs += "="; xs += EnvVarname;
  fr = fopen (fnenv, "r");
  if (fr == NULL) {initStr(abuf); return abuf;}
  while (fgets (linea, CMAXBUFFER, fr) != NULL)
    {
    QuitaRetornoCarroDeLinea (linea);
    if (strcmp (linea, xs.cstr()) == 0)
      {
      fgets (linea, CMAXBUFFER, fr);
      QuitaRetornoCarroDeLinea (linea);
      if (DeleteComillas == true)
        {
        if ((linea[0] == '"') & (linea[strlen(linea) - 1] == '"'))
          {
          int L = strlen (linea);
          for (int i = 0; i < L - 2; ++i) {linea[i] = linea [i + 1];}
          linea[L - 2] = '\0';
          }
        }
      SL->Add (linea);
      }
    }    
  fclose (fr);    
  return abuf;  
  }

//Return the value of a complex cgi var (in one or several lines)
//   Make a malloc. Yoy must free it.
const char *cgienv_GetComplexVar (const char *fnenv, const char *EnvVarname)
  {
#define INIT_LEN 1000  
  FILE *fr;
  XString xs;
  TBuffer Sep, linea;
  char *pc = NULL, *ppos;
  int size = 0, cont = 0, pc_sz;
  bool encontrado = false;

  pc_sz = INIT_LEN;
  pc = (char *)malloc (pc_sz);
  xs = cgienv_GetVarSeparator(fnenv, Sep); xs += "="; xs += EnvVarname;
  fr = fopen (fnenv, "r");
  if (fr == NULL) {return NULL;}
  bool DONE = false;
  while ((fgets (linea, CMAXBUFFER, fr) != NULL) && (DONE == false))
    {
    QuitaRetornoCarroDeLinea (linea);
    if (strcmp (linea, xs.cstr()) == 0)
      {
      encontrado = true;
      while ((fgets (linea, CMAXBUFFER, fr) != NULL) && (DONE == false))
        {
        ppos = strstr (linea, Sep);
        if (ppos == NULL)
          {
          size += strlen (linea);
          if (size >= pc_sz) {pc_sz += strlen (linea) + 1; pc = (char *) realloc (pc, pc_sz);}
          if (cont == 0)
            {
            xstrncpy (pc, pc_sz, linea);
            }
          else
            {  
            xstrncat (pc, pc_sz, linea);
            }
          ++cont;
          }
        else
          {
          DONE = true;
          //Quito el ultimo \n
          if (strlen(pc) > 0) 
            {
            if ((pc[strlen(pc) - 1]) == '\n') {pc[strlen(pc) - 1] = '\0';}
            }
          }        
        }
      }
    }    
  fclose (fr);  
  if (encontrado == false) {free(pc); return NULL;}
  return pc;
  }

bool isAllowedService (StringList *aSLAllowedServices, const char *deniedservices, int aservice, const char *stservice)
  {
  TBuffer service;
  if (IsEmpty(stservice))
    {
    xstrncpy (service, CMAXBUFFER, TranslateServiceR(aservice));
    if (aSLAllowedServices->indexOf (service) < 0) return false; 
    else 
      {
      if (strstr (deniedservices, service) == NULL) return true;
      else return false;
      }
    }
  else
    {
    if (aSLAllowedServices->indexOf (stservice) < 0) return false; 
    else 
      {
      if (strstr (deniedservices, stservice) == NULL) return true;
      else return false;
      }
    }  
  }

char *xstrncpy (char *dest, int sizedest, const char *src)
  {               
  strncpy (dest, src, sizedest - 1);
  dest[sizedest - 1] = '\0';
  return dest;
  }

char *xstrncat (char *dest, int sizedest, const char *src)
  {
  return strncat (dest, src, sizedest - 1 - strlen(dest));
  }

const char LastChar (const char *string)
  {
  if (string == NULL) return ' ';
  if (strcmp (string, "") == 0) return ' ';
  return string[strlen(string) - 1];
  } 
  
const char FirstChar (const char *string)
  {
  if (string == NULL) return ' ';
  if (strcmp (string, "") == 0) return ' ';
  return string[0];
  }
  
int CompareStringsNCS (const void *e1, const void *e2)
  {
  XString *xs1, *xs2;
  int res;
  char c1;
  
  xs1 = (XString *)e1;
  xs2 = (XString *)e2;  
  if (((char *)(xs1->cstr()) == NULL) || ((char *)(xs2->cstr()) == NULL)) {return 1;}  
  c1 = ((char *)(xs1->cstr())) [0];
  if (isalpha(c1) == 0) {return 1;}  
  res = strcasecmp ((char *)(xs1->cstr()), (char *)(xs2->cstr()));
  return res;
  }  
  
int CompareStringsCS (const void *e1, const void *e2)
  {
  XString *xs1, *xs2;
  int res;
  char c1;
  
  xs1 = (XString *)e1;
  xs2 = (XString *)e2;  
  if (((char *)(xs1->cstr()) == NULL) || ((char *)(xs2->cstr()) == NULL)) 
    {
    return 1;
    }  
  c1 = ((char *)(xs1->cstr())) [0];
  if (isalpha(c1) == 0) 
    {
    return 1;
    }  
  res = strcmp ((char *)(xs1->cstr()), (char *)(xs2->cstr()));
  return res;
  }

void FlipStrings (const void *e1, const void *e2)
  {
  XString *xs1, *xs2, *temp;
  xs1 = (XString *)e1;
  xs2 = (XString *)e2;
  temp = new XString (*xs1);
  *xs1  = *xs2;
  *xs2  = *temp;    
  }

void ReverseSL (StringList *SL)
  {
  StringList SLTemp;
  for (int k = 0; k < SL->Count(); ++k)
    {
    SLTemp.Add (SL->getString(k).cstr());
    }
  SL->Clear();
  for (int k = SLTemp.Count() - 1; k >= 0; --k)
    {
    SL->Add (SLTemp.getString(k).cstr());
    }
  }

//Expand variables from string
//$(INTERNAL_DEFINED) -->
//$(SERVER)           --> server
//$(USERNAME)         --> username
//$(PASSWORD)         --> password
void ExpandString (char *linea, int size, const char *internal, const char *server, const char *username, const char *password,
                   const char *user_home)
  {
  if (linea == NULL) return;
  if (strcmp (linea, "") == 0) return;
  XString XS;
  XS = XString (linea);
  XS.replace ("$(INTERNAL_DEFINED)", internal);  
  XS.replace ("$(SERVER)",           server);
  XS.replace ("$(USERNAME)",         username);  
  XS.replace ("$(PASSWORD)",         password);  
  XS.replace ("$(USER_HOME)",        user_home);    
  xstrncpy (linea, size, XS.cstr());
  }
  
bool IsSameFileSystem (const char *ori_fullfilename, const char *des_fullfilename)
  {
  int res1, res2;
  struct stat STAT1, STAT2;
  res1 = stat (ori_fullfilename, &STAT1);
  res2 = stat (des_fullfilename, &STAT2);
  //DEBUG ("--%d--%d--", STAT1.st_dev, STAT2.st_dev);
  if (STAT1.st_dev == STAT2.st_dev) return true; else return false;        
  }  
  
int xrename (const char *ori_fullfilename, const char *des_fullfilename)
  {
  if (IsSameFileSystem(ori_fullfilename, des_fullfilename) == true)
    {
    return rename (ori_fullfilename, des_fullfilename); 
    }
  else
    {
    TBuffer cmd;
    xsnprintf (cmd, CMAXBUFFER, "mv '%s' '%s'", ori_fullfilename, des_fullfilename);
    return system (cmd); 
    }    
  }

//In bytes, return disk wasted below one dir      
long getHardDiskUsage (const char *dirname, TBuffer ErrorMsg)
  {
  TBuffer cmd, buf, basura;
  FILE *fp;
  long du;

  xstrncpy (ErrorMsg, CMAXBUFFER, "");
  xsnprintf (cmd, CMAXBUFFER, "%s %s 2>&1", DU, dirname);
  fp = popen (cmd, "r");
  if (fp == NULL)
    {
    xsnprintf (ErrorMsg, CMAXBUFFER, "Error: popen: '%s'", cmd);
    return -1;    
    }
  do 
    { 
    fgets (buf, CMAXBUFFER, fp);
    if(feof(fp)) break;
    } 
  while(!feof(fp));
  pclose (fp);
  sscanf (buf, "%ld %s", &du, basura);
  return du;        
  }      
  
char *delLastSlash (char *apath)
  {
  if (LastChar (apath) == '/') {apath[strlen(apath) - 1] = '\0';} 
  return apath;
  } 

char *addLastSlash (char *apath)
  {
  if (LastChar (apath) != '/') {xstrncat (apath, CMAXBUFFER, "/");} 
  return apath;
  }

bool CheckServiceDisabled (const char *service, TBuffer file2show)
  {  
  FILE *fdisabled;
  xsnprintf (file2show, CMAXBUFFER, SERVICE_DISABLED, service);
  if ((fdisabled = fopen (file2show, "r")) != NULL)
    {
    fclose (fdisabled);
    return true;
    }
  return false;
  }  
            
char *QuitaComillas (char *token)
  {
  if ((IsEmpty(token) == true) || (strcmp (token, "\"\"") == 0)) return token;
  XString XS;
  if ((FirstChar (token) == '"') && (LastChar(token) == '"')) 
    {
    XS = XString(token).substring (1, strlen(token));
    xstrncpy (token, XS.length(), XS.cstr());
    }
  return token;  
  }            

/*      
/cgi-bin/postman/filebrowser/dump/noop/spa/prucor2/post.uv.es%40lxXbLJTxLx2mL3Q3aWfQ1peu/0/30/500/0/www/imagenes/dir1/dir2/dir3/dir4/elultimo.gif      
Returns all the parms from url
*/          
char *getTrueAllParms (const char *REQUEST_URI, TBuffer trueallparms)
  {
  int ppos;
  const char *pc;
  initStr (trueallparms);
  ppos = 0;
  pc = REQUEST_URI;
  for (int i = 0; i < (signed)strlen(REQUEST_URI); ++i)
    {
    ++pc;
    if (REQUEST_URI[i] == '/') 
      {
      ++ppos;
      if (ppos == 14) 
        {
        xstrncpy (trueallparms, CMAXBUFFER, pc);
        return trueallparms;
        } 
      }
    }
  return trueallparms;
  }
  
int IsDirWriteable (const char *directory)
  {
#define FILE_TEST_WRITE "file_test_write."APPNAME
  FILE *fw;
  TBuffer fn;  
  xsnprintf (fn, CMAXBUFFER, "%s/%s", directory, FILE_TEST_WRITE);
  fw = fopen (fn, "w");
  if (fw == NULL) {return DIR_IS_READONLY;}
  if (fprintf (fw, "a") <= 0) {fclose (fw); DeleteFile (fn); return DIR_IS_OVERQUOTA;}
  if (fclose (fw) != 0) {DeleteFile (fn); return DIR_IS_OVERQUOTA;}
  if (DeleteFile (fn) == false) {return DIR_IS_OVERQUOTA;}
  return DIR_IS_WRITEABLE;
  }  
  
int CountChars (const char *line, const char c)
  {
  int res = 0;
  for (int i = 0; i < (signed int)strlen(line); ++i)
    {
    if (line[i] == c) ++res;
    }  
  return res;  
  }  

void getConnidFromCookie (TBuffer cookiestring)
  {
  unsigned int i, cont = 0;
  for (i = 0; i < strlen(cookiestring); ++i)
    {
    if (cookiestring[i] == '@') {++cont;}
    if (cont == 2) {cookiestring[i] = '\0'; return;}
    }
  cookiestring[0] = '\0';
  }
  
void CGIErrorPageConnectionRefused (const char *lang)
  {        
  printf ("Content-type: text/html\n\n");  
  printf ("%s\n<HTML>\n", HTML_DOCTYPE);
  printf ("<HEAD>\n");
  printf ("<TITLE>%s</TITLE>", L->get(L_ERROR));
  printf ("</HEAD>\n");
  printf ("<BODY link=\"%s\" vlink=\"%s\" alink=\"%s\">\n", BLUE, BLUE2, RED);
  printf ("<p><h1><FONT color=\"%s\">%s:</font> %s</h1><p>\n",  RED, L->get(L_ERROR), L->get(MSG_CONNREFUSED));
  printf ("<p>%s<BR>", L->get(MSG_SERVERISDOWN));
  printf ("%s", L->get(MSG_PERHAPSTIMEOUT));
  printf ("<p><A HREF=\"%s/%s?lang=%s\">%s</A>\n", PATH_CGI, SERVICE_MAIN, lang, L->get(MSG_CANRECONNECTHERE));
  printf ("<HR noshade size=2>\n"); 
  printf ("<TABLE cellpadding=\"2\" cellspacing=\"1\" width=\"100%%\" BORDER=\"0\">\n");
  printf ("<TR bgcolor=\"#CCCCCC\"><TD align=\"center\" colspan=\"7\">\n");
  printf ("<FONT size=2 face=\"Arial,PrimaSans BT,Verdana,sans-serif\" color=\"#000000\">\n");
  printf ("<SMALL>&copy;<a HREF=\"http://www.uv.es\">Universitat de Val&egrave;ncia</a>, 2000-2002</SMALL>\n");
  printf ("</FONT></TD>\n");
  printf ("</TR>\n");
  printf ("</TABLE>\n");
  printf ("</BODY>\n");
  printf ("</HTML>\n");    
  exit (0);
  }

void CGIErrorPage (const char *lang, int MSG_ERROR)
  {        
  printf ("Content-type: text/html\n\n");  
  printf ("%s\n<HTML>\n", HTML_DOCTYPE);
  printf ("<HEAD>\n");
  printf ("<TITLE>%s</TITLE>", L->get(L_ERROR));
  printf ("</HEAD>\n");
  printf ("<BODY link=\"%s\" vlink=\"%s\" alink=\"%s\">\n", BLUE, BLUE2, RED);
  printf ("<p><h1><FONT color=\"%s\">%s:</font> %s</h1><p>\n",  RED, L->get(L_ERROR), L->get(MSG_ERROR));
  printf ("<p>%s<BR>", L->get(MSG_SERVERISDOWN));
  printf ("%s", L->get(MSG_PERHAPSTIMEOUT));
  printf ("<p><A HREF=\"%s/%s?lang=%s\">%s</A>\n", PATH_CGI, SERVICE_MAIN, lang, L->get(MSG_CANRECONNECTHERE));
  printf ("<HR noshade size=2>\n"); 
  printf ("<TABLE cellpadding=\"2\" cellspacing=\"1\" width=\"100%%\" BORDER=\"0\">\n");
  printf ("<TR bgcolor=\"#CCCCCC\"><TD align=\"center\" colspan=\"7\">\n");
  printf ("<FONT size=2 face=\"Arial,PrimaSans BT,Verdana,sans-serif\" color=\"#000000\">\n");
  printf ("<SMALL>&copy;<a HREF=\"http://www.uv.es\">Universitat de Val&egrave;ncia</a>, 2000-2002</SMALL>\n");
  printf ("</FONT></TD>\n");
  printf ("</TR>\n");
  printf ("</TABLE>\n");
  printf ("</BODY>\n");
  printf ("</HTML>\n");    
  exit (0);
  }

void CGIPageConnectionToService (const char *lang, const char *imapserver, const char *user, const char *stservice, const char *stcmd, const char *stsubcmd,
                                 const char *parm1, const char *parm2, const char *parm3, const char *parm4)
  {
  TBuffer tmpbuffer;
          
  printf ("Content-type: text/html\n\n");  
  printf ("%s\n<HTML>\n", HTML_DOCTYPE);
  printf ("<HEAD>\n");
  printf ("<TITLE>%s</TITLE>", L->get(L_LOGIN));
  printf ("</HEAD>\n");
  printf ("<BODY link=\"%s\" vlink=\"%s\" alink=\"%s\">\n", BLUE, BLUE2, RED);  
  printf ("<BR><BR><BR>\n");


  xsnprintf (tmpbuffer, CMAXBUFFER, L->get(MSG_NEED_PASSWORD_SERVICE), stservice);
  printf ("<CENTER><B>%s</B></CENTER>\n", tmpbuffer);     
  printf ("<HR noshade size=2>\n");
  printf ("<FORM NAME=\"%s\" ACTION=\"%s\" METHOD=\"POST\">\n", "theform", PATH_CGI);
  printf ("<CENTER>\n");
  printf ("<INPUT TYPE=HIDDEN NAME=\"imapserver\" VALUE=\"%s\" SIZE=\"10\">\n", imapserver);  
  printf ("<INPUT TYPE=HIDDEN NAME=\"%s\" VALUE=\"%s\">\n", "lang", lang);
  printf ("<INPUT TYPE=HIDDEN NAME=\"%s\" VALUE=\"%s\">\n", "user", user);                
  printf ("<INPUT TYPE=HIDDEN NAME=\"cmd\" VALUE=\"reconnect\">\n");    
  printf ("<INPUT TYPE=HIDDEN NAME=\"service\" VALUE=\"%s\">\n", "main");      
  printf ("<INPUT TYPE=HIDDEN NAME=\"trueservice\" VALUE=\"%s\">\n", stservice);  
  printf ("<INPUT TYPE=HIDDEN NAME=\"truecmd\" VALUE=\"%s\">\n", stcmd);  
  printf ("<INPUT TYPE=HIDDEN NAME=\"truestsubcmd\" VALUE=\"%s\">\n", stsubcmd);
  printf ("<INPUT TYPE=HIDDEN NAME=\"stsubcmd\" VALUE=\"%s\">\n", "noop");  
  printf ("<INPUT TYPE=HIDDEN NAME=\"parm1\" VALUE=\"%s\">\n", parm1);
  printf ("<INPUT TYPE=HIDDEN NAME=\"parm2\" VALUE=\"%s\">\n", parm2);  
  printf ("<INPUT TYPE=HIDDEN NAME=\"parm3\" VALUE=\"%s\">\n", parm3);
  printf ("<INPUT TYPE=HIDDEN NAME=\"parm4\" VALUE=\"%s\">\n", parm4);  
  printf ("<TABLE>\n");
  printf ("<TR><TD align=\"right\"><B>%s:</B></TD><TD>%s</TD></TR>\n", L->get(L_USER), user); 
  printf ("<TR><TD align=\"right\"><B>%s:</B></TD><TD><INPUT TYPE=PASSWORD SIZE=\"10\" NAME=\"pw\" VALUE=\"\"></TD></TR>\n", L->get(L_PASSWORD));                
  printf ("<TR><TD align=\"right\"><B>%s:</B></TD><TD>%s</TD></TR>\n", L->get(L_SERVICE), stservice); 
  printf ("<TR><TD align=\"center\" colspan=\"2\"><INPUT TYPE=SUBMIT NAME=\"%s\" VALUE=\"%s\"></TD></TR>\n", "Login", "Entrar");  
  printf ("</TABLE>\n");
  printf ("</CENTER>\n");
  printf ("</FORM>\n");             
  printf ("<HR noshade size=2>\n");
  printf ("<TABLE cellpadding=\"2\" cellspacing=\"1\" width=\"100%%\" BORDER=\"0\">\n");
  printf ("<TR bgcolor=\"#CCCCCC\"><TD align=\"center\" colspan=\"7\">\n");
  printf ("<FONT size=2 face=\"Arial,PrimaSans BT,Verdana,sans-serif\" color=\"#000000\">\n");
  printf ("<SMALL>&copy;<a HREF=\"http://www.uv.es\">Universitat de Val&egrave;ncia</a>, 2000-2002</SMALL>\n");
  printf ("</FONT></TD>\n");
  printf ("</TR>\n");
  printf ("</TABLE>\n");
  
  printf ("</BODY>\n");
  printf ("</HTML>\n");    
  exit (0);
  }

