/***************************************************************************
                    configuration_dialog.cpp  -  description
                             -------------------
    begin                : Sat Feb 9 2001
    copyright            : (C) 2002 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configuration_dialog.h"
#include "configuration.h"
#include "gui.h"

#include <qbuttongroup.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qframe.h>
#include <qhgroupbox.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qtooltip.h>

Configuration_Dialog::Configuration_Dialog(QWidget *parent, const char *name)
    : QTabDialog(parent, name)
{
  QFrame *dbframe = new QFrame(this);
  QHBoxLayout *hlay = new QHBoxLayout(dbframe);

  QGroupBox *dbbox = new QGroupBox(1, Qt::Horizontal, "Settings", dbframe);
  QFrame *dbboxf = new QFrame(dbbox); 
  QGridLayout *dblay = new QGridLayout(dbboxf, 4, 2);
  QToolTip::add( dbboxf, _(" When disconnected, you can change all MySQL \nconnections parameters here. \nDefault values are usually OK.") );
    
  QLabel *a = new QLabel("<b>Host: </b>", dbboxf); a->setAlignment(Qt::AlignRight);
  dblay->addWidget(a, 0, 0);
  QLabel *b = new QLabel("<b>Database: </b>", dbboxf); b->setAlignment(Qt::AlignRight);
  dblay->addWidget(b, 1, 0);
  QLabel *c = new QLabel("<b>User: </b>", dbboxf); c->setAlignment(Qt::AlignRight);
  dblay->addWidget(c, 2, 0);
  QLabel *d = new QLabel("<b>Pass: </b>", dbboxf); d->setAlignment(Qt::AlignRight);
  dblay->addWidget(d, 3, 0);

  db_host_line = new QLineEdit(config->db_host, dbboxf);
  dblay->addWidget(db_host_line, 0, 1);
  db_database_line = new QLineEdit(config->db_database, dbboxf);
  dblay->addWidget(db_database_line, 1, 1);
  db_user_line = new QLineEdit(config->db_user, dbboxf);
  dblay->addWidget(db_user_line, 2, 1);
  db_pass_line = new QLineEdit(config->db_pass, dbboxf);
  dblay->addWidget(db_pass_line, 3, 1);

  hlay->addWidget(dbbox);

  QFrame *dirframe = new QFrame(this);
  QHBoxLayout *dhlay = new QHBoxLayout(dirframe);

#if HAVE_ID3
#if HAVE_OGG
  QHGroupBox *dirbox = new QHGroupBox(_("MP3/Ogg Directories"), dirframe);
#else
  QHGroupBox *dirbox = new QHGroupBox(_("MP3 Directories"), dirframe);
#endif /* HAVE_OGG */
#elif HAVE_OGG
  QHGroupBox *dirbox = new QHGroupBox(_("Ogg Directories"), dirframe);
#endif /* HAVE_ID3 */

  hddlist = new QListView(dirbox);
  hddlist->setAllColumnsShowFocus(true);
  hddlist->setSorting(-1);
  hddlist->addColumn(_("Directory"), 300);
  char* temps = _(" Here, you can manage a list of directories to search for music files.\n Note sub-directories are searched as well.");
  QToolTip::add( hddlist, temps );
  QToolTip::add( hddlist->viewport(), temps );
    
  QFrame *hddbuttonframe = new QFrame(dirbox);
  QVBoxLayout *hddbuttonlayout = new QVBoxLayout(hddbuttonframe);
    
  QPushButton *hddadd = new QPushButton(_("Add"), hddbuttonframe);
  hddbuttonlayout->addWidget(hddadd, 0, AlignTop);
  hddedit = new QPushButton(_("Edit"), hddbuttonframe);
  hddbuttonlayout->addWidget(hddedit, 0, AlignTop); 
  hddremove = new QPushButton(_("Remove"), hddbuttonframe);
  hddbuttonlayout->addWidget(hddremove, 1, AlignTop); 

  for(QStringList::Iterator it = config->mp3dirs.begin(); it != config->mp3dirs.end(); ++it) {
    QListViewItem *item = new QListViewItem(hddlist, *it);
    item->setPixmap(0, QPixmap(PROKYON_HOME + "/images/artist.png"));
  }

  connect(hddlist, SIGNAL(selectionChanged()), this, SLOT(slot_selectionChanged()));
  connect(hddadd, SIGNAL(clicked()), this, SLOT(slot_hddadd()));
  connect(hddremove, SIGNAL(clicked()), this, SLOT(slot_hddremove()));
  connect(hddedit, SIGNAL(clicked()), this, SLOT(slot_hddedit()));

  if(hddlist->firstChild() != 0) hddlist->setSelected(hddlist->firstChild(), true);

  dhlay->addWidget(dirbox);

  QFrame *togframe = new QFrame(this);
  QHBoxLayout *toghlay = new QHBoxLayout(togframe);

  QGroupBox *togbox = new QGroupBox(1, Qt::Horizontal, _("Toggles"), togframe);
  QFrame *togboxf = new QFrame(togbox); 
  QGridLayout *toglay = new QGridLayout(togboxf, 10, 1);
    
  readv2check = new QCheckBox( _("Read ID3v2 tags"), togboxf); readv2check->setChecked(config->readid3v2 == 1);
  QToolTip::add( readv2check, _("When checked, Prokyon will read ID3V2 tags from mp3 files.\n It will default to V1 if no V2 tags are available") );
  toglay->addWidget(readv2check, 0, 0);
  writev2check = new QCheckBox( _("Write ID3v2 tags"), togboxf); writev2check->setChecked(config->writeid3v2 == 1);
  QToolTip::add( writev2check, _("When checked, Prokyon will always write ID3 V2 tags to mp3 files.") );
  toglay->addWidget(writev2check, 1, 0);
  autocheck = new QCheckBox( _("Autoconnect to database at startup"), togboxf); autocheck->setChecked(config->autoconn == 1);
  toglay->addWidget(autocheck, 2, 0);
  hidecheck = new QCheckBox( _("Autohide artists/sources/playlists in tagedit mode"), togboxf); hidecheck->setChecked(config->autohide == 1);
  QToolTip::add( hidecheck, _("When checked, Prokyon will expand display when tags are edited.") );
  toglay->addWidget(hidecheck, 3, 0);
  hddcheck = new QCheckBox( _("Never show content of whole harddisk"), togboxf); hddcheck->setChecked(config->avoidhdd == 1);
  QToolTip::add( hddcheck, _("Usefull if you have lots of files on your harddisk.") );
  toglay->addWidget(hddcheck, 4, 0);
  smbcheck = new QCheckBox( _("Never show content of whole SMB shares"), togboxf); smbcheck->setChecked(config->avoidsmb == 1);
  QToolTip::add( smbcheck, _("Usefull if you have lots of files on your SMB share.") );
  toglay->addWidget(smbcheck, 5, 0);
  nfscheck = new QCheckBox( _("Never show content of whole NFS exports"), togboxf); nfscheck->setChecked(config->avoidnfs == 1);
  QToolTip::add( nfscheck, _("Usefull if you have lots of files on your NFS share.") );
  toglay->addWidget(nfscheck, 6, 0);
  showtooltip = new QCheckBox( _("Allow tool tip"), togboxf); showtooltip->setChecked( config->getShowToolTip() == 1 );
  QToolTip::add( showtooltip, _("Get rid of silly messages like this one....") );
  toglay->addWidget(showtooltip, 7, 0);
  maxwidthmode = new QCheckBox( _("Allow column to expand automatically"), togboxf); maxwidthmode->setChecked( config->getMaxWidthMode() == 1 );
  QToolTip::add( maxwidthmode, _(" When checked, columns size will be adjusted automatically.\n If unchecked, Prokyon will remember your adjustements\n between sessions.") );
  toglay->addWidget(maxwidthmode, 8, 0);
  guirestore = new QCheckBox( _("Allow gui configuration restore "), togboxf); guirestore->setChecked( config->getAllowGuiRestore() == 1 );
  QToolTip::add( guirestore, _("When checked, internal frame sizes  as well as relative \ncolumns position in central frame \nwill be saved and restore between sessions.") );
  toglay->addWidget(guirestore, 9, 0);

  QFrame *playframe = new QFrame(togboxf);
  QGridLayout *playlay = new QGridLayout(playframe, 3, 2);
  QLabel *l1 = new QLabel(_("<b>play</b> command: "), playframe); l1->setAlignment(Qt::AlignRight);
  playlay->addWidget(l1, 0, 0);
  play_line = new QLineEdit(config->playcmd, playframe);
  playlay->addWidget(play_line, 0, 1);

  QLabel *l2 = new QLabel(_("<b>enqueue</b> command: "), playframe); l2->setAlignment(Qt::AlignRight);
  playlay->addWidget(l2, 1, 0);
  enqueue_line = new QLineEdit(config->enqueuecmd, playframe);
  playlay->addWidget(enqueue_line, 1, 1);

  QLabel *l3 = new QLabel(_("<b>burnCD</b> command: "), playframe); l3->setAlignment(Qt::AlignRight);
  playlay->addWidget(l3, 2, 0);
  burnCD_line = new QLineEdit(config->burnCDcmd, playframe);
  playlay->addWidget(burnCD_line, 2, 1);

	
  toglay->addWidget(playframe, 11, 0);

  toghlay->addWidget(togbox);

  addTab(togframe,_("Toggles") );
  addTab(dbframe, _("Database") );
  addTab(dirframe,_("Directories") );

  setOkButton();
  setCancelButton( _("Cancel") );

  slot_selectionChanged();

  if(gui->getConnectionState()) dbbox->setEnabled(false);
}

void Configuration_Dialog::slot_selectionChanged() {
    if(hddlist->selectedItem() == 0) {
	hddedit->setEnabled(false);
	hddremove->setEnabled(false);
    } else {
	hddedit->setEnabled(true);
	hddremove->setEnabled(true);
    }
}

void Configuration_Dialog::slot_hddadd() {
    QString filename = QFileDialog::getExistingDirectory("/", this);
    if(!filename.isNull()) {
	QListViewItem *curr = hddlist->firstChild();
	while(curr) {
	    if(curr->text(0) == filename) break;
	    curr = curr->nextSibling();
	}
	if(curr) QMessageBox::information(this, "Message", _("The chosen directory is already in use"), QMessageBox::Ok);
	else {
	    QListViewItem *item = new QListViewItem(hddlist, filename);
	    item->setPixmap(0, QPixmap(PROKYON_HOME + "/images/artist.png"));
	    hddlist->setSelected(item, true);
	}
    }
}

void Configuration_Dialog::slot_hddedit() {
    QString filename = QFileDialog::getExistingDirectory(hddlist->selectedItem()->text(0), this);
    if(!filename.isNull()) {
	QListViewItem *curr = hddlist->firstChild();
	while(curr) {
	    if(curr->text(0) == filename && curr != hddlist->selectedItem()) break;
	    curr = curr->nextSibling();
	}
	if(curr) QMessageBox::information(this, "Message", _("The chosen directory is already in use"), QMessageBox::Ok);
	else {
	    hddlist->selectedItem()->setText(0, filename);    
	}
    }
}

void Configuration_Dialog::slot_hddremove() {
    hddlist->takeItem(hddlist->selectedItem());
    if(hddlist->firstChild() != 0) hddlist->setSelected(hddlist->firstChild(), true);
}

Configuration_Dialog::~Configuration_Dialog()
{}
	
