/******************************************************************************
 libprozilla - a download accelerator library
 Copyright (C) 2001 Kalum Somaratna

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

/* FTP LIST command parsing code. */

/* $Id: ftpparse.c,v 1.11 2001/06/21 23:26:17 kalum Exp $ */


#include "common.h"
#include "ftpparse.h"


char *month[] = {
  NULL, "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep",
  "Oct",
  "Nov", "Dec"
};


/* Grendel: I added a STANDALONE def to this, I didn't delete this main() func, 
   because we should have these examples so that others can modify this code */
#ifdef STANDALONE

int main(void)
{
  const char *binls_example =
      "-rw-r--r--   1 root     root         3102 Dec  4 21:08 test.c";

  const char *eplf_example = "+8388621.44468,m839956783,r,s10376,	test.c";

  const char *msftp_example =
      "----------   1 owner    group         1803128 Jul 10 10:18 ls-lR.Z";

  const char *doswftpd_example =
      "-rwxrwxrwx   1 noone    nogroup      322 Aug 19  1996 message.ftp";

  const char *netware_example =
      "d [R----F--] supervisor            512       Jan 16 18:53    login";

  const char *netpres_example =
      "-------r--         326  1391972  1392298 Nov 22  1995 MegaPhone.sit";

  const char *multinet_example =
      "00README.TXT;1      2 30-DEC-1996 17:44 [SYSTEM] (RWED,RWED,RE,RE)";

  const char *multinet2_example =
      "CII-MANUAL.TEX;1  213/216  29-JAN-1996 03:33:12  [ANONYMOU,ANONYMOUS]   (RWED,RWED,,)";

  int size;

  /* Get size and return it. */
  size = size_returner(binls_example, strlen(binls_example));
  size = size_returner(eplf_example, strlen(eplf_example));
  size = size_returner(msftp_example, strlen(msftp_example));
  size = size_returner(doswftpd_example, strlen(doswftpd_example));
  size = size_returner(netware_example, strlen(netware_example));
  size = size_returner(netpres_example, strlen(netpres_example));
  size = size_returner(multinet_example, strlen(multinet_example));
  size = size_returner(multinet2_example, strlen(multinet2_example));

  exit(EXIT_SUCCESS);
}

#endif				/* STANDALONE. */


/******************************************************************************
 ...
******************************************************************************/
int size_returner(char *buf, int len)
{



  /*
     Grendel: If len == 2 or len ==0 then it could be no info present, or empty name in EPLF
   */
  if (len == 0 || len == 2)
    return FTPPARSENOTEXIST;



  if (len == 2)


    /* Determine the format used by the server. */

    if (is_eplf(buf, len))
      return eplf_extract_size(buf, len);

  if (is_multinet(buf, len))
    return multinet_extract_size(buf, len);

  if (is_binls(buf, len))
    return binls_extract_size(buf, len);

  /* I think it is best to keep it modular and easily updatable whenever we
     need to. E.g.:
     if (is_newformat(buf,len))
     return newformat_extract_size(buf, len); */

  return FTPPARSEFAIL;		/* Unknown format :-(, please mail the URL. */
}

/******************************************************************************
 EPLF stuff.
******************************************************************************/
boolean is_eplf(char *buf, int len)
{
  /* Specifications were taken from http://cr.py.to/eplf.html. */

  if (*buf == '+')
    if (buf[len - 2] == 15 /* ^O */  && buf[len - 1] == 12 /* ^L */ )
      return YES;

  return NO;
}

/******************************************************************************
 ...
******************************************************************************/
int eplf_extract_size(char *buf, int len)
{
  int size;

  while (*buf++ != 's')
    ;

  for (size = 0; isdigit(*buf); buf++)
    size = 10 * size + (*buf - '0');

  printf("EPLF\tSize: %5d\n", size);

  return size;			/* Return EPLF size. */
}

/******************************************************************************
 MULTINET stuff.
******************************************************************************/
boolean is_multinet(char *buf, int len)
{
  /* The multinet format looks like this:
     - ';' after the filename.
     - A digit, some space, a digit.
     - Can contain a '/' before size.
     - A date string like [D]D-MMM-JJJJ. */
  if ((buf = strchr(buf, ';')) != NULL)
    if (((buf = strchr(buf, '-')) != NULL) && (*(buf + 4) == '-'))
      return YES;

  return NO;
}

/******************************************************************************
 ...
******************************************************************************/
int multinet_extract_size(char *buf, int len)
{
  int size = 0;
  char *pos = NULL;

  pos = strchr(buf, ';');	/* Skip file name. */
  pos = strchr(pos, '-');	/* Go to date string DD-. */
  pos--;

  while (isdigit(*pos))		/* Skip days maybe 1 or 2 digits. */
    pos--;

  while (isspace(*pos))
    pos--;

  while (isdigit(*pos))
    pos--;

  while (isdigit(*++pos))
    size = 10 * size + (*pos - '0');

  printf(_("MULTINET Size: %d\n"), size);

  return size;
}

/******************************************************************************
 BINLS stuff.
******************************************************************************/
boolean is_binls(char *buf, int len)
{
  int i;

  for (i = 1; i <= 12; i++)
    if (strstr(buf, month[i]) != NULL)
      return YES;

  return NO;
}

/******************************************************************************
 ...
******************************************************************************/
int binls_extract_size(char *buf, int len)
{
  int i;
  int size = 0;
  char *pos = NULL;

  for (i = 1; i <= 12; i++)
    if ((pos = strstr(buf, month[i])) != NULL)
      break;

  while (isspace(*--pos))
    ;

  while (isdigit(*pos))
    pos--;

  while (isdigit(*++pos))
    size = 10 * size + (*pos - '0');

  printf(_("BINLS size: %d\n"), size);

  return size;
}
