dnl Macros that test for specific features.
dnl This file is part of the Autoconf packaging for PSP.
dnl Copyright (C) 2000,  FundsXpress Financial Network, inc.
dnl
dnl This library is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU Lesser General Public
dnl License as published by the Free Software Foundation; either
dnl version 2 of the License, or (at your option) any later version.
dnl
dnl BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
dnl BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
dnl OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
dnl LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
dnl MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
dnl ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
dnl AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
dnl License for more details. 
dnl
dnl You should have received a copy of the GNU Lesser General Public
dnl License along with this library; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
dnl

AC_DEFUN(AC_PSP_SHADOWDIR,
[
  shadow_dir="$1"

  test -d $shadow_dir || echo creating $shadow_dir && mkdir -p $shadow_dir
  echo mirroring $shadow_dir
  # create if needed
  test -d $shadow_dir || mkdir $shadow_dir
  # remove existing links
  find $shadow_dir -type l -exec rm {} \;
  find $shadow_dir/* -type d -depth -exec rmdir {} \; 2>/dev/null
  # find proper depth for links
  case $srcdir in
    /*)
       ln_srcdir=$srcdir
       ;;
    *)
       ln_srcdir=`echo "$shadow_dir" | sed 's/[[^\/]][[^\/]]*/../g'`/$srcdir
       ;;
  esac
  # link it!
  echo $ln_srcdir/$shadow_dir:
  $srcdir/mk/lndir-sh $ln_srcdir/$shadow_dir $shadow_dir
])

AC_DEFUN(AC_PSP_ENABLE_CPAN_STYLE,
[
  dnl cpan-style check
  AC_ARG_ENABLE(cpan-style,
	[  --enable-cpan-style     build cpan-style. [default=no]],,
	enable_cpan_style=no)

  AC_MSG_CHECKING(whether to build lib CPAN-style)
  if test "x$enable_cpan_style" = "xno" ; then
	AC_MSG_RESULT(no)
	CPAN_STYLE=
  else
	AC_MSG_RESULT(yes)
	CPAN_STYLE=yes
	AC_PSP_SHADOWDIR(lib)
  fi
  AC_SUBST(CPAN_STYLE) dnl
])

AC_DEFUN(AC_PSP_ENABLE_BUILD_CPAN,
[
  dnl required packages check
  AC_ARG_ENABLE(build-cpan,
	[  --enable-build-cpan     build required CPAN modules. [default=no]],,
	enable_build_cpan=no)

  AC_MSG_CHECKING(whether to build required CPAN modules)
  if test "x$enable_build_cpan" = "xno" ; then
	AC_MSG_RESULT(no)
	BUILD_CPAN=
  else
	AC_MSG_RESULT(yes)
	BUILD_CPAN=yes
	AC_PSP_SHADOWDIR(cpan)
  fi
  AC_SUBST(BUILD_CPAN) dnl
])

AC_DEFUN(AC_PSP_ENABLE_BUILD_SAMPLES,
[
  dnl required packages check
  AC_ARG_ENABLE(build-samples,
	[  --enable-build-samples  build sample piles. [default=yes]],,
	enable_build_samples=yes)

  AC_MSG_CHECKING(whether to build samples)
  if test "x$enable_build_samples" = "xno" ; then
	AC_MSG_RESULT(no)
	BUILD_SAMPLES=
  else
	AC_MSG_RESULT(yes)
	BUILD_SAMPLES=yes
	AC_PSP_SHADOWDIR(samples)
  fi
  AC_SUBST(BUILD_SAMPLES) dnl
])

AC_DEFUN(AC_PSP_ENABLE_SITELIB,
[
  dnl required packages check
  AC_ARG_ENABLE(sitelib,
	[  --enable-sitelib        install modules in site-lib. [default=no]],,
	enable_sitelib=no)

  AC_MSG_CHECKING(whether to perl modules in site-lib)
  if test "x$enable_sitelib" = "xno" ; then
	AC_MSG_RESULT(no)
	SITELIB_INSTALL=
  else
	AC_MSG_RESULT(yes)
	SITELIB_INSTALL=yes
  fi
  AC_SUBST(SITELIB_INSTALL) dnl
])
